
/***********************************************************************/
/*!
 * \file   spi_tclBDCLRespCarData.h
 * \brief  CarMetadata Call backs output interface
 *************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Cardata Call backs output interface
AUTHOR:         pok6kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification

\endverbatim
 *************************************************************************/
#ifndef _SPI_TCLBDCLRESPCARDATA_H_
#define _SPI_TCLBDCLRESPCARDATA_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class  spi_tclBDCLRespCarData.h
 * \brief  Car Metadata info  are updated to Application using this
 *****************************************************************************/
class spi_tclBDCLRespCarData:public RespBase
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespCarData::spi_tclBDCLRespCarData()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespCarData()
       * \brief   Default Constructor
       * \sa      ~spi_tclBDCLRespCarData()
       **************************************************************************/
      spi_tclBDCLRespCarData():RespBase(e16BDCL_CARDATA_REGID){}

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespCarData::~spi_tclBDCLRespCarData()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLRespCarData()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespCarData()
       **************************************************************************/
      virtual ~spi_tclBDCLRespCarData(){}

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespCarData::vCarDataCallback()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vCarDataCallback()
       * \brief   Called on receiving CarDataSubscription  Msg.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vCarDataSubscriptionCallback(const tBdclCarDataInfoList& rCarDataSubscription){};

      /*********************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespCarData::vCarDataSubscriptionStartCallback()
       *********************************************************************************/
      /*!
       * \fn      virtual t_Void vCarDataSubscriptionStartCallback()
       * \brief   Called on receiving CarDataSubscription Start Msg.
       * \retval  t_Void
       *********************************************************************************/
      virtual t_Void vCarDataSubscriptionStartCallback(const tBdclCarDataInfoList& rCarDataSubscriptionStart){};

      /********************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespCarData::vCarDataSubscriptionStopCallback()
       ********************************************************************************/
      /*!
       * \fn      virtual t_Void vCarDataSubscriptionStopCallback()
       * \brief   Called on receiving CarDataSubscription Stop Msg.
       * \retval  t_Void
       ********************************************************************************/
      virtual t_Void vCarDataSubscriptionStopCallback(const tBdclCarDataInfoList& rCarDataSubscriptionStop){};


   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespCarData(const spi_tclBDCLRespCarData...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespCarData(const spi_tclBDCLRespCarData& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespCarData()
       ***************************************************************************/
      spi_tclBDCLRespCarData(const spi_tclBDCLRespCarData& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespCarData& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespCarData& operator=(const spi_tclBDCLRespCarData& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespCarData(const spi_tclBDCLRespCarData& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespCarData& operator=(const spi_tclBDCLRespCarData& corfoSrc);


      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/


      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespCarData

#endif //_SPI_TCLBDCLRESPMEDIADATA_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
