/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdCarData.h
* \brief  Implementation of the Class spi_tclBDCLCmdCarData
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLCMDCARDATA_
#define SPI_TCLBDCLCMDCARDATA_

#include <memory>

#include "BaseTypes.h"
#include "BDCL_WrapperTypes.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLCarDataDispatcher.h"


/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
class spi_tclBDCLCarDataProxyIntf;
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLCarDataProxyIntf >       t_SptrBDCLCarDataProxy;


/*!
 * \class spi_tclBDCLCmdCarData
 * \brief
 */
class spi_tclBDCLCmdCarData
{
   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCmdCarData()
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLCmdCarData()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLCmdCarData()
       **************************************************************************/
      spi_tclBDCLCmdCarData();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLCmdCarData()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLCmdCarData()
       * \brief    Destructor
       * \sa       spi_tclBDCLCmdCarData()
       **************************************************************************/
     virtual ~spi_tclBDCLCmdCarData();

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Performs initialization for CarData with BDCL device
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Performs cleanup of CarData with BDCL device
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:t_Bool bSendCarAcceleration(...)
       ***************************************************************************/
      /*!
       * \fn     bSendCarAcceleration()
       * \brief  Sends Car Acceleration Data
       * \param  rCarAcceleration [IN]: Structure containing BDCL Acceleration Data
       **************************************************************************/
      t_Bool bSendCarAcceleration(trAccSensorData rCarAcceleration);

      /***************************************************************************
       ** FUNCTION:t_Bool bSendCarGPS(...)
       ***************************************************************************/
      /*!
       * \fn      bSendCarGPS()
       * \brief   Sends Car GPS Data
       * \param   rCarGPS [IN]: Structure containing BDCL GPS Data
       **************************************************************************/
      t_Bool bSendCarGPS(trBdclCarGPS rCarGPS);

      /***************************************************************************
       ** FUNCTION:t_Bool bSendCarGyro(...)
       ***************************************************************************/
      /*!
       * \fn      bSendCarGyro()
       * \brief   Sends Car Gyro Data
       * \param   rCarGyro [IN]: Structure containing BDCL Gyro Data
       **************************************************************************/
      t_Bool bSendCarGyro(trGyroSensorData rCarGyro);

      /***************************************************************************
       ** FUNCTION:t_Bool bSendCarOil(...)
       ***************************************************************************/
      /*!
       * \fn      bSendCarOil()
       * \brief   Sends Car Oil Data
       * \param   rCarOil [IN]: Structure containing BDCL Oil Data
       **************************************************************************/
      t_Bool bSendCarOil(trBdclCarOil rCarOil);

      /***************************************************************************
       ** FUNCTION:t_Bool bSendCarVelocity(...)
       ***************************************************************************/
      /*!
       * \fn      bSendCarVelocity()
       * \brief   Sends Car Velocity Data
       * \param   rCarVelocity [IN]: Structure containing BDCL Velocity Data
       **************************************************************************/
      t_Bool bSendCarVelocity(trBdclCarVelocity rCarVelocity);

      /***************************************************************************
       ** FUNCTION:t_Bool bSendGearInfo(...)
       ***************************************************************************/
      /*!
       * \fn      bSendGearInfo()
       * \brief   Sends Car Gear Data
       * \param   s32Gear [IN]: BDCL Gear Data
       **************************************************************************/
      t_Bool bSendGearInfo(t_S32 s32Gear);

      /***************************************************************************
       ** FUNCTION:t_Bool bSendDataSubscribeDone(...)
       ***************************************************************************/
      /*!
       * \fn      bSendDataSubscribeDone()
       * \brief   Sends Data Subscription Msg
       * \param   rCarDataList [IN]: Structure containing BDCL Car Data
       **************************************************************************/
      t_Bool bSendDataSubscribeDone(const tBdclCarDataInfoList& rCarDataInfoList);

      /***************************************************************************
       ** FUNCTION:t_Bool vCarDataSubscribeCallback(...)
       ***************************************************************************/
      /*!
       * \fn      vCarDataSubscribeCallback()
       * \brief   Called on receiving CarDataSubscribe Msg
       * \param   S_VEHICLE_INFO_LIST [IN]: Structure containing Vehicle Info
       **************************************************************************/
      static t_Void vCarDataSubscribeCallback(S_VEHICLE_INFO_LIST *poContext);

      /***************************************************************************
       ** FUNCTION:t_Bool vCarDataSubcribeStartCallback(...)
       ***************************************************************************/
      /*!
       * \fn      vCarDataSubcribeStartCallback()
       * \brief   Called on receiving CarDataSubscribe start Msg
       * \param   S_VEHICLE_INFO_LIST [IN]: Structure containing Vehicle Info
       **************************************************************************/
      static t_Void vCarDataSubcribeStartCallback(S_VEHICLE_INFO_LIST *poContext);

      /***************************************************************************
       ** FUNCTION:t_Bool vCarDataSubscribeStopCallback(...)
       ***************************************************************************/
      /*!
       * \fn      vCarDataSubscribeStopCallback()
       * \brief   Called on receiving CarDataSubscribe Stop Msg
       * \param   S_VEHICLE_INFO_LIST [IN]: Structure containing Vehicle Info
       **************************************************************************/
      static t_Void vCarDataSubscribeStopCallback(S_VEHICLE_INFO_LIST *poContext);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLCmdCarData(const spi_tclBDCLCmdCarData&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCmdCarData(const spi_tclBDCLCmdCarData&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLCmdCarData(const spi_tclBDCLCmdCarData&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLCmdCarData & operator=(const spi_tclBDCLCmdCarData&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLCmdCarData & operator=(const spi_tclBDCLCmdCarData&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLCmdCarData & operator=(const spi_tclBDCLCmdCarData&);

      //! Pointer to CarData proxy
      t_SptrBDCLCarDataProxy m_spoCarDataProxy;

};
#endif //SPI_TCLBDCLCMDCARDATA_
