/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdBluetooth.cpp
* \brief  Implementation of the Class spi_tclBDCLCmdBluetooth
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <algorithm>
#include "spi_tclBDCLCmdBluetooth.h"
#include "SPITypes.h"
#include "spi_tclBDCLProxyManager.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLBluetoothDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_BDCLWRAPPER
      #include "trcGenProj/Header/spi_tclBDCLCmdBluetooth.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:   spi_tclBDCLCmdBluetooth()
 ***************************************************************************/
spi_tclBDCLCmdBluetooth::spi_tclBDCLCmdBluetooth( )
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::spi_tclBDCLCmdBluetooth entered "));
}

/***************************************************************************
 ** FUNCTION:   ~spi_tclBDCLCmdBluetooth()
 ***************************************************************************/
spi_tclBDCLCmdBluetooth::~spi_tclBDCLCmdBluetooth()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::~spi_tclBDCLCmdBluetooth entered "));
}

/***************************************************************************
 ** FUNCTION:   t_Bool bInitialize()
 ***************************************************************************/
t_Bool spi_tclBDCLCmdBluetooth::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::bInitialize entered "));

   t_Bool bResult = false;
   t_SptrBDCLProxyManager spoProxyManager = spi_tclBDCLProxyManager::getInstance();
   SPI_NORMAL_ASSERT(!spoProxyManager);

   if (spoProxyManager)
   {
      m_spoBluetoothProxy = spoProxyManager->spoGetBluetoothProxyInstance();
      SPI_NORMAL_ASSERT(!m_spoBluetoothProxy);
   }

   if (m_spoBluetoothProxy)
   {
      trBdclBluetoothCbs rCallbacks;
      rCallbacks.fvOnBluetoothOOBInfo =  &spi_tclBDCLCmdBluetooth::vOnMDBluetoothOOBInfoCb;
      rCallbacks.fvOnBluetoothHFPRequest = &spi_tclBDCLCmdBluetooth::vOnBluetoothHFPRequestCb;
      rCallbacks.fvOnBluetoothStartAutoPairRequest =  &spi_tclBDCLCmdBluetooth::vOnStartBluetoothAutopairCb;
      rCallbacks.fvOnBluetoothHFPStatusRequest = &spi_tclBDCLCmdBluetooth::vOnBluetoothHFPStatusRequestCb;
      rCallbacks.fvOnBluetoothIdentifyResultInd = &spi_tclBDCLCmdBluetooth::vOnBluetoothIdentifyResultIndCb;

      m_spoBluetoothProxy->vRegisterBTCallbacks(rCallbacks);

      bResult = true;
   }
   ETG_TRACE_USR1(("[DESC]::spi_tclBDCLCmdBluetooth::bInitialize left with result = %d ", ETG_ENUM(BOOL, bResult)));
   return bResult;
}

/***************************************************************************
 ** FUNCTION:   t_Void vUninitialize()
 ***************************************************************************/
t_Void spi_tclBDCLCmdBluetooth::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::vUninitialize entered "));
   m_spoBluetoothProxy = nullptr;
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnMDBluetoothOOBInfoCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdBluetooth::vOnMDBluetoothOOBInfoCb(S_BT_OOB_INFO* prOOBInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::vOnMDBluetoothOOBInfoCb entered"));
   SPI_NORMAL_ASSERT(NULL == prOOBInfo);

   if (NULL != prOOBInfo)
   {
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: MD Bluetooth address = %s",prOOBInfo->address.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: passKey = %s",prOOBInfo->passKey.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: hash = %s", prOOBInfo->hash.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: randomizer = %s", prOOBInfo->randomizer.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: uuid = %s", prOOBInfo->uuid.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: MD BT name = %s", prOOBInfo->name.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vOnMDBluetoothOOBInfoCb: status = %d", prOOBInfo->status));


      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         t_String szBTAddress = prOOBInfo->address.c_str();
         std::transform(szBTAddress.begin(), szBTAddress.end(), szBTAddress.begin(), ::toupper);
         BDCLBluetoothOOBInfoMsg oBluetoothOOBInfoMsg;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->szBTAddress = szBTAddress;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->szPassKey = prOOBInfo->passKey;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->szHash = prOOBInfo->hash;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->szRamdomizer = prOOBInfo->randomizer;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->szUUID = prOOBInfo->uuid;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->szName = prOOBInfo->name;
         oBluetoothOOBInfoMsg.m_prBluetoothOOBInfo->enBTStatus = static_cast<tenBdclHUBTStatus>(prOOBInfo->status);
      
         poMsgQInterface->bWriteMsgToQ(&oBluetoothOOBInfoMsg, sizeof(oBluetoothOOBInfoMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prInfo)
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnBluetoothHFPRequestCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdBluetooth::vOnBluetoothHFPRequestCb(S_BT_HFP_REQUEST* prBTHFPRequestInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::vOnBluetoothHFPRequestCb entered"));
   SPI_NORMAL_ASSERT(NULL == prBTHFPRequestInfo);

   if (NULL != prBTHFPRequestInfo)
   {
      ETG_TRACE_USR1(("[PARAM]::vOnBluetoothHFPRequestCb: command = %d ", prBTHFPRequestInfo->command));
      ETG_TRACE_USR1(("[PARAM]::vOnBluetoothHFPRequestCb: phoneNum = %s ", prBTHFPRequestInfo->phoneNum.c_str()));
      ETG_TRACE_USR1(("[PARAM]::vOnBluetoothHFPRequestCb: dtmfCode = %d ", prBTHFPRequestInfo->dtmfCode));
	  
      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         BDCLBluetoothHFPRequestMsg oBluetoothHFPRequestMsg;
         oBluetoothHFPRequestMsg.m_prBluetoothHFPRequest->enCommand = static_cast<tenBdclRequestType>(prBTHFPRequestInfo->command);
         oBluetoothHFPRequestMsg.m_prBluetoothHFPRequest->szPhoneNum = prBTHFPRequestInfo->phoneNum;
         oBluetoothHFPRequestMsg.m_prBluetoothHFPRequest->u32DTMFCode = prBTHFPRequestInfo->dtmfCode;
		 
         poMsgQInterface->bWriteMsgToQ(&oBluetoothHFPRequestMsg, sizeof(oBluetoothHFPRequestMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prException)
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnStartBluetoothAutopairCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdBluetooth::vOnStartBluetoothAutopairCb(S_BT_START_PAIR_REQ* prStartBTAutopairReqInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::vOnStartBluetoothAutopairCb entered"));
   SPI_NORMAL_ASSERT(NULL == prStartBTAutopairReqInfo);

   if (NULL != prStartBTAutopairReqInfo)
   {
      ETG_TRACE_USR1(("[PARAM]::vOnStartBluetoothAutopairCb: osType = %u ", prStartBTAutopairReqInfo->osType));
      ETG_TRACE_USR1(("[PARAM]::vOnStartBluetoothAutopairCb: address = %s ", prStartBTAutopairReqInfo->address.c_str()));

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         BDCLStartBluetoothAutopairMsg oStartBluetoothAutopairMsg;
         oStartBluetoothAutopairMsg.m_prStartBluetoothAutopair->enOSType = static_cast<tenBdclOSType>(prStartBTAutopairReqInfo->osType);
         oStartBluetoothAutopairMsg.m_prStartBluetoothAutopair->szMDBTAddress = prStartBTAutopairReqInfo->address;

         poMsgQInterface->bWriteMsgToQ(&oStartBluetoothAutopairMsg, sizeof(oStartBluetoothAutopairMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prException)
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnBluetoothHFPStatusRequestCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdBluetooth::vOnBluetoothHFPStatusRequestCb(S_BT_HFP_STATUS_REQUEST* prBTHFPStatusReqInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::vOnBluetoothHFPStatusRequestCb entered"));
   SPI_NORMAL_ASSERT(NULL == prBTHFPStatusReqInfo);

   if (NULL != prBTHFPStatusReqInfo)
   {
      ETG_TRACE_USR1(("[PARAM]::vOnBluetoothHFPStatusRequestCb: type = %d ", prBTHFPStatusReqInfo->type));

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         BDCLBluetoothHFPStatusRequestMsg oBluetoothHFPStatusRequestMsg;
         oBluetoothHFPStatusRequestMsg.enType =  static_cast<tenBdclStatusType>(prBTHFPStatusReqInfo->type);

         poMsgQInterface->bWriteMsgToQ(&oBluetoothHFPStatusRequestMsg, sizeof(oBluetoothHFPStatusRequestMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prException)
}

/***************************************************************************
 ** FUNCTION:  static t_Void vOnBluetoothIdentifyResultIndCb(...)
 ***************************************************************************/
t_Void spi_tclBDCLCmdBluetooth::vOnBluetoothIdentifyResultIndCb(S_BT_INDENTIFY_RESULT_IND* prBTIdentityResultIndInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::vOnBluetoothIdentifyResultIndCb entered"));
   SPI_NORMAL_ASSERT(NULL == prBTIdentityResultIndInfo);

   if (NULL != prBTIdentityResultIndInfo)
   {
      
      ETG_TRACE_USR2(("[PARAM]::vOnBluetoothIdentifyResultIndCb: Status = %d ", prBTIdentityResultIndInfo->status));
      ETG_TRACE_USR2(("[PARAM]::vOnBluetoothIdentifyResultIndCb: Address = %s ", prBTIdentityResultIndInfo->address.c_str()));

      spi_tclBDCLMsgQInterface* poMsgQInterface = spi_tclBDCLMsgQInterface::getInstance();
      if (NULL != poMsgQInterface)
      {
         BDCLBluetoothIdentifyResultIndMsg oBluetoothIdentifyResultIndMsg;
         oBluetoothIdentifyResultIndMsg.m_prBluetoothIdentifyResultInd->enStatus =  static_cast<tenBdclBTIdentificationStatus>(prBTIdentityResultIndInfo->status);
         oBluetoothIdentifyResultIndMsg.m_prBluetoothIdentifyResultInd->szHUBTAddress = prBTIdentityResultIndInfo->address;

         poMsgQInterface->bWriteMsgToQ(&oBluetoothIdentifyResultIndMsg, sizeof(oBluetoothIdentifyResultIndMsg));
      }//if (NULL != poMsgQinterface)
   }//if (NULL != prException)
}

/***************************************************************************
 ** FUNCTION:  static t_Void bSendHUBluetoothOOBInfo(...)
 ***************************************************************************/
t_Bool spi_tclBDCLCmdBluetooth::bSendHUBluetoothOOBInfo(trBdclBluetoothOOBInfo *prOOBInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::bSendHUBluetoothOOBInfo entered"));

   if(NULL != prOOBInfo)
   {
	   ETG_TRACE_USR2(("[PARAM]::bSendHUBluetoothOOBInfo: Passkey = %s ", prOOBInfo->szPassKey.c_str()));
	   ETG_TRACE_USR2(("[PARAM]::bSendHUBluetoothOOBInfo: HU BT Address = %s ", prOOBInfo->szBTAddress.c_str()));
	   ETG_TRACE_USR2(("[PARAM]::bSendHUBluetoothOOBInfo: HU BT Friendly Name = %s ", prOOBInfo->szName.c_str()));
	   ETG_TRACE_USR2(("[PARAM]::bSendHUBluetoothOOBInfo: Status = %d ", prOOBInfo->enBTStatus));
	   ETG_TRACE_USR2(("[PARAM]::bSendHUBluetoothOOBInfo: Ispaired = %u ",ETG_ENUM(BOOL, prOOBInfo->bIsPaired)));
   }

   t_Bool bRetVal = false;
   if((NULL != m_spoBluetoothProxy) && (NULL != prOOBInfo))
   {
      m_spoBluetoothProxy->vSendHUBTOOBInfo(prOOBInfo);
      bRetVal = true;
   }
   return bRetVal;
}

/*******************************************************************************************************
 ** FUNCTION:  static t_Void bSendBluetoothHFPIndication(...)
 ******************************************************************************************************/
t_Bool spi_tclBDCLCmdBluetooth::bSendBluetoothHFPIndication(trBdclBluetoothHFPIndication *prHFPIndication)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::bSendBluetoothHFPIndication entered"));
   if (NULL != m_spoBluetoothProxy)
   {
	   m_spoBluetoothProxy->vSendBTHfpIndication(prHFPIndication);
	   return true;
   }
   else
	   return false;
}

/*******************************************************************************************************
 ** FUNCTION:  static t_Void bSendBluetoothHFPResponse(...)
 ******************************************************************************************************/
t_Bool spi_tclBDCLCmdBluetooth::bSendBluetoothHFPResponse(trBdclBluetoothHFPResponse *prHFPResponse)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::bSendBluetoothHFPResponse entered"));
   if (NULL != m_spoBluetoothProxy)
   {
	   m_spoBluetoothProxy->vSendBTHfpResponse(prHFPResponse);
	   return true;
   }
   else
	   return false;
}

/*******************************************************************************************************
 ** FUNCTION:  static t_Void bSendBluetoothHFPResponse(...)
 ******************************************************************************************************/
t_Bool spi_tclBDCLCmdBluetooth::bSendBluetoothHFPStatusResponse(trBdclBluetoothHFPStatusResponse *prHFPStatusResponse)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::bSendBluetoothHFPStatusResponse entered"));
   if (NULL != m_spoBluetoothProxy)
   {
	   m_spoBluetoothProxy->vSendBTHfpStatusResponse(prHFPStatusResponse);
	   return true;
   }
   else
	   return false;
}

/*******************************************************************************************************
 ** FUNCTION:  static t_Void bSendBluetoothStartIndentifyReq(...)
 ******************************************************************************************************/
t_Bool spi_tclBDCLCmdBluetooth::bSendBluetoothStartIndentifyReq(t_String szBTMacAddress)
{
   ETG_TRACE_USR1(("spi_tclBDCLCmdBluetooth::bSendBluetoothStartIndentifyReq entered"));
   if (NULL != m_spoBluetoothProxy)
   {
      m_spoBluetoothProxy->vSendBTStartIdentifyRequest(szBTMacAddress);
     return true;
   }
   else
     return false;
}

