/***********************************************************************/
/*!
* \file  spi_tclBDCLBluetoothDispatcher.cpp
* \brief Message Dispatcher for Bluetooth Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Bluetooth Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
05.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclBDCLRespBluetooth.h"
#include "spi_tclBDCLBluetoothDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclBDCLBluetoothDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleBluetoothMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothMsgBase::BDCLBluetoothMsgBase
 ***************************************************************************/
BDCLBluetoothMsgBase::BDCLBluetoothMsgBase()
{
   ETG_TRACE_USR1(("BDCLBluetoothMsgBase::BDCLBluetoothMsgBase entered "));
   vSetServiceID (e32MODULEID_BDCLBLUETOOTH);
}

/***************************************************************************
 ** FUNCTION:  BDCLMDInfoMsg::BDCLMDInfoMsg
 ***************************************************************************/
BDCLBluetoothOOBInfoMsg::BDCLBluetoothOOBInfoMsg() : m_prBluetoothOOBInfo(NULL)
{
   ETG_TRACE_USR1(("BDCLBluetoothOOBInfoMsg::BDCLBluetoothOOBInfoMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothOOBInfoMsg::BDCLBluetoothOOBInfoMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLBluetoothOOBInfoMsg, spi_tclBDCLBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothOOBInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLBluetoothOOBInfoMsg::vAllocateMsg()
{
   m_prBluetoothOOBInfo = new trBdclBluetoothOOBInfo;
   SPI_NORMAL_ASSERT(NULL == m_prBluetoothOOBInfo);
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothOOBInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLBluetoothOOBInfoMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prBluetoothOOBInfo);
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothHFPRequestMsg::BDCLBluetoothHFPRequestMsg
 ***************************************************************************/
BDCLBluetoothHFPRequestMsg::BDCLBluetoothHFPRequestMsg(): m_prBluetoothHFPRequest(NULL)
{
   ETG_TRACE_USR1(("BDCLBluetoothHFPRequestMsg::BDCLBluetoothHFPRequestMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothHFPRequestMsg::BDCLBluetoothHFPRequestMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLBluetoothHFPRequestMsg, spi_tclBDCLBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothHFPRequestMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLBluetoothHFPRequestMsg::vAllocateMsg()
{
   m_prBluetoothHFPRequest = new trBdclBluetoothHFPRequest;
   SPI_NORMAL_ASSERT(NULL == m_prBluetoothHFPRequest);
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothHFPRequestMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLBluetoothHFPRequestMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prBluetoothHFPRequest);
}

/***************************************************************************
 ** FUNCTION:  BDCLStartBluetoothAutopairMsg::BDCLStartBluetoothAutopairMsg
 ***************************************************************************/
BDCLStartBluetoothAutopairMsg::BDCLStartBluetoothAutopairMsg(): m_prStartBluetoothAutopair(NULL)
{
   ETG_TRACE_USR1(("BDCLStartBluetoothAutopairMsg::BDCLStartBluetoothAutopairMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLStartBluetoothAutopairMsg::BDCLStartBluetoothAutopairMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLStartBluetoothAutopairMsg, spi_tclBDCLBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLStartBluetoothAutopairMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLStartBluetoothAutopairMsg::vAllocateMsg()
{
   m_prStartBluetoothAutopair = new trBdclStartBluetoothAutopair;
   SPI_NORMAL_ASSERT(NULL == m_prStartBluetoothAutopair);
}

/***************************************************************************
 ** FUNCTION:  BDCLStartBluetoothAutopairMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLStartBluetoothAutopairMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prStartBluetoothAutopair);
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothHFPStatusRequestMsg::BDCLBluetoothHFPStatusRequestMsg
 ***************************************************************************/
BDCLBluetoothHFPStatusRequestMsg::BDCLBluetoothHFPStatusRequestMsg():enType(e8CL_STATUS_MIC)
{
   ETG_TRACE_USR1(("BDCLBluetoothHFPStatusRequestMsg::BDCLBluetoothHFPStatusRequestMsg entered "));
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothHFPStatusRequestMsg::BDCLBluetoothHFPStatusRequestMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLBluetoothHFPStatusRequestMsg, spi_tclBDCLBluetoothDispatcher);

/***********************************************************************************
 ** FUNCTION:  BDCLBluetoothIdentifyResultIndMsg::BDCLBluetoothIdentifyResultIndMsg
 ***********************************************************************************/
BDCLBluetoothIdentifyResultIndMsg::BDCLBluetoothIdentifyResultIndMsg(): m_prBluetoothIdentifyResultInd(NULL)
{
   ETG_TRACE_USR1(("BDCLBluetoothIdentifyResultIndMsg::BDCLBluetoothIdentifyResultIndMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLBluetoothIdentifyResultIndMsg::BDCLBluetoothIdentifyResultIndMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLBluetoothIdentifyResultIndMsg, spi_tclBDCLBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLStartBluetoothAutopairMsg::vAllocateMsg
 *****************************************************poBDCLBluetoothIdentifyResultIndMsg**********************/
t_Void BDCLBluetoothIdentifyResultIndMsg::vAllocateMsg()
{
   m_prBluetoothIdentifyResultInd = new trBdclBluetoothIdentifyResultInd;
   SPI_NORMAL_ASSERT(NULL == m_prBluetoothIdentifyResultInd);
}

/***************************************************************************
 ** FUNCTION:  BDCLStartBluetoothAutopairMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLBluetoothIdentifyResultIndMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prBluetoothIdentifyResultInd);
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::spi_tclBDCLBluetoothDispatcher
 ***************************************************************************/
spi_tclBDCLBluetoothDispatcher::spi_tclBDCLBluetoothDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLBluetoothDispatcher::spi_tclBDCLBluetoothDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::~spi_tclBDCLBluetoothDispatcher
 ***************************************************************************/
spi_tclBDCLBluetoothDispatcher::~spi_tclBDCLBluetoothDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLBluetoothDispatcher::~spi_tclBDCLBluetoothDispatcher "));
}

/**********************************************************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothOOBInfoMsg* poBDCLBluetoothOOBInfoMsg)
 **********************************************************************************************************************/
t_Void spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothOOBInfoMsg* poBDCLBluetoothOOBInfoMsg) const
{
   ETG_TRACE_USR1((" spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg:BluetoothOOBInfo entered "));
   if (NULL != poBDCLBluetoothOOBInfoMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespBluetooth,
               e16BDCL_BLUETOOTH_REGID,
               vOnBluetoothOOBInfoMsg(poBDCLBluetoothOOBInfoMsg->m_prBluetoothOOBInfo));
   } // if (NULL != poBDCLBluetoothOOBInfoMsg)
}

/****************************************************************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothHFPRequestMsg* poBDCBluetoothHFPRequestMsg)
 ****************************************************************************************************************************/
t_Void spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothHFPRequestMsg* poBDCBluetoothHFPRequestMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg:BT HFP Request entered "));
   if (NULL != poBDCBluetoothHFPRequestMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespBluetooth,
               e16BDCL_BLUETOOTH_REGID,
               vOnBluetoothHFPRequestMsg(poBDCBluetoothHFPRequestMsg->m_prBluetoothHFPRequest));
   } // if (NULL != poBDCBluetoothHFPRequestMsg)
}

/****************************************************************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLStartBluetoothAutopairMsg* poBDCLStartBluetoothAutopairMsg)
 ****************************************************************************************************************************/
t_Void spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLStartBluetoothAutopairMsg* poBDCLStartBluetoothAutopairMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg:Start BT AutoPair entered "));
   if (NULL != poBDCLStartBluetoothAutopairMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespBluetooth,
               e16BDCL_BLUETOOTH_REGID,
               vOnStartBluetoothAutoPairMsg(poBDCLStartBluetoothAutopairMsg->m_prStartBluetoothAutopair));
   } // if (NULL != poBDCLStartBluetoothAutopairMsg)
}

/*****************************************************************************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothHFPStatusRequestMsg* poBDCLBluetoothHFPStatusRequestMsg)
 *****************************************************************************************************************************************/
t_Void spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothHFPStatusRequestMsg* poBDCLBluetoothHFPStatusRequestMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg: HFP Status Request entered "));
   if (NULL != poBDCLBluetoothHFPStatusRequestMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespBluetooth,
               e16BDCL_BLUETOOTH_REGID,
               vOnBluetoothHFPStatusRequestMsg(poBDCLBluetoothHFPStatusRequestMsg->enType));
   } // if (NULL != poBDCLBluetoothHFPStatusRequestMsg)
}

/*****************************************************************************************************************************************
 ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothIdentifyResultIndMsg* poBDCLBluetoothIdentifyResultIndMsg)
 *****************************************************************************************************************************************/
t_Void spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothIdentifyResultIndMsg* poBDCLBluetoothIdentifyResultIndMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg: BT Identify Result entered "));
   if (NULL != poBDCLBluetoothIdentifyResultIndMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespBluetooth,
               e16BDCL_BLUETOOTH_REGID,
               vOnBluetoothIdentifyResultIndMsg(poBDCLBluetoothIdentifyResultIndMsg->m_prBluetoothIdentifyResultInd));
   } // if (NULL != poBDCLBluetoothIdentifyResultIndMsg)
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
