/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdAudio.h
* \brief  Implementation of the Class spi_tclBDCLCmdAudio
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLCMDAUDIO_
#define SPI_TCLBDCLCMDAUDIO_

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "SPITypes.h"
#include "spi_tclAudioSettingsIntf.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
static const t_U8 scu8MaxNumAudioSinks = 3;

//! Forward declarations
class spi_tclBDCLAudioSinkAdapt;
class spi_tclBDCLAudioSourceAdapt;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/*!
 * \class spi_tclBDCLCmdAudio
 * \brief
 */
class spi_tclBDCLCmdAudio
{
   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCmdAudio()
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLCmdAudio()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLCmdAudio()
       **************************************************************************/
      spi_tclBDCLCmdAudio();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLCmdAudio()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLCmdAudio()
       * \brief    Destructor
       * \sa       spi_tclBDCLCmdAudio()
       **************************************************************************/
     virtual ~spi_tclBDCLCmdAudio();

     /***************************************************************************
      ** FUNCTION:  t_Void vSetAudioPipeConfig()
      ***************************************************************************/
     /*!
      * \fn      t_Void vSetAudioPipeConfig()
      * \brief   Set the Audio pipeline configuration for alsa devices
      * \param   crfmapAudioPipeConfig: Contains audio pipeline configuration
      **************************************************************************/
     t_Void vSetAudioPipeConfig(const tmapAudioPipeConfig& crfmapAudioPipeConfig);

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Creates the Audio Sink and Audio Source for various Audio streams
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Creates the Audio Sink and Audio Source for various Audio streams
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool bStartAudioPlayback(tenBdclAudStreamType enAudStream)
       ***************************************************************************/
      /*!
       * \fn      bStartAudioPlayback()
       * \brief   Trigger received when Audio channel has been allocated
       *          (On source activity ON)
       **************************************************************************/
      t_Bool bStartAudioPlayback(tenBdclAudStreamType enAudStream);

      /***************************************************************************
       ** FUNCTION:  t_Bool bStopAudioPlayback()
       ***************************************************************************/
      /*!
       * \fn      bStopAudioPlayback()
       * \brief   Sends a StopPlayback request to audio sink
       **************************************************************************/
      t_Bool bStopAudioPlayback(tenBdclAudStreamType enAudStream, t_Bool bFlushBuffer = false);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioStreamConfig(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioStreamConfig()
       * \brief   Function to set Audio config for a specific stream and key.
       * \param   enAudStream: Audio stream type for which config has to be set
       * \param   szConfigKey: Type of the configuration
       * \param   enAudioStreamConfig: Audio stream configuration  to be set
       * \sa      None
       **************************************************************************/
      t_Void vSetAudioStreamConfig(tenBdclAudStreamType enAudStream, t_String szConfigKey,
               tenAudioStreamConfig enAudioStreamConfig);

      /***************************************************************************
       ** FUNCTION: t_Void vRegisterAudioCbs()
       ***************************************************************************/
      /*!
       * \fn      vRegisterAudioCbs()
       * \brief   Interface to Register for audio callbacks
       * \param   rAudioCbs: [IN] Structure containing callbacks
       **************************************************************************/
      t_Void vRegisterAudioCbs(trBdclAudioCbs rAudioCbs);

      /***************************************************************************
       ** FUNCTION: t_Void vProcessAudioRequest()
       ***************************************************************************/
      /*!
       * \fn      vProcessAudioRequest()
       * \brief   Interface to process audio request from CL device
       * \param   crfrRequest: [IN] Structure containing audio request info
       **************************************************************************/
      t_Void vProcessAudioRequest(const trBdclAudioRequest& crfrRequest);

      /***************************************************************************
      ** FUNCTION:  t_Void vSetModuleState()
      ***************************************************************************/
      /*!
       * \fn      vSetModuleState
       * \brief   Interface to notify different audio module state changes
       * \param   enAudStream: [IN] Audio stream type
       * \param   bModuleActive: [IN] TRUE if module is active, else FALSE
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetModuleState(tenBdclAudStreamType enAudStream, t_Bool bModuleActive);


      /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioSettingsInstance(spi_tclAudioSettingsIntf* poAudioSettingsIntf)
       ***************************************************************************/
       /*!
       * \fn      t_Void vSetAudioSettingsInstance()
       * \brief   Method to set Audio settings instance.
       * \param   poAudioSettingsIntf  : pointer to AudioSettingsIntf.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAudioSettingsInstance(spi_tclAudioSettingsIntf* poAudioSettingsIntf);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLCmdAudio(const spi_tclBDCLCmdAudio&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCmdAudio(const spi_tclBDCLCmdAudio&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLCmdAudio(const spi_tclBDCLCmdAudio&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLCmdAudio & operator=(const spi_tclBDCLCmdAudio&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLCmdAudio & operator=(const spi_tclBDCLCmdAudio&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLCmdAudio & operator=(const spi_tclBDCLCmdAudio&);

      /***************************************************************************
       ** FUNCTION:   t_Bool bGetAudioPipeConfig()
       ***************************************************************************/
      /*!
       * \fn      bGetAudioPipeConfig()
       * \brief   Returns audio configuration data for requested stream
       * \param   enAudioStream: [IN] Audio stream type
       * \param   rfszAudioPipeConfig: [OUT] Audio configuration data
       **************************************************************************/
      t_Bool bGetAudioPipeConfig(tenBdclAudStreamType enAudioStream,
            t_String& rfszAudioPipeConfig);


      //! Array of Pointers for various Audio Sink streams
      spi_tclBDCLAudioSinkAdapt* m_mapAudioSinks[scu8MaxNumAudioSinks];

      //! Pointer to spi_tclBDCLAudioSourceAdapt class for Microphone stream
      spi_tclBDCLAudioSourceAdapt* m_poMicAudioSource;

      //! Map to store audio pipeline configuration for different audio streams
      tmapAudioPipeConfig m_mapAudioPipeConfig;

      trBdclAudioCbs m_rAudioCbs;

      //!pointer for Audio Settings Interface class
      spi_tclAudioSettingsIntf* m_poAudioSettings;

};

#endif //SPI_TCLBDCLCMDAUDIO_
