/***********************************************************************/
/*!
* \file  spi_tclBDCLAudioSinkAdapt.h
* \brief  Implementation of the Class spi_tclBDCLAudioSinkAdapt
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLAUDIOSINKADAPT_
#define SPI_TCLBDCLAUDIOSINKADAPT_

#include <memory>

#include <bdcl/AditAudioSink.h>

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "Lock.h"
#include "spi_tclAudioSettingsIntf.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::unique_ptr< adit::bdcl::AditAudioSink >  tSptrAditAudioSink;

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/


/*!
 * \class spi_tclBDCLAudioSinkAdapt
 * \brief
 */
class spi_tclBDCLAudioSinkAdapt : public adit::bdcl::IAditAudioSinkCallbacks
{

public:
      /***************************************************************************
       ** FUNCTION:   spi_tclBDCLAudioSinkAdapt()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioSinkAdapt()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLAudioSinkAdapt()
       **************************************************************************/
      spi_tclBDCLAudioSinkAdapt(tenBdclAudStreamType enAudStream);

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLAudioSinkAdapt()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLAudioSinkAdapt()
       * \brief   Destructor
       * \sa      spi_tclBDCLAudioSinkAdapt()
       **************************************************************************/
      virtual ~spi_tclBDCLAudioSinkAdapt();

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Initializes session by creating and registering Audio Sink
       * \retval  true : initialized successfull.
       * \retval  false : Initialization failed
       * \param   crfszAudioPipeConfig: [IN] Audio device configuration
       * \sa      vUnintialize()
       **************************************************************************/
      t_Bool bInitialize(const t_String& crfszAudioPipeConfig);

      /***************************************************************************
       ** FUNCTION:  t_Void vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Uninitializes session
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool bStartAudioPlayback()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bStartAudioPlayback()
       * \brief   Function to trigger playback has started once audio channel is allocated.
       * \retval  True if Playback can be initialized, else FALSE
       * \sa      None
       **************************************************************************/
      t_Bool bStartAudioPlayback();

      /***************************************************************************
       ** FUNCTION:  t_Bool bStopAudioPlayback()
       ***************************************************************************/
      /*!
       * \fn      bStopAudioPlayback()
       * \brief   Triggers a StopPlayback request to audio sink and notifies event
       *          via dispatcher
       **************************************************************************/
      t_Bool bStopAudioPlayback(t_Bool bFlushBuffer = false);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioStreamConfig()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioStreamConfig()
       * \brief   Function to set Audio config for a specific stream and key.
       * \sa      None
       **************************************************************************/
      t_Void vSetAudioStreamConfig(t_String szConfigKey, t_String szConfigValue);

       /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioSettingsInstance (spi_tclAudioSettingsIntf* poAudioSettingsIntf)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioSettingsInstance()
       * \brief   Function to set Audio settings pointer.
       * \param   poAudioSettingsIntf: [IN] Audio settings pointer
       * \sa      None
       **************************************************************************/
      t_Void vSetAudioSettingsInstance (spi_tclAudioSettingsIntf* poAudioSettingsIntf);

private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLAudioSinkAdapt(const spi_tclBDCLAudioSinkAdapt&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioSinkAdapt(const spi_tclBDCLAudioSinkAdapt&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLAudioSinkAdapt(const spi_tclBDCLAudioSinkAdapt&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLAudioSinkAdapt & operator=(const spi_tclBDCLAudioSinkAdapt&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLAudioSinkAdapt & operator=(const spi_tclBDCLAudioSinkAdapt&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLAudioSinkAdapt & operator=(const spi_tclBDCLAudioSinkAdapt&);

      /***************************************************************************
       ** FUNCTION:  void onPlaybackInit()
       ***************************************************************************/
      /*!
       * \fn      onPlaybackInit()
       * \brief   Callback to receive PlaybackInit from MD
       * \param   inSampleRate [IN]:
       * \param   inChannelConfig [IN]:
       * \param   inSampleFormat [IN]:
       **************************************************************************/
      virtual void onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig,
            unsigned int inSampleFormat);

      /***************************************************************************
       ** FUNCTION:  void onPlaybackPause()
       ***************************************************************************/
      /*!
       * \fn      onPlaybackPause()
       * \brief   Callback to receive PlaybackPause from MD
       **************************************************************************/
      virtual void onPlaybackPause();

      /***************************************************************************
       ** FUNCTION:  void onPlaybackResume()
       ***************************************************************************/
      /*!
       * \fn      onPlaybackResume()
       * \brief   Callback to receive PlaybackResume from MD
       **************************************************************************/
      virtual void onPlaybackResume();

      /***************************************************************************
       ** FUNCTION:  void onPlaybackStop()
       ***************************************************************************/
      /*!
       * \fn      onPlaybackStop()
       * \brief   Callback to receive PlaybackStop from MD
       **************************************************************************/
      virtual void onPlaybackStop();

      /***************************************************************************
       ** FUNCTION:  void onPlaybackInterrupt()
       ***************************************************************************/
      /*!
       * \fn      onPlaybackInterrupt()
       * \brief   Callback to receive VR Interrupt from MD
       **************************************************************************/
      virtual void onPlaybackInterrupt();

      /***************************************************************************
       ** FUNCTION:  void onError()
       ***************************************************************************/
      /*!
       * \fn      onError()
       * \brief   Callback to receive errors from Audio sink
       * \param   [IN] inErrorCode: Error type enumeration
       **************************************************************************/
      virtual void onError(tBdclErrorCodes inErrorCode);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioStreamConfig( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioStreamConfig()
       * \brief   Function to set the Audio configuration for specific streams.
       * \param   crfszAudioPipeConfig: [IN] Audio device configuration
       **************************************************************************/
      t_Void vSetAudioStreamConfig(const t_String& crfszAudioPipeConfig);

      //! Variable for Audio Stream Type
      const tenBdclAudStreamType m_cenStreamType;

      //! Pointer to an Audio sink object
      tSptrAditAudioSink m_spoAudioSink;

      //! Lock object for Audio Sink
      Lock  m_oAudSinkLock;

      spi_tclAudioSettingsIntf* m_poAudioSettings;

};
#endif //SPI_TCLBDCLAUDIOSINKADAPT_
