/***********************************************************************/
/*!
* \file  spi_tclBDCLAudioDispatcher.h
* \brief Message Dispatcher for Video Messages. implemented using
*        double dispatch mechanism
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Video Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLAUDIODISPATCHER_H_
#define SPI_TCLBDCLAUDIODISPATCHER_H_

/******************************************************************* ********
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "BDCLTypes.h"

//!Forward declarations
class spi_tclBDCLAudioDispatcher;

/****************************************************************************/
/*!
 * \class BDCLAudioMsgBase
 * \brief Base Message type for all Audio messages
 ****************************************************************************/
class BDCLAudioMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLAudioMsgBase::BDCLAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLAudioMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLAudioMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLAudioMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLAudioDispatcher* poBDCLAudioDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poBDCLAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLAudioDispatcher* poBDCLAudioDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLAudioMsgBase::~BDCLAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLAudioMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLAudioMsgBase()
      {
      }
};

/****************************************************************************/
/*!
 * \class BDCLAudioRequestMsg
 * \brief Audio message for various streams
 ****************************************************************************/
class BDCLAudioRequestMsg: public BDCLAudioMsgBase
{
   public:
      trBdclAudioRequest m_rAudioRequest;

      /***************************************************************************
       ** FUNCTION:  BDCLAudioRequestMsg::BDCLAudioRequestMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLAudioRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLAudioRequestMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLAudioRequestMsg::~BDCLAudioRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLAudioRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLAudioRequestMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLAudioRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLAudioDispatcher* poBDCLAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBDCLAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLAudioDispatcher* poBDCLAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLAudioRequestMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLAudioRequestMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};

/****************************************************************************/
/*!
 * \class BDCLVRModuleStatusMsg
 * \brief Audio message for various streams
 ****************************************************************************/
class BDCLVRModuleStatusMsg: public BDCLAudioMsgBase
{
   public:
      tenBdclVRState m_enVRState;

      /***************************************************************************
       ** FUNCTION:  BDCLVRModuleStatusMsg::BDCLVRModuleStatusMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLVRModuleStatusMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLVRModuleStatusMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLVRModuleStatusMsg::~BDCLVRModuleStatusMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLVRModuleStatusMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLVRModuleStatusMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVRModuleStatusMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLAudioDispatcher* poBDCLAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBDCLAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLAudioDispatcher* poBDCLAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLVRModuleStatusMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLVRModuleStatusMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {
      }
};

/****************************************************************************/
/*!
 * \class spi_tclBDCLAudioDispatcher
 * \brief Message Dispatcher for Audio Messages
 ****************************************************************************/
class spi_tclBDCLAudioDispatcher
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioDispatcher::spi_tclBDCLAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclBDCLAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioDispatcher::~spi_tclBDCLAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLSessionDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioDispatcher::vHandleAudioMsg(BDCLAudioRequestMsg*
       **            poMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(BDCLAudioRequestMsg* poMsg)
       * \brief   Handles Messages of BDCLAudioRequestMsg type
	    * \param   poMsg : pointer to BDCLAudioRequestMsg.
       **************************************************************************/
      t_Void vHandleAudioMsg(BDCLAudioRequestMsg* poMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioDispatcher::vHandleAudioMsg(BDCLVRModuleStatusMsg*
       **            poMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(BDCLVRModuleStatusMsg* poMsg)
       * \brief   Handles Messages of BDCLVRModuleStatusMsg type
       * \param   poMsg : pointer to BDCLVRModuleStatusMsg.
       **************************************************************************/
      t_Void vHandleAudioMsg(BDCLVRModuleStatusMsg* poMsg) const;

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioDispatcher(const spi_tclBDCLAudioDispatcher...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioDispatcher(
       *                             const spi_tclBDCLAudioDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLAudioDispatcher()
       ***************************************************************************/
      spi_tclBDCLAudioDispatcher(const spi_tclBDCLAudioDispatcher& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAudioDispatcher& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioDispatcher& operator=(
       *                          const spi_tclBDCLAudioDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLAudioDispatcher(const spi_tclBDCLAudioDispatcher& corfoSrc)
       ***************************************************************************/
      spi_tclBDCLAudioDispatcher& operator=(const spi_tclBDCLAudioDispatcher& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclBDCLAudioDispatcher


#endif // SPI_TCLBDCLAUDIODISPATCHER_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
