/***********************************************************************/
/*!
 * \file  spi_tclBDCLAppMngr.cpp
 * \brief BDCL App Mngr Implementation
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    BDCL App Mngr Implementation
 AUTHOR:         rur1kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                        | Modification
 04.05.2017  | Ramya Murthy                  | Initial Version

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclAppMngrDefines.h"
#include "spi_tclBDCLAppMngr.h"
#include "spi_tclBDCLManager.h"
#include "spi_TBTTypes.h"
#include "spi_tclExtCompManager.h"
#include "spi_tclExtCmdNativeTransport.h"

#ifdef FILEWRITE
#include "FileHandler.h"
using namespace spi::io;
#endif

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_APPMNGR
#include "trcGenProj/Header/spi_tclBDCLAppMngr.cpp.trc.h"
#endif
#endif

static const t_U32 scou32UnknownDevId = 0;

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/***************************************************************************
 ** FUNCTION:  spi_tclBDCLAppMngr::spi_tclBDCLAppMngr()
 ***************************************************************************/
spi_tclBDCLAppMngr::spi_tclBDCLAppMngr(): m_u32SelectedDevId(scou32UnknownDevId),
                                          m_bIsNextTurnDataSubscribed(false),
                                          m_bIsAssistantGuideDataSubscribed(false), m_enSelDeviceType(e8_UNKNOWN_DEVICE)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::spi_tclBDCLAppMngr entered"));
   m_rPhoneCallMetaDataList.enPhoneCallDirection = e8PHONE_CALL_DIRECTION_NOT_KNOWN;
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLAppMngr::~spi_tclBDCLAppMngr()
 ***************************************************************************/
spi_tclBDCLAppMngr::~spi_tclBDCLAppMngr()
{
   ETG_TRACE_USR1((" spi_tclBDCLAppMngr::~spi_tclBDCLAppMngr entered"));
   m_rPhoneCallMetaDataList.enPhoneCallDirection = e8PHONE_CALL_DIRECTION_NOT_KNOWN;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bInitialize()
 ***************************************************************************/
t_Bool spi_tclBDCLAppMngr::bInitialize()
{
   ETG_TRACE_USR1((" spi_tclBDCLAppMngr::bInitialize entered"));

   t_Bool bInitSuccess = false;
   t_SptrBDCLManager spoBDCLManager = spi_tclBDCLManager::getInstance();

   if ((spoBDCLManager) &&
            (true == spoBDCLManager->bRegisterObject((spi_tclBDCLRespMediaData*)this))&&
            (true == spoBDCLManager->bRegisterObject((spi_tclBDCLRespNavigation*)this)))
   {
      bInitSuccess = true;
      m_spoCmdMediaData = spoBDCLManager->spoGetCmdMediaDataInstance();
      m_spoCmdNavigation = spoBDCLManager->spoGetCmdNavigationInstance();
      m_spoCmdInput = spoBDCLManager->spoGetCmdInputInstance();
   }

   if (spoBDCLManager)
   {
      spoBDCLManager->bRegisterObject((spi_tclBDCLRespSession*)this);
   }
   SPI_NORMAL_ASSERT((!spoBDCLManager) || (!m_spoCmdMediaData) || (!m_spoCmdNavigation) || (!m_spoCmdInput));

   ETG_TRACE_USR2(("bInitialise() left with result = %u", bInitSuccess));
   return bInitSuccess;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vUnInitialize()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vUnInitialize()
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vUnInitialize() entered"));

   t_Bool bUnInitSuccess = false;

   t_SptrBDCLManager spoBDCLManager = spi_tclBDCLManager::getInstance();
   if ((spoBDCLManager) &&
            (spoBDCLManager->bUnRegisterObject((spi_tclBDCLRespMediaData*) this)))
   {
      bUnInitSuccess = true;
   }

   ETG_TRACE_USR2(("vUnInitialize() left with result = %u", bUnInitSuccess));
}
/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclBDCLAppMngr::vRegisterAppMngrCallbacks()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vRegisterAppMngrCallbacks(
         const trAppMngrCallbacks& corfrAppMngrCbs)
{
   //Add code
   m_rAppMngrCallbacks = corfrAppMngrCbs;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vSelectDevice()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vSelectDevice(const trSelectDeviceRequest& corfrSelectReq)
{
   /*lint -esym(40,fpvSelectDeviceResult)fpvSelectDeviceResult Undeclared identifier */
   ETG_TRACE_USR2(("[DESC]::vSelectDevice: Dev-0x%x, ConnReq - %d", corfrSelectReq.m_u32DeviceHandle, ETG_ENUM(CONNECTION_REQ, corfrSelectReq.m_enDevConnReq)));

   tenErrorCode enErrCode = e8NO_ERRORS;
   t_Bool bRet = true;
   if (e8DEVCONNREQ_SELECT == corfrSelectReq.m_enDevConnReq)
   {
      //@Note: Appmngr is the first component that receives select device after device switch(DISCOVERER).
      //If the selection sequence changes then this message should be sent by different component.
      //Update selection progress state to HMI
      if (NULL != m_rAppMngrCallbacks.fvSelectionProgressState)
      {
         (m_rAppMngrCallbacks.fvSelectionProgressState)(corfrSelectReq.m_u32DeviceHandle,
                  e8_SELECTION_PROGRESS_STATE_PREPARING_ENDPOINTS);
      }

      //Initialize Video session
      if (m_spoCmdMediaData)
      {
         bRet = (m_spoCmdMediaData->bInitialize()) && bRet;
      }
      if (m_spoCmdNavigation)
      {
         bRet = (m_spoCmdNavigation->bInitialize()) && bRet;
      }

      if (corfrSelectReq.m_enDeviceType == e8_APPLE_DEVICE)
      {
         m_enSelDeviceType = e8_APPLE_DEVICE;
         //Native transport start message will not come until the app is launched on phone.
         //So calling launch app during selection itself
         bSendAppLaunchRequest(corfrSelectReq.m_u32DeviceHandle,corfrSelectReq.m_enDevCategory);
      }else
      {
         m_enSelDeviceType = e8_ANDROID_DEVICE;
         ETG_TRACE_USR2(("[DESC]:spi_tclBDCLAppMngr::vOnSelectDevice for devicetype ANDROID "));
      }
      enErrCode = bRet ? e8NO_ERRORS : e8UNKNOWN_ERROR;
      ETG_TRACE_USR2(("spi_tclBDCLAppMngr::vSelectDevice: enErrCode:%d", enErrCode));

   }//if( corfrSelectReq.m_enDevConnReq == e8DEVCONNREQ_SELECT )
   else if (e8DEVCONNREQ_DESELECT == corfrSelectReq.m_enDevConnReq)
   {
      if (m_spoCmdMediaData)
      {
         m_spoCmdMediaData->vUninitialize();
      }

      //@TODO - check if required. During deselection if device is not connected, this takes 1s because 
      //there is a timeout when trying to write to AOAP socket.
      //vSubscribeForTBTUpdates(false);

      if (m_spoCmdNavigation)
      {
         m_spoCmdNavigation->vUninitialize();
      }

      if (e8PHONE_CALL_DIRECTION_NOT_KNOWN != m_rPhoneCallMetaDataList.enPhoneCallDirection)
      {
         //Added for phone call app state update
         m_rAppPhoneData.tvecPhoneCallMetaDataList.clear();
         m_rAppPhoneData.bPhoneMetadataValid = true;
         m_rPhoneCallMetaDataList.enPhoneCallDirection = e8PHONE_CALL_DIRECTION_NOT_KNOWN;

         //push back data to the vector
         m_rAppPhoneData.tvecPhoneCallMetaDataList.push_back(m_rPhoneCallMetaDataList);
         // post the data to service
         if (NULL != m_rAppMngrCallbacks.fvAppPhoneData)
         {
            m_rAppMngrCallbacks.fvAppPhoneData(m_rAppPhoneData, corEmptyUsrContext);
         }//if (NULL != m_poMplayResp)
      }

      m_enSelDeviceType = e8_UNKNOWN_DEVICE;
   }//else if
   else
   {
      bRet = false;
   }

   if (NULL != m_rAppMngrCallbacks.fpvSelectDeviceResult)
   {
      (m_rAppMngrCallbacks.fpvSelectDeviceResult)(bRet);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bLaunchApp()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vLaunchApp(const t_U32 cou32DevId, t_U32 u32AppId,
         const trUserContext& rfrcUsrCntxt, tenDiPOAppType enDiPOAppType,
         t_String szTelephoneNumber, tenEcnrSetting enEcnrSetting)
{
   /*lint -esym(40,fpvLaunchAppResult)fpvLaunchAppResult Undeclared identifier */
   ETG_TRACE_USR1((" spi_tclBDCLAppMngr::vLaunchApp:Dev-0x%x App-0x%x,Apptype: %d",
            cou32DevId, u32AppId,ETG_ENUM(DIPO_APP_TYPE,enDiPOAppType)));

   SPI_INTENTIONALLY_UNUSED(enEcnrSetting);
   SPI_INTENTIONALLY_UNUSED(szTelephoneNumber);

   if (m_spoCmdInput)
   {
      switch (enDiPOAppType)
      {
         case e8DIPO_NOT_USED:
         case e8DIPO_NO_URL:
         {
            // Just ask for video focus.
            ETG_TRACE_USR1((" spi_tclAAPAppMngr::vLaunchApp:NO URL"));
         }
         break;
         case e8DIPO_MAPS:
         {
            //Send Key code for Navigation
            m_spoCmdInput->vReportKey(e8KEY_RELEASE,e32DEV_NAV);
         }
         break;
         case e8DIPO_MOBILEPHONE:
         {
            // Send Key event for Telephony
            m_spoCmdInput->vReportKey(e8KEY_RELEASE,e32APP_KEYCODE_TELEPHONY);
         }
         break;
         case e8DIPO_MUSIC:
         {
            //Send Key event for Music
            m_spoCmdInput->vReportKey(e8KEY_RELEASE, e32DEV_MEDIA);
         }
         break;
         //Commented as HMI is not sending these Key events for Carlife along with launch app
         /*case e8DIPO_SIRI_BUTTONUP:
           {
               //Send Key event for Voice rec button down
               m_spoCmdInput->vReportKey(e8KEY_RELEASE, e32DEV_PTT);
            }
               break;
            case e8DIPO_SIRI_BUTTONDOWN:
            {
               //Send Key event for voice rec button up
               m_spoCmdInput->vReportKey(e8KEY_PRESS, e32DEV_PTT);
            }
               break;*/
         default:
         {
            // Unsupported Application Type
            ETG_TRACE_USR1((" spi_tclAAPAppMngr::vLaunchApp:Unsupported"));
         }
         break;
      } //switch (enDiPOAppType)
   } //if (m_spoCmdInput)

   bSendAppLaunchRequest(cou32DevId,e8DEV_TYPE_CARLIFE);

   if (NULL != m_rAppMngrCallbacks.fpvLaunchAppResult)
   {
      (m_rAppMngrCallbacks.fpvLaunchAppResult)(cou32DevId, u32AppId,
               enDiPOAppType, e8NO_ERRORS, rfrcUsrCntxt);
   }//if( NULL != m_rAppMngrCallbacks.fpvLaunchAppResult)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vTerminateApp()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vTerminateApp(const t_U32 cou32DevId,
         const t_U32 cou32AppId, const trUserContext& rfrcUsrCntxt)
{
   /*lint -esym(40,fpvTerminateAppResult) fpvTerminateAppResult is not referenced */
   ETG_TRACE_USR1((" spi_tclBDCLAppMngr::vTerminateApp:Dev-0x%x App-0%x",
            cou32DevId, cou32AppId));

   if (NULL != m_rAppMngrCallbacks.fpvTerminateAppResult)
   {
      (m_rAppMngrCallbacks.fpvTerminateAppResult)(cou32DevId, cou32AppId,
               e8NO_ERRORS, rfrcUsrCntxt);
   }//if( NULL != m_rAppMngrCallbacks.fpvTerminateAppResult )
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vGetAppIconData()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vGetAppIconData(t_String szAppIconUrl,
         const trUserContext& rfrcUsrCntxt)
{
   /*lint -esym(40,fpvCbAppIconDataResult) fpvCbAppIconDataResult is not referenced */
   SPI_INTENTIONALLY_UNUSED(szAppIconUrl);

   if (NULL != m_rAppMngrCallbacks.fpvCbAppIconDataResult)
   {
      (m_rAppMngrCallbacks.fpvCbAppIconDataResult)(e8ICON_INVALID, NULL, 0,
               rfrcUsrCntxt);
   }//if( NULL != m_rAppMngrCallbacks.fpvCbAppIconDataResult)
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bCheckAppValidity()
 ***************************************************************************/
t_Bool spi_tclBDCLAppMngr::bCheckAppValidity(const t_U32 cou32DevId,
         const t_U32 cou32AppId)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::bCheckAppValidity entered"));
   SPI_INTENTIONALLY_UNUSED(cou32DevId);
   SPI_INTENTIONALLY_UNUSED(cou32AppId);
   return true;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vSetVehicleConfig();
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig,
         t_Bool bSetConfig)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr:vSetVehicleConfig: %d, SetConfig=%d ",
            enVehicleConfig, ETG_ENUM(BOOL, bSetConfig)));
   SPI_INTENTIONALLY_UNUSED(bSetConfig);
   SPI_INTENTIONALLY_UNUSED(enVehicleConfig);
}


/***********************************************************************************************************************
 ** FUNCTION:  spi_tclBDCLAppMngr::vSetConfigData(..)
 ************************************************************************************************************************/
t_Void spi_tclBDCLAppMngr::vSetConfigData(const trConfigData& rfrConfigData)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vSetConfigData entered"));
   m_rBDCLConfigData = rfrConfigData;
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vMediaMetadataCallback(const trBdclMediaMetadata* rBDCLMediaDataMetadata)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vMediaMetadataCallback entered"));

   trUserContext rfcorUsrCntxt;
   m_rAppMediaMetaData.bMediaMetadataValid = true;
   t_Bool bSolicited = false;
   if(NULL !=rBDCLMediaDataMetadata)
   {
      bSolicited = true;
      //cSource is not the AppNAme . Its is the storage path of the song.
      //Just mapping it to Appname as there is no other variable to indicate the storage path in trAppMediaMetaData. HMI to take call
      //in case if any changes are needed.
      m_rAppMediaMetaData.szAppName.assign(rBDCLMediaDataMetadata->cSource, STR_METADATA_LENGTH);
      m_rAppMediaMetaData.szArtist.assign(rBDCLMediaDataMetadata->cArtist, STR_METADATA_LENGTH);
      m_rAppMediaMetaData.szAlbum.assign(rBDCLMediaDataMetadata->cAlbum, STR_METADATA_LENGTH);
      m_rAppMediaMetaData.szTitle.assign(rBDCLMediaDataMetadata->cSong, STR_METADATA_LENGTH);
      m_rAppMediaMetaData.szImageMIMEType = "";
      m_rAppMediaMetaData.rAppMediaAlbumArt.u8Items.clear();
      m_rAppMediaMetaData.u32QueueCount = rBDCLMediaDataMetadata->u32PlayListNumber;// TODO: Confirm if Correct.
      m_rAppMediaPlaytime.u32TotalPlayTime = rBDCLMediaDataMetadata->u32Duration;
      m_rAppMediaMetaData.u32ImageSize = rBDCLMediaDataMetadata->sImageSize;
      
      if(0 != (rBDCLMediaDataMetadata->sImageSize))
      {
         for (size_t uIndex = 0; uIndex < (rBDCLMediaDataMetadata->sImageSize); uIndex++)
         {
            m_rAppMediaMetaData.rAppMediaAlbumArt.u8Items.push_back(rBDCLMediaDataMetadata->cAlbumArt[uIndex]);
         }
      }
      //This code is added for debugging purpose. define FILEWRITE before use
      #ifdef FILEWRITE
      t_Bool bFileExists = false;
      {
         FileHandler oFileHandler("/var/opt/bosch/dynamic/spi/AppmngrMediadata.txt", SPI_EN_RDONLY);
         bFileExists = (oFileHandler.bIsValid());
      }
      if (!bFileExists)
      {
         FileHandler oFileHandler("/var/opt/bosch/dynamic/spi/AppmngrMediadata.txt", SPI_EN_WRONLY);
         ETG_TRACE_USR4(("Writing turn icon data to file"));
         const signed char* pChar = (t_SString)(rBDCLMediaDataMetadata->cAlbumArt);
         oFileHandler.bFWrite(pChar, (rBDCLMediaDataMetadata->sImageSize));
      }
      #endif

      // Set the Play Mode
      vSetPlayModeState(rBDCLMediaDataMetadata->enPlayMode, bSolicited);

      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - MetadataValid  = %d", ETG_ENUM(BOOL, m_rAppMediaMetaData.bMediaMetadataValid)));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Song  = %s", m_rAppMediaMetaData.szTitle.c_str()));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Album  = %s",m_rAppMediaMetaData.szAlbum.c_str()));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Artist  = %s",m_rAppMediaMetaData.szArtist.c_str()));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - AppName  = %s",m_rAppMediaMetaData.szAppName.c_str()));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Total Track Number  = %d ",  m_rAppMediaMetaData.u32QueueCount));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Image MIME Type  = %s ", m_rAppMediaMetaData.szImageMIMEType.c_str()));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Size of Album art Content = %d",rBDCLMediaDataMetadata->sImageSize ));
      ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback - Size of Album art vector = %d", m_rAppMediaMetaData.rAppMediaAlbumArt.u8Items.size()));

   }
   //! Forward metadata to Connection Manager
   if (NULL != (m_rAppMngrCallbacks.fvAppMediaMetaData))
   {
      (m_rAppMngrCallbacks.fvAppMediaMetaData)(m_rAppMediaMetaData, rfcorUsrCntxt);
   }//if (NULL != (m_rDiPoConnCallbacks.fvAppMetadata))
}



/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vMediaPlaybackMetadataCallback()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vSetPlayModeState(tenBdclPlayMode enPlayMode,t_Bool bSolicited)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vSetPlayModeState entered"));
   switch(enPlayMode)
   {
      case e8PLAYMODE_REPEATE_ONE:
      {
         tenMediaPlayBackRepeatState enMediaPlayBackRepeatOneState = e8REPEAT_ONE;
         m_rAppMediaMetaData.enMediaPlayBackRepeatState = enMediaPlayBackRepeatOneState;
         m_rAppMediaMetaData.enMediaPlayBackShuffleState = e8SHUFFLE_OFF;
      }
      break;
      case e8PLAYMODE_SHUFFLE:
      {
         tenMediaPlayBackShuffleState enMediaPlayBackShuffleState = e8SHUFFLE_ON;
         m_rAppMediaMetaData.enMediaPlayBackShuffleState = enMediaPlayBackShuffleState;
         m_rAppMediaMetaData.enMediaPlayBackRepeatState = e8REPEAT_OFF;
      }
      break;
      case e8PLAYMODE_REPEATE_ALL:
      {
         tenMediaPlayBackRepeatState enMediaPlayBackRepeatOneState = e8REPEAT_ALL;
         m_rAppMediaMetaData.enMediaPlayBackRepeatState = enMediaPlayBackRepeatOneState;
         m_rAppMediaMetaData.enMediaPlayBackShuffleState = e8SHUFFLE_OFF;
      }
      break;
   }
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vProgressBarCallback()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vProgressBarCallback(const t_U32 u32ProgressBarInfo)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vProgressBarCallback entered"));
   trUserContext rfcorUsrCntxt;
   m_rAppMediaPlaytime.u32ElapsedPlayTime = u32ProgressBarInfo/1000; // value in ms converting to s.
   if (NULL != (m_rAppMngrCallbacks.fvAppMediaPlaytime))
   {
      (m_rAppMngrCallbacks.fvAppMediaPlaytime)(m_rAppMediaPlaytime, rfcorUsrCntxt);
   }//if (NULL != (m_rDiPoConnCallbacks.fvAppMetadata))
}

/******************************************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnSelectDeviceResult(...)
 ******************************************************************************************************/
t_Void spi_tclBDCLAppMngr::vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
                                                 const tenResponseCode coenRespCode)
{
    ETG_TRACE_USR1(("[DESC]::spi_tclBDCLAppMngr::vOnSelectDeviceResult() cou32DevId = %d, coenConnReq = %d coenRespCode = %d",
                             cou32DevId, ETG_ENUM(CONNECTION_REQ, coenConnReq), ETG_ENUM(RESPONSE_CODE, coenRespCode)));

   if ((e8DEVCONNREQ_SELECT == coenConnReq) && (e8SUCCESS == coenRespCode))
   {
      //Store the selected device handle
      m_u32SelectedDevId = cou32DevId;
      vSubscribeForTBTUpdates(true);
   }
   else if ((e8DEVCONNREQ_SELECT == coenConnReq) && (e8FAILURE == coenRespCode))
   {
      if (m_spoCmdMediaData)
      {
         m_spoCmdMediaData->vUninitialize();
      }
      if (m_spoCmdNavigation)
      {
         m_spoCmdNavigation->vUninitialize();
      }
      m_enSelDeviceType = e8_UNKNOWN_DEVICE;
   }
   else if (e8DEVCONNREQ_DESELECT == coenConnReq)
   {
      //Clear the selected device handle
      m_u32SelectedDevId = 0;
   }
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vOnCarLifeDataSubscriptionDoneMsg()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vOnCarLifeDataSubscriptionDoneUpdate(const tBdclCarLifeInfoList& corfrInfolist)
{
    ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vOnCarLifeDataSubscriptionDoneUpdate entered"));

    if (m_spoCmdNavigation)
    {
        tBdclCarLifeInfoList rCarLifeInfoList;
        for(t_U8 u8Index = 0; u8Index < corfrInfolist.size(); ++u8Index)
        {
            if(e8CARLIFE_DATA_TURNBYTURN == corfrInfolist[u8Index].enCarlifeDataModuleID &&
               true == corfrInfolist[u8Index].bSupportFlag &&
               true == m_rBDCLConfigData.bTBTUpdateEnabled )
            {
                rCarLifeInfoList.push_back(corfrInfolist[u8Index]);
                m_bIsNextTurnDataSubscribed = true;
            }
            else if(e8CARLFIE_DATA_ASSISTANTGUIDE == corfrInfolist[u8Index].enCarlifeDataModuleID &&
                    true == corfrInfolist[u8Index].bSupportFlag &&
                    true == m_rBDCLConfigData.bTBTAssisstantGuideEnabled )
             {
                 rCarLifeInfoList.push_back(corfrInfolist[u8Index]);
                 m_bIsAssistantGuideDataSubscribed = true;
             }
        }
        if(0 < rCarLifeInfoList.size())
        {
            m_spoCmdNavigation->bSendCarLifeDataSubscribeStart(rCarLifeInfoList);
        }
    }
    ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vOnCarLifeDataSubscriptionDoneUpdate left with m_bIsNextTurnDataSubscribed=%d, m_bIsAssistantGuideDataSubscribed=%d",
                     ETG_ENUM(BOOL,m_bIsNextTurnDataSubscribed),
                     ETG_ENUM(BOOL,m_bIsAssistantGuideDataSubscribed)));
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vOnNaviNextTurnInfoUpdate()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vOnNaviNextTurnInfoUpdate(const trBdclNaviNextTurnInfo& corfrBdclNaviNextTurnInfo)
{
    ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vOnNaviNextTurnInfoUpdate entered"));
    if(0 != m_u32SelectedDevId)
    {
        trTurnByTurnInfo rTurnByTurnInfo;
        rTurnByTurnInfo.u32DeviceHandle = m_u32SelectedDevId;
        rTurnByTurnInfo.enDeviceCategory = e8DEV_TYPE_CARLIFE;
        rTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid = true;
        rTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid = false;
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.enBDCLNaviTurnType =
                      static_cast<tenBDCLNextTurnType>(corfrBdclNaviNextTurnInfo.enNextTurn);
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.enBDCLNavigationAppState =
                      static_cast<tenBDCLNavigationAppState>(corfrBdclNaviNextTurnInfo.enAction);
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.u32RemainDistance = corfrBdclNaviNextTurnInfo.u32RemainingDistance;
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.u32TotalDistance = corfrBdclNaviNextTurnInfo.u32TotalDistance;

        //ETG_TRACE_USR1(("[PARAM]::vOnNaviNextTurnInfoUpdate: RoadName size %d", strlen(corfrBdclNaviNextTurnInfo.cRoadName)));
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.szRoadName.assign(
                 corfrBdclNaviNextTurnInfo.cRoadName, strlen(corfrBdclNaviNextTurnInfo.cRoadName));

        //ETG_TRACE_USR1(("[PARAM]::vOnNaviNextTurnInfoUpdate: TurnIcon data size %d", strlen(corfrBdclNaviNextTurnInfo.cTurnIcon)));
        if((corfrBdclNaviNextTurnInfo.u32TurnIconSize > 0) && (corfrBdclNaviNextTurnInfo.u32TurnIconSize < STR_ALBUMART_MAX_SIZE))
        {
            for (t_U32 u32Index = 0; u32Index < corfrBdclNaviNextTurnInfo.u32TurnIconSize; ++u32Index)
            {
                rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.u8TurnIconData.push_back(corfrBdclNaviNextTurnInfo.cTurnIcon[u32Index]);
            }
        }

        //ETG_TRACE_USR4(("spi_tclBDCLAppMngr::vOnNaviNextTurnInfoUpdate - Roadname  = %s", rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo.szRoadName.c_str()));

        if(NULL != m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo)
        {
            m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo(rTurnByTurnInfo);
        }
    }
    ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vOnNaviNextTurnInfoUpdate left"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vOnNaviAssitantGuideInfoUpdate()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vOnNaviAssitantGuideInfoUpdate(
                  const trBdclNaviAssitantGuideInfo& corfrNaviAssitantGuideInfo)
{
    ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vOnNaviAssitantGuideInfoUpdate entered"));
    if(0 != m_u32SelectedDevId)
    {
        trTurnByTurnInfo rTurnByTurnInfo;
        rTurnByTurnInfo.u32DeviceHandle = m_u32SelectedDevId;
        rTurnByTurnInfo.enDeviceCategory = e8DEV_TYPE_CARLIFE;
        rTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid = false;
        rTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid = true;
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo.enAssistantType =
                      static_cast<tenBDCLAssistantType>(corfrNaviAssitantGuideInfo.enAssistantType);
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo.enBDCLAssistantGuideAppState =
                      static_cast<tenBDCLNavigationAppState>(corfrNaviAssitantGuideInfo.enAction);
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo.enTrafficSignType =
                      static_cast<tenBDCLTrafficSignType>(corfrNaviAssitantGuideInfo.u32TrafficSignType);
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo.u32CameraSpeed = corfrNaviAssitantGuideInfo.u32CameraSpeed;
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo.u32RemainDistance = corfrNaviAssitantGuideInfo.u32RemainingDistance;
        rTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo.u32TotalDistance = corfrNaviAssitantGuideInfo.u32TotalDistance;
        if(NULL != m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo)
        {
            m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo(rTurnByTurnInfo);
        }
    }
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclBDCLAppMngr::vSubscribeForTBTUpdates(t_Bool)
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vSubscribeForTBTUpdates(t_Bool bSubscribe)
{
    ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vSubscribeForTBTUpdates entered bSubscribe=%d",ETG_ENUM(BOOL,bSubscribe)));

    if(true == bSubscribe)
    {
        if(m_spoCmdNavigation)
        {
            tBdclCarLifeInfoList rCarLifeInfoList;
            if(true == m_rBDCLConfigData.bTBTUpdateEnabled)
            {
                trBdclCarLifeInfo rCarLifeInfo;
                rCarLifeInfo.enCarlifeDataModuleID = e8CARLIFE_DATA_TURNBYTURN;
                rCarLifeInfo.bSupportFlag = true;
                rCarLifeInfoList.push_back(rCarLifeInfo);
            }
            if(true == m_rBDCLConfigData.bTBTAssisstantGuideEnabled)
            {
                trBdclCarLifeInfo rCarLifeInfo;
                rCarLifeInfo.enCarlifeDataModuleID = e8CARLFIE_DATA_ASSISTANTGUIDE;
                rCarLifeInfo.bSupportFlag = true;
                rCarLifeInfoList.push_back(rCarLifeInfo);
            }
            if(0 < rCarLifeInfoList.size())
            {
                m_spoCmdNavigation->bSendCarLifeDataSubscribe(rCarLifeInfoList);
            }
        }
    }
    else
    {
        if(m_spoCmdNavigation)
        {
            tBdclCarLifeInfoList rCarLifeInfoList;
            if(true == m_bIsNextTurnDataSubscribed)
            {
                m_bIsNextTurnDataSubscribed = false;
                trBdclCarLifeInfo rCarLifeInfo;
                rCarLifeInfo.enCarlifeDataModuleID = e8CARLIFE_DATA_TURNBYTURN;
                rCarLifeInfo.bSupportFlag = false;
                rCarLifeInfoList.push_back(rCarLifeInfo);
            }
            if(true == m_bIsAssistantGuideDataSubscribed)
            {
                m_bIsAssistantGuideDataSubscribed = false;
                trBdclCarLifeInfo rCarLifeInfo;
                rCarLifeInfo.enCarlifeDataModuleID = e8CARLFIE_DATA_ASSISTANTGUIDE;
                rCarLifeInfo.bSupportFlag = false;
                rCarLifeInfoList.push_back(rCarLifeInfo);
            }
            if(0 < rCarLifeInfoList.size())
            {
                m_spoCmdNavigation->bSendCarLifeDataSubscribeStop(rCarLifeInfoList);
            }
        }
    }
}


/***************************************************************************
 ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnModuleStatusInfo()
 ***************************************************************************/
t_Void spi_tclBDCLAppMngr::vOnModuleStatusInfo(
         const tBdclModuleStatusList& corfStatusList)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr::vOnModuleStatusInfo entered"));
   for (auto itr = corfStatusList.begin(); itr != corfStatusList.end(); ++itr)
   {
      tenBdclCmdModuleID enModuleID = static_cast<tenBdclCmdModuleID>(itr->u32ModuleID);
      if (e8CL_PHONE_MODULE_ID == enModuleID)
      {
        	 t_Bool bCallStateChanged = false;
        	 tenBdclPhoneState enPhoneModuleStatus = static_cast<tenBdclPhoneState>(itr->u32StatusID);
        	 ETG_TRACE_USR4(("[PARAM]::Phone module state = %d", ETG_ENUM(BDCL_PHONE_STATE, enPhoneModuleStatus)));
        	 // clear the member variable vector list
        	 m_rAppPhoneData.tvecPhoneCallMetaDataList.clear();
        	 m_rAppPhoneData.bPhoneMetadataValid = true;
        	 switch(enPhoneModuleStatus)
        	 {
        	    case e8CL_PHONE_STATUS_IDLE:
        	    {
        	       bCallStateChanged = (e8PHONE_CALL_DIRECTION_NOT_KNOWN != m_rPhoneCallMetaDataList.enPhoneCallDirection)?true:false;
        	       m_rPhoneCallMetaDataList.enPhoneCallDirection = e8PHONE_CALL_DIRECTION_NOT_KNOWN;
        	    }
                break;
             case e8CL_PHONE_STATUS_INCOMING:
             {
                bCallStateChanged = (e8CALL_INCOMING != m_rPhoneCallMetaDataList.enPhoneCallDirection)?true:false;
                m_rPhoneCallMetaDataList.enPhoneCallDirection = e8CALL_INCOMING;
             }
                break;
        	    case e8CL_PHONE_STATUS_OUTING:
        	    {
        	       bCallStateChanged = (e8CALL_OUTGOING != m_rPhoneCallMetaDataList.enPhoneCallDirection)?true:false;
        	       m_rPhoneCallMetaDataList.enPhoneCallDirection = e8CALL_OUTGOING;
        	    }
        	       break;
        	 }
        	 if(bCallStateChanged == true)
        	 {
        	    //push back data to the vector
        	    m_rAppPhoneData.tvecPhoneCallMetaDataList.push_back(m_rPhoneCallMetaDataList);
        	    // post the data to service
        	    if(NULL != m_rAppMngrCallbacks.fvAppPhoneData)
        	    {
        	       m_rAppMngrCallbacks.fvAppPhoneData(m_rAppPhoneData, corEmptyUsrContext);
        	    }//if (NULL != m_poMplayResp)
        	    bCallStateChanged = false;
        	 }
       }
   } //for (auto itr = corfStatusList.begin();...)
}
/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bSendAppLaunchRequest();
 ***************************************************************************/
t_Bool spi_tclBDCLAppMngr::bSendAppLaunchRequest(const t_U32 cou32DevId,
         tenDeviceCategory enDevCategory)
{
   ETG_TRACE_USR1(("spi_tclBDCLAppMngr:bSendAppLaunchRequest entered: Device handle = 0x%x, Device Category =%d ",
            cou32DevId, ETG_ENUM(DEVICE_CATEGORY, enDevCategory)));
   t_Bool bRet = false;
   if (m_enSelDeviceType == e8_APPLE_DEVICE)
   {
      spi_tclExtCompManager *poExtCompMgr = spi_tclExtCompManager::getInstance();
      spi_tclExtCmdNativeTransportIntf *poExtCmdNativeTransportIntf = NULL;
      if (NULL != poExtCompMgr)
      {
         poExtCmdNativeTransportIntf = poExtCompMgr->poGetCmdNativeTransportIntfInst();
      }
      if (NULL != poExtCmdNativeTransportIntf)
      {
         ETG_TRACE_USR2(("[DESC]:spi_tclBDCLAppMngr::bSendAppLaunchRequest calling launchapp"));
         trEAPAppInfo rEAPAppInfo;
		 if(NULL != m_poAppSettings)
		 {
			 m_poAppSettings->vGetEAPAppInfo(rEAPAppInfo);
		 }
         bRet = poExtCmdNativeTransportIntf->bLaunchApp(cou32DevId,enDevCategory,rEAPAppInfo);
      };
   }else
   {
      ETG_TRACE_USR2(("[DESC]:spi_tclBDCLAppMngr::bSendAppLaunchRequest No action taken for Android device"));
   }

   ETG_TRACE_USR2(("[DESC]:spi_tclBDCLAppMngr::bSendAppLaunchRequest returned with = %d",ETG_ENUM(BOOL, bRet)));
   return bRet;
}


//lint –restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
