/***********************************************************************/
/*!
 * \file  spi_tclBDCLAppMngr.h
 * \brief BDCL App Mngr Implementation
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    BDCL App Mngr Implementation
 AUTHOR:         rur1kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                        | Modification
 04.05.2017  | Ramya Murthy                  | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLBDCLAPPMNGR_H_
#define _SPI_TCLBDCLAPPMNGR_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <memory>
#include <algorithm>
#include "SPITypes.h"
#include "spi_tclAppMngrDev.h"
#include "spi_tclBDCLRespMediaData.h"
#include "spi_tclBDCLRespNavigation.h"
#include "spi_tclBDCLRespSession.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

//! Forward declarations
class spi_tclBDCLCmdMediaData;
class spi_tclBDCLCmdNavigation;
class spi_tclBDCLCmdInput;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLCmdMediaData >     t_SptrBDCLCmdMediaData;
typedef std::shared_ptr< spi_tclBDCLCmdNavigation >    t_SptrBDCLCmdNavigation;
typedef std::shared_ptr< spi_tclBDCLCmdInput >     t_SptrBDCLCmdInput;

/****************************************************************************/
/*!
* \class spi_tclBDCLAppMngr
* \brief BDCL AppMngr Implementation
****************************************************************************/
class spi_tclBDCLAppMngr: public spi_tclAppMngrDev,public spi_tclBDCLRespMediaData,public spi_tclBDCLRespNavigation,public spi_tclBDCLRespSession
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAppMngr::spi_tclBDCLAppMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAppMngr()
       * \brief   Default Constructor
       * \sa      ~spi_tclBDCLAppMngr()
       **************************************************************************/
      spi_tclBDCLAppMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAppMngr::~spi_tclBDCLAppMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLAppMngr()
       * \brief   Destructor
       * \sa      spi_tclBDCLAppMngr()
       **************************************************************************/
      ~spi_tclBDCLAppMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the BDCL App Mngr related things
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vUnInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUnInitialize()
       * \brief   To Uninitialize all the Dipo App Mngr related things
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclBDCLAppMngr::vRegisterAppMngrCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs)
       * \brief   To Register for the asynchronous responses that are required from
       *          ML/DiPo App Mngr
       * \param   corfrAppMngrCbs : [IN] Application Manager callabcks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSelectDevice(const t_U32 cou32DevId,
       *          const tenDeviceConnectionReq coenConnReq)
       * \brief   To Subscribe/unsubscribe for events of the currently selected device
       * \param  corfrSelectReq : Device selection request details
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bLaunchApp()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bLaunchApp(const t_U32 cou32DevId,
       *           t_U32 u32AppHandle,
       *           tenDiPOAppType enDiPOAppType,
       *           t_String szTelephoneNumber,
       *           tenEcnrSetting enEcnrSetting)
       * \brief   To Launch the requested app
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param  [IN] enDevCat : Device Type Information(Mirror Link/DiPO).
       * \param  [IN] u32AppHandle : Uniquely identifies an Application on
       *              the target Device. This value will be obtained from AppList Interface.
       *              This value will be set to 0xFFFFFFFF if DeviceCategory = DEV_TYPE_DIPO.
       * \param  [IN] enDiPOAppType : Identifies the application to be launched on a DiPO device.
       *              This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
       * \param  [IN] szTelephoneNumber : Number to be dialed if the DiPO application to be launched
       *              is a phone application. If not valid to be used, this will be set to NULL,
       *              zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
       * \param  [IN] enEcnrSetting : Sets voice or server echo cancellation and noise reduction
       *              settings if the DiPO application to be launched is a phone application.
       *              If not valid to be used, this will be set to ECNR_NOCHANGE.
       * \retval  t_Bool
       * \sa      vTerminateApp()
       **************************************************************************/
      t_Void vLaunchApp(const t_U32 cou32DevId, t_U32 u32AppId, const trUserContext& rfrcUsrCntxt,
               tenDiPOAppType enDiPOAppType, t_String szTelephoneNumber, tenEcnrSetting enEcnrSetting);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vTerminateApp()
       ***************************************************************************/
      /*!
       * \fn      t_Void vTerminateApp(trUserContext rUserContext,
       *          t_U32 u32DeviceId, t_U32 u32AppId)
       * \brief   To Terminate an Application asynchronously.
       * \param   rUserContext : [IN] Context Message
       * \param   u32DeviceId  : [IN] Device Id
       * \param   u32AppId     : [IN] Application Id
       * \retval  t_Void
       * \sa      t_Bool bLaunchApp(t_U32 u32DeviceId, t_U32 u32AppId)
       **************************************************************************/
      t_Void vTerminateApp(const t_U32 cou32devId, const t_U32 cou32AppId, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vGetAppIconData()
       ***************************************************************************/
      /*!
       * \fn    virtual t_Void vGetAppIconData(t_String szAppIconUrl,
       *         const trUserContext& rfrcUsrCntxt)
       * \brief  To Get the application icon data
       * \param  szAppIconUrl  : [IN] Application Icon data
       * \param  rfrcUsrCntxt  : [IN] User Context
       * \retval  t_Void
       **************************************************************************/
      t_Void vGetAppIconData(t_String szAppIconUrl, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclBDCLAppMngr::bCheckAppValidity()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bCheckAppValidity(const t_U32 cou32DevId,
       *             const t_U32 cou32AppId)
       * \brief   To check whether the application exists or not
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   cou32AppId  : [IN] Application Id
       * \retval  t_Bool
       **************************************************************************/
      t_Bool bCheckAppValidity(const t_U32 cou32DevId, const t_U32 cou32AppId);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclBDCLAppMngr::vSetVehicleConfig(tenVehicleConfiguration...)
       ***************************************************************************/
      /*!
       * \fn      vSetVehicleConfig(tenVehicleConfiguration...)
       * \brief   Method to set vehicle configuration
       * \param   enVehicleConfig : [IN] Vehicle config data required.
       * 		  bSetConfig      : [IN]   Boolean value to set for changing value or not
       * \retval  None
       ***************************************************************************/
      t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig, t_Bool bSetConfig);

      /***************************************************************************
       ** FUNCTION: t_Void vSetConfigData(const trConfigData& rfrConfigData)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetConfigData(const trConfigData& rfrConfigData)
       * \brief  Sets the Config data
       * \param  rfrConfigData : structure consisting of values to be set for
       *                         navigation and notification updates
       ***************************************************************************/
      t_Void vSetConfigData(const trConfigData& rfrConfigData);

      /***************************************************************************
       ** FUNCTION: t_Void vMediaMetadataCallback(const trBdclMediaMetadata* )
       ***************************************************************************/
      /*!
       * \fn     t_Void vMediaMetadataCallback(const trBdclMediaMetadata* )
       * \brief  Receives and updates the Media Data Info
       * \param  trBdclMediaMetadata : structure consisting of values to be set for
       *                               Media Data updates
       ***************************************************************************/
      t_Void vMediaMetadataCallback(const trBdclMediaMetadata* rBDCLMediaDataMetadata);

      /***************************************************************************
       ** FUNCTION: t_Void vProgressBarCallback(const t_U32 u32ProgressBarInfo)
       ***************************************************************************/
      /*!
       * \fn     t_Void vProgressBarCallback(const t_U32 u32ProgressBarInfo)
       * \brief  Receives Progress Bar updates
       * \param  u32ProgressBarInfo : Elapsed time info
       ***************************************************************************/
      t_Void vProgressBarCallback(const t_U32 u32ProgressBarInfo);
	  
      /***************************************************************************
       ** FUNCTION: t_Void vSetPlayModeState(tenBdclPlayMode ,t_Bool )
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetPlayModeState(tenBdclPlayMode ,t_Bool )
       * \brief  Sets the Play Mode State
       * \param  enPlayMode : Play Mode State(REPEAT_ALL,REPEAT_ONE,SHUFFLE)
       ***************************************************************************/
      t_Void vSetPlayModeState(tenBdclPlayMode enPlayMode,t_Bool bSolicited);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/
   protected:

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnSelectDeviceResult()
      ***************************************************************************/
      /*!
      * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
      *                 const tenDeviceConnectionReq coenConnReq,
      *                 const tenResponseCode coenRespCode)
      * \brief   To perform the actions that are required, after the select device is
      *           successful
      * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
      * \pram    coenConnReq : [IN] Identifies the Connection Request.
      * \pram    coenRespCode: [IN] Response code. Success/Failure
      * \retval  t_Void
      **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
                                   const tenResponseCode coenRespCode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnCarLifeDataSubscriptionDoneUpdate()
       ***************************************************************************/
      /*!
       * \fn      vOnCarLifeDataSubscriptionDoneUpdate
       * \brief   Triggered when MD sends Carlife Data Subscription Done Message.
       * \param   tBdclCarLifeInfoList [IN]: List with Carlife Subscription Info
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnCarLifeDataSubscriptionDoneUpdate(const tBdclCarLifeInfoList& crfrInfolist);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnNaviNextTurnInfoUpdate()
       ***************************************************************************/
      /*!
       * \fn      vOnNaviNextTurnInfoUpdate
       * \brief   Triggered when BDCL device Navi Next Turn Info Msg
       * \param   crfrInfo [IN]: Structure containing BDCL NaviNextTurnInfo
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnNaviNextTurnInfoUpdate(const trBdclNaviNextTurnInfo& corfrBdclNaviNextTurnInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnNaviAssitantGuideInfoUpdate()
       ***************************************************************************/
      /*!
       * \fn      vOnNaviAssitantGuideInfoUpdate
       * \brief   Triggered when BDCL devices sends Navi Assitant Guide Info
       * \param   crfrInfo [IN]: Structure containing Navi Assitant Guide Info
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnNaviAssitantGuideInfoUpdate(const trBdclNaviAssitantGuideInfo& corfrNaviAssitantGuideInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLAppMngr::vOnModuleStatusInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnModuleStatusInfo
       * \brief   Triggered when BDCL device updates status of one or modules on the device
       * \param   corfStatusList [IN]: Structure containing status information of
       *             various logical modules in BDCL device
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnModuleStatusInfo(const tBdclModuleStatusList& corfStatusList);

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAppMngr& spi_tclBDCLAppMngr::operator= (const..
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAppMngr& operator= (const spi_tclBDCLAppMngr &corfrSrc)
       * \brief   Assignment Operator, will not be implemented.
       * \note    This is a technique to disable the assignment operator for this class.
       *          So if an attempt for the assignment is made linker complains.
       * \param   corfrSrc : [IN] Source Object
       **************************************************************************/
      spi_tclBDCLAppMngr& operator=(const spi_tclBDCLAppMngr &corfrSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAppMngr::spi_tclBDCLAppMngr(const spi_tclBDCLAppMngr..
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAppMngr(const spi_tclBDCLAppMngr &corfrSrc)
       * \brief   Copy constructor, will not be implemented.
       * \note    This is a technique to disable the Copy constructor for this class.
       * \param   corfrSrc : [IN] Source Object
       **************************************************************************/
      spi_tclBDCLAppMngr(const spi_tclBDCLAppMngr &corfrSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLAppMngr::vSubscribeForTBTUpdates(t_Bool bSubscribe)
       ***************************************************************************/
      /*!
       * \fn      vSubscribeForTBTUpdates(t_Bool bSubscribe)
       * \brief   Subscribe/UnSubscribe for TBT updates
       * \param   bSubscribe : [IN] if true - subscribe for TBT updates
       *                            if false - unsubscribe for TBT updates
       **************************************************************************/
      t_Void vSubscribeForTBTUpdates(t_Bool bSubscribe);

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLAppMngr::bSendAppLaunchRequest(const t_U32 cou32DevId,tenDeviceCategory enDevCategory)
       ***************************************************************************/
      /*!
       * \fn     bSendAppLaunchRequest(const t_U32 cou32DevId,tenDeviceCategory enDevCategory)
       * \brief  Request to Launch Carlife App on Mobilr device
       * \param  cou32DevId : [IN] Uniquely identifies the target Device
       * \param  enDevCategory :[IN] Device category
       ***************************************************************************/
      t_Bool bSendAppLaunchRequest(const t_U32 cou32DevId,
               tenDeviceCategory enDevCategory);

      //! call back structure to end response to tclAppMngr
      trAppMngrCallbacks m_rAppMngrCallbacks;

      //! Device handle of the selected device
      t_U32 m_u32SelectedDevId;

      t_SptrBDCLCmdMediaData m_spoCmdMediaData;

      t_SptrBDCLCmdNavigation m_spoCmdNavigation;

      //! Pointer to Cmd Input class
      t_SptrBDCLCmdInput m_spoCmdInput;

      trAppMediaMetaData m_rAppMediaMetaData;

      trAppMediaPlaytime m_rAppMediaPlaytime;

      t_Bool m_bIsNextTurnDataSubscribed;

      t_Bool m_bIsAssistantGuideDataSubscribed;

      //!Sturture for enabling TBT for CarLife
      trConfigData m_rBDCLConfigData;

      // Phone Metadata
      trAppPhoneData m_rAppPhoneData;

      trPhoneCallMetaData m_rPhoneCallMetaDataList;

      tenDeviceType m_enSelDeviceType;


      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

};//spi_tclBDCLAppMngr


#endif //_SPI_TCLBDCLAPPMNGR_H_
