/***************************************************************************/
/*!
* \file  spi_tclAAPVendorExtsnEndpoint
* \brief Interface to interact with AAP Vendor Extension Endpoint
****************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface to interact with AAP Vendor Extension Endpoint
AUTHOR:         Noopur R K
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
08.06.2017  | Noopur R K            | Initial Version

\endverbatim
*****************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <algorithm>

#include "Lock.h"
#include "AAPTypes.h"
#include "spi_tclAAPVendorExtsnEndpoint.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_AAPWRAPPER
      #include "trcGenProj/Header/spi_tclAAPVendorExtsnEndpoint.cpp.trc.h"
   #endif
#endif
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/



spi_tclAAPVendorExtsnEndpoint::~spi_tclAAPVendorExtsnEndpoint()
{
   /*lint -esym(40,nullptr) nullptr is not referenced */
   ETG_TRACE_USR1(("~spi_tclAAPVendorExtsn() entered "));
}


void spi_tclAAPVendorExtsnEndpoint::addDiscoveryInfo(ServiceDiscoveryResponse* sdr)
{
   ETG_TRACE_USR1(("spi_tclAAPVendorExtsnEndpoint::addDiscoveryInfo entered "));
   Service* service = sdr->add_services();
   service->set_id(id());
   VendorExtensionService* ves = service->mutable_vendor_extension_service();
   ves->set_service_name("com.example.android.projection.protocol.EchoVendorExtension");
   ves->add_package_white_list("com.example.echovendor");

   t_String s1 = "hello";
   t_Void *po = static_cast <t_Void*> (&s1);
   sendData(po,4);

}
/////////////////EOF
