/***********************************************************************/
/*!
 * \file  spi_tclAAPVendorExtsnDispatcher.cpp
 * \brief Message Dispatcher for Vendor extension Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Vendor Extensio Messages
 AUTHOR:         Noopur R K
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 08.06.2017  | Noopur R K            | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "spi_tclAAPVendorExtsnDispatcher.h"
#include "spi_tclAAPRespVendorExtsn.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclAAPVendorExtsnDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleVendorExtsnMsg(this);         \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  AAPVendorExtsnMsgBase::AAPVendorExtsnMsgBase
 ***************************************************************************/
AAPVendorExtsnMsgBase::AAPVendorExtsnMsgBase()
{
   ETG_TRACE_USR1(("AAPVendorExtsnMsgBase::AAPVendorExtsnMsgBase entered\n"));
   vSetServiceID(e32MODULEID_AAPVENDOREXTSN);
}

/***************************************************************************
 ** FUNCTION:  spi_tclAAPVendorExtsnDispatcher::spi_tclAAPVendorExtsnDispatcher
 ***************************************************************************/
spi_tclAAPVendorExtsnDispatcher::spi_tclAAPVendorExtsnDispatcher()
{
   ETG_TRACE_USR1(("spi_tclAAPBTDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclAAPVendorExtsnDispatcher::~spi_tclAAPVendorExtsnDispatcher
 ***************************************************************************/
spi_tclAAPVendorExtsnDispatcher::~spi_tclAAPVendorExtsnDispatcher()
{
   ETG_TRACE_USR1(("~spi_tclAAPBTDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  AAPNotificationMsg::AAPNotificationMsg
 ***************************************************************************/
AAPVendorExtsnDataMsg::AAPVendorExtsnDataMsg():
      poData(NULL),
      u8LengthOfData(0)
{
   ETG_TRACE_USR1(("AAPVendorExtsnDataMsg() entered "));
   vAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  AAPVendorExtsnDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AAPVendorExtsnDataMsg, spi_tclAAPVendorExtsnDispatcher);

/***************************************************************************
 ** FUNCTION:  AAPNotificationMsg::vAllocateMsg
 ***************************************************************************/
t_Void AAPVendorExtsnDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("AAPVendorExtsnDataMsg::vAllocateMsg() entered "));
}

/***************************************************************************
 ** FUNCTION:  AAPVendorExtsnDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AAPVendorExtsnDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("AAPVendorExtsnDataMsg::vDeAllocateMsg() entered "));
   RELEASE_MEM(poData);
}
/*********************************************************************************************
 ** FUNCTION:  spi_tclAAPVendorExtsnDispatcher::vHandleNotificationMsg(AAPsubscriptionStatusMsg...)
 *********************************************************************************************/
t_Void spi_tclAAPVendorExtsnDispatcher::vHandleVendorExtsnMsg(AAPVendorExtsnDataMsg* poVendorExtsnMsg)const
{
   ETG_TRACE_USR1(("spi_tclAAPVendorExtsnDispatcher::vHandleNotificationMsg entered "));
   if (NULL != poVendorExtsnMsg)
   {
      CALL_REG_OBJECTS(spi_tclAAPRespVendorExtsn,
               e16AAP_VENDOREXTSN_REGID,
         vVendorExtsnDataCallback(poVendorExtsnMsg->poData,poVendorExtsnMsg->u8LengthOfData));
   } // if (NULL != poSubsrStatus)

}
