/***********************************************************************/
/*!
 * \file  spi_tclAAPCmdVendorExtsn.h
 * \brief Interface to interact with AAP Vendor Extension Endpoint
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Interface to interact with AAP Vendor Extension Endpoint
 AUTHOR:         Noopur R K
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 08.06.2017  | Noopur R K            | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLAAPVENDOREXTSNENDPOINT_H_
#define _SPI_TCLAAPVENDOREXTSNENDPOINT_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include <aauto/VendorExtension.h>
#include "aauto/common.h"
//#include "aauto/IGalVerificationVendorExtensionCallbacks.h"
#include "AAPTypes.h"
#include <SPITypes.h>
//#include "spi_tclAAPVendorExtensionCbs.h"
#include "Lock.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/* Forward declaration */

/******************************************************************************/
/*!
 * \class spi_tclAAPVendorExtsnEndpoint
 * \brief Interface to interact with Vendor Extension Endpoint
 *******************************************************************************/

class spi_tclAAPVendorExtsnEndpoint: public VendorExtension
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/
      /***************************************************************************
       ** FUNCTION:  spi_tclAAPVendorExtsnEndpoint::spi_tclAAPVendorExtsnEndpoint()
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPVendorExtsnEndpoint()
       * \brief   Default Constructor
       ***************************************************************************/
      spi_tclAAPVendorExtsnEndpoint(uint8_t id, MessageRouter* router) :
               VendorExtension(id, router)
      {
      }
      ;

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPVendorExtsnEndpoint::~spi_tclAAPVendorExtsnEndpoint()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclAAPVendorExtsnEndpoint()
       * \brief   Destructor
       * \sa      spi_tclAAPVendorExtsnEndpoint()
       ***************************************************************************/
      ~spi_tclAAPVendorExtsnEndpoint();

      /********************************************************************
       ** FUNCTION:  spi_tclAAPCmdVendorExtsn::addDiscoveryInfo()
       ***************************************************************************/
      /*!
       * \fn      addDiscoveryInfo()
       * \brief   Method used to set the discovery info for the vendor extension channel
       * \param   poData : Void pointer to the data
       *          u32lengthOfData : Length of the data to be transmitted
       ***************************************************************************/
      void addDiscoveryInfo(ServiceDiscoveryResponse* sdr);
};
#endif
