/***********************************************************************/
/*!
 * \file  spi_tclAAPVendorExtsnDispatcher.h
 * \brief Message Dispatcher for Vendor Extension Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Vendor Extension Messages
 AUTHOR:         Noopur R K
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 10.03.2015  | Noopur R K            | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLAAPVENDOREXTSNDISPATCHER_H_
#define _SPI_TCLAAPVENDOREXTSNDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "AAPTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclAAPVendorExtsnDispatcher;

/****************************************************************************/
/*!
 * \class AAPVendorExtsnMsgBase
 * \brief Base Message type for all Vendor Extension messages
 ****************************************************************************/
class AAPVendorExtsnMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  AAPVendorExtsnMsgBase::AAPVendorExtsnMsgBase
    ***************************************************************************/
   /*!
    * \fn      AAPVendorExtsnMsgBase()
    * \brief   Default constructor
    **************************************************************************/
    AAPVendorExtsnMsgBase();

   /***************************************************************************
    ** FUNCTION:  AAPBTMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclAAPVendorExtsnDispatcher* poVendorExtensionDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poVendorExtensionDispatcher : pointer to Message dispatcher for Vendor Extsn
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclAAPVendorExtsnDispatcher* poVendorExtensionDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  AAPBTMsgBase::~AAPBTMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~AAPBTMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AAPVendorExtsnMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class AAPBTPairingRequestMsg
 * \brief BT Pairing Request msg
 ****************************************************************************/
class AAPVendorExtsnDataMsg: public AAPVendorExtsnMsgBase
{
   public:

   t_U8* poData;
   size_t u8LengthOfData;

   /***************************************************************************
    ** FUNCTION:  AAPVendorExtsnDataMsg::AAPVendorExtsnDataMsg
    ***************************************************************************/
   /*!
    * \fn      AAPVendorExtsnDataMsg()
    * \brief   Default constructor
    **************************************************************************/
   AAPVendorExtsnDataMsg();

   /***************************************************************************
    ** FUNCTION:  AAPVendorExtsnDataMsg::~AAPVendorExtsnDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~AAPVendorExtsnDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AAPVendorExtsnDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  AAPVendorExtsnDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclAAPVendorExtsnDispatcher* poVendorExtsnDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poVendorExtsnDispatcher : pointer to Message dispatcher for Vendor Extension
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclAAPVendorExtsnDispatcher* poAAPVendorExtsnDispatcher);

   /***************************************************************************
    ** FUNCTION:  AAPVendorExtsnDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AAPVendorExtsnDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclAAPBTDispatcher
 * \brief Message Dispatcher for BT Messages
 ****************************************************************************/
class spi_tclAAPVendorExtsnDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclAAPVendorExtsnDispatcher::spi_tclAAPVendorExtsnDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclAAPVendorExtsnDispatcher()
    * \brief   Default constructor
    **************************************************************************/
      spi_tclAAPVendorExtsnDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclAAPVendorExtsnDispatcher::~spi_tclAAPVendorExtsnDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclAAPVendorExtsnDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclAAPVendorExtsnDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclAAPVendorExtsnDispatcher::vHandleBTMsg(AAPVendorExtsnDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBTMsg(AAPVendorExtsnDataMsg* poVendorExtsnDataMsg)
    * \brief   Handles Messages of AAPVendorExtsnDataMsg type
    * \param   poBTPairingRequest : pointer to AAPVendorExtsnDataMsg.
    **************************************************************************/
   t_Void vHandleVendorExtsnMsg(AAPVendorExtsnDataMsg* poVendorExtsnData) const;

};

#endif /* _SPI_TCLAAPVENDOREXTSNDISPATCHER_H_ */

