/***********************************************************************/
/*!
* \file  spi_tclAAPCmdVendorExtsn.h
* \brief Interface to interact with AAP Vendor Extension Endpoint
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface to interact with AAP Vendor Extension Endpoint
AUTHOR:         Noopur R K
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
08.06.2017  | Noopur R K            | Initial Version

\endverbatim
*************************************************************************/

#ifndef _SPI_TCLAAPCMDVENDOREXTSN_H_
#define _SPI_TCLAAPCMDVENDOREXTSN_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <aauto/VendorExtension.h>

#include "AAPTypes.h"
#include <SPITypes.h>
//#include "spi_tclAAPVendorExtensionCbs.h"
#include "spi_tclAAPVendorExtsnEndpoint.h"
#include "Lock.h"
#include "spi_tclAAPCmdVendorExtsnIntf.h"
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/* Forward declaration */

/******************************************************************************/
/*!
* \class spi_tclAAPVendorExtensionCbs
* \brief Interface to interact with Vendor Extension Endpoint
*
* It is responsible for creation & initialization of Vendor Extension Endpoint.
*******************************************************************************/

class spi_tclAAPCmdVendorExtsn : public spi_tclAAPCmdVendorExtsnIntf
{
   public:
      /***************************************************************************
      *********************************PUBLIC*************************************
      ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  spi_tclAAPCmdVendorExtsn::spi_tclAAPCmdVendorExtsn()
      ***************************************************************************/
      /*!
      * \fn      spi_tclAAPCmdVendorExtsn()
      * \brief   Default Constructor
      * \sa      ~spi_tclAAPCmdVendorExtsn()
      ***************************************************************************/
      spi_tclAAPCmdVendorExtsn();

      /***************************************************************************
      ** FUNCTION:  spi_tclAAPCmdVendorExtsn::~spi_tclAAPCmdVendorExtsn()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclAAPCmdVendorExtsn()
      * \brief   Destructor
      * \sa      spi_tclAAPCmdVendorExtsn()
      ***************************************************************************/
      ~spi_tclAAPCmdVendorExtsn();
      
      /***************************************************************************
      ** FUNCTION:  spi_tclAAPCmdVendorExtsn::vCreateVendorExtsnEndpoint()
      ***************************************************************************/
      /*!
      * \fn      vCreateVendorExtsnEndpoint()
      * \brief   Method to create the Vendor extension endpoint
      * \Param   None
      ***************************************************************************/
      t_Void vInitialiseVendorExtsnEndpoint();
      
      /***************************************************************************
      ** FUNCTION:  spi_tclAAPCmdVendorExtsn::vCreateVendorExtsnEndpoint()
      ***************************************************************************/
      /*!
      * \fn      vCreateVendorExtsnEndpoint()
      * \brief   Method to create the Vendor extension endpoint
      * \Param   None
      ***************************************************************************/
      t_Void vUninitialiseVendorExtsnEndpoint();
      
      /***************************************************************************
      ** FUNCTION:  spi_tclAAPCmdVendorExtsn::vSendData()
      ***************************************************************************/
      /*!
      * \fn      vSendData()
      * \brief   Method used to send data from the HU to the MD
      * \param   poData : Void pointer to the data
      *          u32lengthOfData : Length of the data to be transmitted
      ***************************************************************************/
      t_Void vSendData(t_Void *poData, size_t u8LengthOfData);
      
      //! Lock object for Vendor extension endpoint
      Lock  m_oEndpointLock;

      spi_tclAAPVendorExtsnEndpoint* m_poVendorExtsnEndpoint;

      //shared_ptr<IVendorExtensionCallbacks> m_poVendorExtensionCbs;
};
#endif
