/*!
 *******************************************************************************
 * \file              spi_tclAAPTransportCbs.h
 * \brief             Callbacks class for transport
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Callbacks class for transport
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 07.08.2017 |  Noopur R K                  | Initial Version

 \endverbatim
 ******************************************************************************/
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/


#ifndef _SPI_TCLAAPTRANSPORT_CBS_H
#define _SPI_TCLAAPTRANSPORT_CBS_H

/* *************  includes  ************* */
/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/util/Transport.h>

#include "BaseTypes.h"
#include "Lock.h"
#include "Timer.h"
/* This class includes a general set of ITransportCallbacks that must be set up to receive the errors in transport during the session */

class spi_tclAAPTransportCbs : public ITransportCallbacks
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION: spi_tclAAPTransportCbs::spi_tclAAPTransportCbs()
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPTransportCbs()
       * \brief   Constructor
       * \sa      spi_tclAAPTransportCbs
       **************************************************************************/
      spi_tclAAPTransportCbs();

      
      /***************************************************************************
       ** FUNCTION: spi_tclAAPTransportCbs::~spi_tclAAPTransportCbs()
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPTransportCbs()
       * \brief   Destructor
       * \sa      spi_tclAAPTransportCbs
       **************************************************************************/
      virtual ~spi_tclAAPTransportCbs();

      //! Callbacks for transport
       /***************************************************************************
        ** FUNCTION:  t_Bool spi_tclAAPSession::notifyErrorCallback()
        ***************************************************************************/
       /*!
        * \fn      notifyErrorCallback
      * \brief     Called when there is are errors in the transport for the active session
      * \param     inErrorCode : This parameter gives the information about the error
      *                          occured during the transport.
      *                          The following errors are handled
      *                              WRITE_SUCCESS     =  0
      *                              WRITE_ERR_FATAL   = -1
      *                              WRITE_ERR_IO      = -2
      *                              WRITE_ERR_TIMEOUT = -3
      *                              READ_SUCCESS      = -4
      *                              READ_ERR_FATAL    = -5
      *                              READ_ERR_IO       = -6
      *                              READ_ERR_TIMEOUT  = -7
      *                              UNKNOWN_ERR       = -8
      ***************************************************************************/
      void notifyStatusCallback(GalReceiverTransportStatus galTransportErrorStatus);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclAAPTransportCbs::vStartTimer()
       ***************************************************************************/
      /*!
       * \fn      vStartTimer()
       * \brief   Start timer function will begin the timer after a I/O or
       *          timeout error has been received.
       * \param   none
       * \return  none
       **************************************************************************/
      t_Void vStartTimer();

      /***************************************************************************
       ** FUNCTION: spi_tclAAPTransportCbs::vStopTimer()
       ***************************************************************************/
      /*!
       * \fn      vStopTimer()
       * \brief   Start timer function will stop the timer after a I/O or
       *          timeout error has been received.
       * \param   none
       * \return  none
       **************************************************************************/
      t_Void vStopTimer();

      /***************************************************************************
       ** FUNCTION: spi_tclAAPTransportCbs::bTransportErrorTimerCb()
       ***************************************************************************/
      /*!
       * \fn      bTransportErrorTimerCb()
       * \brief   Callback that will be called on timer transport error timer expiry
       * \param   none
       * \return  bool
       **************************************************************************/
      static t_Bool bTransportErrorTimerCb(timer_t rTimerID, t_Void *pvObject, const t_Void *pvUserData);

      Lock m_oTransportErrorLock;
};
#endif
