/*!
 *******************************************************************************
 * \file              spi_tclAAPCmdSessionIntf.h
 * \brief             Cmd session Interface for Android Auto
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Cmd session Interface for Android Auto
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 04.12.2019 |  Devansh Gupta               | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLAAPCMDSESSIONINTF_H_
#define SPI_TCLAAPCMDSESSIONINTF_H_

/******************************************************************************
 | includes:
 | 1)AAP - includes
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "AAPTypes.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/


/*!
 * \class spi_tclAAPCmdSessionIntf
 * \brief
 */

class spi_tclAAPCmdSessionIntf
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPCmdSessionIntf::spi_tclAAPCmdSessionIntf();
       ***************************************************************************/
      /*!
       * \fn     spi_tclAAPCmdSessionIntf()
       * \brief  Default Constructor
       * \sa      ~spi_tclAAPCmdSessionIntf()
       **************************************************************************/
      spi_tclAAPCmdSessionIntf(){}

      /***************************************************************************
       ** FUNCTION:  virtual spi_tclAAPCmdSessionIntf::~spi_tclAAPCmdSessionIntf()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclAAPCmdSessionIntf()
       * \brief   Destructor
       * \sa      spi_tclAAPCmdSessionIntf()
       **************************************************************************/
      virtual ~spi_tclAAPCmdSessionIntf(){}

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPCmdSessionIntf::bInitializeSession()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitializeSession()
       * \brief   Initializes session by creating galreceiver
       * \param   cou32DeviceHandle : unique ID of ML Server
       * \retval  true : initialized successfull.
       * \retval  false : initialization failed
       * \sa      vUnInitializeSession()
       **************************************************************************/
      virtual t_Bool bInitializeSession()=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vUnInitializeSession( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vUnInitializeSession()
       * \brief   UnInitializes session by destroying galreceiver
       * \sa      bIntializeSession
       **************************************************************************/
      virtual t_Void vUnInitializeSession()=0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPCmdSessionIntf:: bStartTransport( )
       ***************************************************************************/
      /*!
       * \fn      t_Bool bStartTransport()
       * \brief   Start transport (communication between MD and HU
       * \sa      vStopTransport
       **************************************************************************/
      virtual t_Bool bStartTransport(const trAAPSessionInfo &rfrSessionInfo)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vStopTransport( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vStopTransport()
       * \brief   Stop transport
       * \sa      bStartTransport
       **************************************************************************/
      virtual t_Void vStopTransport()=0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPCmdSessionIntf:: bSetCertificates( )
       ***************************************************************************/
      /*!
       * \fn      t_Bool spi_tclAAPCmdSessionIntf:: bSetCertificates( )
       * \brief   Set certificate path
       * \param   szCertiPath : certificate path
       * \param  enCertificateType : CertificateType to be used for authentication
       * \retval : returns true if certificates are set successfully
       **************************************************************************/
      virtual t_Bool bSetCertificates(trAAPCertConfigData &rfrCertsConfigData, tenCertificateType enCertificatetype)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vSetHeadUnitInfo( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetHeadUnitInfo()
       * \brief   Sets info about the head unit for authentication
       * \param   rfrHeadUnitInfo : Head unit information
       **************************************************************************/
      virtual t_Void vSetHeadUnitInfo(const trAAPHeadUnitInfo &rfrHeadUnitInfo)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vSendByeByeMessage()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSendByeByeMessage()
       * \brief   Send Bye bye message to phone when user intentionally deselects aap
       **************************************************************************/
      virtual t_Void vSendByeByeMessage()=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vSendByeByeResponse( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vSendByeByeResponse()
       * \brief   Send Bye bye response to phone in response
       **************************************************************************/
      virtual t_Void vSendByeByeResponse()=0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPCmdSessionIntf::vSetNavigationFocus()
       ***************************************************************************/
      /*!
       * \fn      vSetNavigationFocus(tenAAPNavFocusType enNavFocusType)
       * \brief   Set Navigation Focus type
       * \param   enNavFocusType : Navigation focus type
       **************************************************************************/
      virtual t_Void vSetNavigationFocus(tenAAPNavFocusType enNavFocusType)=0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPCmdSessionIntf::vSetAudioFocus()
       ***************************************************************************/
      /*!
       * \fn      vSetAudioFocus(AudioFocusStateType focusState, bool unsolicited)
       * \brief   Set Audio Focus type
       * \param
       **************************************************************************/
      virtual t_Void vSetAudioFocus(tenAAPDeviceAudioFocusState enDevAudFocusState, t_Bool bUnsolicited)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vSendSessionConfiguration()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSendSessionConfiguration(t_U32 u32SessionConfiguration)
       * \brief   Send session configuration to phone
       * \param   u32SessionConfiguration : consisting of session configuration
       *          for the AAP session
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSendSessionConfiguration(t_U32 u32SessionConfiguration)=0;
      /***************************************************************************
        ** FUNCTION:  t_Void spi_tclAAPCmdSessionIntf:: vSendPingRequest()
        ***************************************************************************/
       /*!
        * \fn      t_Void vsendPingRequest(timer_t timestamp, bool bugReport)
        * \brief   Send periodic ping requests to phone to see if the session is alive
        * \retval  t_Void
        **************************************************************************/
      virtual t_Void vSendPingRequest()=0;

};

#endif /* SPI_TCLAAPCMDSESSIONINTF_H_ */
