/*
 * spi_tclAAPCmdVideoIntf.h
 *
 *  Created on: Mar 14, 2019
 *      Author: OLR5KOR
 */

#ifndef SPI_TCLAAPCMDVIDEOINTF_H_
#define SPI_TCLAAPCMDVIDEOINTF_H_
#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"

class spi_tclAAPCmdVideoIntf
{

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclAAPCmdVideo::spi_tclAAPCmdVideo()
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPCmdVideo()
       * \brief   Default Constructor
       * \sa      ~spi_tclAAPCmdVideo()
       **************************************************************************/
      spi_tclAAPCmdVideoIntf(){} ;

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPCmdVideo::~spi_tclAAPCmdVideo()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclAAPCmdVideo()
       * \brief   Destructor
       * \sa      spi_tclAAPCmdVideo()
       **************************************************************************/
      virtual ~spi_tclAAPCmdVideoIntf(){};

      virtual t_Bool bInitialize(trAAPVideoConfig& rfrAAPVideoConfig,
               tvecAAPVideoPipeLineConfigList& rfvecAAPVideoPipeLineConfigList)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   method to un initialize video sink
       * \sa      bInitialize()
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vUninitialize()=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::vSetVideoFocus()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetVideoFocus(tenVideoFocus enVideoFocus,
       *          t_Bool bUnsolicited)
       * \brief   method to request or Grant/Deny Video Focus to/from MD
       * \param   enVideoFocus : [IN] Video Focus mode
       * \param   bUnsolicited : TRUE - if it is response for Phone's request
       *                         FALSE - If SPI triggers it
       * \sa      playbackStartCallback(),playbackStopCallback(),videoFocusCallback()
       *
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetVideoFocus(tenVideoFocus enVideoFocus, t_Bool bUnsolicited)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::playbackStartCallback()
       ***************************************************************************/
      /*!
       * \fn      t_Void playbackStartCallback()
       * \brief   method to inform the application that the Video Play back is started
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void playbackStartCallback()=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::playbackStopCallback()
       ***************************************************************************/
      /*!
       * \fn      t_Void playbackStopCallback()
       * \brief   method to inform the application that the Video Play back is stopped
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void playbackStopCallback()=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::videoFocusCallback()
       ***************************************************************************/
      /*!
       * \fn      t_Void videoFocusCallback(t_S32 s32Focus, t_S32 s32Reason)
       * \brief   Method to inform the application that the Video Focus is requested
       *          or rejected from the MD
       * \param   s32Focus  : [IN] Video Focus Mode
       * \param   s32Reason : [IN] Video Focus Reason
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void videoFocusCallback(t_S32 s32Focus, t_S32 s32Reason)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::setupCallback(t_S32 s32MediaCodecType)
       ***************************************************************************/
      /*!
       * \fn      t_Void setupCallback(t_S32 s32MediaCodecType)
       * \brief   Signals that the MD wants to set up a video stream
       *          and the information in this callback should be used
       *          to set up any hardware necessary to handle the incoming stream type.
       * \param   s32MediaCodecType  : [IN] Media Codec Type
       *          (Currently, the only valid value is MEDIA_CODEC_VIDEO_H264_BP)
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void setupCallback(t_S32 s32MediaCodecType)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::setupCallback(t_S32 s32MediaCodecType)
       ***************************************************************************/
      /*!
       * \fn      t_Void setupCallback(t_S32 s32MediaCodecType)
       * \brief   Method to inform when MD sends video configuration. This configuration can be
       *          different from what is originally set by setConfigItem
       * \param   s32VideoWidth   : [IN] The width of codec resolution selected.
       * \param   s32VideoHeight  : [IN] The height of codec resolution selected.
       * \param   s32UIResWidth   : [IN] The width of the logical UI resolution.
       * \param   s32UIResHeight  : [IN] The height of the logical UI resolution.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void sourceVideoConfigCallback(t_S32 s32VideoWidth, t_S32 s32VideoHeight, t_S32 s32UIResWidth,
               t_S32 s32UIResHeight)=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::playbackFirstFrameRenderedCallback()
       ***************************************************************************/
      /*!
       * \fn      playbackFirstFrameRenderedCallback()
       * \brief   Method to inform when the first frame is rendered by the MD.
       * \param   NONE
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void playbackFirstFrameRenderedCallback()=0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclAAPCmdVideo::vNativeVideoRenderingStatus()
       ***************************************************************************/
      /*!
       * \fn      vNativeVideoRenderingStatus()
       * \brief   Method to inform about the native projection rendering status
       update
       * \param   enNativeVideoRenderingStatus
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus)=0;

};

#endif /* SPI_TCLAAPCMDVIDEOINTF_H_ */
