/*
 * spi_tclAAPCmdVendorExtsnIntf.h
 *
 *  Created on: Mar 14, 2019
 *      Author: OLR5KOR
 */

#ifndef SPI_TCLAAPCMDVENDOREXTSNINTF_H_
#define SPI_TCLAAPCMDVENDOREXTSNINTF_H_
#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"

class spi_tclAAPCmdVendorExtsnIntf
{
   public :
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdVendorExtsn::spi_tclAAPCmdVendorExtsn()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAAPCmdVendorExtsn()
   * \brief   Default Constructor
   * \sa      ~spi_tclAAPCmdVendorExtsn()
   ***************************************************************************/
	spi_tclAAPCmdVendorExtsnIntf(){};

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdVendorExtsn::~spi_tclAAPCmdVendorExtsn()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclAAPCmdVendorExtsn()
   * \brief   Destructor
   * \sa      spi_tclAAPCmdVendorExtsn()
   ***************************************************************************/
	virtual ~spi_tclAAPCmdVendorExtsnIntf(){};

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdVendorExtsn::vCreateVendorExtsnEndpoint()
   ***************************************************************************/
   /*!
   * \fn      vCreateVendorExtsnEndpoint()
   * \brief   Method to create the Vendor extension endpoint
   * \Param   None
   ***************************************************************************/
   virtual t_Void vInitialiseVendorExtsnEndpoint()=0;

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdVendorExtsn::vCreateVendorExtsnEndpoint()
   ***************************************************************************/
   /*!
   * \fn      vCreateVendorExtsnEndpoint()
   * \brief   Method to create the Vendor extension endpoint
   * \Param   None
   ***************************************************************************/
   virtual t_Void vUninitialiseVendorExtsnEndpoint()=0;

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdVendorExtsn::vSendData()
   ***************************************************************************/
   /*!
   * \fn      vSendData()
   * \brief   Method used to send data from the HU to the MD
   * \param   poData : Void pointer to the data
   *          u32lengthOfData : Length of the data to be transmitted
   ***************************************************************************/
   virtual t_Void vSendData(t_Void *poData, size_t u8LengthOfData)=0;
};

#endif /* SPI_TCLAAPCMDVENDOREXTSNINTF_H_ */
