/*
 * spi_tclAAPCmdNotificationIntf.h
 *
 *  Created on: Mar 14, 2019
 *      Author: OLR5KOR
 */

#ifndef SPI_TCLAAPCMDNOTIFICATIONINF_H_
#define SPI_TCLAAPCMDNOTIFICATIONINF_H_
#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"
class spi_tclAAPCmdNotificationIntf
{
   public :
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdNotification::spi_tclAAPCmdNotification()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAAPCmdNotification()
   * \brief   Default Constructor
   * \sa      ~spi_tclAAPCmdNotification()
   ***************************************************************************/
	spi_tclAAPCmdNotificationIntf(){};

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdNotification::~spi_tclAAPCmdNotification()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclAAPCmdNotification()
   * \brief   Destructor
   * \sa      spi_tclAAPCmdNotification()
   ***************************************************************************/
	virtual ~spi_tclAAPCmdNotificationIntf(){};

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclAAPCmdNotification::bInitializeNotification()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bInitializeNotification()
   * \brief   Creates and initialises an instance of Notification Endpoint
   * \retval  t_Bool  :  True if the Notification Endpoint is initialised, else False
   * \sa      vUninitializeNotification()
   ***************************************************************************/
   virtual t_Bool bInitializeNotification()=0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAAPCmdNotification::vUninitializeNotification()
   ***************************************************************************/
   /*!
   * \fn      t_Void vUninitializeNotification()
   * \brief   Uninitialises and destroys an instance of Notification Endpoint
   * \retval  t_Void
   * \sa      bInitializeNotification()
   ***************************************************************************/
   virtual t_Void vUninitializeNotification()=0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAAPCmdNotification::vAckNotification()
   ***************************************************************************/
   /*!
   * \fn      t_Void vAckNotification(t_U32 u32DeviceHandle,
   *                  const t_String& corfszNotifId)
   * \brief   Acknowledges the receipt of notification
   * \param   u32DeviceHandle  : [IN] Id of the device to be acknowledged
   * \param   corfszNotifId    : [IN] Received notification's Id
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vAckNotification(t_U32 u32DeviceHandle, const t_String& corfszNotifId)=0;
};

#endif /* SPI_TCLAAPCMDNOTIFICATIONINF_H_ */
