/*
 * spi_tclAAPCmdInputIntf.h
 *
 *  Created on: Mar 14, 2019
 *      Author: OLR5KOR
 */

#ifndef SPI_TCLAAPCMDINPUTINTF_H_
#define SPI_TCLAAPCMDINPUTINTF_H_
#include <set>
#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"

class spi_tclAAPCmdInputIntf
{
	 /***************************************************************************
	    *********************************PUBLIC*************************************
	    ***************************************************************************/

public:	   /***************************************************************************
	    ** FUNCTION:  spi_tclAAPCmdInput::spi_tclAAPCmdInput();
	    ***************************************************************************/
	   /*!
	    * \fn     spi_tclAAPCmdInput()
	    * \brief  Default Constructor
	    * \sa     spi_tclAAPCmdInput()
	    **************************************************************************/
	    spi_tclAAPCmdInputIntf(){};

	   /***************************************************************************
	    ** FUNCTION:  spi_tclAAPCmdInput::~spi_tclAAPCmdInput()
	    ***************************************************************************/
	   /*!
	    * \fn      virtual ~spi_tclAAPCmdInput()
	    * \brief   Virtual Destructor
	    * \sa      spi_tclAAPCmdInput()
	    **************************************************************************/
	    virtual ~spi_tclAAPCmdInputIntf(){};

	   /***************************************************************************
	    ** FUNCTION:  virtual spi_tclAAPCmdInput::bInitializeInput()
	    ***************************************************************************/
	   /*!
	    * \fn      bInitializeInout()
	    * \brief   Initializes the InputSource Endpoint, registers keycodes and touch
	    * 	      screen.
	    * \param   rAAPInputConfig  : [IN] Display Configuration
            * \param   rsetAASuppKeys   : [IN] Supported Keys
	    * \sa      bInitialize()
	    **************************************************************************/
	   virtual t_Bool bInitializeInput(const trAAPInputConfig& rAAPInputConfig,std::set<tenKeyCode>& rsetAASuppKeys)=0;

	   /***************************************************************************
	    ** FUNCTION:  virtual spi_tclAAPCmdInput::bUnInitialize()
	    ***************************************************************************/
	   /*!
	    * \fn      bUnInitialize()
	    * \brief   Uninitializes the InputSource Endpoint.
	    * \sa      bUnInitialize()
	    **************************************************************************/
	   virtual t_Void bUnInitializeInput()=0;

	   /***************************************************************************
	    ** FUNCTION: t_Void spi_tclAAPCmdInput::vReportTouch
	    ***************************************************************************/
	   /*!
	    * \fn      vReportTouch(t_U32 u32DeviceHandle,trTouchData &rfrTouchData)
	    * \brief   Receives the Touch events and forwards it to Project Specific Endpoint
	    * 		  wrapper.
	    * \param   u32DeviceHandle  : [IN] unique identifier to AAP device
	    * \param   rfrTouchData     : [IN] reference to touch data structure which contains
	    *          touch details received /ref trTouchData
	    * \param   rScalingAttributes : [IN] Scaling attributes to scale the touch coordinates
	    * \retval  NONE
	    **************************************************************************/
	   virtual t_Void vReportTouch(t_U32 u32DeviceHandle, trTouchData &rfrTouchData,
	                       trScalingAttributes rScalingAttributes)=0;

	   /***************************************************************************
	    ** FUNCTION:  t_Void spi_tclAAPCmdInput::vReportkey
	    ***************************************************************************/
	   /*!
	    * \fn      vReportkey(t_U32 u32DeviceHandle, tenKeyMode enKeyMode,
	    tenKeyCode enKeyCode)
	    * \brief   Receives hard key events and forwards it to Project Specific Endpoint.
	    * \param   u32DeviceHandle : [IN] unique identifier to AAP device
	    * \param   enKeyMode       : [IN] indicates keypress or keyrelease
	    * \param   enKeyCode       : [IN] unique key code identifier
	    * \retval  NONE
	    **************************************************************************/
	   virtual t_Void vReportkey(t_U32 u32DeviceHandle, tenKeyMode enKeyMode,
	               tenKeyCode enKeyCode)=0;

	   /***************************************************************************
	    ** FUNCTION:  t_Void spi_tclAAPCmdInput::vReportKnobkey
	    ***************************************************************************/
	   /*!
	    * \fn      vReportKnobkey(t_U32 u32DeviceHandle, t_S32 s32DeltaCnts)
	    * \brief   Receives hard key events and forwards it to Project Specific Endpoint.
	    * \param   u32DeviceHandle : [IN] unique identifier to AAP device
	    * \param   s32DeltaCnts    : [IN] Knob Encoder delta count change
	    * \retval  NONE
	    **************************************************************************/
	   virtual t_Void vReportKnobkey(t_U32 u32DeviceHandle, t_S32 s32DeltaCnts)=0;
};

#endif /* SPI_TCLAAPCMDINPUTINTF_H_ */
