/*
 * spi_tclAAPCmdBluetoothIntf.h
 *
 *  Created on: Mar 14, 2019
 *      Author: OLR5KOR
 */

#ifndef SPI_TCLAAPCMDBLUETOOTHINTF_H_
#define SPI_TCLAAPCMDBLUETOOTHINTF_H_
#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"
class spi_tclAAPCmdBluetoothIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdBluetooth::spi_tclAAPCmdBluetooth()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAAPCmdBluetooth()
   * \brief   Default Constructor
   * \sa      ~spi_tclAAPCmdBluetooth()
   ***************************************************************************/
	spi_tclAAPCmdBluetoothIntf(){};

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdBluetooth::~spi_tclAAPCmdBluetooth()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclAAPCmdBluetooth()
   * \brief   Destructor
   * \sa      spi_tclAAPCmdBluetooth()
   ***************************************************************************/
   virtual ~spi_tclAAPCmdBluetoothIntf(){};

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclAAPCmdBluetooth::bInitialiseBTEndpoint()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bInitialiseBTEndpoint()
   * \brief   Creates and initialises an instance of BT Endpoint
   * \retval  t_Bool  :  True if the BT Endpoint is initialised, else False
   * \sa      vUninitialiseBTEndpoint()
   ***************************************************************************/
   virtual t_Bool bInitialiseBTEndpoint(const t_String& rfcoszVehicleBTAddress,
         tenBTPairingMethod enBTPairingMethod)=0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAAPCmdBluetooth::vUninitialiseBTEndpoint()
   ***************************************************************************/
   /*!
   * \fn      t_Void vUninitialiseBTEndpoint()
   * \brief   Uninitialises and destroys an instance of BT Endpoint
   * \retval  t_Void
   * \sa      bInitialiseBTEndpoint()
   ***************************************************************************/
   virtual t_Void vUninitialiseBTEndpoint()=0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAAPCmdBluetooth::vSendBTPairingResponse()
   ***************************************************************************/
   /*!
   * \fn      vSendBTPairingResponse(t_Bool bReadyToPair, t_Bool bAAPDevicePaired)
   * \brief   Interface to send Pairing response to BT Endpoint
   * \param   bReadyToPair [IN] : True - if HU is ready to pair AAP device, else False.
   * \param   bAAPDevicePaired [IN] : True - if HU is paired with AAP device, else False.
   * \sa      None
   ***************************************************************************/
   virtual t_Void vSendBTPairingResponse(t_Bool bReadyToPair, t_Bool bAAPDevicePaired)=0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAAPCmdBluetooth::vSendAuthenticationData()
   ***************************************************************************/
   /*!
   * \fn      vSendAuthenticationData(const t_String& rfcoszAuthData)
   * \brief   Interface to send pairing authentication data to BT Endpoint
   * \param   rfcoszAuthData [IN] : Pairing authentication data
   * \sa      None
   ***************************************************************************/
   virtual t_Void vSendAuthenticationData(const t_String& rfcoszAuthData, tenBTPairingMethod enPairingMethod)=0;
};

#endif /* SPI_TCLAAPCMDBLUETOOTHINTF_H_ */
