/***********************************************************************/
/*!
* \file  spi_tclAAPCmdAudioIntf.h
* \brief  Implementation of the Class spi_tclCommonSettingsIntf
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for AAP Cmd Audio
AUTHOR:         olr5kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
20.02.2019  | olr5kor			    Initial Version
\endverbatim
*************************************************************************/

#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"
#include "spi_tclAudioSettingsIntf.h"
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLAAPCMDAUDIOINTF_H_
#define SPI_TCLAAPCMDAUDIOINTF_H_


class spi_tclAAPCmdAudioIntf
{
public :
      /***************************************************************************
      ****************************PUBLIC *********************************
      ***************************************************************************/

      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::spi_tclAAPCmdAudioIntf()
      ***************************************************************************/
      /*!
      * \fn      spi_tclAAPCmdAudioIntf()
      * \brief   Constructor
      * \param   None
      **************************************************************************/
      spi_tclAAPCmdAudioIntf(){};
      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::~spi_tclAAPCmdAudioIntf()
      ***************************************************************************/
      /*!
      * \fn      spi_tclAAPCmdAudioIntf()
      * \brief   Destructor
      * \param   None
      **************************************************************************/
      virtual ~spi_tclAAPCmdAudioIntf(){};
      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::vSetAudioPipeConfig()
      ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioPipeConfig()
       * \brief   Set the Audio pipeline configuration for alsa devices
       * \param   crfmapAudioPipeConfig: Contains audio pipeline configuration
      **************************************************************************/
      virtual t_Void vSetAudioPipeConfig(const tmapAudioPipeConfig& crfmapAudioPipeConfig) = 0;
      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::bCreateEndpoints()
      ***************************************************************************/
      /*!
       * \fn      t_Bool bCreateEndpoints()
       * \brief   Creates the Audio Sink and Source endpoints for various Audio streams
       * \param   poAudioSettings : Pointer to audio settings interface
       * \retval  true  : Creation of endpoints successfull.
       * \retval  false : Creation of endpoints failed
       * \sa      vDestroyEndpoints()
      **************************************************************************/
      virtual t_Bool bCreateEndpoints(spi_tclAudioSettingsIntf* poAudioSettings/*tenAAPAudStreamType enAudStreamType, t_U8 u8SessionID*/) = 0;
      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::vDestroyEndpoints()
      ***************************************************************************/
      /*!
       * \fn      t_Void vDestroyEndpoints()
       * \brief   Destroys the Audio Sink and Source endpoints for various Audio streams
       * \sa      bCreateEndpoints()
      **************************************************************************/
      virtual t_Void vDestroyEndpoints() = 0;
      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::bPlaybackStarted()
      ***************************************************************************/
      /*!
       * \fn      t_Bool bPlaybackStarted()
       * \brief   Trigger received when Audio channel has been allocated
       *          (On source activity ON)
       * \sa      None
      **************************************************************************/
      virtual t_Bool bPlaybackStarted(tenAAPAudStreamType enAudStreamType) = 0;

      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::bMicrequestCompleted()
      ***************************************************************************/
      /*!
       * \fn      t_Bool bMicrequestCompleted()
       * \brief   Trigger received when Speech Audio channel has been allocated
       *          (On source activity ON)
       * \sa      None
      **************************************************************************/
      virtual t_Bool bMicRequestCompleted()=0;

      /***************************************************************************
      ** FUNCTION: spi_tclAAPCmdAudioIntf::vSetAudioStreamConfig()
      ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioStreamConfig()
       * \brief   Function to set Audio config for a specific stream and key.
       * \param   enStreamType: Audio stream type for which config has to be set
       * \param   szConfigKey: Type of the configuration
       * \param   enAudioStreamConfig: Audio stream configuration  to be set
       * \sa      None
      **************************************************************************/
      virtual t_Void vSetAudioStreamConfig(tenAAPAudStreamType enStreamType, t_String szConfigKey,
               tenAudioStreamConfig enAudioStreamConfig)=0;
      /***************************************************************************
      ****************************END OF PUBLIC *********************************
      ***************************************************************************/
};

#endif /* SPI_TCLAAPCMDAUDIOINTF_H_ */
