/*!
 *******************************************************************************
 * \file               spi_tclService.cpp
 *******************************************************************************
 \verbatim
 PROJECT:        G3G
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     CCA service Spi
 created with CCA skeleton generator.
 COPYRIGHT:      &copy; RBEI
 HISTORY:
 Date       | Author                 | Modifications
 30.10.2013 | Vinoop U               | Initial Version
 03.12.2013 | Ramya Murthy           | Updated vOnMSGetDeviceInfoList()
                                       and vOnMSGetAppList() definitions to 
                                       comply with changes to SpiCmdInterface.
 26.12.2013 | Shiva Kumar G          | Updated with few elements for 
                                       HMI Interface
 05.04.2013 | Shiva Kumar G          | Updated New Methods & Properties
 06.04.2014 | Ramya Murthy           | Initialisation sequence implementation
 10.06.2014 | Ramya Murthy           | Audio policy redesign implementation.
 16.07.2014 | Shiva Kumar G          | Implemented SessionStatusInfo update
 31.07.2014 | Ramya Murthy           | SPI feature configuration via LoadSettings()
 30.09.2014 | Ramya Murthy           | Called vDestory() of FI messages that use dynamic
                                       memory allocation
 01.10.2014 | Ramya Murthy           | Added Telephone client handler (moved from BT Manager)
 25.10.2014 |  Shihabudheen P M      | added vUpdateSessionStatusInfo
 28.10.2014 | Hari Priya E R         | Added changes for subscription of location data
 31.10.2014 | Ramya Murthy           | Implementation for "SameDevice" param in BluetoothDeviceStatus
 17.11.2014 | Hari Priya E R         | Fix for SUZUKI-20652
 05.11.2014 | Ramya Murthy           | Implementation for Application metadata.
 12.03.2014 | Ramkumar Muniraj       | Post notification was not informed. This is fixed.
 29.05.2015 | Ramya Murthy           | Implementation for BTPairingRequired property.
 12.06.2015 | Sameer Chandra         | Adapted clientCapabilities as per new FI.
 19.06.2015 | Shihabudheen P M       | added vOnDataServiceSubscribeRquest()
 25.06.2015 | Sameer Chandra         | Added ML XDeviceKey Support for PSA
 15.06.2014 | Shihabudheen P M       | vOnLbBTAddressUpdate()
 14.07.2015 | Shiva Kumar G          | Adaptations to upadted FI 
                                       1.Adding display width and height in mm to T_ DisplayLayerAttributes.
                                       2.Removal of u16MultiTouchSupport.
 16.07.2015 |  Sameer Chandra        | Added method vOnMSSendKnobEncoderChange to support Knob
                                       Encoder.
 10.08.2015 | Vinoop U               | Added method result implementation for methods
                                       SetVehicleConfiguration,SetAccessoryDisplayContext,
                                       SetDisplayAttributes,SetDeviceUsagePreference,
                                       SetVehicleBTAddress
 09.09.2015 | Shiva Kumar Gurija     | Extended ML Keys support for PSA SOP1
 07.09.2015 | Dhiraj Asopa           | Added Implementation of method SetAccessoryAudioContext().
 11.09.2015 | Dhiraj Asopa           | Added Implementation of method vOnMSSetFeatureRestrictions().
 14.12.2015 | Rachana L Achar        | Modified the prototype of vLaunchAppResult method
 26.02.2016 | Rachana L Achar        | AAP Navigation implementation
 10.03.2016 | Rachana L Achar        | AAP Notification implementation
 16.03.2016 | Ramya Murthy           | Revised implementation of data subscription
 05.05.2016 | Ramya Murthy           | Reverted usage of vOnVehicleData() to provide Drive mode info.
                                       Only interface vSetVehicleConfig() will be used instead (fix for GMMY17-14526).
 29.11.2016 |  Noopur R K            | HMI Synchronization
 01.01.2017 |  Noopur R K            | Added changes for Delete device interface implementation
 01.01.2017 |  Noopur R K            | Added changes for Blacklisting of devices implementation
 07.07.2017 |  Noopur R K            | Added changes for FI based General restriction info for AAP.
 19.03.2018 |  Jiji Anna Jacob       | Extended TBT property to include ML Navigation Metadata.
 11.04.2018 | Dundamma S B           | Removed Telephone Client Handler implementation(vOnTelephoneCallActivity()) as it is moved to External interface.
 08.07.2019 | Likhitha               | Added vOnMSGetDeviceList

 \endverbatim
 *******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "StringHandler.h"
#include "TraceStreamable.h"
using namespace spi::spitrace;
#include "spi_tclCmdInterface.h"
#include "XFiObjHandler.h"
#include "spi_tclMainApp.h"
#include "FIMsgDispatch.h"
#include "spi_tclAudioPolicy.h"
#include "spi_tclSPMClient.h"
#include "spi_tclDiaglogClient.h"
#include "spi_LoopbackTypes.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompManager.h"
#include "spi_WifiTypedefs.h"
#include "spi_tclService.h"
#ifdef FILEWRITE
#include <fstream>
#endif
#include "spi_tclSensorDataClientHandler.h"
#include "spi_tclSensorPVDataClientHandler.h"
using namespace shl::msgHandler;

//!Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_TCLSERVICE
#include "trcGenProj/Header/spi_tclService.cpp.trc.h"
#endif
#endif

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported


/******************************************************************************
 | defines
 |----------------------------------------------------------------------------*/

//!Version defines for offered service
#define SPI_SERVICE_FI_MAJOR_VERSION  MIDW_SMARTPHONEINTFI_C_U16_SERVICE_MAJORVERSION
#define SPI_SERVICE_FI_MINOR_VERSION  MIDW_SMARTPHONEINTFI_C_U16_SERVICE_MINORVERSION
#define SPI_SERVICE_FI_PATCH_VERSION  0

#define CLEAR_BTDEVSTATUS_MSG(MESSAGE_OBJ) \
      MESSAGE_OBJ.BluetoothDeviceHandle = 0;  \
      MESSAGE_OBJ.ProjectionDeviceHandle = 0; \
      MESSAGE_OBJ.BTChangeInfo.enType = static_cast<midw_fi_tcl_e8_BTChangeInfo::tenType>(e8NO_CHANGE);   \
      MESSAGE_OBJ.CallActiveStatus = false;

typedef struct
{
   //! Key Code which we will receive from the HMI
   spi_tenFiKeyCode e32SpiKeyCode;
   //! Corresponding SPI type Switch Code
   tenKeyCode enKeyCode;

}trKeyCode;

typedef struct
{
   //! Language which we will receive from the HMI unknown
   spi_tenFiLanguageSetting e32SpiLanguageSetting;
   //! Corresponding SPI type Switch
   tenLanguageSetting enLanguageSetting;

}trLanguageSetting;

const trLanguageSetting aLanguageSetting [] =
{
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_UNKNOWN,e32LANGUAGE_UNKNOWN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ALBANIAN,e32LANGUAGE_ALBANIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ARABIC,e32LANGUAGE_ARABIC},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_BULGARIAN,e32LANGUAGE_BULGARIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED,e32LANGUAGE_CHINESE_CANTONESE_SIMPLIFIED},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_CHINESE_CANTONESE_TRADITIONAL,e32LANGUAGE_CHINESE_CANTONESE_TRADITIONAL},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED ,e32LANGUAGE_CHINESE_MANDARIN_SIMPLIFIED},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_CROATIAN,e32LANGUAGE_CROATIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_CZECH,e32LANGUAGE_CZECH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_DANISH,e32LANGUAGE_DANISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_DUTCH,e32LANGUAGE_DUTCH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_AUSTRALIAN,e32LANGUAGE_ENGLISH_AUSTRALIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_UK,e32LANGUAGE_ENGLISH_UK},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_US,e32LANGUAGE_ENGLISH_US},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_US_FOR_JPN,e32LANGUAGE_ENGLISH_US_FOR_JPN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_US_FOR_PRC ,e32LANGUAGE_ENGLISH_US_FOR_PRC},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_CANADIAN,e32LANGUAGE_ENGLISH_CANADIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ENGLISH_INDIA,e32LANGUAGE_ENGLISH_INDIA},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ESTONIAN,e32LANGUAGE_ESTONIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_FINNISH,e32LANGUAGE_FINNISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_FLEMISH,e32LANGUAGE_FLEMISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_FRENCH,e32LANGUAGE_FRENCH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_FRENCH_CANDIAN,e32LANGUAGE_FRENCH_CANDIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_GERMAN,e32LANGUAGE_GERMAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_GREEK,e32LANGUAGE_GREEK},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_HEBREW,e32LANGUAGE_HEBREW},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_HINDI,e32LANGUAGE_HINDI},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_HUNGARIAN,e32LANGUAGE_HUNGARIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_INDONESIAN,e32LANGUAGE_INDONESIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ITALIAN,e32LANGUAGE_ITALIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_JAPANESE,e32LANGUAGE_JAPANESE},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_KOREAN,e32LANGUAGE_KOREAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_LATVIAN ,e32LANGUAGE_LATVIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_LITHUANIAN,e32LANGUAGE_LITHUANIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_MALAY,e32LANGUAGE_MALAY},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_NORWEGIAN,e32LANGUAGE_NORWEGIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_PERSIAN_FARSI_IRANIAN,e32LANGUAGE_PERSIAN_FARSI_IRANIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_PHILIPPINES ,e32LANGUAGE_PHILIPPINES},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_POLISH,e32LANGUAGE_POLISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_PORTUGUESE,e32LANGUAGE_PORTUGUESE},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_PORTUGUESE_BRAZILIAN,e32LANGUAGE_PORTUGUESE_BRAZILIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_ROMANIAN,e32LANGUAGE_ROMANIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_RUSSIAN,e32LANGUAGE_RUSSIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SERBIAN,e32LANGUAGE_SERBIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SLOVAKIAN,e32LANGUAGE_SLOVAKIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SLOVENIAN,e32LANGUAGE_SLOVENIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SPANISH,e32LANGUAGE_SPANISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SPANISH_LATIN_AMERICAN,e32LANGUAGE_SPANISH_LATIN_AMERICAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SPANISH_MEXICAN,e32LANGUAGE_SPANISH_MEXICAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_SWEDISH,e32LANGUAGE_SWEDISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_TAIWANESE,e32LANGUAGE_TAIWANESE},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_THAI,e32LANGUAGE_THAI},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_TURKISH,e32LANGUAGE_TURKISH},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_UKRAINIAN,e32LANGUAGE_UKRAINIAN},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_VIETNAMESE,e32LANGUAGE_VIETNAMESE},
         {spi_tenFiLanguageSetting::FI_EN_LANGUAGE_UNSUPPORTED,e32LANGUAGE_UNSUPPORTED}

};
const trKeyCode aKeyCode[] =
{
   {spi_tenFiKeyCode::FI_EN_DEV_BACKWARD,e32DEV_BACKWARD},
   {spi_tenFiKeyCode::FI_EN_DEV_MENU,e32DEV_MENU},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_NEXT,e32MULTIMEDIA_NEXT},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_PREVIOUS,e32MULTIMEDIA_PREVIOUS},
   {spi_tenFiKeyCode::FI_EN_DEV_PHONE_FLASH,e32DEV_PHONE_FLASH},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_PLAY,e32MULTIMEDIA_PLAY},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_PAUSE,e32MULTIMEDIA_PAUSE},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_STOP,e32MULTIMEDIA_STOP},
   {spi_tenFiKeyCode::FI_EN_DEV_PHONE_CALL,e32DEV_PHONE_CALL},
   {spi_tenFiKeyCode::FI_EN_DEV_PHONE_END,e32DEV_PHONE_END},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_MUTE,e32MULTIMEDIA_MUTE},
   {spi_tenFiKeyCode::FI_EN_DEV_SOFT_LEFT,e32DEV_SOFT_LEFT},
   {spi_tenFiKeyCode::FI_EN_DEV_SOFT_MIDDLE,e32DEV_SOFT_MIDDLE},
   {spi_tenFiKeyCode::FI_EN_DEV_SOFT_RIGHT,e32DEV_SOFT_RIGHT},
   {spi_tenFiKeyCode::FI_EN_DEV_APPLICATION,e32DEV_APPLICATION},
   {spi_tenFiKeyCode::FI_EN_DEV_OK,e32DEV_OK},
   {spi_tenFiKeyCode::FI_EN_DEV_DELETE,e32DEV_DELETE},
   {spi_tenFiKeyCode::FI_EN_DEV_ZOOM_IN,e32DEV_ZOOM_IN},
   {spi_tenFiKeyCode::FI_EN_DEV_ZOOM_OUT,e32DEV_ZOOM_OUT},
   {spi_tenFiKeyCode::FI_EN_DEV_CLEAR,e32DEV_CLEAR},
   {spi_tenFiKeyCode::FI_EN_DEV_FORWARD,e32DEV_FORWARD},
   {spi_tenFiKeyCode::FI_EN_DEV_HOME,e32DEV_HOME},
   {spi_tenFiKeyCode::FI_EN_DEV_SEARCH,e32DEV_SEARCH},
   {spi_tenFiKeyCode::FI_EN_DEV_PTT,e32DEV_PTT},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_FORWARD,e32MULTIMEDIA_FORWARD},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_REWIND,e32MULTIMEDIA_REWIND},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_0,e32DEV_KEY_0},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_1,e32DEV_KEY_1},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_2,e32DEV_KEY_2},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_3,e32DEV_KEY_3},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_4,e32DEV_KEY_4},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_5,e32DEV_KEY_5},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_6,e32DEV_KEY_6},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_7,e32DEV_KEY_7},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_8,e32DEV_KEY_8},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_9,e32DEV_KEY_9},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_0,e32ITU_KEY_0},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_1,e32ITU_KEY_1},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_2,e32ITU_KEY_2},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_3,e32ITU_KEY_3},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_4,e32ITU_KEY_4},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_5,e32ITU_KEY_5},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_6,e32ITU_KEY_6},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_7,e32ITU_KEY_7},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_8,e32ITU_KEY_8},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_9,e32ITU_KEY_9},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_PLUS,e32DEV_KEY_PLUS},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_STAR,e32DEV_KEY_STAR},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_HASH,e32DEV_KEY_HASH},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_ASTERIX,e32ITU_KEY_ASTERIX},
   {spi_tenFiKeyCode::FI_EN_ITU_KEY_POUND,e32ITU_KEY_POUND},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_RIGHT,e32TWODKNOB0_SHIFT_RIGHT},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_LEFT,e32TWODKNOB0_SHIFT_LEFT},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_UP,e32TWODKNOB0_SHIFT_UP},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_DOWN,e32TWODKNOB0_SHIFT_DOWN},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_UP_RIGHT, e32TWODKNOB0_SHIFT_UP_RIGHT},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_UP_LEFT, e32TWODKNOB0_SHIFT_UP_LEFT},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_DOWN_RIGHT, e32TWODKNOB0_SHIFT_DOWN_RIGHT},
   {spi_tenFiKeyCode::FI_EN_TWODKNOB0_SHIFT_DOWN_LEFT,e32TWODKNOB0_SHIFT_DOWN_LEFT},
   {spi_tenFiKeyCode::FI_EN_DEV_TEL,e32APP_KEYCODE_TELEPHONY},
   {spi_tenFiKeyCode::FI_EN_DEV_MEDIA,e32DEV_MEDIA},
   {spi_tenFiKeyCode::FI_EN_DEV_NAV,e32DEV_NAV},
   {spi_tenFiKeyCode::FI_EN_DEV_KEY_PHONE_MUTE,e32DEV_PHONE_MUTE},
   {spi_tenFiKeyCode::FI_EN_MULTIMEDIA_PLAY_PAUSE,e32MULTIMEDIA_PLAY_PAUSE},
   {spi_tenFiKeyCode::FI_EN_ROTARY_KNOB,e32ROTARY_KNOB},
   {spi_tenFiKeyCode::FI_EN_DEV_PHONE_MERGE_CALLS,e32MERGE_CALLS},
   {spi_tenFiKeyCode::FI_EN_DEV_PHONE_SWAP_CALLS,e32SWAP_CALLS}
};

static const t_U32 scou32MaxDeviceHandle = 0xFFFFFFFF;
static tenBTVoiceSessionStatus aVoiceSessionResponse[] = {
                                       e8BTVOICESESSION_STATUS_IDLE,
                                       e8BTVOICESESSION_STATUS_REQUEST_ACCEPTED,
                                       e8BTVOICESESSION_STATUS_REQUEST_DENIED,
                                       e8BTVOICESESSION_STATUS_REQUEST_DENIED_NOHFP,
                                       e8BTVOICESESSION_STATUS_REQUEST_DENIED_VOICEALREADYACTIVE
                                       };

//To convert Km/h into cm/s
//static const t_Float scf16SpeedConversionValue = 27.78;

//! Middleware FI string Character set
#define MIDWFI_CHAR_SET_UTF8   (midw_fi_tclString::FI_EN_UTF8)

#define PARKBRAKESTATE_ENGAGED    (midw_fi_tcl_e8_ParkBrake::FI_EN_PARK_BRAKE_ENGAGED)
#define VEHICLESTATE_PARK_MODE    (midw_fi_tcl_e8_VehicleState::FI_EN_PARK_MODE)
#define LEFT_HAND_DRIVE           (midw_fi_tcl_e8_Vehicle_Configuration::FI_EN_LEFT_HAND_DRIVE)
#define RIGHT_HAND_DRIVE          (midw_fi_tcl_e8_Vehicle_Configuration::FI_EN_RIGHT_HAND_DRIVE)
#define LOW_FIDELITY              (midw_fi_tcl_e8_FidelityType::FI_EN_E8LOW_FIDELITY)
#define HIGH_FIDELITY             (midw_fi_tcl_e8_FidelityType::FI_EN_E8HIGH_FIDELITY)

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
//! Empty location data callback structures
static trLocationDataCallbacks srDataSvcLocDataCb;
static trSensorDataCallbacks srDataSvcSensorDataCb;
static const t_U32 cou32InvalidHandle         = 0;
static const t_U8 cou8VOICESESSION_REQUEST_END_USER_EVENT = 3;
static const t_U8 cou8VOICESESSION_REQUEST_END_REAL_CALL_EVENT = 4;
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart> spi_tMsgGetDevInfoListMS
 * \brief Get Device Info List Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodStart>
         spi_tMsgGetDevInfoListMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetDeviceInfoMethodStart> spi_tMsgGetDevInfoMS
 * \brief Get Device Info Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetDeviceListMethodStart>
         spi_tMsgGetDevListMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSelectDeviceMethodStart> spi_tMsgSelectDeviceMS
 * \brief Select Device Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSelectDeviceMethodStart>
         spi_tMsgSelectDeviceMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgLaunchAppMethodStart> spi_tMsgLaunchAppMS
 * \brief Launch App Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgLaunchAppMethodStart>
         spi_tMsgLaunchAppMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgTerminateAppMethodStart> spi_tMsgTerminateAppMS
 * \brief Terminate App Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgTerminateAppMethodStart>
         spi_tMsgTerminateAppMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetAppListMethodStart> spi_tMsgGetAppListMS
 * \brief Get Application List Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetAppListMethodStart>
         spi_tMsgGetAppListMS;

/*! 
 * \XFiObjHandler<midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart>
 * \brief Get Application Icon data Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetAppIconDataMethodStart>
         spi_tMsgGetAppIconDataMS;

/*! 
 * \XFiObjHandler<midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart>
 * \brief Set application Icon Attributes Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodStart>
        spi_tMsgSetAppIconAttrMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart> spi_tMsgSetVehicleConfigMS
 * \brief Set vehicle configuration Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodStart>
        spi_tMsgSetVehicleConfigMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart> spi_tMsgSetVehicleMovementMS
 * \brief Set vehicle Movement Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodStart>
        spi_tMsgSetVehicleMovementMS;
/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart> spi_tMsgSetVehicleManufacturerInformationMS
 * \brief Set vehicle Information Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodStart>
        spi_tMsgSetVehicleManufacturerInformationMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart> spi_tMsgVehicleMechanicalSpeedMS
 * \brief Vehicle Mechanical Speed Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodStart>
        spi_tMsgVehicleMechanicalSpeedMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart> spi_tMsgSetVideoBlockingModeMS
 * \brief Set video blocking mode Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodStart>
        spi_tMsgSetVideoBlockingModeMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart> spi_tMsgSetAudioBlockingModeMS
 * \brief Set audio blocking mode Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodStart>
       spi_tMsgSetAudioBlockingModeMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart> spi_tMsgSetOrientationModeMS
 * \brief Set Orientation mode Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetOrientationModeMethodStart>
       spi_tMsgSetOrientationModeMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart> spi_tMsgSetScreenSizeMS
 * \brief Set Screen Size Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetScreenSizeMethodStart>
       spi_tMsgSetScreenSizeMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart> spi_tMsgGetVideoSettingsMS
 * \brief Get Video Settings Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetVideoSettingsMethodStart>
       spi_tMsgGetVideoSettingsMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart> spi_tMsgSetDeviceUsagePreferenceMS
 * \brief set device usage preference Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodStart>
       spi_tMsgSetDeviceUsagePreferenceMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart> spi_tMsgGetDeviceUsagePreferenceMS
 * \brief get device usage preference Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodStart>
       spi_tMsgGetDeviceUsagePreferenceMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart> spi_tMsgAccDispCntxtMS
 * \brief Accessory display context Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodStart>
       spi_tMsgAccDispCntxtMS;

/*! 
 * \XFiObjHandler<midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart> spi_tMsgAccAudioCntxtMS
 * \brief Accessory audio context Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodStart>
       spi_tMsgAccAudioCntxtMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart> spi_tMsgSetClientCapabilitiesMS
 * \brief set client capabilities Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodStart>
       spi_tMsgSetClientCapabilitiesMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart> spi_tMsgSetSetMLNotiEnabledInfoMS
 * \brief Set ML Notification Enabled Info Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodStart>
       spi_tMsgSetSetMLNotiEnabledInfoMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart> spi_tMsgInvokeNotiAction
 * \brief Invoke Notification Action  Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodStart>
       spi_tMsgInvokeNotiAction;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSendTouchEventMethodStart> spi_tMsgSetSendTouchEventMS
 * \brief seend touch events Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSendTouchEventMethodStart>
       spi_tMsgSetSendTouchEventMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSendKeyEventMethodStart> spi_tMsgSendKeyEventMS
 * \brief Send Key Events Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSendKeyEventMethodStart>
       spi_tMsgSendKeyEventMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart> spi_tMsgSetVehicleBTAddressMS
 * \brief set vehicle BT Address Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodStart>
       spi_tMsgSetVehicleBTAddressMS;


/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetRegionMethodStart> spi_tMsgSetRegionMS
 * \brief set Region Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetRegionMethodStart>
       spi_tMsgSetRegionMS;

/*! 
 * \ XFiObjHandler<midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart> spi_tMsgAccAppStateMS
 * \brief set accessory App state 
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgAccessoryAppStateMethodStart>
       spi_tMsgAccAppStateMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart> spi_tMsgRoleSwitchReqMS
 * \brief role switch required Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart>
      spi_tMsgRoleSwitchReqMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart> spi_tMsgSetAccDisplayContextReqMS
 * \brief set accessory display context method start.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodStart>
      spi_tMsgSetAccDisplayContextReqMS;

/*! 
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart> spi_tMsgSetSetDisplayAttributesMS
 * \brief set display attributes Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodStart>
       spi_tMsgSetDisplayAttributesMS;
/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart> spi_tMsgGetKeyIconDataMS
 * \brief get ML key icon data.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetKeyIconDataMethodStart>
        spi_tMsgGetKeyIconDataMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart> spi_tMsgRotaryCtrlEventMS
 * \brief Send Rotary Controller event.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgRotaryControllerEventMethodStart>
        spi_tMsgRotaryCtrlEventMS;


/*!
 * \XFiObjHandler<midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart> spi_tMsgSetAccAudioCntxtMS
 * \brief Set Accessory audio context Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodStart>
spi_tMsgSetAccAudioCntxtMS;

/*!
 * \XFiObjHandler<midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart> spi_tMsgSetSetFeatureRestrictionsMS
 * \brief Set Feature Restrictions Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodStart>
spi_tMsgSetFeatureRestrictionsMS;

/*!
 * \brief Set Technology preference if device supports more than one technology
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodStart>
spi_tMsgSetTechnologyPrefMS;

/*!
 * \brief Get Technology preference setting
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodStart>
spi_tMsgGetTechnologyPrefMS;
/*
 * \brief Set the Device authorization status
 */

typedef XFiObjHandler<midw_smartphoneintfi_tclMsgProjectionDeviceAuthorizationSet>
spi_tMsgSetDeviceAuth;
/*
 * \brief Set the Technology Selection status
 */

typedef XFiObjHandler<midw_smartphoneintfi_tclMsgTechnologySelectionSet>
spi_tMsgSetTechSelection;
/*
 * \brief Set the Device selection mode (automatic/manual)
 */

typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodStart>
spi_tMsgSetDeviceSelModeMS;

/*
 * \brief Set the Notification Status
 */

typedef XFiObjHandler<midw_smartphoneintfi_tclMsgAAPNotificationEventSet>
spi_tMsgSetAAPNotifEvent;

/*
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart> spi_tMsgGetMediaObjectAlbumArt
 * \brief Get Media object album art
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodStart>
spi_tMsgGetMediaObjectAlbumArt;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart> spi_tMsgGetSPIVersionMS
 * \brief Get SPI Version Object
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodStart>
         spi_tMsgGetSPIVersionMS;
		 
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgmySPINBluetoothVoiceRecInfoSet>
spi_tMsgmySPINBTVRResponse;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart> spi_tMsgDeleteDevice
 * \brief Delete devices Object
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgDeleteDeviceMethodStart>
spi_tMsgDeleteDevice;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart> spi_tMsgInitiateWirelessDiscoveryMS
 * \brief Initiate Wireless Discovery Object
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodStart>
         spi_tMsgInitiateWirelessDiscoveryMS;

		 
		 
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart>
         spi_tMsgGetWiFiCredentialsMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSetETCStatusMethodStart> spi_tMsgSetETCStatusMS
 * \brief - set the Electronic Toll Collection (ETC) enabling status.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetETCStatusMethodStart>
       spi_tMsgSetETCStatusMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSendKeyEventMethodStart> spi_tMsgSendKeyEventMS
 * \brief Send Key Events Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSendLanguageSettingMethodStart>
       spi_tMsgSendLanguageSettingMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart> spi_tMsgSendVehiclePowerModeStateMS
 * \brief - Interface that determines the position of the ignition switch
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodStart>
       spi_tMsgSendVehiclePowerModeStateMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart> spi_tMsgSendAmbientColorMS
 * \brief - Interface that ambient colour details of the HU like Red, Green, Blue, Alpha etc
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSendAmbientColourMethodStart>
       spi_tMsgSendAmbientColorMS;
/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart> spi_tMsgDistanceToEmptyTankMS
 * \brief - distance to empty tank.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodStart>
       spi_tMsgDistanceToEmptyTankMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart> spi_tMsgRegRouteGuidanceDisplayConfMS
 * \brief - Register route guidance display component configurations.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart>
       spi_tMsgRegRouteGuidanceDisplayConfMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart> spi_tMsgStartRouteGuidanceUpdatesMS
 * \brief - Start route guidance updates from the phone.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodStart>
       spi_tMsgStartRouteGuidanceUpdatesMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodStart> spi_tMsgRegRouteGuidanceDisplayConfMS
 * \brief - Stop route guidance updates from the phone.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodStart>
       spi_tMsgStopRouteGuidanceUpdatesMS;

/*!
 * \XFIObjHandler<midw_smartphoneintfi_tclMsgRegisterSetClientStateMethodStart> spi_tMsgRegSetClientStateMS
 * \brief - Client state of the master user of SPI Service
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgSetClientStateMethodStart>
       spi_tMsgSetClientStateMS;
	   
/*!
* \XFIObjHandler<midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart> spi_tMsgRegisterKeyCodes
 * \brief Register KeyCodes Method start, with auto extract & auto destroy feature.
 */
typedef XFiObjHandler<midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodStart>
       spi_tMsgRegisterKeyCodes;

/*****************************************************************************
 * \CCA MESSAGE MAP
 ******************************************************************************/
//!Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
//!method should be called on receiving a specific message.
BEGIN_MSG_MAP(spi_tclService, ahl_tclBaseWork)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETDEVICEINFOLIST,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetDeviceInfoList)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETDEVICELIST,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetDeviceList)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SELECTDEVICE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSelectDevice)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_LAUNCHAPP,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSLaunchApp)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_TERMINATEAPP,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSTerminateApp)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETAPPLIST,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetAppList)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETAPPICONDATA ,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetAppIconData)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETAPPICONATTRIBUTES ,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetAppIconAttr)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETVEHICLECONFIGURATION ,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetVehicleConfig)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETVEHICLEMOVEMENTSTATE ,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetVehicleMovementState)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETVEHICLEMANUFACTURERINFORMATION ,
		 AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetVehicleManufacturerInformation)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_VEHICLEMECHANICALSPEED ,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSVehicleMechanicalSpeed)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETVIDEOBLOCKINGMODE ,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetVideoBlockingMode)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETAUDIOBLOCKINGMODE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetAudioBlockingMode)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETORIENTATIONMODE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetOrientationMode)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETSCREENSIZE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetScreenSize)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETVIDEOSETTINGS,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetVideoSettings)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETDEVICEUSAGEPREFERENCE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetDeviceUsagePreference)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETDEVICEUSAGEPREFERENCE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetDeviceUsagePreference)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_ACCESSORYDISPLAYCONTEXT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSAccessoryDisplayContext)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETCLIENTCAPABILITIES,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetClientCapabilities)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETMLNOTIFICATIONENABLEDINFO,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetMLNotificationEnabledInfo)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_INVOKENOTIFICATIONACTION,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSInvokeNotificationAction)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SENDTOUCHEVENT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSendTouchEvent)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SENDKEYEVENT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSendKeyEvent)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETVEHICLEBTADDRESS,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetVehicleBTAddress)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETREGION,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetRegion)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_ACCESSORYAUDIOCONTEXT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSAccessoryAudioContext)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_ACCESSORYAPPSTATE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSAccessoryAppState)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_DIPOROLESWITCHREQUIRED,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSDiPoRoleSwitchRequired)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETACCESSORYDISPLAYCONTEXT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetAccessoryDisplayContext)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETKEYICONDATA,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetKeyIconData)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETDISPLAYATTRIBUTES,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetDisplayAttributes)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_ROTARYCONTROLLEREVENT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSendRotaryCtrlEvent)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETACCESSORYAUDIOCONTEXT,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetAccessoryAudioContext)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETFEATURERESTRICTIONS,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetFeatureRestrictions)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETTECHNOLOGYPREFERENCE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetTechnologyPreference)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETTECHNOLOGYPREFERENCE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetTechnologyPreference)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETDEVICESELECTIONMODE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetDeviceSelMode)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETMEDIAOBJECTALBUMART,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetMediaObjectAlbumArt)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETSPIVERSIONINFO,
		 AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetSPIVersion)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_DELETEDEVICE,
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMsDeleteDevice)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_INITIATEWIRELESSDISCOVERY,
		 AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSInitiateWirelessDiscovery)
		 
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETWIFICREDENTIALS,
		 AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSGetWiFiCredentials)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETETCSTATUS,
		 AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetETCStatus)


ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SENDLANGUAGESETTING,
                  AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSendLanguageSetting)


ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SENDVEHICLEPOWERMODESTATE,
		        AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSendVehiclePowerModeState)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SENDAMBIENTCOLOUR,
		        AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSendAmbientColour)


ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_DISTANCETOEMPTYTANK,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSDistanceToEmptyTank)
ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_REGISTERKEYCODES,
                        AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSRegisterKeyCodes)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_REGISTERROUTEGUIDANCEDISPLAYCONFIGURATION,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSRegRouteGuidanceDisplayConf)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_STARTROUTEGUIDANCEUPDATES,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSStartRouteGuidanceUpdates)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_STOPROUTEGUIDANCEUPDATES,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSStopRouteGuidanceUpdates)

ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_SETCLIENTSTATE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART,vOnMSSetClientState)

/*Internal (loopback) messages mapping*/
ON_MESSAGE_SVCDATA(SPI_C_U16_IFID_VEHICLE_BTADDRESS_UPDATE,
       AMT_C_U8_CCAMSG_OPCODE_STATUS,vOnLbBTAddressUpdate)
ON_MESSAGE_SVCDATA(SPI_C_U16_IFID_SPI_STATE,
       AMT_C_U8_CCAMSG_OPCODE_STATUS,vOnLbSPIStateUpdate)
ON_MESSAGE_SVCDATA(SPI_C_U16_IFID_AUTOREGISTERPROPERTY,
     AMT_C_U8_CCAMSG_OPCODE_STATUS,vOnLbAutoRegisterProperty)
ON_MESSAGE_SVCDATA(SPI_C_U16_IFID_AUTOUNREGISTERPROPERTY,
     AMT_C_U8_CCAMSG_OPCODE_STATUS,vOnLbAutoUnregisterProperty)

END_MSG_MAP()

/**************************************************************************
 * \FUNCTION   : spi_tclService::spi_tclService(spi_tclMainApp* poMainAppl)
 **************************************************************************/
spi_tclService::spi_tclService(spi_tclMainApp* poMainAppl)
   : ahl_tclBaseOneThreadService(
      poMainAppl, /* Main Appl Pointer          */
      CCA_C_U16_SRV_SMARTPHONEINTEGRATION, /* ID of offered Service           */
      SPI_SERVICE_FI_MAJOR_VERSION, /* MajorVersion of offered Service */
      SPI_SERVICE_FI_MINOR_VERSION, /* MinorVersion of offered Service */
      SPI_SERVICE_FI_PATCH_VERSION), /* PatchVersion of offered Service */
     m_poMainAppl(poMainAppl),
     m_poSpiCmdIntf(nullptr),
     m_poAudioPolicy(nullptr),
     m_poSPMClient(nullptr),
     m_poDiaglogClient(nullptr),
     m_poExtClientFactory(NULL),
     m_poExtCompManger(NULL),
     m_enDriveModeConfig(e8_UNKNOWN_CONFIG)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::spi_tclService() entered"));
   #ifdef GEN3X86
   vSetPrivateServiceAvailableAllowed(false);
   #endif
   NORMAL_M_ASSERT(nullptr != poMainAppl);
} // end of spi_tclService()

/**************************************************************************
 * \FUNCTION   : spi_tclService::~spi_tclService(tVoid)
 *******************************************************************************/
spi_tclService::~spi_tclService(tVoid)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::~spi_tclService() entered"));

   m_NotificationInfo.vDestroy();
   m_AppMediaMetaDataLock.s16Lock();
   m_AppMediaMetaData.vDestroy();
   m_AppMediaMetaDataLock.vUnlock();
   m_AppPhoneDataLock.s16Lock();
   m_AppPhoneData.vDestroy();
   m_AppPhoneDataLock.vUnlock();
   m_AppMediaPlayBacktime.vDestroy();
   m_poSPMClient = nullptr;
   m_poAudioPolicy = nullptr;
   m_poSpiCmdIntf = nullptr;
   m_poMainAppl = nullptr;
   m_WifiCredentialsStatus.vDestroy();
   m_poDiaglogClient = nullptr;
   m_poExtCompManger=nullptr;
   m_poExtClientFactory=nullptr;
   m_ProjVideoInfoStatus.vDestroy();
   m_rTurnByTurnInfo.vDestroy();
   m_rAAutoTurnByTurnInfo.vDestroy();
   m_rMLTurnByTurnInfo.vDestroy();
   m_rBDCLTurnByTurnInfo.vDestroy();
   m_rCarPlayRouteGuidanceUpdate.vDestroy();
   m_rCarplayRouteGuidanceManeuverUpdate.vDestroy();
   m_oDisplayComponentMapLock.s16Lock();
   m_mapDisplayComponent.clear();
   m_oDisplayComponentMapLock.vUnlock();
   m_oCarPlayRGClientsMapLock.s16Lock();
   m_mapCarPlayRGClients.clear();
   m_oCarPlayRGClientsMapLock.vUnlock();
   m_oCarPlayRGMClientsMapLock.s16Lock();
   m_mapCarPlayRGMClients.clear();
   m_oCarPlayRGMClientsMapLock.vUnlock();
} // end of ~spi_tclService()

/**************************************************************************
** FUNCTION:  t_Bool spi_tclService::bInitialize();
**************************************************************************/
t_Bool spi_tclService::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::bInitialize() entered"));

   t_Bool bInit = false;

   //!Initialize SPI service messages
   m_AppInfoStatus.DeviceHandle = 0;
   m_AppInfoStatus.DeviceConnectionType.enType = midw_fi_tcl_e8_DeviceConnectionType::FI_EN_UNKNOWN_CONNECTION;
   m_AppInfoStatus.AppStatus.enType = midw_fi_tcl_e8_AppStatusInfo::FI_EN_NOT_KNOWN;

   //!Initialise BTDeviceStatus message
   CLEAR_BTDEVSTATUS_MSG(m_BTDeviceStatusMsg);

   //! Initialize Session Status info message
   m_SessionStatus.DeviceHandle = 0;
   m_SessionStatus.DeviceCategory.enType = midw_fi_tcl_e8_DeviceCategory::FI_EN_DEV_TYPE_UNKNOWN;
   m_SessionStatus.SessionStatus.enType = midw_fi_tcl_e8_SessionStatus::FI_EN_SESSION_UNKNOWN;
   m_SessionStatus.HandsetInteractionStatus.enType = midw_fi_tcl_e8_HandsetInteraction::FI_EN_HANDSET_INTERACTION_UNKNOWN;

   //! Initialize Device Authorization status
   m_DevAuthStatus.NumDevices = 0;
   //Since Framework is taking MEDIA_APP_TYPE_RADIO as default MediaAppCategory,initializing it to MEDIA_APP_TYPE_UNKNOWN here
   //MediaAppHandle is also set to default value.
   m_enRelActiveMedAppStatus.MediaAppHandle = 0xFFFFFFFF;
   m_enRelActiveMedAppStatus.MediaAppCategory.enType = (midw_fi_tcl_e8Media_AppCategory::tenType)(e8MEDIA_APP_TYPE_UNKNOWN);
   //! Initialise Command interface pointer
   if (nullptr != m_poMainAppl)
   {
      //Invoke SPI C++ Interface class and pass the Response class pointer
      m_poSpiCmdIntf = spi_tclCmdInterface::getInstance(this, m_poMainAppl);
      NORMAL_M_ASSERT(nullptr != m_poSpiCmdIntf);

      if (nullptr != m_poSpiCmdIntf)
      {
         m_poAudioPolicy = new(std::nothrow) spi_tclAudioPolicy(m_poSpiCmdIntf, m_poMainAppl);
      }
      NORMAL_M_ASSERT(nullptr != m_poAudioPolicy);

      m_poExtClientFactory=spi_tclExtClientFactory::getInstance(m_poMainAppl);
      NORMAL_M_ASSERT(nullptr != m_poExtClientFactory);

      m_poExtCompManger=spi_tclExtCompManager::getInstance();
      NORMAL_M_ASSERT(nullptr != m_poExtCompManger);

      m_poSPMClient = new(std::nothrow) spi_tclSPMClient(m_poMainAppl);
      NORMAL_M_ASSERT(nullptr != m_poSPMClient);

      m_poDiaglogClient = new(std::nothrow) spi_tclDiaglogClient(m_poMainAppl);
      NORMAL_M_ASSERT(nullptr != m_poDiaglogClient);	  

      bInit = ((nullptr != m_poSpiCmdIntf) &&
            (nullptr != m_poAudioPolicy) &&
            (nullptr != m_poSPMClient) &&
            (nullptr != m_poDiaglogClient) &&
            (nullptr != m_poExtClientFactory)&&
            (nullptr != m_poExtCompManger)&&
            (m_poSpiCmdIntf->bInitialize()) &&
            (m_poExtClientFactory->bInitialize())&&
            (m_poExtCompManger->bInitialize()));

   } //if (nullptr != m_poMainAppl)
   //!Insert the  switch codes received from HMI and the corresponding SPI Key codes to map
   vInsertKeyCodeToMap();
   vInsertLanguageToMap();

   return bInit;
}//! end of bInitialize()

/**************************************************************************
** FUNCTION:  t_Bool spi_tclService::bUnInitialize();
**************************************************************************/
t_Bool spi_tclService::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::bUnInitialize() entered"));

   t_Bool bUnInit = false;

   RELEASE_MEM_OSAL(m_poSPMClient);
   RELEASE_MEM_OSAL(m_poDiaglogClient);
   RELEASE_MEM_OSAL(m_poAudioPolicy);

   if (nullptr != m_poSpiCmdIntf)
   {
      bUnInit = m_poSpiCmdIntf->bUnInitialize();
   }
   m_poSpiCmdIntf = nullptr;

   if (nullptr != m_poExtClientFactory)
      {
         bUnInit = m_poExtClientFactory->bUnInitialize();
      }
   m_poExtClientFactory = nullptr;
   if (nullptr != m_poExtCompManger)
      {
         bUnInit = m_poExtCompManger->bUnInitialize();
      }
   m_poExtCompManger = nullptr;

   return bUnInit;
}//! end of bUnInitialize()

/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vLoadSettings()
***************************************************************************/
t_Void spi_tclService::vLoadSettings()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vLoadSettings() entered"));
   trSpiFeatureSupport rSpiFeatureSupport;
   if ((nullptr != m_poSpiCmdIntf))
   {
      m_poSpiCmdIntf->vLoadSettings();
      t_String szSPIVersion = m_poSpiCmdIntf->szGetSPIVersion();
      m_poSpiCmdIntf->vGetSpiFeatureSupport(rSpiFeatureSupport);
      ETG_TRACE_USR1(("[FUNC]spi_tclService::vLoadSettings() SPI Version = %s",szSPIVersion.c_str()));
   }
   //! MediaPlayer client handler pointer
   if(NULL != m_poExtClientFactory)
   {
      m_poExtClientFactory->vLoadSettings(rSpiFeatureSupport);
   }

   vInitialiseCallbacks();

   if(m_poSpiCmdIntf)
   {
       m_poSpiCmdIntf->vLoadSettingsCompleted();
   }

   ETG_TRACE_USR1(("[FUNC]spi_tclService::vLoadSettings exit"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vSaveSettings()
***************************************************************************/
t_Void spi_tclService::vSaveSettings()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vSaveSettings() entered"));
   if (nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vSaveSettings();
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vInitialiseCallbacks()
***************************************************************************/
t_Void spi_tclService::vInitialiseCallbacks()
{
	 /*lint -esym(40,fvOnGpsData)fvOnGpsData Undeclared identifier */
	 /*lint -esym(40,fvOnAccSensorData)fvOnAccSensorData Undeclared identifier */
	 /*lint -esym(40,fvOnGyroSensorData)fvOnGyroSensorData Undeclared identifier */
	 /*lint -esym(40,_1)_1 Undeclared identifier */
   //Initialise the callback structures
   srDataSvcLocDataCb.fvOnGpsData =
      std::bind(&spi_tclService::vOnGPSData, this, SPI_FUNC_PLACEHOLDERS_1);
   srDataSvcSensorDataCb.fvOnSensorData =
      std::bind(&spi_tclService::vOnSensorData, this, SPI_FUNC_PLACEHOLDERS_1);
   srDataSvcSensorDataCb.fvOnAccSensorData =
      std::bind(&spi_tclService::vOnAccSensorData, this, SPI_FUNC_PLACEHOLDERS_1);
   srDataSvcSensorDataCb.fvOnGyroSensorData =
      std::bind(&spi_tclService::vOnGyroSensorData, this, SPI_FUNC_PLACEHOLDERS_1);
}

/*******************************************************************************
 * \FUNCTION   : tVoid spi_tclService::vOnServiceAvailable()
 *******************************************************************************/
tVoid spi_tclService::vOnServiceAvailable(tVoid)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnServiceAvailable() entered"));

   //!Add your code here

} //!end of vOnServiceAvailable()

/*******************************************************************************
 * \FUNCTION   : tVoid spi_tclService::vOnServiceUnavailable()
 *******************************************************************************/
tVoid spi_tclService::vOnServiceUnavailable(tVoid)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnServiceUnavailable() entered"));

   //!Add your code here

} //!end of vOnServiceUnavailable()

/*******************************************************************************
 * \FUNCTION   : tBool spi_tclService::bStatusMessageFactory(tU16 u16FunctionId...
 *******************************************************************************/
tBool spi_tclService::bStatusMessageFactory(tU16 u16FunctionId,
         amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg)
{
   (tVoid) poInMsg; // These lines are added to avoid LINT warnings. Please
   (tVoid) roOutMsg; // remove as soon as the variables are used.

   tBool bSuccess = TRUE; 

   ETG_TRACE_USR1(("[FUNC]spi_tclService::bStatusMessageFactory() entered with FunctionId = 0x%x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case MIDW_SMARTPHONEINTFI_C_U16_DEVICESTATUSINFO:
      {
         midw_smartphoneintfi_tclMsgDeviceStatusInfoStatus oDeviceStatusInfo = m_enDevStatusInfo;

         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with DEVICESTATUSINFO - " \
                  "u32DevHandle = %d enDevConnType = %d enDeviceStatus- %d",
                  m_enDevStatusInfo.DeviceHandle,
                  m_enDevStatusInfo.DeviceConnectionType.enType,
                  m_enDevStatusInfo.DeviceStatus.enType));
         //Hand over the message 
         bSuccess = fi_tclVisitorMessage(oDeviceStatusInfo,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_APPSTATUSINFO:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with APPSTATUSINFO - " \
                           "u32DevHandle = %d enDevConnType = %d enAppStatus- %d",
                           m_AppInfoStatus.DeviceHandle,
                           m_AppInfoStatus.DeviceConnectionType.enType,
                           m_AppInfoStatus.AppStatus.enType));
         bSuccess = fi_tclVisitorMessage(m_AppInfoStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);

      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_DAPSTATUSINFO:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with DAPSTATUSINFO - " \
                           "u32DevHandle = %d enDevConnType = %d enDAPStatus- %d",
                           m_enDAPStatusInfo.DeviceHandle,
                           m_enDAPStatusInfo.DeviceConnectionType.enType,
                           m_enDAPStatusInfo.DAPStatus.enType));
         bSuccess = fi_tclVisitorMessage(m_enDAPStatusInfo,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_NOTIFICATIONINFO:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with NOTIFICATIONINFO - " \
                           "u32DevHandle = %d AppHandle = %d",
                           m_NotificationInfo.DeviceHandle,
                           m_NotificationInfo.AppHandle));
         bSuccess = fi_tclVisitorMessage(m_NotificationInfo,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONMEDIAMETADATA:
      {
         m_AppMediaMetaDataLock.s16Lock();
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with APPLICATIONMEDIAMETADATA - " \
                           "u32DevHandle = %d MetaDataValid = %d",
                           m_AppMediaMetaData.DeviceHandle,
                           m_AppMediaMetaData.MetaDataValid));
         bSuccess = fi_tclVisitorMessage(m_AppMediaMetaData,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         m_AppMediaMetaDataLock.vUnlock();
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONPHONEDATA:
      {
         t_String szCarrierName;
         m_AppPhoneDataLock.s16Lock();
         GET_STRINGDATA_FROM_FI_STRINGOBJ(m_AppPhoneData.CarrierName, midw_fi_tclString::FI_EN_UTF8, szCarrierName);
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with APPLICATIONPHONEDATA - " \
                                    "u32DevHandle = %d PhoneDataValid = %d"
                                    "enSignalStrength- %d enRegistrationStatus- %d enAirPlaneModeStatus -%d enMute- %d CarrierName -%s",
                                    m_AppPhoneData.DeviceHandle,
                                    m_AppPhoneData.PhoneDataValid,
                                    m_AppPhoneData.SignalStrength.enType,
                                    m_AppPhoneData.RegistrationStatus.enType,
                                    m_AppPhoneData.AirPlaneModeStatus.enType,
                                    m_AppPhoneData.Mute.enType,
                                    szCarrierName.c_str()));
         ETG_TRACE_USR2(("DESC:bStatusMessageFactory with APPLICATIONPHONEDATA - " \
                         "Battery charge level = %d, Battery charging state = %d",
                         m_AppPhoneData.BatteryChargeLevel, ETG_ENUM(BATTERY_CHARGING_STATE, m_AppPhoneData.BatteryChargingState.enType)));
         bSuccess = fi_tclVisitorMessage(m_AppPhoneData,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         m_AppPhoneDataLock.vUnlock();
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_MEDIAPLAYBACKTIME:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with MEDIAPLAYBACKTIME - " \
                                    "u32DevHandle = %d TotalPlayTime = %d ElapsedPlayTime- %d",
                                    m_AppMediaPlayBacktime.DeviceHandle,
                                    m_AppMediaPlayBacktime.TotalPlayTime,
                                    m_AppMediaPlayBacktime.ElapsedPlayTime));
         bSuccess = fi_tclVisitorMessage(m_AppMediaPlayBacktime,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_DEVICEDISPLAYCONTEXT:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with DEVICEDISPLAYCONTEXT - " \
                                             "u32DevHandle = %d DisplayFlag = %d",
                                             m_DeviceDispCntxt.DeviceHandle,
                                             m_DeviceDispCntxt.DisplayFlag));
         bSuccess = fi_tclVisitorMessage(m_DeviceDispCntxt,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
/*   case MIDW_SMARTPHONEINTFI_C_U16_DATASERVICEINFO:
      {
         //Default implementation is provided to avoid Asserts.
         //@todo - revisit during Data service Implementation
         midw_smartphoneintfi_tclMsgDataServiceInfoStatus oDataServiceStatus;
         //Sending status update for Invalid device Id
         oDataServiceStatus.DeviceHandle = 0;
         oDataServiceStatus.DeviceCategory.enType = (midw_fi_tcl_e8_DeviceCategory::tenType)(e8DEV_TYPE_UNKNOWN);
         bSuccess = fi_tclVisitorMessage(oDataServiceStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
*/
   case MIDW_SMARTPHONEINTFI_C_U16_BLUETOOTHDEVICESTATUS:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with BLUETOOTHDEVICESTATUS - " \
                                                      "BluetoothDeviceHandle = %d ProjectionDeviceHandle = %d ConnectedProfiles- %d "
                                                      "enBTChangeInfo- %d SameDevice- %d CallActiveStatus- %d",
                                                      m_BTDeviceStatusMsg.BluetoothDeviceHandle,
                                                      m_BTDeviceStatusMsg.ProjectionDeviceHandle,
                                                      m_BTDeviceStatusMsg.ConnectedProfiles,
                                                      m_BTDeviceStatusMsg.BTChangeInfo.enType,
                                                      m_BTDeviceStatusMsg.SameDevice,
                                                      m_BTDeviceStatusMsg.CallActiveStatus));
         bSuccess = fi_tclVisitorMessage(m_BTDeviceStatusMsg,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         CLEAR_BTDEVSTATUS_MSG(m_BTDeviceStatusMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_DEVICEAUDIOCONTEXT:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with DEVICEAUDIOCONTEXT - " \
                                             "u32DevHandle = %d AudioFlag = %d enAudioContext- %d",
                                             m_DeviceAudioCntxt.DeviceHandle,
                                             m_DeviceAudioCntxt.AudioFlag,
                                             m_DeviceAudioCntxt.AudioContext.enType));
          bSuccess = fi_tclVisitorMessage(m_DeviceAudioCntxt,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_DIPOAPPSTATUSINFO:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with DIPOAPPSTATUSINFO - " \
                                                      "enAppStateSpeech = %d enAppStatePhone = %d enAppStateNavigation- %d",
                                                      m_DeviceAppState.AppStateSpeech.enType,
                                                      m_DeviceAppState.AppStatePhone.enType ,
                                                      m_DeviceAppState.AppStateNavigation.enType));
         bSuccess = fi_tclVisitorMessage(m_DeviceAppState,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_SESSIONSTATUSINFO:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with SESSIONSTATUSINFO - " \
                                                      "u32DevHandle = %d enDeviceCategory = %d enSessionStatus- %d enHandsetInteractionStatus- %d",
                                                      m_SessionStatus.DeviceHandle,
                                                      m_SessionStatus.DeviceCategory.enType ,
                                                      m_SessionStatus.SessionStatus.enType,
                                                      m_SessionStatus.HandsetInteractionStatus.enType));
         bSuccess = fi_tclVisitorMessage(m_SessionStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_MLSERVERKEYCAPABILITIES:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with MLSERVERKEYCAPABILITIES - " \
                                                               "u32DevHandle = %d NumXDeviceKeys = %d",
                                                               m_MLSrvKeyCapabilities.DeviceHandle,
                                                               m_MLSrvKeyCapabilities.NumXDeviceKeys));

         bSuccess = fi_tclVisitorMessage(m_MLSrvKeyCapabilities,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_PROJECTIONDEVICEAUTHORIZATION:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with PROJECTIONDEVICEAUTHORIZATION - " \
                                                                       "NumDevices- %d",
                                                                       m_DevAuthStatus.NumDevices));
         bSuccess = fi_tclVisitorMessage(m_DevAuthStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
     break;
   case MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONSTATUSINFO:
         {
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with NAVIGATIONSTATUSINFO - " \
                                                                                   "u32DevHandle = %d enDeviceCategory = %d enNavigationStatus- %d",
                                                                                   m_NavStatus.DeviceHandle,
                                                                                   m_NavStatus.DeviceCategory.enType,
                                                                                   m_NavStatus.NavigationStatus.enType));
            bSuccess = fi_tclVisitorMessage(m_NavStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         }
         break;
   case MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDATA:
         {
		    t_String szImage;
            GET_STRINGDATA_FROM_FI_STRINGOBJ(m_NavNextTurnStatus.Image, midw_fi_tclString::FI_EN_UTF8, szImage);
		    t_String szRoadName;
            GET_STRINGDATA_FROM_FI_STRINGOBJ(m_NavNextTurnStatus.RoadName, midw_fi_tclString::FI_EN_UTF8, szRoadName);
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with NAVIGATIONNEXTTURNDATA - " \
                                                                                     "u32DevHandle = %d enDeviceCategory = %d  "
                                                                                     "enTurnSide- %d enNextTurnEvent- %d  TurnAngle- %d TurnNumber- %d Image- %s",
                                                                                     m_NavNextTurnStatus.DeviceHandle,
                                                                                     m_NavNextTurnStatus.DeviceCategory.enType,

                                                                                     m_NavNextTurnStatus.TurnSide.enType,
                                                                                     m_NavNextTurnStatus.NextTurnEvent.enType,

                                                                                     m_NavNextTurnStatus.TurnAngle,
                                                                                     m_NavNextTurnStatus.TurnNumber,szImage.c_str()));
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with NAVIGATIONNEXTTURNDATA - " \
                                                                                     "u32DevHandle = %d enDeviceCategory = %d RoadName- %s ",                                                                                                                                                                          m_NavNextTurnStatus.DeviceHandle,
                                                                                     m_NavNextTurnStatus.DeviceCategory.enType,
                                                                                     szRoadName.c_str()));

            bSuccess = fi_tclVisitorMessage(m_NavNextTurnStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         }
         break;
   case MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDISTANCEDATA:
         {
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with NAVIGATIONNEXTTURNDISTANCEDATA - " \
                                                                                     "u32DevHandle = %d enDeviceCategory = %d DistanceInMeters- %d TimeInSec- %d",
                                                                                      m_NavNextTurnDistanceStatus.DeviceHandle,
                                                                                      m_NavNextTurnDistanceStatus.DeviceCategory.enType,
                                                                                      m_NavNextTurnDistanceStatus.DistanceInMeters,
                                                                                      m_NavNextTurnDistanceStatus.TimeInSec));
            bSuccess = fi_tclVisitorMessage(m_NavNextTurnDistanceStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         }
         break;
   case MIDW_SMARTPHONEINTFI_C_U16_AAPNOTIFICATIONEVENT:
         {
		    t_String szAAPNotificationId;
            GET_STRINGDATA_FROM_FI_STRINGOBJ(m_NotificationEventStatus.AAPNotificationId, midw_fi_tclString::FI_EN_UTF8, szAAPNotificationId);
		    t_String szNotificationText;
            GET_STRINGDATA_FROM_FI_STRINGOBJ(m_NotificationEventStatus.NotificationText, midw_fi_tclString::FI_EN_UTF8, szNotificationText);
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with AAPNOTIFICATIONEVENT - " \
                                                                                         "u32DevHandle = %d enDeviceCategory = %d AAPNotificationId- %s",
                                                                                         m_NotificationEventStatus.DeviceHandle,
                                                                                         m_NotificationEventStatus.DeviceCategory.enType,
                                                                                         szAAPNotificationId.c_str()));
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with AAPNOTIFICATIONEVENT - " \
                                                                                         " NotificationText- %s",
                                                                                         szNotificationText.c_str()));

            bSuccess = fi_tclVisitorMessage(m_NotificationEventStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         }
         break;
   case MIDW_SMARTPHONEINTFI_C_U16_TECHNOLOGYSELECTION:
         {
            ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with TECHNOLOGYSELECTION  u32DevHandle = %d enDeviceType = %d SelectedTechnology- %d",
                                                                                   m_TechSelectionStatus.DeviceHandle,
                                                                                   m_TechSelectionStatus.DeviceType.enType,
                                                                                   m_TechSelectionStatus.SelectedTechnology.enType));
            bSuccess = fi_tclVisitorMessage(m_TechSelectionStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         }
         break;
   case MIDW_SMARTPHONEINTFI_C_U16_DIAL:
      {
         bSuccess = fi_tclVisitorMessage(m_DialStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
     break;
   case MIDW_SMARTPHONEINTFI_C_U16_WIFICREDENTIALS:
      {
         t_String szWiFiSSID;
         GET_STRINGDATA_FROM_FI_STRINGOBJ(m_WifiCredentialsStatus.AccessoryWiFiAPCredentials.SSID, midw_fi_tclString::FI_EN_UTF8, szWiFiSSID);
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with WIFICREDENTIALS WiFi SSID = %s", szWiFiSSID.c_str()));
         bSuccess = fi_tclVisitorMessage(m_WifiCredentialsStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   
   case MIDW_SMARTPHONEINTFI_C_U16_DEVICELOCKSTATUS:
      {
         bSuccess = fi_tclVisitorMessage(m_DeviceLockStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_PROJECTEDVIDEOINFO:
      {
         bSuccess = fi_tclVisitorMessage(m_ProjVideoInfoStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         ETG_TRACE_USR1(("[DESC]:spi_tclService::bStatusMessageFactory MIDW_SMARTPHONEINTFI_C_U16_PROJECTEDVIDEOINFO UIHeight-%d, UIWidth = %d",
                  m_ProjVideoInfoStatus.ProjectedVideoAttributes.u16UIResolutionHeight, m_ProjVideoInfoStatus.ProjectedVideoAttributes.u16UIResolutionWidth));
      }
     break;
   case MIDW_SMARTPHONEINTFI_C_U16_TURNBYTURNINFO:
      {
         bSuccess = fi_tclVisitorMessage(m_rTurnByTurnInfo,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_RELATIVELYACTIVEMEDIAAPP:
      {
         ETG_TRACE_USR2(("[DESC]:bStatusMessageFactory with RELATIVELYACTIVEMEDIAAPP - " \
                           "MediaAppHandle = %d MediaAppCategory- %d",
                           m_enRelActiveMedAppStatus.MediaAppHandle,
                           m_enRelActiveMedAppStatus.MediaAppCategory.enType));
         bSuccess = fi_tclVisitorMessage(m_enRelActiveMedAppStatus,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
      break;
   case MIDW_SMARTPHONEINTFI_C_U16_AAUTOTURNBYTURNINFO:
      {
         bSuccess = fi_tclVisitorMessage(m_rAAutoTurnByTurnInfo, SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_MLTURNBYTURNINFO:
      {
         bSuccess = fi_tclVisitorMessage(m_rMLTurnByTurnInfo, SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_BDCLTURNBYTURNINFO:
      {
         bSuccess = fi_tclVisitorMessage(m_rBDCLTurnByTurnInfo, SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEUPDATE:
      {
         bSuccess = fi_tclVisitorMessage(m_rCarPlayRouteGuidanceUpdate,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEMANEUVERUPDATE:
      {
         bSuccess = fi_tclVisitorMessage(m_rCarplayRouteGuidanceManeuverUpdate,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
      }
   break;
   case MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONPHONECALLDATA:
      {
         m_AppPhoneCallDataLock.s16Lock();
         bSuccess = fi_tclVisitorMessage(m_AppPhoneCallData,SPI_SERVICE_FI_MAJOR_VERSION).bHandOver(&roOutMsg);
         m_AppPhoneCallDataLock.vUnlock();
      }
      break;
   default:
      {
         ETG_TRACE_ERR(("[ERR]:bStatusMessageFactory() entered with Invalid FunctionId."));
         bSuccess = FALSE;
      }
      break;

   } //!switch (u16FunctionId)

   if (FALSE == bSuccess)
   {
      ETG_TRACE_FATAL(("[ERR]:bStatusMessageFactory() entered and Creation of message with 'FunctionId = 0x%x' failed.", u16FunctionId));
      NORMAL_M_ASSERT_ALWAYS();
   }

   ETG_TRACE_USR1(("[FUNC]spi_tclService::bStatusMessageFactory() left with result: %u.", bSuccess));

   return bSuccess;

} /* end of bStatusMessageFactory()*/

/***************************************************************************
 ** FUNCTION:  tBool spi_tclService::bProcessSet(amt_tclServiceData* p...
 ***************************************************************************/
tBool spi_tclService::bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error)
{
   SPI_INTENTIONALLY_UNUSED(bPropertyChanged);
   SPI_INTENTIONALLY_UNUSED(u16Error);

   tU16 u16FunctionId = poMessage->u16GetFunctionID();
   ETG_TRACE_USR1(("[FUNC]spi_tclService::bProcessSet entered with FunctionID = 0x%4x ", u16FunctionId));

   tBool bMsgValid = FALSE;

   //! Call appropriate method in SPI to process the DevPrj Set message.
   switch (u16FunctionId)
   {
      case MIDW_SMARTPHONEINTFI_C_U16_PROJECTIONDEVICEAUTHORIZATION:
      {
         spi_tMsgSetDeviceAuth oXFiSetDevAuth(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
         bMsgValid = oXFiSetDevAuth.bIsValid();
         if ((true == bMsgValid) && (nullptr != m_poSpiCmdIntf))
         {
            ETG_TRACE_USR2(("[DESC] bProcessSet Received Projection Device Authorization Device Handle = %d, Authorization Status = %d ",
                  oXFiSetDevAuth.DeviceHandle, ETG_ENUM(AUTHORIZATION_STATUS, oXFiSetDevAuth.UserAuthorizationStatus.enType)));
            tenUserAuthorizationStatus enUserAuthStatus = static_cast<tenUserAuthorizationStatus>  (oXFiSetDevAuth.UserAuthorizationStatus.enType);
            trUserContext rUsrContext;
            CPY_TO_USRCNTXT(poMessage, rUsrContext);
            m_poSpiCmdIntf->vSetDeviceAuthorization(oXFiSetDevAuth.DeviceHandle, enUserAuthStatus, rUsrContext);

            //! Clearing the list to avoid duplicate update when HMI accepts the projection device authorization popup
            m_DevAuthStatus.NumDevices = 0;
            m_DevAuthStatus.DeviceAuthInfoList.clear();
         } //if (nullptr != m_poSpiCmdInterface)
      }
         break;
      case MIDW_SMARTPHONEINTFI_C_U16_AAPNOTIFICATIONEVENT:
      {
         spi_tMsgSetAAPNotifEvent oXFiSetAAPNotf(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
         bMsgValid = oXFiSetAAPNotf.bIsValid();
         if ((true == bMsgValid) && (nullptr != m_poSpiCmdIntf))
         {
            t_String szAAPNotifId;
            GET_STRINGDATA_FROM_FI_STRINGOBJ(oXFiSetAAPNotf.AAPNotificationId, midw_fi_tclString::FI_EN_UTF8, szAAPNotifId);
            ETG_TRACE_USR2(("[DESC] bProcessSet Received AAP NotificationId = %s",szAAPNotifId.c_str()));
            //Acknowledge the receipt of notification
            if (false == szAAPNotifId.empty())
            {
               trNotificationAckData rNotificationAckData;
           	   rNotificationAckData.u32DeviceHandle = m_NotificationEventStatus.DeviceHandle;
           	   rNotificationAckData.enDeviceCategory = static_cast<tenDeviceCategory>(m_NotificationEventStatus.DeviceCategory.enType);
           	   rNotificationAckData.szNotifId = szAAPNotifId;
               m_poSpiCmdIntf->vAckNotification(rNotificationAckData);
            }
         } //if (nullptr != m_poSpiCmdInterface)
      }
         break;
	case MIDW_SMARTPHONEINTFI_C_U16_MYSPINBLUETOOTHVOICERECINFO:
      {
         spi_tMsgmySPINBTVRResponse oMySPINVRResponse(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

         if (
            (TRUE == oMySPINVRResponse.bIsValid())
            &&
            (nullptr != m_poSpiCmdIntf)
            )
         {
            m_poSpiCmdIntf->vUpdateVoiceSessionState(
                           oMySPINVRResponse.DeviceHandle,
                           aVoiceSessionResponse[oMySPINVRResponse.BTVoiceRecReqResponse.enType]);
         }

      }
      break;
      case MIDW_SMARTPHONEINTFI_C_U16_TECHNOLOGYSELECTION:
      {
         spi_tMsgSetTechSelection oXFiSetTechSelection(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
         bMsgValid = oXFiSetTechSelection.bIsValid();
         if ((true == bMsgValid) && (nullptr != m_poSpiCmdIntf))
         {
        	 ETG_TRACE_USR2(("[DESC] bProcessSet Received Technology SelectionDevice Handle = %d, Selected Technology = %d ",
        			 oXFiSetTechSelection.DeviceHandle, ETG_ENUM(DEVICE_CATEGORY, oXFiSetTechSelection.SelectedTechnology.enType)));
        	 tenDeviceCategory enSelectedTechnology = static_cast<tenDeviceCategory>  (oXFiSetTechSelection.SelectedTechnology.enType);
        	 m_poSpiCmdIntf->vSetTechnologySelection(oXFiSetTechSelection.DeviceHandle, enSelectedTechnology);

        	 //! Setting the SelectedTechnology to avoid duplicate update when HMI sets the SelectedTechnology
        	 m_TechSelectionStatus.SelectedTechnology.enType =  oXFiSetTechSelection.SelectedTechnology.enType;

         } //if (nullptr != m_poSpiCmdInterface)
      }
         break;


      default:
         ETG_TRACE_ERR(("[ERR]:bProcessSet() entered with Invalid FunctionID: 0x%x ", u16FunctionId));
         break;
   } //switch (u16FunctionId)
   return bMsgValid;
}

/*******************************************************************************
 * \ FUNCTION   : tVoid spi_tclService::vProcessTimer(tU16 u16TimerId)
 *******************************************************************************/
tVoid spi_tclService::vProcessTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vProcessTimer entered with TimerID = 0x%x.", u16TimerId));

   //!   Add your code here

   ETG_TRACE_USR1(("[FUNC]spi_tclService::vProcessTimer() left"));

} //! end of vProcessTimer()

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMSGetDeviceInfoList(amt_tclServiceData* poMessage)
 *********************************************************************************************/
tVoid spi_tclService::vOnMSGetDeviceInfoList(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetDeviceInfoList() entered."));

   spi_tMsgGetDevInfoListMS oDevInfoListMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

   if (
      (TRUE == oDevInfoListMS.bIsValid())
      && 
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
      m_poSpiCmdIntf->vGetDeviceInfoList(rMsgContext.rUserContext);

   }//if(TRUE == oDevInfoListMS.bIsValid())
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMSGetDeviceInfo(amt_tclServiceData* poMessage)
 *********************************************************************************************/
tVoid spi_tclService::vOnMSGetDeviceList(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetDeviceList() entered."));

   spi_tMsgGetDevListMS oDevListMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

   if (
      (TRUE == oDevListMS.bIsValid())
      &&
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
      ETG_TRACE_USR2(("[FUNC]spi_tclService::vOnMSGetDeviceList:DeviceID:0x%x",oDevListMS.DeviceHandle));
      m_poSpiCmdIntf->vGetDeviceList(oDevListMS.DeviceHandle, rMsgContext.rUserContext);

   }//if(TRUE == oDevListMS.bIsValid())
}

/***************************************************************************
** FUNCTION:  tVoid spi_tclService::vPopulateDeviceInfoList()
***************************************************************************/
tVoid spi_tclService::vPopulateDeviceInfoList(std::vector<midw_fi_tcl_DeviceDetails> &rfrvecDeviceInfo,
                                                const std::vector<trDeviceInfo>& corfvecrDeviceInfoList)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPopulateDeviceInfoList() entered"));

   tU16 u16DeviceInfoListSize = static_cast <t_U16>(corfvecrDeviceInfoList.size());
   //Clear the vector contents, if any
   if (0 < rfrvecDeviceInfo.size())
   {
      rfrvecDeviceInfo.clear();
   }

   for (tU16 u16Index = 0; u16Index < u16DeviceInfoListSize; ++u16Index)
   {
      midw_fi_tcl_DeviceDetails oDevicedetails;

      oDevicedetails.u32DeviceHandle = corfvecrDeviceInfoList[u16Index].u32DeviceHandle;
      oDevicedetails.szDeviceName.bSet(corfvecrDeviceInfoList[u16Index].szDeviceName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oDevicedetails.enDeviceCategory.enType =
               (midw_fi_tcl_e8_DeviceCategory::tenType) (corfvecrDeviceInfoList[u16Index].enDeviceCategory);
      oDevicedetails.szDeviceModelName.bSet(corfvecrDeviceInfoList[u16Index].szDeviceModelName.c_str(),
               midw_fi_tclString::FI_EN_UTF8);
      oDevicedetails.szDeviceManufacturerName.bSet(corfvecrDeviceInfoList[u16Index].szDeviceManufacturerName.c_str(),
               midw_fi_tclString::FI_EN_UTF8);
      oDevicedetails.enDeviceConnectionStatus.enType =
               (midw_fi_tcl_e8_DeviceConnectionStatus::tenType) (corfvecrDeviceInfoList[u16Index].enDeviceConnectionStatus);
      oDevicedetails.enDeviceConnectionType.enType =
               (midw_fi_tcl_e8_DeviceConnectionType::tenType) (corfvecrDeviceInfoList[u16Index].enDeviceConnectionType);
      oDevicedetails.enDeviceUsageEnabled.enType = (midw_fi_tcl_e8_EnabledInfo::tenType) (corfvecrDeviceInfoList[u16Index].enDeviceUsageEnabled);
      oDevicedetails.bSelectedDevice = corfvecrDeviceInfoList[u16Index].bSelectedDevice;
      oDevicedetails.bDAPSupport = corfvecrDeviceInfoList[u16Index].bDAPSupport;
      oDevicedetails.szBTAddress.bSet(corfvecrDeviceInfoList[u16Index].szBTAddress.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oDevicedetails.rProjectionCapability.enDeviceType.enType =
               (midw_fi_tcl_e8_DeviceType::tenType) corfvecrDeviceInfoList[u16Index].rProjectionCapability.enDeviceType;

      ETG_TRACE_USR4(("[PARAM]::vPopulateDeviceInfoList: Device type for Device 0x%x is %d",  oDevicedetails.u32DeviceHandle,
               ETG_ENUM(DEVICE_TYPE, oDevicedetails.rProjectionCapability.enDeviceType.enType )));

      oDevicedetails.rProjectionCapability.enAndroidProjection.enType =
               (midw_fi_tcl_e8_SupportInfo::tenType)corfvecrDeviceInfoList[u16Index].rProjectionCapability.enAndroidAutoSupport;
      oDevicedetails.rProjectionCapability.enMirrorlinkProjection.enType =
               (midw_fi_tcl_e8_SupportInfo::tenType)corfvecrDeviceInfoList[u16Index].rProjectionCapability.enMirrorlinkSupport;
      oDevicedetails.rProjectionCapability.enCarplayProjection.enType =
               (midw_fi_tcl_e8_SupportInfo::tenType)corfvecrDeviceInfoList[u16Index].rProjectionCapability.enCarplaySupport;
      oDevicedetails.rProjectionCapability.enCarlifeProjection.enType =
               (midw_fi_tcl_e8_SupportInfo::tenType)corfvecrDeviceInfoList[u16Index].rProjectionCapability.enCarlifeSupport;
      oDevicedetails.rProjectionCapability.enUSBPortType.enType =
               (midw_fi_tcl_e8_USBPortType::tenType)corfvecrDeviceInfoList[u16Index].rProjectionCapability.enUSBPortType;

      oDevicedetails.rDeviceSelectionInfo.enDeviceSelectionState.enType =
               (midw_fi_tcl_e8_DeviceSelectionState::tenType)corfvecrDeviceInfoList[u16Index].rDeviceSelectionInfo.enDeviceSelectionState;
      oDevicedetails.rDeviceSelectionInfo.enDeviceSelectionErrorType.enType =
               (midw_fi_tcl_e8_DeviceSelectionErrorType::tenType)corfvecrDeviceInfoList[u16Index].rDeviceSelectionInfo.enDeviceSelectionErrorType;
      oDevicedetails.rDeviceSelectionInfo.enDeviceSelectionProgressState.enType =
               (midw_fi_tcl_e8_DeviceSelectionProgressState::tenType)corfvecrDeviceInfoList[u16Index].rDeviceSelectionInfo.enDeviceSelectionProgressState;

      oDevicedetails.u32VendorID = corfvecrDeviceInfoList[u16Index].u32VendorID;
      oDevicedetails.u32ProductID = corfvecrDeviceInfoList[u16Index].u32ProductID;
      //CRQ 430789: [A-IVI][G3G] - Interface to update USB port using system path information - Planned for Next release or as a Patch
      oDevicedetails.szSystemPath.bSet(corfvecrDeviceInfoList[u16Index].szSystemPath.c_str(), midw_fi_tclString::FI_EN_UTF8);
      ETG_TRACE_USR4(("[PARAM]::spi_tclService::vPopulateDeviceInfoList() - szSystemPath = %s", corfvecrDeviceInfoList[u16Index].szSystemPath.c_str()));

      //Major,Minor,Patch version parameters are strings in the smartphoneintegrationfi and tU32 valules in SPITypes
      //@todo - needs to be modified
      StringHandler oStrHndlr;
      std::string szTemp;
      oStrHndlr.vConvertIntToStr(corfvecrDeviceInfoList[u16Index].rVersionInfo.u32MajorVersion,szTemp,DECIMAL_STRING);
      oDevicedetails.rVersionInfo.szMajorVersion.bSet(szTemp.c_str(), midw_fi_tclString::FI_EN_UTF8);

      oStrHndlr.vConvertIntToStr(corfvecrDeviceInfoList[u16Index].rVersionInfo.u32MinorVersion,szTemp,DECIMAL_STRING);
      oDevicedetails.rVersionInfo.szMinorVersion.bSet(szTemp.c_str(), midw_fi_tclString::FI_EN_UTF8);

      oStrHndlr.vConvertIntToStr(corfvecrDeviceInfoList[u16Index].rVersionInfo.u32PatchVersion,szTemp,DECIMAL_STRING);
      oDevicedetails.rVersionInfo.szPatchVersion.bSet(szTemp.c_str(), midw_fi_tclString::FI_EN_UTF8);

      oDevicedetails.szSerialNumber.bSet(corfvecrDeviceInfoList[u16Index].szSerialNumber.c_str(),
               midw_fi_tclString::FI_EN_UTF8);
      //oDevicedetails.rServerCapabilities is not handled currently
      oDevicedetails.enUserAuthorizationStatus.enType =
               (midw_fi_tcl_e8_UserAuthorizationStatus::tenType)corfvecrDeviceInfoList[u16Index].enUserAuthorizationStatus;

      oDevicedetails.enSessionTransportType.enType =
               (midw_fi_tcl_e8_SessionTransportType::tenType)corfvecrDeviceInfoList[u16Index].enSessionTransport;


      //Push the structure to the container
      rfrvecDeviceInfo.push_back(oDevicedetails);

   }//for( tU8 u8Index = 0; u8Index < u16DeviceInfoListSize; ++u8Index)
}

/********************************************************************************************
 * \FUNCTION   :tVoid vOnMSSelectDevice(amt_tclServiceData* poMessage)
 *********************************************************************************************/
tVoid spi_tclService::vOnMSSelectDevice(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSelectDevice() entered."));
   spi_tMsgSelectDeviceMS oSelectDeviceMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

   if ((TRUE == oSelectDeviceMS.bIsValid()) && (nullptr != m_poSpiCmdIntf))
   {
      ETG_TRACE_USR4(("[FUNC]spi_tclService::vOnMSSelectDevice() Selection Type = %d, Connection Req = %d",
               oSelectDeviceMS.SelectionType.enType, oSelectDeviceMS.DeviceConnectionReq.enType));
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      tenSelectReason enSelectReason=(midw_fi_tcl_e8_SelectionType::FI_EN_SELECTION_TYPE_USER_TRIGGERED == oSelectDeviceMS.SelectionType.enType)?e8_REASON_USER_TRIGGER:e8_REASON_HMI_TRIGGER;

      m_poSpiCmdIntf->vSelectDevice(oSelectDeviceMS.DeviceHandle,
               static_cast<tenDeviceConnectionType> (oSelectDeviceMS.DeviceConnectionType.enType),
               static_cast<tenDeviceConnectionReq> (oSelectDeviceMS.DeviceConnectionReq.enType),
               static_cast<tenEnabledInfo> (oSelectDeviceMS.DAPUsage.enType),
               static_cast<tenEnabledInfo> (oSelectDeviceMS.CDBUsage.enType),
               static_cast<tenDeviceCategory> (oSelectDeviceMS.DeviceCategory.enType),
               rMsgContext.rUserContext,
               enSelectReason);

   }//if(TRUE == oSelectDeviceMS.bIsValid())
}

/********************************************************************************************
 * \FUNCTION   :tVoid vOnMSLaunchApp(amt_tclServiceData* poMessage)
 *********************************************************************************************/
tVoid spi_tclService::vOnMSLaunchApp(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSLaunchApp() entered."));
  spi_tMsgLaunchAppMS oLaunchAppMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
  if (
     (TRUE == oLaunchAppMS.bIsValid())
     && 
     (nullptr != m_poSpiCmdIntf)
     )
  {
     trUserContext rUsrContext;
     CPY_TO_USRCNTXT(poMessage, rUsrContext);

	 ETG_TRACE_USR2(("[FUNC]spi_tclService::vOnMSLaunchApp:DeviceID:0x%x,DevCat:%d,AppHandle:0x%x",
	 oLaunchAppMS.DeviceHandle,oLaunchAppMS.DeviceCategory.enType,oLaunchAppMS.AppHandle));
	 
     m_poSpiCmdIntf->vLaunchApp(oLaunchAppMS.DeviceHandle,
        (tenDeviceCategory)(oLaunchAppMS.DeviceCategory.enType),
        oLaunchAppMS.AppHandle,
        (tenDiPOAppType)(oLaunchAppMS.DiPOAppType.enType),
        (t_String)(oLaunchAppMS.TelephoneNumber.szValue),
        (tenEcnrSetting)(oLaunchAppMS.EcnrSetting.enType),
        rUsrContext);
  }//if(TRUE == oLaunchAppMS.bIsValid())
}

/********************************************************************************************
 * \FUNCTION   :tVoid vOnMSTerminateApp(amt_tclServiceData* poMessage)
 *********************************************************************************************/
tVoid spi_tclService::vOnMSTerminateApp(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSTerminateApp() entered."));

   spi_tMsgTerminateAppMS oTerminateAppMS(*poMessage,
            SPI_SERVICE_FI_MAJOR_VERSION);
   if (
      (TRUE == oTerminateAppMS.bIsValid())
      && 
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trUserContext rUsrContext;
      CPY_TO_USRCNTXT(poMessage, rUsrContext);

      m_poSpiCmdIntf->vTerminateApp(oTerminateAppMS.DeviceHandle,
               oTerminateAppMS.AppHandle,
               rUsrContext);
   }//if(TRUE == oTerminateAppMS.bIsValid())
}

/********************************************************************************************
 * \FUNCTION   :tVoid vOnMSGetAppList(amt_tclServiceData* poMessage)
 *********************************************************************************************/
tVoid spi_tclService::vOnMSGetAppList(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetAppList() entered."));

   spi_tMsgGetAppListMS oGetAppListMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

   if (
      (TRUE == oGetAppListMS.bIsValid())
      && 
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      tU32 u32NumApps = 0;
      std::vector<trAppDetails> vecrAppDetailsList;

      m_poSpiCmdIntf->vGetAppList((t_U32)oGetAppListMS.DeviceHandle, (t_U32&)u32NumApps, vecrAppDetailsList);

      midw_smartphoneintfi_tclMsgGetAppListMethodResult oMRGetAppList;

      oMRGetAppList.DeviceHandle = oGetAppListMS.DeviceHandle;
      oMRGetAppList.NumAppDetailsList = static_cast <t_U16>(u32NumApps);

      //@todo - find work around to avoid std usage
      std::vector<midw_fi_tcl_AppDetails> rvecAppDetailsList;
      vPopulateAppInfoList(oGetAppListMS.DeviceHandle,rvecAppDetailsList,vecrAppDetailsList);
      oMRGetAppList.AppDetailsList = rvecAppDetailsList;

      ETG_TRACE_USR1(("vOnMSGetAppList received Device Handle = 0x%x supports %d UI Apps",
         oMRGetAppList.DeviceHandle,oMRGetAppList.NumAppDetailsList));

      for(tU16 u16Index=0; u16Index < oMRGetAppList.AppDetailsList.size() ; ++u16Index)
      {
         ETG_TRACE_USR1(("vOnMSGetAppList received AppID= 0x%x ,Category=0x%x , Status=%d , AppCertStatus=%d ,AppName = %s"
            ,oMRGetAppList.AppDetailsList[u16Index].u32AppHandle
            ,oMRGetAppList.AppDetailsList[u16Index].enAppCategory.enType
            ,ETG_ENUM(APP_STATUS,oMRGetAppList.AppDetailsList[u16Index].enAppStatus.enType)
            ,ETG_ENUM(APP_CERTIFICATION_STATUS,oMRGetAppList.AppDetailsList[u16Index].e8AppCertificationInfo.enType)
            ,oMRGetAppList.AppDetailsList[u16Index].szAppName.szValue));
      }//for(tU16 u16Index=0; u16Index < oMRGetAppLis...

      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRGetAppList,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vOnMSGetAppList() left with Error in posting Message"));
      } //if( FALSE == oPostMsg.bSendMessage

      //! De-allocate memory used by message
      oMRGetAppList.vDestroy();

   }//if(TRUE == oGetAppListMS.bIsValid())
}


/***************************************************************************
** FUNCTION:  tVoid spi_tclService::vPopulateAppInfoList()
***************************************************************************/
tVoid spi_tclService::vPopulateAppInfoList(tU32 u32DevId,
                                             std::vector<midw_fi_tcl_AppDetails>& rfvecAppDetailsList,
                                             std::vector<trAppDetails> vecrAppDetailsList) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPopulateAppInfoList() entered with Device Id = 0x%x",u32DevId));

   //Clear the vector contents, if any
   rfvecAppDetailsList.clear();

   for( tU16 u16Index = 0 ; u16Index < vecrAppDetailsList.size() ; ++u16Index )
   {
      midw_fi_tcl_AppDetails oAppDetails;

      //Application basic details.
      oAppDetails.u32AppHandle = vecrAppDetailsList[u16Index].u32AppHandle;
      oAppDetails.szAppName.bSet(vecrAppDetailsList[u16Index].szAppName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.szAppVariant.bSet(vecrAppDetailsList[u16Index].szAppVariant.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.szAppProviderName.bSet(vecrAppDetailsList[u16Index].szAppProviderName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.szAppProviderURL.bSet(vecrAppDetailsList[u16Index].szAppProviderURL.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.szAppDescription.bSet(vecrAppDetailsList[u16Index].szAppDescription.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.szAppCertificateURL.bSet(vecrAppDetailsList[u16Index].szAppCertificateURL.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.enAppCategory.enType = (midw_fi_tcl_e32_AppCategory::tenType)(vecrAppDetailsList[u16Index].enAppCategory);
      oAppDetails.enTrustLevel.enType = (midw_fi_tcl_e16_TrustLevel::tenType)(vecrAppDetailsList[u16Index].enTrustLevel);
      oAppDetails.enAppStatus.enType = (midw_fi_tcl_e8_AppStatus::tenType)(vecrAppDetailsList[u16Index].enAppStatus);

      //Copy App Display Info
      oAppDetails.rAppDisplayInfo.enAppDisplayCategory.enType = 
         (midw_fi_tcl_e32_AppDisplayCategory::tenType)(vecrAppDetailsList[u16Index].rAppDisplayInfo.enAppDisplayCategory);
      oAppDetails.rAppDisplayInfo.enTrustLevel.enType = 
         (midw_fi_tcl_e16_TrustLevel::tenType)(vecrAppDetailsList[u16Index].rAppDisplayInfo.enTrustLevel);
      oAppDetails.rAppDisplayInfo.u32AppDisplayRules = vecrAppDetailsList[u16Index].rAppDisplayInfo.u32AppDisplayRules;
      oAppDetails.rAppDisplayInfo.szAppDisplayOrientation.bSet(
         vecrAppDetailsList[u16Index].rAppDisplayInfo.szAppDisplayOrientation.c_str(), midw_fi_tclString::FI_EN_UTF8);


      //copy App Audio Info
      oAppDetails.rAppAudioInfo.szAppAudioType.bSet(
         vecrAppDetailsList[u16Index].rAppAudioInfo.szAppAudioType.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.rAppAudioInfo.enAppAudioCategory.enType = 
         (midw_fi_tcl_e32_AppAudioCategory::tenType)(vecrAppDetailsList[u16Index].rAppAudioInfo.enAppAudioCategory);
      oAppDetails.rAppAudioInfo.enTrustLevel.enType = 
         (midw_fi_tcl_e16_TrustLevel::tenType)(vecrAppDetailsList[u16Index].rAppAudioInfo.enTrustLevel);
      oAppDetails.rAppAudioInfo.u32AppAudioRules = vecrAppDetailsList[u16Index].rAppAudioInfo.u32AppAudioRules;

      //copy App Remoting Info
      oAppDetails.rAppRemotingInfo.szRemotingProtocolID.bSet(
         vecrAppDetailsList[u16Index].rAppRemotingInfo.szRemotingProtocolID.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.rAppRemotingInfo.szRemotingFormat.bSet(
         vecrAppDetailsList[u16Index].rAppRemotingInfo.szRemotingFormat.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.rAppRemotingInfo.szRemotingDirection.bSet(
         vecrAppDetailsList[u16Index].rAppRemotingInfo.szRemotingDirection.c_str(), midw_fi_tclString::FI_EN_UTF8);
      oAppDetails.rAppRemotingInfo.u32RemotingAudioIPL = vecrAppDetailsList[u16Index].rAppRemotingInfo.u32RemotingAudioIPL;
      oAppDetails.rAppRemotingInfo.u32RemotingAudioMPL = vecrAppDetailsList[u16Index].rAppRemotingInfo.u32RemotingAudioMPL;

      //copy Application certification type - Drive or Park certified
      oAppDetails.e8AppCertificationInfo.enType = 
         (midw_fi_tcl_e8_AppCertificationInfo::tenType)(vecrAppDetailsList[u16Index].enAppCertificationInfo);

      //copy App certification entity - CCC or CCC-Member
      oAppDetails.e8AppCertificationEntity.enType = 
         (midw_fi_tcl_e8_AppCertificationEntity::tenType)(vecrAppDetailsList[u16Index].enAppCertificationEntity);

      //copy Icons supported by the Application
      oAppDetails.u16NumAppIcons = static_cast <t_U16>(vecrAppDetailsList[u16Index].u32NumAppIcons);
      for(tU8 u8Index=0;u8Index<vecrAppDetailsList[u16Index].tvecAppIconList.size();++u8Index)
      {
         midw_fi_tcl_IconAttributes oIconAttr;
         oIconAttr.u32IconWidth = vecrAppDetailsList[u16Index].tvecAppIconList[u8Index].u32IconWidth;
         oIconAttr.u32IconHeight = vecrAppDetailsList[u16Index].tvecAppIconList[u8Index].u32IconHeight;
         oIconAttr.u32IconDepth = vecrAppDetailsList[u16Index].tvecAppIconList[u8Index].u32IconDepth;
         oIconAttr.enIconMimeType.enType = 
         (midw_fi_tcl_e8_IconMimeType::tenType)(vecrAppDetailsList[u16Index].tvecAppIconList[u8Index].enIconMimeType);
         oIconAttr.szIconURL.bSet(
            vecrAppDetailsList[u16Index].tvecAppIconList[u8Index].szIconURL.c_str(), midw_fi_tclString::FI_EN_UTF8);

         oAppDetails.AppIconList.push_back(oIconAttr);
      }//for(tU8 u8Index=0;u8Index<vecrAppDetailsList[u16Index].tvecAppI

      rfvecAppDetailsList.push_back(oAppDetails);
   }//for( tU16 u16Index = 0 ; u16Index <
   
   
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSGetAppIconData()
***************************************************************************/
t_Void spi_tclService::vOnMSGetAppIconData(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetAppIconData"));

   spi_tMsgGetAppIconDataMS oGetAppIconData(*poMessage,
      SPI_SERVICE_FI_MAJOR_VERSION);

   if (
      (TRUE == oGetAppIconData.bIsValid())
      && 
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trUserContext rUsrContext;
      CPY_TO_USRCNTXT(poMessage, rUsrContext);

      t_String szIconUrl;
      szIconUrl.assign(oGetAppIconData.AppIconURL.szValue);

      m_poSpiCmdIntf->vGetAppIconData(szIconUrl,rUsrContext);

   }//if(TRUE == oGetAppIconData.bIsValid())
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetAppIconAttr()
***************************************************************************/
t_Void spi_tclService::vOnMSSetAppIconAttr(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetAppIconAttr() entered"));
   spi_tMsgSetAppIconAttrMS oSetAppIconAttr(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   if( (TRUE == oSetAppIconAttr.bIsValid())&&(nullptr != m_poSpiCmdIntf))
   {
      trUserContext rUsrContext;
      CPY_TO_USRCNTXT(poMessage, rUsrContext);

      trIconAttributes rIconAttr;
      rIconAttr.u32IconWidth = oSetAppIconAttr.IconAttributes.u32IconWidth;
      rIconAttr.u32IconHeight = oSetAppIconAttr.IconAttributes.u32IconHeight ;
      rIconAttr.u32IconDepth = oSetAppIconAttr.IconAttributes.u32IconDepth;
      rIconAttr.enIconMimeType = static_cast<tenIconMimeType>(oSetAppIconAttr.IconAttributes.enIconMimeType.enType);
      if(nullptr != oSetAppIconAttr.IconAttributes.szIconURL.szValue)
      {
         rIconAttr.szIconURL.assign(oSetAppIconAttr.IconAttributes.szIconURL.szValue);
      }//if(nullptr != oSetAppIconAttr.IconAttributes.szIconURL.szValue)

      m_poSpiCmdIntf->vSetAppIconAttributes(oSetAppIconAttr.DeviceHandle,
         oSetAppIconAttr.AppHandle,rIconAttr,rUsrContext);
      ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetAppIconAttr() left"));
   }//if(TRUE == oSetAppiconAttr.bIsValid())
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetVehicleConfig()
***************************************************************************/
t_Void spi_tclService::vOnMSSetVehicleConfig(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetVehicleConfig() entered"));
   spi_tMsgSetVehicleConfigMS oSetVehicleConfig(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   if( (TRUE == oSetVehicleConfig.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      tenVehicleConfiguration enVehicleConfig = 
         static_cast<tenVehicleConfiguration>(oSetVehicleConfig.VehicleConfiguration.enType) ;
      m_poSpiCmdIntf->vSetVehicleConfig(enVehicleConfig,(t_Bool)oSetVehicleConfig.SetConfiguration,rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetVehicleConfigurationMethodResult oSetVehicleConfigMR;
      oSetVehicleConfigMR.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oSetVehicleConfigMR.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oSetVehicleConfigMR,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetVehicleConfig() left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oSetVehicleConfig.bIsValid())&
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetVehicleMovementState()
***************************************************************************/
t_Void spi_tclService::vOnMSSetVehicleMovementState(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetVehicleMovementState () entered"));
   spi_tMsgSetVehicleMovementMS oSetVehicleMovementState(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   if ((TRUE == oSetVehicleMovementState.bIsValid()) && (nullptr != m_poSpiCmdIntf))
   {
      //! Extract park brake, vehicle state and gear info
      t_Bool bParkBrakeActive = (PARKBRAKESTATE_ENGAGED == oSetVehicleMovementState.ParkBrakeInfo.enType);
      tenVehicleMovementState enVehMovState = (VEHICLESTATE_PARK_MODE == oSetVehicleMovementState.VehicleState.enType)?
         (e8VEHICLE_MOVEMENT_STATE_PARKED) : (e8VEHICLE_MOVEMENT_STATE_FORWARD) ;
      tenGearPosition enGearPosition = static_cast<tenGearPosition>(oSetVehicleMovementState.GearInfo.enType);

      ETG_TRACE_USR2(("[DESC]::vOnMSSetVehicleMovementState received "
            "Park brake = %d, Vehicle State = %d, Gear = %d ", ETG_ENUM(BOOL, bParkBrakeActive),
            ETG_ENUM(VEH_MOV_STATE, enVehMovState), ETG_ENUM(GEARPOSITION, enGearPosition)));

      //! Update the Park/Drive mode if Park brake or Vehicle state has changed.
      if ((bParkBrakeActive != m_rVehicleData.bParkBrakeActive) ||
            (enVehMovState != m_rVehicleData.enVehMovState))
      {
         vEvaluateDriveMode(bParkBrakeActive, enVehMovState);
      }//if ((bParkBrakeActive != m_rVehicleData.bParkBrakeActive)||...)

      //! Store received data
      m_rVehicleData.bParkBrakeActive = bParkBrakeActive;
      m_rVehicleData.enVehMovState = enVehMovState;
      m_rVehicleData.enGearPosition = enGearPosition;

      //! Set Vehicle data
      m_poSpiCmdIntf->vOnVehicleData(m_rVehicleData, false);

      //! Send SetVehicleMovementState result to HMI
      trMsgContext rMsgCntxt;
      CPY_TO_USRCNTXT(poMessage, rMsgCntxt.rUserContext);
      midw_smartphoneintfi_tclMsgSetVehicleMovementStateMethodResult oMRInvokeVehicleMovementActionReq;
      oMRInvokeVehicleMovementActionReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRInvokeVehicleMovementActionReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRInvokeVehicleMovementActionReq, rMsgCntxt, SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetVehicleMovementState() left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage)
   }//if((TRUE == oSetVehicleMovementState.bIsValid())&&...)
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetVehicleManufacturerInformation()
***************************************************************************/
t_Void spi_tclService::vOnMSSetVehicleManufacturerInformation(amt_tclServiceData* poMessage)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetVehicleManufacturerInformation () entered"));
	spi_tMsgSetVehicleManufacturerInformationMS oSetVehicleManufacturerInformation(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

	if ((TRUE == oSetVehicleManufacturerInformation.bIsValid()) && (nullptr != m_poSpiCmdIntf))
	{
		trMsgContext rMsgContext;
		CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
		trVehicleManufacturerInformation rVehicleManufacturerInformation;

		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleMake,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleMake);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleModel,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleModel);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleModelYear,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleModelYear);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleHUSwVersion,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleHUSwVersion);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleHUHwVersion,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleHUHwVersion);

		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleHUSwBuild,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleHUSwBuild);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleHUMake,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleHUMake);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.VehicleHUModel,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.szVehicleHUModel);


		rVehicleManufacturerInformation.enDriverSideInfo = (LEFT_HAND_DRIVE == oSetVehicleManufacturerInformation.DriverSideInfo.enType)? e8LEFT_HAND_DRIVE : e8RIGHT_HAND_DRIVE;
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.OEMICONDetails.OEMIconName,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.rOEMIconDetails.szOEMName);
		GET_STRINGDATA_FROM_FI_STRINGOBJ(oSetVehicleManufacturerInformation.OEMICONDetails.OEMIconpath,midw_fi_tclString::FI_EN_UTF8,rVehicleManufacturerInformation.rOEMIconDetails.szOEMPath);
		rVehicleManufacturerInformation.bIsNativeNavSupported = oSetVehicleManufacturerInformation.isNativeNavSupported;
		rVehicleManufacturerInformation.bIsRotaryCtrlSupported = oSetVehicleManufacturerInformation.isRotaryCtrlSupported;
		rVehicleManufacturerInformation.u16SupportedSPITechnologiesInfo = oSetVehicleManufacturerInformation.SupportedSPITechnologiesInfo;
		rVehicleManufacturerInformation.enFidelity = (HIGH_FIDELITY == oSetVehicleManufacturerInformation.FidelityType.enType) ? e8HIGH_FIDELITY : e8LOW_FIDELITY ;

		ETG_TRACE_USR4(("Data Coming from HMI"));

		ETG_TRACE_USR4(("Vehicle Make = %s",rVehicleManufacturerInformation.szVehicleMake.c_str()));
		ETG_TRACE_USR4(("Vehicle Model = %s",rVehicleManufacturerInformation.szVehicleModel.c_str()));
		ETG_TRACE_USR4(("Vehicle Model Year = %s",rVehicleManufacturerInformation.szVehicleModelYear.c_str()));
		ETG_TRACE_USR4(("Vehicle HU Software Version = %s",rVehicleManufacturerInformation.szVehicleHUSwVersion.c_str()));
		ETG_TRACE_USR4(("Vehicle HU Hardware Version = %s",rVehicleManufacturerInformation.szVehicleHUHwVersion.c_str()));
		ETG_TRACE_USR4(("Vehicle HU Make = %s",rVehicleManufacturerInformation.szVehicleHUMake.c_str()));
		ETG_TRACE_USR4(("Vehicle HU Model = %s",rVehicleManufacturerInformation.szVehicleHUModel.c_str()));
		ETG_TRACE_USR4(("Vehicle HU Software Build = %s",rVehicleManufacturerInformation.szVehicleHUSwBuild.c_str()));
		ETG_TRACE_USR4(("DriverSide Information = %u",ETG_ENUM(DRIVER_SIDE_INFO,rVehicleManufacturerInformation.enDriverSideInfo)));
		ETG_TRACE_USR4(("Vehicle SupportedSPITechnologies Information  = %d",rVehicleManufacturerInformation.u16SupportedSPITechnologiesInfo));
		ETG_TRACE_USR4(("Native Navigation Supported= %d ",ETG_ENUM(BOOL, rVehicleManufacturerInformation.bIsNativeNavSupported)));
		ETG_TRACE_USR4(("Roatry Control Supported = %d ",ETG_ENUM(BOOL, rVehicleManufacturerInformation.bIsRotaryCtrlSupported)));
		ETG_TRACE_USR4(("Vehicle OEM Name is = %s",rVehicleManufacturerInformation.rOEMIconDetails.szOEMName.c_str()));
		ETG_TRACE_USR4(("Vehicle OEM Path is = %s",rVehicleManufacturerInformation.rOEMIconDetails.szOEMPath.c_str()));
		ETG_TRACE_USR4(("Fidelity  type = %u",ETG_ENUM(FIDELITY_TYPE,rVehicleManufacturerInformation.enFidelity)));

		m_poSpiCmdIntf->vSetVehicleManufacturerInformation(rVehicleManufacturerInformation);

		midw_smartphoneintfi_tclMsgSetVehicleManufacturerInformationMethodResult oMRSetVehicleManufacturerInformation;
		oMRSetVehicleManufacturerInformation.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
		oMRSetVehicleManufacturerInformation.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

		//post Method result to HMI
		FIMsgDispatch oPostMsg(_poMainAppl);
		if( FALSE == oPostMsg.bSendResMessage(oMRSetVehicleManufacturerInformation,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
		{
			ETG_TRACE_ERR(("[ERR]:vOnMSSetVehicleManufacturerInformations:Error in posting Method Result"));
		} //if( FALSE == oPostMsg.bSendMessage
	}
	else
	{
		ETG_TRACE_ERR(("spi_tclService::vOnMSSetVehicleManufacturerInformation- Invalid Update"));
	}
}
/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSVehicleMechanicalSpeed()
***************************************************************************/
t_Void spi_tclService::vOnMSVehicleMechanicalSpeed(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSVehicleMechanicalSpeed() Entered"));
   spi_tMsgVehicleMechanicalSpeedMS oSetVehicleMechanicalSpeed(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   if( (TRUE == oSetVehicleMechanicalSpeed.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      ETG_TRACE_USR2(("[DESC]: vOnMSVehicleMechanicalSpeed received value of Mechanical Speed = %d ", oSetVehicleMechanicalSpeed.VehicleSpeed));

      // Extracting the speed information
      m_rVehicleData.s16Speed = static_cast<t_S16>(oSetVehicleMechanicalSpeed.VehicleSpeed);
      m_rVehicleData.bSpeedAvailable = true;

      m_poSpiCmdIntf->vOnVehicleData(m_rVehicleData,false);

      trMsgContext rMsgCntxt;
      CPY_TO_USRCNTXT(poMessage, rMsgCntxt.rUserContext);

      midw_smartphoneintfi_tclMsgVehicleMechanicalSpeedMethodResult oMRInvokeVehicleMechanicalSpeedActionReq;
      oMRInvokeVehicleMechanicalSpeedActionReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRInvokeVehicleMechanicalSpeedActionReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRInvokeVehicleMechanicalSpeedActionReq, rMsgCntxt, SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSVehicleMechanicalSpeed() left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage)
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetVideoBlockingMode()
***************************************************************************/
t_Void spi_tclService::vOnMSSetVideoBlockingMode(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetVideoBlockingMode () entered"));
   spi_tMsgSetVideoBlockingModeMS oSetVideoBlockingMode(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetVideoBlockingMode.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      m_poSpiCmdIntf->vSetVideoBlockingMode(oSetVideoBlockingMode.DeviceHandle,
         static_cast<tenBlockingMode>(oSetVideoBlockingMode.BlockingMode.enType),
         static_cast<tenVideoBlockingReason>(oSetVideoBlockingMode.VideoBlockingReason.enType),rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult oSetVideoBlockingMR;
      oSetVideoBlockingMR.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oSetVideoBlockingMR.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oSetVideoBlockingMR,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetVehicleConfig() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage


   }//if( (TRUE == oSetVideoBlockingMode.bIsValid())&
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetAudioBlockingMode()
***************************************************************************/
t_Void spi_tclService::vOnMSSetAudioBlockingMode(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetAudioBlockingMode() entered"));
   spi_tMsgSetAudioBlockingModeMS oSetAudioBlockingMode(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   if( (TRUE == oSetAudioBlockingMode.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
	  trUserContext rUsrCntxt;
	  CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      m_poSpiCmdIntf->vSetAudioBlockingMode(oSetAudioBlockingMode.GlobalMuteEnable,
    		  oSetAudioBlockingMode.MediaAudioBlockingEnable,rUsrCntxt);

      trMsgContext rMsgCntxt;
      CPY_TO_USRCNTXT(poMessage, rMsgCntxt.rUserContext);

      //@todo - response to come from response interface
      midw_smartphoneintfi_tclMsgSetAudioBlockingModeMethodResult oMRSetAudioBlocking;
      oMRSetAudioBlocking.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS);
      oMRSetAudioBlocking.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR);

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetAudioBlocking,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetAudioBlockingMode() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oMRSetAudioBlocking.bIsValid())&
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetOrientationMode()
***************************************************************************/
t_Void spi_tclService::vOnMSSetOrientationMode(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetOrientationMode() entered"));

   spi_tMsgSetOrientationModeMS oSetOrientationMode(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   if( (TRUE == oSetOrientationMode.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      m_poSpiCmdIntf->vSetOrientationMode(oSetOrientationMode.DeviceHandle,
         static_cast<tenOrientationMode>(oSetOrientationMode.OrientationMode.enType),rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult oMRSetOrientationMode;
      oMRSetOrientationMode.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetOrientationMode.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetOrientationMode,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("ERR]:vOnMSSetOrientationMode() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oSetOrientationMode.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetScreenSize()
***************************************************************************/
t_Void spi_tclService::vOnMSSetScreenSize(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetScreenSize() entered"));
   
   spi_tMsgSetScreenSizeMS oSetScreenSize(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetScreenSize.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      trScreenAttributes rScreenAttributes;
      rScreenAttributes.u32ScreenHeight = oSetScreenSize.ScreenAttributes.u16ScreenHeight;
      rScreenAttributes.u32ScreenWidth = oSetScreenSize.ScreenAttributes.u16ScreenWidth;
      rScreenAttributes.enScreenAspectRatio = 
         static_cast<tenScreenAspectRatio>(oSetScreenSize.ScreenAttributes.enScreenAspectRatio.enType);

      m_poSpiCmdIntf->vSetScreenSize(rScreenAttributes,rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetScreenSizeMethodResult oMRSetScreenSizeReq;
      oMRSetScreenSizeReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetScreenSizeReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetScreenSizeReq,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetScreenSize() Left With Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oSetScreenSize.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSGetVideoSettings()
***************************************************************************/
t_Void spi_tclService::vOnMSGetVideoSettings(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetVideoSettings() entered"));
   spi_tMsgGetVideoSettingsMS oGetVideoSettings(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oGetVideoSettings.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trMsgContext rMsgCntxt;
      CPY_TO_USRCNTXT(poMessage, rMsgCntxt.rUserContext);

      trVideoAttributes rVideoAttr;
      m_poSpiCmdIntf->vGetVideoSettings(oGetVideoSettings.DeviceHandle,rVideoAttr);

      midw_smartphoneintfi_tclMsgGetVideoSettingsMethodResult oMRGetVideoSettings;
      oMRGetVideoSettings.DeviceHandle = oGetVideoSettings.DeviceHandle;
      oMRGetVideoSettings.VideoAttributes.enOrientationMode.enType = 
         static_cast<midw_fi_tcl_e8_OrientationMode::tenType>(rVideoAttr.enOrientationMode);
      oMRGetVideoSettings.VideoAttributes.rScreenAttributes.u16ScreenHeight = (tU16)(rVideoAttr.rScreenAttributes.u32ScreenHeight);
      oMRGetVideoSettings.VideoAttributes.rScreenAttributes.u16ScreenWidth = (tU16)(rVideoAttr.rScreenAttributes.u32ScreenWidth);
      oMRGetVideoSettings.VideoAttributes.rScreenAttributes.enScreenAspectRatio.enType = 
         static_cast<midw_fi_tcl_e8_ScreenAspectRatio::tenType>(rVideoAttr.rScreenAttributes.enScreenAspectRatio);

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRGetVideoSettings,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSGetVideoSettings() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oGetVideoSettingsMS.bIsValid())&&(nullptr != m_poSpiCmdIntf) )

}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetDeviceUsagePreference()
***************************************************************************/
t_Void spi_tclService::vOnMSSetDeviceUsagePreference(amt_tclServiceData* poMessage)
{
      ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetDeviceUsagePreference() entered"));
   spi_tMsgSetDeviceUsagePreferenceMS oSetDeviceUsagePreference(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetDeviceUsagePreference.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      m_poSpiCmdIntf->vSetDeviceUsagePreference(oSetDeviceUsagePreference.DeviceHandle,
         (tenDeviceCategory)oSetDeviceUsagePreference.DeviceCategory.enType,
         (tenEnabledInfo)oSetDeviceUsagePreference.EnabledInfo.enType,rUsrCntxt);
   }//if( (TRUE == oSetDeviceUsagePreference.bIsValid())&&(nullptr != m_poSpiCmdIntf) )

}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnGetDeviceUsagePreferenceMS()
***************************************************************************/
t_Void spi_tclService::vOnMSGetDeviceUsagePreference(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetDeviceUsagePreference() entered"));
   spi_tMsgGetDeviceUsagePreferenceMS oGetDeviceUsagePreference(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oGetDeviceUsagePreference.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trMsgContext rMsgCntxt;
      CPY_TO_USRCNTXT(poMessage, rMsgCntxt.rUserContext);

      tenEnabledInfo enEnabledInfo=e8USAGE_DISABLED;
      m_poSpiCmdIntf->bGetDeviceUsagePreference(oGetDeviceUsagePreference.DeviceHandle,
         (tenDeviceCategory)oGetDeviceUsagePreference.DeviceCategory.enType,enEnabledInfo);

      midw_smartphoneintfi_tclMsgGetDeviceUsagePreferenceMethodResult oMRGetDeviceUsagePreference;
      oMRGetDeviceUsagePreference.DeviceHandle = oGetDeviceUsagePreference.DeviceHandle;
      oMRGetDeviceUsagePreference.DeviceCategory.enType = oGetDeviceUsagePreference.DeviceCategory.enType;
      oMRGetDeviceUsagePreference.EnabledInfo.enType = static_cast<midw_fi_tcl_e8_EnabledInfo::tenType>(enEnabledInfo);

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRGetDeviceUsagePreference,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSGetDeviceUsagePreference()Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oGetDeviceUsagePreference.bIsValid())&&(nullptr != m_poSpiCmdIntf) )

}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSAccessoryDisplayContext()
***************************************************************************/
t_Void spi_tclService::vOnMSAccessoryDisplayContext(amt_tclServiceData* poMessage)
{
   spi_tMsgAccDispCntxtMS oAccDispCntxt(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oAccDispCntxt.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
#ifdef VARIANT_S_FTR_ENABLE_HMI_SYNC
   t_Bool bDisplayFlag = (t_Bool)oAccDispCntxt.DisplayFlag;
   if(true == bDisplayFlag)
   {
      tenNativeVideoRenderingStatus enNativeVideoRenderingStatus = e8_NATIVE_VIDEO_RENDERING_STARTED;
	  ETG_TRACE_USR1(("spi_tclService::vOnMSAccessoryDisplayContext()::"
	     "VARIANT_S_FTR_ENABLE_HMI_SYNC display flag = %d "
		 ,ETG_ENUM(NATIVE_VIDEO_RENDERING_STATUS,enNativeVideoRenderingStatus)));
	  vSetNativeVideoRenderingStatus(enNativeVideoRenderingStatus);
   }
#endif
      ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSAccessoryDisplayContext() entered"));
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      m_poSpiCmdIntf->vSetAccessoryDisplayContext(oAccDispCntxt.DeviceHandle,(t_Bool)oAccDispCntxt.DisplayFlag,
         (tenDisplayContext)oAccDispCntxt.DisplayContext.enType,rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgAccessoryDisplayContextMethodResult oMRAccessoryDisplayContextReq;
      oMRAccessoryDisplayContextReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRAccessoryDisplayContextReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRAccessoryDisplayContextReq,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSAccessoryDisplayContext() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oMRAccessoryDisplayContextReq.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetAccessoryDisplayContext()
***************************************************************************/
t_Void spi_tclService::vOnMSSetAccessoryDisplayContext(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetAccessoryDisplayContext() entered"));
   spi_tMsgSetAccDisplayContextReqMS oSetAccDispCntxt(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetAccDispCntxt.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trDisplayContext rDisplayContext;
      rDisplayContext.enDisplayContext = (tenDisplayContext)oSetAccDispCntxt.DisplayContextInfo.DisplayContext.enType;
      rDisplayContext.bDisplayFlag = (t_Bool)oSetAccDispCntxt.DisplayContextInfo.DisplayFlag;

#ifdef VARIANT_S_FTR_ENABLE_HMI_SYNC
      if(true == rDisplayContext.bDisplayFlag)
      {
         tenNativeVideoRenderingStatus enNativeVideoRenderingStatus = e8_NATIVE_VIDEO_RENDERING_STARTED;
         ETG_TRACE_USR1(("spi_tclService::vOnMSAccessoryDisplayContext()::"
                  "VARIANT_S_FTR_ENABLE_HMI_SYNC display flag = %d "
                  ,ETG_ENUM(NATIVE_VIDEO_RENDERING_STATUS,enNativeVideoRenderingStatus)));
         vSetNativeVideoRenderingStatus(enNativeVideoRenderingStatus);
      }
#endif

      trDisplayConstraint rDisplayConstraint;
      rDisplayConstraint.enTransferType = (tenDiPOTransferType)oSetAccDispCntxt.DisplayConstraintInfo.TransferType.enType;
      rDisplayConstraint.enTransferPriority = (tenDiPOTransferPriority)oSetAccDispCntxt.DisplayConstraintInfo.TransferPriority.enType;
      rDisplayConstraint.enTakeConstraint = (tenDiPOConstraint)oSetAccDispCntxt.DisplayConstraintInfo.TakeConstraint.enType;
      rDisplayConstraint.enBorrowConstraint = (tenDiPOConstraint)oSetAccDispCntxt.DisplayConstraintInfo.BorrowConstraint.enType;
      strcpy(rDisplayConstraint.szBorrowId, oSetAccDispCntxt.DisplayConstraintInfo.BorrowId.szValue);

      ETG_TRACE_USR4(("[FUNC]spi_tclService::vOnMSSetAccessoryDisplayContext():%d",oSetAccDispCntxt.ContextResponsibility.enType));

      m_poSpiCmdIntf->vSetAccessoryDisplayMode(oSetAccDispCntxt.DeviceHandle,
         rDisplayContext,
         rDisplayConstraint,
         (tenDisplayInfo)oSetAccDispCntxt.ContextResponsibility.enType);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetAccessoryDisplayContextMethodResult oSetAccDispCntxtMR;
      oSetAccDispCntxtMR.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oSetAccDispCntxtMR.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oSetAccDispCntxtMR,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetAccessoryDisplayContext() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage
   }
   else
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vOnMSSetAccessoryDisplayContext()Left with Message extraction failed"));
   }
   
}


/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSAccessoryAudioContext()
***************************************************************************/
t_Void spi_tclService::vOnMSAccessoryAudioContext(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSAccessoryAudioContext() entered"));
 
   spi_tMsgAccAudioCntxtMS oAccAudioCntxt(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oAccAudioCntxt.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      m_poSpiCmdIntf->vSetAccessoryAudioContext(oAccAudioCntxt.DeviceHandle,
               (tenAudioContext) oAccAudioCntxt.AudioContext.enType,
               (t_Bool) oAccAudioCntxt.AudioFlag, rUsrCntxt, e8DEV_TYPE_DIPO);

      m_poSpiCmdIntf->vSetAccessoryAudioContext(oAccAudioCntxt.DeviceHandle,
               (tenAudioContext) oAccAudioCntxt.AudioContext.enType,
               (t_Bool) oAccAudioCntxt.AudioFlag, rUsrCntxt, e8DEV_TYPE_ANDROIDAUTO);

      m_poSpiCmdIntf->vSetAccessoryAudioContext(oAccAudioCntxt.DeviceHandle,
               (tenAudioContext) oAccAudioCntxt.AudioContext.enType,
               (t_Bool) oAccAudioCntxt.AudioFlag, rUsrCntxt, e8DEV_TYPE_MYSPIN);

      m_poSpiCmdIntf->vSetAccessoryAudioContext(oAccAudioCntxt.DeviceHandle,
               (tenAudioContext) oAccAudioCntxt.AudioContext.enType,
               (t_Bool) oAccAudioCntxt.AudioFlag, rUsrCntxt, e8DEV_TYPE_CARLIFE);

      m_poSpiCmdIntf->vSetAccessoryAudioContext(oAccAudioCntxt.DeviceHandle,
                     (tenAudioContext) oAccAudioCntxt.AudioContext.enType,
                     (t_Bool) oAccAudioCntxt.AudioFlag, rUsrCntxt, e8DEV_TYPE_ONCAR);
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgAccessoryAudioContextMethodResult
               oMRAccessoryAudioContextReq;
      oMRAccessoryAudioContextReq.ResponseCode.enType
               = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRAccessoryAudioContextReq.ErrorCode.enType
               = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

       //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if (FALSE == oPostMsg.bSendResMessage(oMRAccessoryAudioContextReq, rMsgContext,
               SPI_SERVICE_FI_MAJOR_VERSION))
       {
          ETG_TRACE_ERR(("[ERR]:vOnMSAccessoryAudioContext left with Error in posting Method Result"));
       } //if( FALSE == oPostMsg.bSendMessage
   }//if( (TRUE == oAccDispCntxt.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSAccessoryAppState()
***************************************************************************/
t_Void spi_tclService::vOnMSAccessoryAppState(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSAccessoryAppState() entered"));

   spi_tMsgAccAppStateMS oAccAppstate(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oAccAppstate.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);
      m_poSpiCmdIntf->vSetAccessoryAppState((tenSpeechAppState)oAccAppstate.AppStateSpeech.enType, 
         (tenPhoneAppState)oAccAppstate.AppStatePhone.enType, (tenNavAppState)oAccAppstate.AppStateNavigation.enType, rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgAccessoryAppStateMethodResult oMRAccessoryAppStateReq;
      oMRAccessoryAppStateReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRAccessoryAppStateReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRAccessoryAppStateReq,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSAccessoryAppState left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage )
   }//if( (TRUE == oAccAudioCntxt.bIsValid())&&(nullptr != m_pSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetClientCapabilities()
***************************************************************************/
t_Void spi_tclService::vOnMSSetClientCapabilities(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetClientCapabilities() entered"));

   spi_tMsgSetClientCapabilitiesMS oSetClientCapabilities(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetClientCapabilities.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      trClientCapabilities rClntCapabilities ;
      rClntCapabilities.rKeyCapabilities.u32KnobKeySupport = 
         oSetClientCapabilities.ClientCapabilities.rKeyCapabilities.u32KnobKeySupport;

      rClntCapabilities.rKeyCapabilities.u32DeviceKeySupport  = 
         oSetClientCapabilities.ClientCapabilities.rKeyCapabilities.u32DeviceKeySupport;

      rClntCapabilities.rKeyCapabilities.u32MultimediaKeySupport  = 
         oSetClientCapabilities.ClientCapabilities.rKeyCapabilities.u32MultimediaKeySupport;

      rClntCapabilities.rKeyCapabilities.u32MiscKeySupport = 
         oSetClientCapabilities.ClientCapabilities.rKeyCapabilities.u32MiscKeySupport;

      rClntCapabilities.rKeyCapabilities.u32PointerTouchSupport = 
         oSetClientCapabilities.ClientCapabilities.rKeyCapabilities.u32PointerTouchSupport;

      //implement method in cmdintf && Send the request
      m_poSpiCmdIntf->vSetClientCapabilities(rClntCapabilities,rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetClientCapabilitiesMethodResult oMRSetClientCapabilitiesReq;
      oMRSetClientCapabilitiesReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetClientCapabilitiesReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetClientCapabilitiesReq,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetClientCapabilities Left With Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oSetClientCapabilities.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetMLNotificationEnabledInfo()
***************************************************************************/
t_Void spi_tclService::vOnMSSetMLNotificationEnabledInfo(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetMLNotificationEnabledInfo() entered"));
   spi_tMsgSetSetMLNotiEnabledInfoMS oSetMLNotiEnabledInfo(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetMLNotiEnabledInfo.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      tU32 u32ListSize = static_cast <tU32>(oSetMLNotiEnabledInfo.NotificationEnableList.size());
      std::vector<trNotiEnable> vecrNotificationEnableList;
      for(tU32 u32Index=0;u32Index<u32ListSize;++u32Index)
      {
         trNotiEnable rNotiEnable;
         rNotiEnable.u32AppHandle = oSetMLNotiEnabledInfo.NotificationEnableList[u32Index].u32AppHandle;
         rNotiEnable.enEnabledInfo = (tenEnabledInfo)oSetMLNotiEnabledInfo.NotificationEnableList[u32Index].enEnabledInfo.enType;
         vecrNotificationEnableList.push_back(rNotiEnable);
      }//for(tU32 u32Index;u32Index<u32ListSize;++u32Index)

      m_poSpiCmdIntf->vSetMLNotificationEnabledInfo(oSetMLNotiEnabledInfo.DeviceHandle,
         oSetMLNotiEnabledInfo.NumNotificationEnableList,
         vecrNotificationEnableList,
         rUsrCntxt);

   }//if( (TRUE == oSetMLNotiEnabledInfo.bIsValid())&&(nullptr != m_poSpiCmdIntf) )

}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSInvokeNotificationAction()
***************************************************************************/
t_Void spi_tclService::vOnMSInvokeNotificationAction(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSInvokeNotificationAction() emtered"));
   spi_tMsgInvokeNotiAction oInvokeNotiAction(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oInvokeNotiAction.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      ETG_TRACE_USR2(("[DESC]:vInvokeNotificationAction received values of Dev-0x%x NotiID-0x%x and  ActionID-0x%x ",
         oInvokeNotiAction.DeviceHandle,oInvokeNotiAction.NotificationID,oInvokeNotiAction.NotificationActionID));

      m_poSpiCmdIntf->vInvokeNotificationAction(oInvokeNotiAction.DeviceHandle,oInvokeNotiAction.AppHandle,
      oInvokeNotiAction.NotificationID,oInvokeNotiAction.NotificationActionID,rUsrCntxt);
   }//if( (TRUE == oInvokeNotiAction.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSendTouchEvent()
***************************************************************************/
t_Void spi_tclService::vOnMSSendTouchEvent(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSendTouchEvent() entered"));
   spi_tMsgSetSendTouchEventMS oSendTouchEvent(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSendTouchEvent.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      trTouchData rTouchData;
      rTouchData.u32TouchDescriptors = oSendTouchEvent.TouchData.u16TouchDescriptors ;

      tU32 u32TouchInfoListSize = static_cast <tU32>(oSendTouchEvent.TouchData.TouchInfoList.size());
      for(tU32 u32Index=0;u32Index<u32TouchInfoListSize;++u32Index)
      {
         trTouchInfo rTouchInfo;
         //u32TimeStamp & u32Pressure to be added in SPI FI

         tU32 u32TouchCoordinatesListLen = static_cast <tU32>(oSendTouchEvent.TouchData.TouchInfoList[u32Index].TouchCoordinatesList.size());
         for(tU32 u32Ind=0;u32Ind<u32TouchCoordinatesListLen;++u32Ind)
         {
            trTouchCoordinates rTouchCoordinates;

            rTouchCoordinates.s32XCoordinate = 
               oSendTouchEvent.TouchData.TouchInfoList[u32Index].TouchCoordinatesList[u32Ind].u16XCoordinate;

            rTouchCoordinates.s32YCoordinate = 
               oSendTouchEvent.TouchData.TouchInfoList[u32Index].TouchCoordinatesList[u32Ind].u16YCoordinate;

            rTouchCoordinates.enTouchMode = 
               (tenTouchMode)oSendTouchEvent.TouchData.TouchInfoList[u32Index].TouchCoordinatesList[u32Ind].enTouchMode.enType;

            //u8Identifier to be added in SPI FI
            rTouchInfo.tvecTouchCoordinatesList.push_back(rTouchCoordinates);

         }//for(tU32 u32Ind;u32Ind<u32TouchCoordinatesListLen;++u32Ind)

         rTouchData.tvecTouchInfoList.push_back(rTouchInfo);

      }//for(tU32 u32Index;u32Index<u32TouchInfoListSize;++u32Index)

      m_poSpiCmdIntf->vSendTouchEvent(oSendTouchEvent.DeviceHandle,
         rTouchData,rUsrCntxt);

      //currently send the response from here only. Once it is implemented, response
      //should be called from Response Interface & remove the call from here
      vPostSendTouchEvent(e8FAILURE,e8OPERATION_REJECTED,rUsrCntxt);

   }//if( (TRUE == oSendTouchEvent.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSendKeyEvent()
***************************************************************************/
t_Void spi_tclService::vOnMSSendKeyEvent(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSendKeyEvent() entered"));
   spi_tMsgSendKeyEventMS oSendKeyEvent(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSendKeyEvent.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      ETG_TRACE_USR2(("[DESC]:vOnMSSendKeyEvent() received KeyCode-%d and  keyMode-%d",ETG_ENUM(KEY_CODE,oSendKeyEvent.KeyCode.enType),
         ETG_ENUM(KEY_MODE,oSendKeyEvent.KeyMode.enType)));

      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      tenKeyCode enKeyCode = enGetKeyCode(oSendKeyEvent.KeyCode.enType);
      tenKeyMode enKeyMode = static_cast<tenKeyMode>(oSendKeyEvent.KeyMode.enType);

      tenResponseCode enRespCode = e8SUCCESS;
      tenErrorCode enErrorCode = e8NO_ERRORS;
      if(e32INVALID_KEY != enKeyCode)
      {
         m_poSpiCmdIntf->vSendKeyEvent(oSendKeyEvent.DeviceHandle,enKeyMode,
            enKeyCode,rUsrCntxt);
      }
      else
      {
         enRespCode = e8FAILURE;
         enErrorCode = e8UNSUPPORTED_KEY;
      }


      //currently send the response from here only. Once it is implemented, response
      //should be called from Response Interface & remove the call from here
      vPostSendKeyEvent(enRespCode,enErrorCode,rUsrCntxt);
   }//if( (TRUE == oSendKeyEvent.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}


/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetVehicleBTAddress()
***************************************************************************/
t_Void spi_tclService::vOnMSSetVehicleBTAddress(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetVehicleBTAddress() entered"));
   
   spi_tMsgSetVehicleBTAddressMS oSetVehicleBTAddress(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetVehicleBTAddress.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      t_String szBTAddress;
      szBTAddress.assign(oSetVehicleBTAddress.BTAddress.szValue);
      m_poSpiCmdIntf->vSetVehicleBTAddress(szBTAddress,rUsrCntxt);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetVehicleBTAddressMethodResult oMRSetVehicleBTAddress;
      oMRSetVehicleBTAddress.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetVehicleBTAddress.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetVehicleBTAddress,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetVehicleBTAddress() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage
   }//if( (TRUE == oSetVehicleBTAddress.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetRegion()
***************************************************************************/
t_Void spi_tclService::vOnMSSetRegion(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetRegion() entered"));
   spi_tMsgSetRegionMS oSetRegion(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSetRegion.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      tenRegion enRegion = static_cast<tenRegion>(oSetRegion.Region.enType);
      m_poSpiCmdIntf->vSetRegion(enRegion);

     trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetRegionMethodResult oMRSetRegionReq;
      oMRSetRegionReq.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetRegionReq.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetRegionReq,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetVehicleBTAddress() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage
  
   }//if( (TRUE == oSetVehicleBTAddress.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/***************************************************************************
** FUNCTION: tVoid spi_tclService::vOnMSDiPoRoleSwitchRequired
***************************************************************************/
tVoid spi_tclService::vOnMSDiPoRoleSwitchRequired(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSDiPoRoleSwitchRequired() entered"));

   t_U32 u32DeviceHandle = 0;   
   spi_tMsgRoleSwitchReqMS oRoleSwitchReq(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   t_Bool bDeviceCarplayCapability = oRoleSwitchReq.DeviceCarplayCapability ;
   trMsgContext rMsgContext;
   CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

   if ((TRUE == oRoleSwitchReq.bIsValid()) && (nullptr != m_poSpiCmdIntf))
   {
      u32DeviceHandle = oRoleSwitchReq.u8DeviceTag;
      t_String szSerialNumber;
      GET_STRINGDATA_FROM_FI_STRINGOBJ(oRoleSwitchReq.USBSerialNumber, midw_fi_tclString::FI_EN_UTF8, szSerialNumber);
      //bDeviceCarplayCapability = oRoleSwitchReq.DeviceCarplayCapability;
      ETG_TRACE_USR2(("[FUNC]spi_tclService::vOnMSDiPoRoleSwitchRequired() Received for Device 0x%x with serial number = %s", u32DeviceHandle, szSerialNumber.c_str()));
      ETG_TRACE_USR2(("[FUNC]spi_tclService::vOnMSDiPoRoleSwitchRequired() Received bDeviceCarplayCapability = %d", ETG_ENUM(BOOL, bDeviceCarplayCapability)));
      t_Bool bRoleSwitchReq = m_poSpiCmdIntf->bIsDiPoRoleSwitchRequired(szSerialNumber, rMsgContext.rUserContext, u32DeviceHandle,bDeviceCarplayCapability);
      SPI_INTENTIONALLY_UNUSED(bRoleSwitchReq);
    }//if( (TRUE == oSetVehicleBTAddress.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}


/**************************************************************************
 ** FUNCTION   : tVoid spi_tclService:: vOnMSSetAccessoryAudioContext()
 ***************************************************************************/
t_Void spi_tclService::vOnMSSetAccessoryAudioContext(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetAccessoryAudioContext() entered"));

   spi_tMsgSetAccAudioCntxtMS oSetAccAudioCntxt(*poMessage,
            SPI_SERVICE_FI_MAJOR_VERSION);
   if ((TRUE == oSetAccAudioCntxt.bIsValid()) && (nullptr != m_poSpiCmdIntf))
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);
      std::vector<trAudioContext> vecrAudioContextInfo;
      tU32 u32ListSize = static_cast <tU32>(oSetAccAudioCntxt.AudioContextInfo.size());
      for (tU32 u32Index = 0; u32Index < u32ListSize; ++u32Index)
      {
         trAudioContext rAudContext;
         rAudContext.AudioContext = (tenAudioContext) oSetAccAudioCntxt.AudioContextInfo[u32Index].AudioContext.enType;
         rAudContext.AudioFlag   = oSetAccAudioCntxt.AudioContextInfo[u32Index].AudioFlag;
         m_poSpiCmdIntf->vSetAccessoryAudioContext(oSetAccAudioCntxt.DeviceHandle,
                  rAudContext.AudioContext, rAudContext.AudioFlag, rUsrCntxt, e8DEV_TYPE_DIPO);
         m_poSpiCmdIntf->vSetAccessoryAudioContext(oSetAccAudioCntxt.DeviceHandle,
                  rAudContext.AudioContext, rAudContext.AudioFlag, rUsrCntxt, e8DEV_TYPE_ANDROIDAUTO);
      }

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetAccessoryAudioContextMethodResult
               oMRSetAccessoryAudioContextReq;
      oMRSetAccessoryAudioContextReq.ResponseCode.enType
               = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetAccessoryAudioContextReq.ErrorCode.enType
               = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if (FALSE == oPostMsg.bSendResMessage(oMRSetAccessoryAudioContextReq,
               rMsgContext,
               SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetAccessoryAudioContext() Left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage

   }//if( (TRUE == oAccDispCntxt.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/**************************************************************************
 ** FUNCTION   : tVoid spi_tclService:: vOnMSSetFeatureRestrictions()
 ***************************************************************************/
t_Void spi_tclService::vOnMSSetFeatureRestrictions(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetFeatureRestrictions() entered "));

   spi_tMsgSetFeatureRestrictionsMS oSetFeatureRestrictions(*poMessage,
            SPI_SERVICE_FI_MAJOR_VERSION);
   if ((TRUE == oSetFeatureRestrictions.bIsValid()) && (nullptr
            != m_poSpiCmdIntf))
   {
      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      ETG_TRACE_USR1(("[PARAM]::vOnMSSetFeatureRestrictions() Device Category = %d, Park Mode Restriction = %d, Drive Mode Restriction = %d,"
               "General Restriction Info = %d",
            ETG_ENUM( DEVICE_CATEGORY, oSetFeatureRestrictions.DeviceCategory.enType),
            oSetFeatureRestrictions.ParkModeRestrictionInfo.FeatureLockout,
            oSetFeatureRestrictions.DriveModeRestrictionInfo.FeatureLockout,
            oSetFeatureRestrictions.GeneralRestrictionInfo));

      //send restriction trigger to command interface
      m_poSpiCmdIntf->vSetFeatureRestrictions((tenDeviceCategory) oSetFeatureRestrictions.DeviceCategory.enType,
            (t_U8) oSetFeatureRestrictions.ParkModeRestrictionInfo.FeatureLockout,
            (t_U8) oSetFeatureRestrictions.DriveModeRestrictionInfo.FeatureLockout);

      //send General Restriction Info to command interface
      m_poSpiCmdIntf->vSetGeneralRestrictions((tenDeviceCategory) oSetFeatureRestrictions.DeviceCategory.enType,
               oSetFeatureRestrictions.GeneralRestrictionInfo);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgSetFeatureRestrictionsMethodResult
               oFeatureRestrictionsMR;
      oFeatureRestrictionsMR.ResponseCode.enType
               = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oFeatureRestrictionsMR.ErrorCode.enType
               = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if (FALSE == oPostMsg.bSendResMessage(oFeatureRestrictionsMR,
               rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetFeatureRestrictions() Left with Error in posting Method Result"));
      }
   }
}


/**************************************************************************
 ** FUNCTION   : tVoid spi_tclService:: vOnMSSetTechnologyPreference()
 ***************************************************************************/
t_Void spi_tclService::vOnMSSetTechnologyPreference(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetTechnologyPreference() entered "));
   spi_tMsgSetTechnologyPrefMS oSetTechPref(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   t_U32 u32DeviceHandle = oSetTechPref.DeviceHandle;
   t_U32 u32NoofPreferences = oSetTechPref.NumofPreferences;
   //Devicetype need to be added
   //! Consider only the first element in technology preference
   tenDeviceCategory enTechnologyPref = e8DEV_TYPE_UNKNOWN;
   tenErrorCode enErrorCode = e8NO_ERRORS;
   tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE;
   if(0 < oSetTechPref.PreferenceOrderList.size())
   {
      enTechnologyPref = static_cast<tenDeviceCategory> (oSetTechPref.PreferenceOrderList[0].enType);
   }

   enDeviceType = static_cast<tenDeviceType> (oSetTechPref.DeviceType.enType);
   ETG_TRACE_USR4(("[PARAM]::vOnMSSetTechnologyPreference() - u32DeviceHandle = 0x%x, DeviceType = %d Pref size = %d u32NoofPreferences = %d",
         u32DeviceHandle, ETG_ENUM(DEVICE_TYPE, enDeviceType), oSetTechPref.PreferenceOrderList.size(), u32NoofPreferences));
   trMsgContext rMsgContext;
   CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

   if(nullptr != m_poSpiCmdIntf)
   {
	  //Devicetype need to be sent
      m_poSpiCmdIntf->vSetTechnologyPreference(u32DeviceHandle, enTechnologyPref, enDeviceType, enErrorCode);
   }


   tenResponseCode enRespCode = (e8NO_ERRORS == enErrorCode)?e8SUCCESS:e8FAILURE;
   midw_smartphoneintfi_tclMsgSetTechnologyPreferenceMethodResult oSetTechnologyPrefMR;
   oSetTechnologyPrefMR.ResponseCode.enType = static_cast<midw_fi_tcl_e8_ResponseCode::tenType> (enRespCode);

   //post Method result to HMI. There is no failure case foreseen as of now
   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oSetTechnologyPrefMR,
            rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vOnMSSetTechnologyPreference: Error in posting Method Result"));
   }
}

/**************************************************************************
 ** FUNCTION   : tVoid spi_tclService:: vOnMSGetTechnologyPreference()
 ***************************************************************************/
t_Void spi_tclService::vOnMSGetTechnologyPreference(amt_tclServiceData* poMessage)
{
   spi_tMsgGetTechnologyPrefMS oGetTechPref(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   t_U32 u32DeviceHandle = oGetTechPref.DeviceHandle;
   tenDeviceType enDeviceType = static_cast<tenDeviceType> (oGetTechPref.DeviceType.enType);
   std::vector<tenDeviceCategory> vecTechPreference;
   tenDeviceCategory enTechnologyPref = e8DEV_TYPE_UNKNOWN;
   trMsgContext rMsgContext;
   CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

   if(nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vGetTechnologyPreference(u32DeviceHandle, enDeviceType, enTechnologyPref);
   }

   midw_smartphoneintfi_tclMsgGetTechnologyPreferenceMethodResult oGetTechnologyPrefMR;
   oGetTechnologyPrefMR.NumofPreferences = 1;

   midw_fi_tcl_e8_DeviceCategory enTechnologypref;
   enTechnologypref.enType = (midw_fi_tcl_e8_DeviceCategory::tenType)enTechnologyPref;
   oGetTechnologyPrefMR.PreferenceOrderList.push_back(enTechnologypref);

   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSGetTechnologyPreference() u32DeviceHandle = 0x%x, Pref size = %d", u32DeviceHandle,  oGetTechnologyPrefMR.PreferenceOrderList.size()));

   //post Method result to HMI. There is no failure case foreseen as of now
   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oGetTechnologyPrefMR,
            rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vOnMSGetTechnologyPreference: Error in posting Method Result"));
   }
}

/**************************************************************************
 ** FUNCTION   : tVoid spi_tclService:: vOnMSSetDeviceSelMode()
 ***************************************************************************/
t_Void spi_tclService::vOnMSSetDeviceSelMode(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSetDeviceSelMode() entered "));
   spi_tMsgSetDeviceSelModeMS oSetDevSelMode(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   tenDeviceSelectionMode enDeviceSelectionMode = static_cast<tenDeviceSelectionMode> (oSetDevSelMode.DeviceSelectionMode.enType);

   ETG_TRACE_USR4(("[PARAM]::vOnMSSetDeviceSelMode() - Request to switch device selection mode to %d",
            ETG_ENUM(DEVICE_SELECTION_MODE,enDeviceSelectionMode)));
   trMsgContext rMsgContext;
   CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

   if(nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vSetDeviceSelectionMode(enDeviceSelectionMode);
   }

   midw_smartphoneintfi_tclMsgSetDeviceSelectionModeMethodResult oSetDevSelMR;
   oSetDevSelMR.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;

   //post Method result to HMI. There is no failure case foreseen as of now
   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oSetDevSelMR,
            rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vOnMSSetDeviceSelMode: Error in posting Method Result"));
   }
}

/******************************************************************************
** FUNCTION:  tVoid spi_tclService::vOnLoopbackService(amt_tclSer...
******************************************************************************/
/*virtual*/
tVoid spi_tclService::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData *poMessage)
{
   ETG_TRACE_USR1(("[FUNC]vOnLoopback() entered with service Id = %d", u16ServiceID));

   if(
     (nullptr != poMessage)
     &&
     (FALSE == ahl_tclBaseOneThreadService::bDefaultSvcDataHandler(this, poMessage))
     )
   {
      // Trace: Nothing else to do since it is a loopback message.
      // Message will be deleted by the framework.
      // No error message to be sent back if loop back could not find a mapping
      // function - just perform the trace.
      ETG_TRACE_ERR(("vOnLoopback() could not find a mapping function."));
      ETG_TRACE_ERR(("Opcode: %d", ETG_ENUM(OP_CODES, poMessage->u8GetOpCode())
         ));
   }
}

/***************************************************************************
** FUNCTION:  tBool spi_tclService::vOnLbBTAddressUpdate(amt_tclServiceData* poMessage)
***************************************************************************/
t_Void spi_tclService::vOnLbBTAddressUpdate(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnLbBTAddressUpdate()"));
   if ((nullptr != poMessage) && (nullptr != m_poSpiCmdIntf))
   {
      tLbOnVehicleBTAdressUpdate oBTAddressUpdate(poMessage);
      t_String szBTAddress = (nullptr != oBTAddressUpdate.pcocGetData())? (oBTAddressUpdate.pcocGetData()) : ("");
      m_poSpiCmdIntf->vSetVehicleBTAddress(szBTAddress);
   }//if(NULL != m_poSpiCmdIntf)
}

/***************************************************************************
** FUNCTION:  tBool spi_tclService::bUpdateClients(tCU16 cu16FunID)
***************************************************************************/
tBool spi_tclService::bUpdateClients(tCU16 cu16FunID)
{
   //Update all clients registered for the property.
   ail_tenCommunicationError enCommError = eUpdateClients(cu16FunID);

   tBool bRet = (AIL_EN_N_NO_ERROR == enCommError);

   if (FALSE == bRet)
   {
      ETG_TRACE_ERR(( "[ERR]:bUpdateClients failed: %d", enCommError));
   }//if(FALSE == bRet)

   return bRet;
}

/***************************************************************************
** FUNCTION: tVoid spi_tclService::vPostDeviceStatusInfo(tenDeviceStatusInfo enDeviceStatusInfo)
***************************************************************************/
tVoid spi_tclService::vPostDeviceStatusInfo(t_U32 u32DevHandle,
         tenDeviceConnectionType enDevConnType,
         tenDeviceStatusInfo enDeviceStatus)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostDeviceStatusInfo u32DevHandle = %d"
            " enDevConnType = %d enDeviceStatus- %d ",
            u32DevHandle, ETG_ENUM(CONNECTION_TYPE, enDevConnType),  ETG_ENUM(DEVICE_STATUS_INFO, enDeviceStatus)));

   m_enDevStatusInfo.DeviceHandle = u32DevHandle;
   m_enDevStatusInfo.DeviceStatus.enType = (midw_fi_tcl_e8_DeviceStatusInfo::tenType) enDeviceStatus;
   m_enDevStatusInfo.DeviceConnectionType.enType =
            (midw_fi_tcl_e8_DeviceConnectionType::tenType) enDevConnType;

   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICESTATUSINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostDeviceStatusInfo:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICESTATUSINFO))
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vPostDeviceInfoList
 ***************************************************************************/
t_Void spi_tclService::vPostDeviceInfoList(const std::vector<trDeviceInfo>& corfvecDeviceInfoList,
         const trUserContext &corfrUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostDeviceInfoList Num.Devices-%d ",
            corfvecDeviceInfoList.size()));

   midw_smartphoneintfi_tclMsgGetDeviceInfoListMethodResult oMRDeviceInfoList;
   oMRDeviceInfoList.NumDevices = static_cast <t_U16>(corfvecDeviceInfoList.size());

   //@todo - find work around to avoid std usage
   std::vector<midw_fi_tcl_DeviceDetails> rvecDeviceInfo;
   vPopulateDeviceInfoList(rvecDeviceInfo, corfvecDeviceInfoList);
   oMRDeviceInfoList.DeviceInfoList = rvecDeviceInfo ;
   ETG_TRACE_USR4(("[PARAM]::vPostDeviceInfoList - Num.Devices-%d",oMRDeviceInfoList.NumDevices));

   for (tU8 u8Index = 0; u8Index < oMRDeviceInfoList.DeviceInfoList.size(); ++u8Index)
   {
      ETG_TRACE_USR4(("[PARAM]::vPostDeviceInfoList - Dev-0x%x Index-%d Name-%s",
         oMRDeviceInfoList.DeviceInfoList[u8Index].u32DeviceHandle,
         u8Index,
         oMRDeviceInfoList.DeviceInfoList[u8Index].szDeviceName.szValue));
   }

   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = corfrUsrCntxt;
   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oMRDeviceInfoList,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostDeviceInfoList() left with Error in posting Message"));
   } //if (FALSE == oPostMsg.bSendMessage)

   //! De-allocate memory used by message
   oMRDeviceInfoList.vDestroy();
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vPostDeviceList
 ***************************************************************************/
t_Void spi_tclService::vPostDeviceList(const std::vector<trDeviceInfo>& corfvecDeviceInfoList,
         const trUserContext &corfrUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostDeviceList Num.Devices-%d ",
            corfvecDeviceInfoList.size()));

   midw_smartphoneintfi_tclMsgGetDeviceListMethodResult oMRDeviceList;
   oMRDeviceList.NumDevices = static_cast <t_U16>(corfvecDeviceInfoList.size());

   //@todo - find work around to avoid std usage
   std::vector<midw_fi_tcl_DeviceDetails> rvecDeviceInfo;
   vPopulateDeviceInfoList(rvecDeviceInfo, corfvecDeviceInfoList);
   oMRDeviceList.DeviceInfoList = rvecDeviceInfo ;
   ETG_TRACE_USR4(("[PARAM]::vPostDeviceList - Num.Devices-%d",oMRDeviceList.NumDevices));

   for (tU8 u8Index = 0; u8Index < oMRDeviceList.DeviceInfoList.size(); ++u8Index)
   {
      ETG_TRACE_USR4(("[PARAM]::vPostDeviceList - Dev-0x%x Index-%d Name-%s",
         oMRDeviceList.DeviceInfoList[u8Index].u32DeviceHandle,
         u8Index,
         oMRDeviceList.DeviceInfoList[u8Index].szDeviceName.szValue));
   }

   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = corfrUsrCntxt;
   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oMRDeviceList,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostDeviceList() left with Error in posting Message"));
   } //if (FALSE == oPostMsg.bSendMessage)

   //! De-allocate memory used by message
   oMRDeviceList.vDestroy();
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostDAPStatusInfo
***************************************************************************/
t_Void spi_tclService::vPostDAPStatusInfo(t_U32 u32DeviceHandle,
         tenDeviceConnectionType enDevConnType,
         tenDAPStatus enDAPStatus)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostDAPStatusInfo-0x%x enDAPStatus = %d",
            u32DeviceHandle, enDAPStatus));
   m_enDAPStatusInfo.DeviceHandle = u32DeviceHandle;
   m_enDAPStatusInfo.DeviceConnectionType.enType =
            (midw_fi_tcl_e8_DeviceConnectionType::tenType)(enDevConnType);
   m_enDAPStatusInfo.DAPStatus.enType = (midw_fi_tcl_e8_DAPStatus::tenType)(enDAPStatus);
   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DAPSTATUSINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostDAPStatusInfo:Error in updating clients\n"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DAPSTATUSINFO))
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostRelativelyActiveMediaAppStatus
***************************************************************************/
t_Void spi_tclService::vPostRelativelyActiveMediaAppStatus(t_U32 u32RelativelyActiveMediaAppID,
         tenRelativelyActiveMediaAppCat enRelativelyActiveMediaAppCat)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostRelativelyActiveMediaAppStatus-%d AppID = 0x%x\n",
            enRelativelyActiveMediaAppCat, u32RelativelyActiveMediaAppID));
   m_enRelActiveMedAppStatus.MediaAppHandle = u32RelativelyActiveMediaAppID;
   m_enRelActiveMedAppStatus.MediaAppCategory.enType =
            (midw_fi_tcl_e8Media_AppCategory::tenType)(enRelativelyActiveMediaAppCat);
   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_RELATIVELYACTIVEMEDIAAPP))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostRelativelyActiveMediaAppStatus:Error in updating clients\n"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_RELATIVELYACTIVEMEDIAAPP))
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostAppStatusInfo()
***************************************************************************/
t_Void spi_tclService::vPostAppStatusInfo(t_U32 u32DeviceHandle,
                          tenDeviceConnectionType enDevConnType,
                          tenAppStatusInfo enAppStatus)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostAppStatusInfo-0x%x ",u32DeviceHandle));
   m_AppInfoStatus.DeviceHandle = u32DeviceHandle;
   m_AppInfoStatus.DeviceConnectionType.enType = (midw_fi_tcl_e8_DeviceConnectionType::tenType)(enDevConnType);
   m_AppInfoStatus.AppStatus.enType = (midw_fi_tcl_e8_AppStatusInfo::tenType)(enAppStatus);

   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPSTATUSINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostAppStatusInfo:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPSTATUSINFO))

   //Get the Apps Audio Info from AppMngr
   std::vector<trAppsAudioInfo> vecAppsAudioInfo;
   if(NULL != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vGetAppAudioInfo(vecAppsAudioInfo);
      m_poSpiCmdIntf->vSetAppAudioInfo(vecAppsAudioInfo);
   }
   

}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostNotificationInfo()
***************************************************************************/
t_Void spi_tclService::vPostNotificationInfo(t_U32 u32DeviceHandle,
                                             t_U32 u32AppHandle, 
                                             const trNotiData& corfrNotificationData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostNotificationInfo:Device-0x%x App-0x%x NotiID-0x%x NotiAppID-0x%x",
      u32DeviceHandle,u32AppHandle,corfrNotificationData.u32NotiID,corfrNotificationData.u32NotiAppID));

   ETG_TRACE_USR4(("[PARAM]:spi_tclService::vPostNotificationInfo:Notification Title -%s ",
      corfrNotificationData.szNotiTitle.c_str()));

   ETG_TRACE_USR4(("[PARAM]:spi_tclService::vPostNotificationInfo:Notification Body -%s ",
      corfrNotificationData.szNotiBody.c_str()));

   //Notification details
   m_NotificationInfo.DeviceHandle = u32DeviceHandle;
   m_NotificationInfo.AppHandle = u32AppHandle;
   //Unique ID of notification
   m_NotificationInfo.NotificationData.u16NotificationID = static_cast <tU16>(corfrNotificationData.u32NotiID);
   //Name of notification
   m_NotificationInfo.NotificationData.szNotificationTitle.bSet(corfrNotificationData.szNotiTitle.c_str(), midw_fi_tclString::FI_EN_UTF8);
   //Body of notification
   m_NotificationInfo.NotificationData.szNotificationBody.bSet(corfrNotificationData.szNotiBody.c_str(), midw_fi_tclString::FI_EN_UTF8);
   m_NotificationInfo.NotificationData.u16NotificationIconCount = static_cast <tU16>(corfrNotificationData.u32NotiIconCount);

   //Notification Icon Details
   tU16 u16IconAttrListLen = static_cast <tU16>(corfrNotificationData.tvecNotiIconList.size());

   for(tU16 u16Index=0;u16Index<u16IconAttrListLen;++u16Index)
   {
      midw_fi_tcl_IconAttributes oIconAttr;

      oIconAttr.u32IconWidth = corfrNotificationData.tvecNotiIconList[u16Index].u32IconWidth;
      oIconAttr.u32IconHeight = corfrNotificationData.tvecNotiIconList[u16Index].u32IconHeight;
      oIconAttr.u32IconDepth = corfrNotificationData.tvecNotiIconList[u16Index].u32IconDepth;
      oIconAttr.enIconMimeType.enType = 
         (midw_fi_tcl_e8_IconMimeType::tenType)(corfrNotificationData.tvecNotiIconList[u16Index].enIconMimeType);
      oIconAttr.szIconURL.bSet(
         corfrNotificationData.tvecNotiIconList[u16Index].szIconURL.c_str(), midw_fi_tclString::FI_EN_UTF8);

      m_NotificationInfo.NotificationData.NotificationIconList.push_back(oIconAttr) ;
   }//for(tU16 u16Index=0;u16Index<u16IconAttrListLen;++u16Index)

   m_NotificationInfo.NotificationData.u16NotificationAppID = static_cast <tU16>(corfrNotificationData.u32NotiAppID) ;

   //details of ACtions that can be performed on thsis Notification
   tU16 u16NotiActionListLen = static_cast <tU16>(corfrNotificationData.tvecNotiActionList.size());
   for(tU16 u16Index=0;u16Index<u16NotiActionListLen;++u16Index)
   {
      midw_fi_tcl_NotificationAction oNotiAction;
      ETG_TRACE_USR4(("spi_tclService::vPostNotificationInfo:NotiActionID-0x%x",
         corfrNotificationData.tvecNotiActionList[u16Index].u32NotiActionID));

      ETG_TRACE_USR4(("spi_tclService::vPostNotificationInfo:NotiActionName -%s ",
         corfrNotificationData.tvecNotiActionList[u16Index].szNotiActionName.c_str()));

      //copy notification action id details
      oNotiAction.u16NotificationActionID = static_cast <tU16>(corfrNotificationData.tvecNotiActionList[u16Index].u32NotiActionID) ;
      oNotiAction.szNotificationActionName.bSet( 
         corfrNotificationData.tvecNotiActionList[u16Index].szNotiActionName.c_str(),midw_fi_tclString::FI_EN_UTF8);
      oNotiAction.u16NotificationActionIconCount = static_cast <tU16>(corfrNotificationData.tvecNotiActionList[u16Index].u32NotiActionIconCount) ;

      //copy notification action icon details
      tU16 u16NotiActionIconAttrListLen=static_cast <tU16>(corfrNotificationData.tvecNotiActionList[u16Index].tvecNotiActionIconList.size());
      for(tU16 u16Ind=0;u16Ind<u16NotiActionIconAttrListLen;++u16Ind)
      {
         midw_fi_tcl_IconAttributes oIconAttr;
         oIconAttr.u32IconWidth = corfrNotificationData.tvecNotiActionList[u16Index].tvecNotiActionIconList[u16Ind].u32IconWidth;
         oIconAttr.u32IconHeight = corfrNotificationData.tvecNotiActionList[u16Index].tvecNotiActionIconList[u16Ind].u32IconHeight;
         oIconAttr.u32IconDepth = corfrNotificationData.tvecNotiActionList[u16Index].tvecNotiActionIconList[u16Ind].u32IconDepth;
         oIconAttr.enIconMimeType.enType = 
            (midw_fi_tcl_e8_IconMimeType::tenType)(corfrNotificationData.tvecNotiActionList[u16Index].tvecNotiActionIconList[u16Ind].enIconMimeType);
         oIconAttr.szIconURL.bSet(
            corfrNotificationData.tvecNotiActionList[u16Index].tvecNotiActionIconList[u16Ind].szIconURL.c_str(), midw_fi_tclString::FI_EN_UTF8);

         oNotiAction.NotificationActionIconList.push_back(oIconAttr);
      }//for(tU16 u16Ind=0;u16Ind<u16NotiActionIconAttrListLen;++u16Ind)

      m_NotificationInfo.NotificationData.NotificationActionList.push_back(oNotiAction);
   }//for(tU16 u16Index=0;u16Index<u16NotiActionListLen;++u16Index)

   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NOTIFICATIONINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostNotificationInfo:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NOTIFICATIONINFO))

   m_NotificationInfo.vDestroy();
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostApplicationMediaMetaData()
***************************************************************************/
t_Void spi_tclService::vPostApplicationMediaMetaData(
      const trAppMediaMetaData& rfcorApplicationMediaMetaData,
      const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostApplicationMediaMetaData entered: bMediaMetadataValid = %u ",
         ETG_ENUM(BOOL, rfcorApplicationMediaMetaData.bMediaMetadataValid)));

   SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);

   if (nullptr != m_poSpiCmdIntf)
   {
      //! Retrieving device handle
      m_AppMediaMetaDataLock.s16Lock();
      m_AppMediaMetaData.DeviceHandle = m_poSpiCmdIntf->u32GetSelectedDeviceHandle();
      //! Set Metadata Validity
      m_AppMediaMetaData.MetaDataValid = rfcorApplicationMediaMetaData.bMediaMetadataValid;
      //! Retrieving Meta Data
      m_AppMediaMetaData.ApplicationMediaMetaData.AppName.bSet( rfcorApplicationMediaMetaData.szAppName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.Title.bSet( rfcorApplicationMediaMetaData.szTitle.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.Artist.bSet( rfcorApplicationMediaMetaData.szArtist.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.Album.bSet( rfcorApplicationMediaMetaData.szAlbum.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.AlbumArtist.bSet(rfcorApplicationMediaMetaData.szAlbumArtist.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.Genre.bSet( rfcorApplicationMediaMetaData.szGenre.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.Composer.bSet( rfcorApplicationMediaMetaData.szGenre.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.TrackNumber = rfcorApplicationMediaMetaData.u32TrackNumber ;
      m_AppMediaMetaData.ApplicationMediaMetaData.AlbumTrackCount = rfcorApplicationMediaMetaData.u32AlbumTrackCount ;
      m_AppMediaMetaData.ApplicationMediaMetaData.AlbumDiscNumber = rfcorApplicationMediaMetaData.u32AlbumDiscNumber ;
      m_AppMediaMetaData.ApplicationMediaMetaData.AlbumDiscCount = rfcorApplicationMediaMetaData.u32AlbumDiscCount ;
      m_AppMediaMetaData.ApplicationMediaMetaData.ChapterCount = rfcorApplicationMediaMetaData.u32ChapterCount ;

      //Copy to FI Object, track no and total track no
      m_AppMediaMetaData.ApplicationMediaMetaData.u32QueueIndex = rfcorApplicationMediaMetaData.u32QueueIndex ;
      m_AppMediaMetaData.ApplicationMediaMetaData.u32QueueCount = rfcorApplicationMediaMetaData.u32QueueCount ;

      m_AppMediaMetaData.ApplicationMediaMetaData.ImageMIMEType.bSet( rfcorApplicationMediaMetaData.szImageMIMEType.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.ImageSize = rfcorApplicationMediaMetaData.u32ImageSize ;
      m_AppMediaMetaData.ApplicationMediaMetaData.ImageUrl.bSet( rfcorApplicationMediaMetaData.szImageUrl.c_str(), midw_fi_tclString::FI_EN_UTF8);

      //Image data should be sent as byte data
      m_AppMediaMetaData.ApplicationMediaMetaData.oImageData.clear();
      if(0 != (rfcorApplicationMediaMetaData.u32ImageSize) && (1 < rfcorApplicationMediaMetaData.rAppMediaAlbumArt.u8Items.size()))
      {
         //u32ImageSize is applicable for AAP and CP, rAppMediaAlbumArt.u8Items is used only for AAP.
         //rAppMediaAlbumArt.u8Items size is considered to differentiate between AAP and CP.
         for(size_t uIndex = 0;uIndex < rfcorApplicationMediaMetaData.u32ImageSize; uIndex++)
            m_AppMediaMetaData.ApplicationMediaMetaData.oImageData.push_back(rfcorApplicationMediaMetaData.rAppMediaAlbumArt.u8Items[uIndex]);
      }

      //This code is added for testing and debugging purpose. Please define FILEWRITE to use it
      #ifdef FILEWRITE
      std::ofstream File;
      File.open("/var/opt/bosch/dynamic/spi/Service_AlbumArt.txt", std::ios_base::in|std::ios_base::out|std::ios_base::trunc);
      if (File.is_open())
      {
         ETG_TRACE_USR4(("Opening file "));
         for(size_t i=0;i<rfcorApplicationMediaMetaData.u32ImageSize;i++)
         {
            File << rfcorApplicationMediaMetaData.rAppMediaAlbumArt.u8Items[i];
         }
         File.close();
         ETG_TRACE_USR4(("Close file "));
      }
      else
      {
         ETG_TRACE_USR4(("Error while opening file"));
      }
      #endif

      m_AppMediaMetaData.ApplicationMediaMetaData.PlayBackState.enType = static_cast<midw_fi_tcl_e8_PlayBackState::tenType>(rfcorApplicationMediaMetaData.enMediaPlayBackState) ;
      m_AppMediaMetaData.ApplicationMediaMetaData.ShuffleState.enType = static_cast<midw_fi_tcl_e8_PlayBackShuffleState::tenType>(rfcorApplicationMediaMetaData.enMediaPlayBackShuffleState) ;
      m_AppMediaMetaData.ApplicationMediaMetaData.RepeatState.enType = static_cast<midw_fi_tcl_e8_PlayBackRepeatState::tenType>(rfcorApplicationMediaMetaData.enMediaPlayBackRepeatState) ;
      m_AppMediaMetaData.ApplicationMediaMetaData.MediaType.enType = static_cast<midw_fi_tcl_e8_PlayBackMediaType::tenType>(rfcorApplicationMediaMetaData.enMediaPlayBackMediaType) ;
      m_AppMediaMetaData.ApplicationMediaMetaData.iTunesRadioAd = rfcorApplicationMediaMetaData.bITunesRadioAd ;
      m_AppMediaMetaData.ApplicationMediaMetaData.iTunesRadioStationName.bSet(rfcorApplicationMediaMetaData.szITunesRadioStationName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppMediaMetaData.ApplicationMediaMetaData.MediaRating = rfcorApplicationMediaMetaData.u8MediaRating;

      m_AppMediaMetaDataLock.vUnlock();

     //! Printing metadata in single trace
      //! because ETG can't handle more than one string in single trace
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: AppName %s",
            rfcorApplicationMediaMetaData.szAppName.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Title %s",
            rfcorApplicationMediaMetaData.szTitle.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Artist %s",
            rfcorApplicationMediaMetaData.szArtist.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Album %s",
            rfcorApplicationMediaMetaData.szAlbum.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Album Artist %s",
            rfcorApplicationMediaMetaData.szAlbumArtist.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Genre %s",
            rfcorApplicationMediaMetaData.szGenre.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Composer %s",
            rfcorApplicationMediaMetaData.szGenre.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Album TrackNumber = 0x%x, AlbumTrackCount = 0x%x, AlbumDiscNumber = 0x%x,AlbumDiscCount = 0x%x, ChapterCount = 0x%x",
            rfcorApplicationMediaMetaData.u32TrackNumber,rfcorApplicationMediaMetaData.u32AlbumTrackCount, rfcorApplicationMediaMetaData.u32AlbumDiscNumber,
            rfcorApplicationMediaMetaData.u32AlbumDiscCount,rfcorApplicationMediaMetaData.u32ChapterCount));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: List TrackNumber = %d, List TrackCount = %d",
               rfcorApplicationMediaMetaData.u32QueueIndex, rfcorApplicationMediaMetaData.u32QueueCount));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Image Mimetype  %s",
            rfcorApplicationMediaMetaData.szImageMIMEType.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: ImageSize = %d", rfcorApplicationMediaMetaData.u32ImageSize));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: Image url %s",
            rfcorApplicationMediaMetaData.szImageUrl.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: iTunes RadioStation name %s",
            rfcorApplicationMediaMetaData.szITunesRadioStationName.c_str()));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: bITunesRadioAd = %d, u8MediaRating = %d",
            rfcorApplicationMediaMetaData.bITunesRadioAd,rfcorApplicationMediaMetaData.u8MediaRating));
      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaMetaData: PlayBackState = %d, ShuffleState = %d, RepeatState = %d,MediaType = %d",
            ETG_ENUM(PLAYBACK_STATE,rfcorApplicationMediaMetaData.enMediaPlayBackState),
            ETG_ENUM(SHUFFLE_MODE, rfcorApplicationMediaMetaData.enMediaPlayBackShuffleState),
            ETG_ENUM(REPEAT_MODE, rfcorApplicationMediaMetaData.enMediaPlayBackRepeatState),
            rfcorApplicationMediaMetaData.enMediaPlayBackMediaType));
      //! Updating clients
      if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONMEDIAMETADATA))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostApplicationMediaMetaData:Error in updating clients"));
      } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONMEDIAMETADATA))
      m_AppMediaMetaDataLock.s16Lock();
      m_AppMediaMetaData.vDestroy();
      m_AppMediaMetaDataLock.vUnlock();
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostApplicationMediaPlaytime()
***************************************************************************/
t_Void spi_tclService::vPostApplicationMediaPlaytime(const trAppMediaPlaytime& rfcorApplicationMediaPlaytime,
      const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostApplicationMediaPlaytime entered"));

   SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);

   if (nullptr != m_poSpiCmdIntf)
   {
      //! Retrieving device handle
      m_AppMediaPlayBacktime.DeviceHandle = m_poSpiCmdIntf->u32GetSelectedDeviceHandle();
      m_AppMediaPlayBacktime.TotalPlayTime = rfcorApplicationMediaPlaytime.u32TotalPlayTime;
      m_AppMediaPlayBacktime.ElapsedPlayTime = rfcorApplicationMediaPlaytime.u32ElapsedPlayTime;

      ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaPlaytime: TotalPlayTime = %d, ElapsedPlayTime = %d",
            m_AppMediaPlayBacktime.TotalPlayTime,m_AppMediaPlayBacktime.ElapsedPlayTime));

      //! Updating clients
      if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_MEDIAPLAYBACKTIME))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostApplicationMediaPlaytime:Error in updating clients"));
      } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_MEDIAPLAYBACKTIME))
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostApplicationPhoneData()
***************************************************************************/
t_Void spi_tclService::vPostApplicationPhoneData(const trAppPhoneData& rfcorApplicationPhoneData,
      const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostApplicationPhoneData entered: bPhoneMetadataValid = %u",
         ETG_ENUM(BOOL, rfcorApplicationPhoneData.bPhoneMetadataValid)));
   SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);

   if (nullptr != m_poSpiCmdIntf)
   {
      m_AppPhoneDataLock.s16Lock();
      m_AppPhoneData.DeviceHandle = m_poSpiCmdIntf->u32GetSelectedDeviceHandle();
      m_AppPhoneData.PhoneDataValid = rfcorApplicationPhoneData.bPhoneMetadataValid;
      m_AppPhoneData.SignalStrength.enType = static_cast<midw_fi_tcl_e8_PhoneSignalStrength::tenType>(rfcorApplicationPhoneData.enSignalStrength);
      m_AppPhoneData.RegistrationStatus.enType = static_cast<midw_fi_tcl_e8_PhoneRegistrationStatus::tenType>(rfcorApplicationPhoneData.enRegistrationStatus);
      m_AppPhoneData.AirPlaneModeStatus.enType = static_cast<midw_fi_tcl_e8_PhoneAirPlaneModeStatus::tenType>(rfcorApplicationPhoneData.enAirPlaneModeStatus);
      m_AppPhoneData.Mute.enType = static_cast<midw_fi_tcl_e8_Mute::tenType>(rfcorApplicationPhoneData.enMute);
      m_AppPhoneData.CarrierName.bSet(rfcorApplicationPhoneData.szCarrierName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      m_AppPhoneData.BatteryChargeLevel = rfcorApplicationPhoneData.u8BatteryChargeLevel;
      m_AppPhoneData.BatteryChargingState.enType = static_cast<midw_fi_tcl_e8_BatteryChargingState::tenType>(rfcorApplicationPhoneData.enBatteryChargingState);

      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Phone data validity = %d ", ETG_ENUM(BOOL,m_AppPhoneData.PhoneDataValid)));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Signal Strength = %d ",
            ETG_ENUM(SIGNAL_STRENGTH, rfcorApplicationPhoneData.enSignalStrength)));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Registration Status = %d ",
            ETG_ENUM(REGISTRATION_STATUS, rfcorApplicationPhoneData.enRegistrationStatus)));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: AirPlaneMode Status = %d ",
            ETG_ENUM(AIRPLANE_MODE_STATUS, rfcorApplicationPhoneData.enAirPlaneModeStatus)));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Mute Status = %d ",
            ETG_ENUM(PHONE_MUTE_STATUS, rfcorApplicationPhoneData.enMute)));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Carrier Name = %s ", rfcorApplicationPhoneData.szCarrierName.c_str()));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Battery charge level = %d", rfcorApplicationPhoneData.u8BatteryChargeLevel));
      ETG_TRACE_USR2(("vPostApplicationPhoneData :: Battery charging state = %d", ETG_ENUM(BATTERY_CHARGING_STATE, rfcorApplicationPhoneData.enBatteryChargingState)));

      //! Populate the metadata to SPI fi structure
      vPopulatePhoneMetadata( m_AppPhoneData.PhoneCallMetadata,
            rfcorApplicationPhoneData.tvecPhoneCallMetaDataList);

      ETG_TRACE_USR2(("No of items in phonecallmetadata :%d", m_AppPhoneData.PhoneCallMetadata.size()));
      m_AppPhoneDataLock.vUnlock();
      //! Updating clients
      if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONPHONEDATA))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostApplicationPhoneData:Error in updating clients"));
      } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONPHONEDATA))
      m_AppPhoneDataLock.s16Lock();
      m_AppPhoneData.vDestroy();
      m_AppPhoneDataLock.vUnlock();
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostApplicationPhoneCallData()
***************************************************************************/
t_Void spi_tclService::vPostApplicationPhoneCallData(const trAppPhoneCallData& rfcorApplicationPhoneCallData,
      const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostApplicationPhoneCallData entered: "));

   SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);
   if (nullptr != m_poSpiCmdIntf)
   {
      m_AppPhoneCallDataLock.s16Lock();
      m_AppPhoneCallData.DeviceHandle = m_poSpiCmdIntf->u32GetSelectedDeviceHandle();

      //! Populate the metadata to SPI fi structure
      vPopulatePhoneExtendedMetadata( m_AppPhoneCallData.PhoneCallExtendedMetadata,
               rfcorApplicationPhoneCallData.tvecPhoneCallExtendedMetaDataList);

      ETG_TRACE_USR2(("No of items in phonecallextendedmetadata :%d", m_AppPhoneCallData.PhoneCallExtendedMetadata.size()));
      m_AppPhoneCallDataLock.vUnlock();
      //! Updating clients
      if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONPHONECALLDATA))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostApplicationPhoneCallData:Error in updating clients"));
      } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_APPLICATIONPHONECALLDATA))
      m_AppPhoneCallDataLock.s16Lock();
      m_AppPhoneCallData.vDestroy();
      m_AppPhoneCallDataLock.vUnlock();
   }
}
/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostDeviceDisplayContext()
***************************************************************************/
t_Void spi_tclService::vPostDeviceDisplayContext(t_U32 u32DeviceHandle,
                                                 t_Bool bDisplayFlag,
                                                 tenDisplayContextReason enDisplayContextReason,
                                                 tenDiPOEntity enPermScreen,
                                                 const trUserContext rcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rcUsrCntxt);
   ETG_TRACE_USR1(("spi_tclService::vPostDeviceDisplayContext:Device Id: %d enDisplayContextReason:%d bDisplayFlag-%d Permanent Display owner:%d",
         u32DeviceHandle,ETG_ENUM(DISPLAY_CONTEXT_REASON,enDisplayContextReason),bDisplayFlag, ETG_CENUM(tenDiPOEntity, enPermScreen)));

   m_DeviceDispCntxt.DeviceHandle = u32DeviceHandle ;
   m_DeviceDispCntxt.DisplayFlag = bDisplayFlag ;
   //m_DeviceDispCntxt.DisplayContext.enType = static_cast<midw_fi_tcl_e8_DisplayContext::tenType>(enDisplayContext);
   m_DeviceDispCntxt.DisplayContextReason.enType = static_cast <midw_fi_tcl_e8_DisplayContextReason::tenType> (enDisplayContextReason);
   m_DeviceDispCntxt.DisplayPermanentEntity.enType = static_cast <midw_fi_tcl_e8_Entity::tenType> (enPermScreen);

   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICEDISPLAYCONTEXT))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostDeviceDisplayContext:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICEDISPLAYCONTEXT))

}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostDeviceAudioContext()
***************************************************************************/
t_Void spi_tclService::vPostDeviceAudioContext(t_U32 u32DeviceHandle,
      t_Bool bPlayFlag, t_U8 u8AudioContext,
      tenDiPOEntity enPermMainAudio,
      const trUserContext rcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rcUsrCntxt);
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostDeviceAudioContext:Device Id: %d enAudioContext:%d bPlayFlag-%d Permanent audio owner : %d",
         u32DeviceHandle,u8AudioContext,bPlayFlag, ETG_CENUM(tenDiPOEntity, enPermMainAudio)));

   m_DeviceAudioCntxt.DeviceHandle = u32DeviceHandle;
   m_DeviceAudioCntxt.AudioFlag = bPlayFlag;
   m_DeviceAudioCntxt.AudioContext.enType = static_cast<midw_fi_tcl_e8_AudioContext::tenType>(u8AudioContext);
   m_DeviceAudioCntxt.AudioPermanentEntity.enType = static_cast<midw_fi_tcl_e8_Entity::tenType>(enPermMainAudio);
    
   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICEAUDIOCONTEXT))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostDeviceAudioContext:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICEAUDIOCONTEXT))
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostDeviceAppState()
***************************************************************************/
t_Void spi_tclService::vPostDeviceAppState(tenSpeechAppState enSpeechAppState, 
                                           tenPhoneAppState enPhoneAppState, 
                                           tenNavAppState enNavAppState, 
                                           const trUserContext rcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rcUsrCntxt);
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostDeviceAppState:enSpeechAppState: %d tenPhoneAppState:%d tenNavAppState-%d",
       enSpeechAppState,enPhoneAppState,enNavAppState));

   t_Bool bPreviousSPICallState = ((midw_fi_tcl_e8_PhoneAppState::FI_EN_SPI_APP_STATE_PHONE_ACTIVE )== m_DeviceAppState.AppStatePhone.enType)?true:false;

   m_DeviceAppState.AppStateSpeech.enType = static_cast<midw_fi_tcl_e8_SpeechAppState::tenType>(enSpeechAppState);
   m_DeviceAppState.AppStatePhone.enType = static_cast<midw_fi_tcl_e8_PhoneAppState::tenType>(enPhoneAppState);
   m_DeviceAppState.AppStateNavigation.enType = static_cast<midw_fi_tcl_e8_NavigationAppState::tenType>(enNavAppState);

   // Fix for SUZUKI-20652
   /*Whenever a Carplay call is in progress,set the SubStateData paramter of the SPM Substate property to true for substate Phone.
     This causes the SPM to Set the Phone Substate.
    When there is no active call,reset the SubStateData paramter of the SPM Substate property to false for substate Phone .
    This causes the SPM to release the Phone Substate.*/
   t_Bool bCurrentSPICallState = ((midw_fi_tcl_e8_PhoneAppState::FI_EN_SPI_APP_STATE_PHONE_ACTIVE )== m_DeviceAppState.AppStatePhone.enType)?true:false;
   
   if((nullptr != m_poSPMClient) && (bPreviousSPICallState != bCurrentSPICallState)) //Fix for 272413: [Chery M31T IHU High]
   {
      m_poSPMClient->vSendSpmPhoneSubState(bCurrentSPICallState);
   }

   if(FALSE ==  bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DIPOAPPSTATUSINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostDeviceAppState:Error in updating clients"));
   }// if(FALSE ==  bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DIPOAPPSTATUSINFO))
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostDeviceSpmSubState()
***************************************************************************/
/*!
* \fn     vPostDeviceSpmSubState()
* \brief  This function used to update LCM about the SPM substate changes
* \param  enSpmSubState  : [IN] Spm SubState type
* \param  m_bSubStateData  : [IN] Spm SubState data
**************************************************************************/
t_Void spi_tclService::vPostDeviceSpmSubState(tenSpmSubState enSpmSubState, t_Bool m_bSubStateData)
{
   ETG_TRACE_USR1((" [FUNC]vPostDeviceSpmState: enSpmSubState=%d m_bSubStateData=%d",
                                             enSpmSubState, ETG_ENUM(BOOL, m_bSubStateData)));
   if(nullptr != m_poSPMClient)
   {
      m_poSPMClient->vSendSpmSubState(enSpmSubState, m_bSubStateData);
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSessionStatusInfo()
***************************************************************************/
t_Void spi_tclService::vPostSessionStatusInfo(t_U32 u32DeviceHandle,
                                              tenDeviceCategory enDevCat,
                                              tenSessionStatus enSessionStatus)
{
   ETG_TRACE_USR1((" [FUNC]vPostSessionStatusInfo: Dev=0x%x Cat=%d SessionStatus=%d LastSentStatus=%d",
      u32DeviceHandle,ETG_ENUM(DEVICE_CATEGORY,enDevCat),ETG_ENUM(SESSION_STATUS,enSessionStatus),
      ETG_ENUM(SESSION_STATUS,m_SessionStatus.SessionStatus.enType)));

   if((enSessionStatus != (static_cast<tenSessionStatus>(m_SessionStatus.SessionStatus.enType))) ||
         (enDevCat) != (static_cast<tenDeviceCategory>(m_SessionStatus.DeviceCategory.enType)))
   {
      m_SessionStatus.DeviceHandle = u32DeviceHandle;
      m_SessionStatus.DeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(enDevCat);
      m_SessionStatus.SessionStatus.enType = static_cast<midw_fi_tcl_e8_SessionStatus::tenType>(enSessionStatus);
      ETG_TRACE_USR2((" [PARAM]vPostSessionStatusInfo: data sent Dev=0x%x Cat=%d SessionStatus=%d LastSentStatus=%d",
         u32DeviceHandle,ETG_ENUM(DEVICE_CATEGORY,enDevCat),ETG_ENUM(SESSION_STATUS,enSessionStatus),
         ETG_ENUM(SESSION_STATUS,m_SessionStatus.SessionStatus.enType)));
      //! During session status update , don't change the value for HandsetInteraction as it is not available
      //! can be populated later in vUpdateDevAuthAndAccessInfo when info is available
      if(FALSE ==  bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_SESSIONSTATUSINFO))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostSessionStatusInfo:Error in updating clients"));
      }// if(FALSE ==  bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_SESSIONSTATUSINFO))
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vPostSelectDeviceResult
 ***************************************************************************/
t_Void spi_tclService::vPostSelectDeviceResult(const trSelectDeviceRequest& corfrSelectReq, tenErrorCode enErrorCode,
         const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSelectDeviceResult-0x%x enDevConnType=%d,"
            " enDevConnReq=%d, enErrorCode = %d,n",
            corfrSelectReq.m_u32DeviceHandle,corfrSelectReq.m_enDevConnType,
            corfrSelectReq.m_enDevConnReq,
            ETG_ENUM(ERROR_CODE,enErrorCode)));
   trMsgContext rMsgContext;
   rMsgContext.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSelectDeviceMethodResult oMRSelectDevice;
   oMRSelectDevice.DeviceHandle = corfrSelectReq.m_u32DeviceHandle;
   oMRSelectDevice.DeviceConnectionType.enType = (midw_fi_tcl_e8_DeviceConnectionType::tenType)(corfrSelectReq.m_enDevConnType);
   oMRSelectDevice.DeviceConnectionReq.enType = (midw_fi_tcl_e8_DeviceConnectionReq::tenType)(corfrSelectReq.m_enDevConnReq);
   tenResponseCode enRespCode = (e8NO_ERRORS == enErrorCode)? e8SUCCESS:e8FAILURE;
   oMRSelectDevice.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)(enRespCode);
   oMRSelectDevice.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)(enErrorCode);
   oMRSelectDevice.DeviceCategory.enType = (midw_fi_tcl_e8_DeviceCategory::tenType)(corfrSelectReq.m_enDevCategory);

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSelectDevice,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSelectDeviceResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vLaunchAppResult()
***************************************************************************/
t_Void spi_tclService::vLaunchAppResult(t_U32 u32DeviceHandle, 
                                        t_U32 u32AppHandle, 
                                        tenDiPOAppType enDiPOAppType,
                                        tenResponseCode enResponseCode, 
                                        tenErrorCode enErrorCode, 
                                        const trUserContext& corfrUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vLaunchAppResult: Dev-0x%x App-0x%x Response Code-%d Errorcode-%d",
      u32DeviceHandle,u32AppHandle,enResponseCode,enErrorCode));

   trMsgContext rMsgContext;
   rMsgContext.rUserContext = corfrUsrCntxt;

   midw_smartphoneintfi_tclMsgLaunchAppMethodResult oMRLaunchApp;
   oMRLaunchApp.DeviceHandle = u32DeviceHandle;
   oMRLaunchApp.AppHandle = u32AppHandle;
   oMRLaunchApp.DiPOAppType.enType = (midw_fi_tcl_e8_DiPOAppType::tenType)enDiPOAppType;
   oMRLaunchApp.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRLaunchApp.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRLaunchApp,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vLaunchAppResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage

}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vTerminateAppResult()
***************************************************************************/
t_Void spi_tclService::vTerminateAppResult(t_U32 u32DeviceHandle, 
                                           t_U32 u32AppHandle, 
                                           tenResponseCode enResponseCode, 
                                           tenErrorCode enErrorCode, 
                                           const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vTerminateAppResult: Dev-0x%x App-0x%x Response Code-%d Errorcode-%d",
      u32DeviceHandle,u32AppHandle,enResponseCode,enErrorCode));

   trMsgContext rMsgContext;
   rMsgContext.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgTerminateAppMethodResult oMRTerminateApp;
   oMRTerminateApp.DeviceHandle = u32DeviceHandle;
   oMRTerminateApp.AppHandle = u32AppHandle;
   oMRTerminateApp.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRTerminateApp.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRTerminateApp,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vTerminateAppResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage

}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSetAppIconAttributesResult()
***************************************************************************/
t_Void spi_tclService::vPostSetAppIconAttributesResult(tenResponseCode enResponseCode,
                                                       tenErrorCode enErrorCode, 
                                                       const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSetAppIconAttributesResult()"));
   trMsgContext rMsgContext;
   rMsgContext.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSetAppIconAttributesMethodResult oMRSetAppIconAttr;

   oMRSetAppIconAttr.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSetAppIconAttr.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSetAppIconAttr,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSetAppIconAttributesResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostAppIconDataResult()
***************************************************************************/
t_Void spi_tclService::vPostAppIconDataResult(tenIconMimeType enIconMimeType,
                                              const t_U8* pcu8AppIconData, 
                                              t_U32 u32Len,
                                              const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostAppIconDataResult:%d",ETG_ENUM(ICON_MIME_TYPE,enIconMimeType)));

   trMsgContext rMsgContext;
   rMsgContext.rUserContext = rcUsrCntxt;

   t_String szMimeType="image/invalid";
   //! Retrieve Mime type info
   switch (enIconMimeType)
   {
   case e8ICON_PNG:
      szMimeType.assign("image/png");
      break;
   case e8ICON_JPEG:
      szMimeType.assign("image/jpeg");
      break;
   default:
      //Icon MIME Type is already set to invalid
      ETG_TRACE_ERR(("[ERR]: vPostAppIconDataResult:  \
                     Invalid enum value encountered for IconMimeType: %d ", (tU8)enIconMimeType));
      break;
   } //switch (enIconMimeType)

   midw_smartphoneintfi_tclMsgGetAppIconDataMethodResult oMRAppIconData;
   oMRAppIconData.IconMimeType.bSet(szMimeType.c_str(), midw_fi_tclString::FI_EN_UTF8);

   if(nullptr != pcu8AppIconData)
   {
      for(t_U32 u32Index=0;u32Index<u32Len;++u32Index)
      {
         oMRAppIconData.AppIconData.push_back(pcu8AppIconData[u32Index]);
      }//for(t_U32 u32Index=0;u32Index<u32Len;++u32Index)
   }//if(nullptr != pcu8AppIconData)

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRAppIconData,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostAppIconDataResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage(...))

   //! De-allocate memory used by message
   oMRAppIconData.vDestroy();
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSetVideoBlockingModeResult()
***************************************************************************/
t_Void spi_tclService::vPostSetVideoBlockingModeResult(tenResponseCode enResponseCode,
                                                       tenErrorCode enErrorCode, 
                                                       const trUserContext& corfrcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSetVideoBlockingModeResult:enErrorCode:%d",enErrorCode));

   trMsgContext rMsgContext;
   rMsgContext.rUserContext = corfrcUsrCntxt;

   midw_smartphoneintfi_tclMsgSetVideoBlockingModeMethodResult oMRSetVideoVlockingMode;
   oMRSetVideoVlockingMode.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSetVideoVlockingMode.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSetVideoVlockingMode,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSetVideoBlockingModeResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vPostBluetoothDeviceStatus(...)
 ***************************************************************************/
t_Void spi_tclService::vPostBluetoothDeviceStatus(t_U32 u32BluetoothDevHandle,
                                                  t_U32 u32ProjectionDevHandle,
                                                  tenBTChangeInfo enBTChange,
                                                  t_U8 u8Profiles,
                                                  t_Bool bSameDevice,
                                                  t_Bool bCallActive)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostBluetoothDeviceStatus: "
         "u32BluetoothDevHandle:%d, u32ProjectionDevHandle:%d, enBTChange:%d, bSameDevice:%d, bCallActive:%d u8Profiles =%d",
         u32BluetoothDevHandle, u32ProjectionDevHandle,
         ETG_ENUM(BT_CHANGE_INFO, enBTChange),
         ETG_ENUM(BOOL, bSameDevice),
         ETG_ENUM(BOOL, bCallActive),u8Profiles));

   m_BTDeviceStatusMsg.BluetoothDeviceHandle = u32BluetoothDevHandle;
   m_BTDeviceStatusMsg.ProjectionDeviceHandle = u32ProjectionDevHandle;
   m_BTDeviceStatusMsg.BTChangeInfo.enType = static_cast<midw_fi_tcl_e8_BTChangeInfo::tenType>(enBTChange);
   m_BTDeviceStatusMsg.ConnectedProfiles = u8Profiles;
   m_BTDeviceStatusMsg.SameDevice = bSameDevice;
   m_BTDeviceStatusMsg.CallActiveStatus = bCallActive;

   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_BLUETOOTHDEVICESTATUS))
   {
      ETG_TRACE_ERR(("vPostBluetoothDeviceStatus:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_BLUETOOTHDEVICESTATUS))
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSetOrientationModeResult()
***************************************************************************/
t_Void spi_tclService::vPostSetOrientationModeResult(tenResponseCode enResponseCode,
                                                     tenErrorCode enErrorCode, 
                                                     const trUserContext& corfrcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSetOrientationModeResult:enErrorCode:%d",enErrorCode));

   trMsgContext rMsgContext;
   rMsgContext.rUserContext = corfrcUsrCntxt;

   midw_smartphoneintfi_tclMsgSetOrientationModeMethodResult oMRSetOrientationMode;
   oMRSetOrientationMode.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSetOrientationMode.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSetOrientationMode,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSetOrientationModeResult:Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSetMLNotificationEnabledInfoResult()
***************************************************************************/
t_Void spi_tclService::vPostSetMLNotificationEnabledInfoResult(t_U32 u32DeviceHandle,
                                                               tenResponseCode enResponseCode, 
                                                               tenErrorCode enErrorCode, 
                                                               const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSetMLNotificationEnabledInfoResult:enErrorCode:%d",enErrorCode));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSetMLNotificationEnabledInfoMethodResult oMRSetMLNotiEnabledInfo;
   oMRSetMLNotiEnabledInfo.DeviceHandle = u32DeviceHandle;
   oMRSetMLNotiEnabledInfo.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSetMLNotiEnabledInfo.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSetMLNotiEnabledInfo,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSetMLNotificationEnabledInfoResult:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostInvokeNotificationActionResult()
***************************************************************************/
t_Void spi_tclService::vPostInvokeNotificationActionResult(tenResponseCode enResponseCode,
                                                           tenErrorCode enErrorCode,
                                                           const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostInvokeNotificationActionResult:enErrorCode:%d",enErrorCode));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgInvokeNotificationActionMethodResult oMRInvokeNotiAction;
   oMRInvokeNotiAction.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRInvokeNotiAction.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRInvokeNotiAction,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostInvokeNotificationActionResult:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSendTouchEvent()
***************************************************************************/
t_Void spi_tclService::vPostSendTouchEvent(tenResponseCode enResponseCode,
                                           tenErrorCode enErrorCode, 
                                           const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSendTouchEvent:enErrorCode:%d",enErrorCode));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSendTouchEventMethodResult oMRSendTouchEvent;
   oMRSendTouchEvent.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSendTouchEvent.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSendTouchEvent,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSendTouchEvent:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSendKeyEvent()
***************************************************************************/
t_Void spi_tclService::vPostSendKeyEvent(tenResponseCode enResponseCode,
                                         tenErrorCode enErrorCode, 
                                         const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSendKeyEvent:enErrorCode:%d",enErrorCode));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSendKeyEventMethodResult oMRSendKeyEvent;
   oMRSendKeyEvent.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSendKeyEvent.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSendKeyEvent,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSendKeyEvent:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclService::bRequestAudioActivation(t_U8)
 ***************************************************************************/
t_Bool spi_tclService::bRequestAudioActivation(t_U8 u8SourceNum)
{
   t_Bool bRetVal = false;
   ETG_TRACE_USR1((" [FUNC]spi_tclService::bRequestAudioActivation entered %d", u8SourceNum));

   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = (t_Bool)(m_poAudioPolicy->bRequestAudioActivation(u8SourceNum));
   }
   return bRetVal;
}//spi_tclService::bRequestAudioActivation(t_U8 u8SourceNum)

/***************************************************************************
 ** FUNCTION:  bool spi_tclService::bRequestAudioDeactivation(t_U8, tenSrcAvailabilityReason)
 ***************************************************************************/
t_Bool spi_tclService::bRequestAudioDeactivation(t_U8 u8SourceNum, tenSrcAvailabilityReason enSrcAvlReason)
{
   t_Bool bRetVal = false;
   ETG_TRACE_USR1((" [FUNC]spi_tclService::bRequestAudioDeactivation entered u8SourceNum = %d, enSrcAvlReason = %d", u8SourceNum, ETG_ENUM(AVAIL_REASON,enSrcAvlReason)));

   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = (t_Bool)(m_poAudioPolicy->bRequestAudioDeactivation(u8SourceNum, enSrcAvlReason));
   }
   return bRetVal;
}//spi_tclService::bRequestAudioDeactivation(t_U8 , tenSrcAvailabilityReason )

/***************************************************************************
 ** FUNCTION:  bool spi_tclService::bPauseAudioActivity(t_U8)
 ***************************************************************************/
t_Bool spi_tclService::bPauseAudioActivity(t_U8 u8SourceNum)
{
   t_Bool bRetVal = false;
   ETG_TRACE_USR1(("[FUNC]spi_tclService:: bPauseAudioActivity entered %d", u8SourceNum));

   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = (t_Bool)(m_poAudioPolicy->bPauseAudioActivity(u8SourceNum));
   }
   return bRetVal;
}//spi_tclService::bPauseAudioActivity(t_U8 u8SourceNum)

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vStartSourceActivityResult(t_U8,t_Bool)
 ***************************************************************************/
t_Void spi_tclService::vStartSourceActivityResult(t_U8 u8SourceNum,
      t_Bool bError)
{
   ETG_TRACE_USR1((" [FUNC]spi_tclService::vStartSourceActivityResult entered %d %d ", u8SourceNum, bError));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->vStartSourceActivityResult(u8SourceNum, bError);
   }
}//spi_tclService::vStartSourceActivityResult(t_U8 t_Bool)

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vStopSourceActivityResult(t_U8,t_Bool)
 ***************************************************************************/
t_Void spi_tclService::vStopSourceActivityResult(t_U8 u8SourceNum,
      t_Bool bError)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vStopSourceActivityResult entered %d %d", u8SourceNum, bError));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->vStopSourceActivityResult(u8SourceNum, bError);
   }
}//spi_tclService::vStopSourceActivityResult(t_U8 t_Bool)

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPauseSourceActivityResult(t_U8,t_Bool)
 ***************************************************************************/
t_Void spi_tclService::vPauseSourceActivityResult(t_U8 u8SourceNum,
      t_Bool bError)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPauseSourceActivityResult entered %d %d", u8SourceNum, bError));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->vPauseSourceActivityResult(u8SourceNum, bError);
   }
}//spi_tclService::vPauseSourceActivityResult(t_U8 t_Bool)

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::bSetSourceAvailability(t_U8,t_Bool)
 ***************************************************************************/
t_Bool spi_tclService::bSetSrcAvailability(t_U8 u8SourceNum, tenSrcAvailability enSrcAvailability, tenSrcAvailabilityReason enSrcAvailReason)
{
   t_Bool bRetVal = false;
   ETG_TRACE_USR1((" [FUNC]spi_tclService::bSetSrcAvailability entered u8SourceNum = %d, enSrcAvailability = %d, Availability reason = %d", u8SourceNum, ETG_ENUM(SRC_AVAILABILITY,enSrcAvailability), ETG_ENUM(AVAILABILITY_REASON,enSrcAvailReason)));

   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = (t_Bool)(m_poAudioPolicy->bSetSrcAvailability(u8SourceNum, enSrcAvailability, enSrcAvailReason));
   }
   return bRetVal;
}//spi_tclService::bSetSourceAvailability(t_U8 u8SourceNum)

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vSetServiceAvailable()
 ***************************************************************************/
t_Void spi_tclService::vSetServiceAvailable(t_Bool bAvail)
{
   ETG_TRACE_USR1((" [FUNC]spi_tclService::vSetServiceAvailable entered  bAvail = %d ", bAvail));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->vSetServiceAvailable(bAvail);
   }
}//spi_tclService::vSetServiceAvailable(t_Bool bAvail)

/***************************************************************************
** FUNCTION: t_Bool spi_tclService::bSetAudioDucking()
***************************************************************************/
t_Bool spi_tclService::bSetAudioDucking(const t_U8 cou8SrcNum,const t_U16 cou16RampDuration,
      const t_U8 cou8VolumeindB,
      const tenDuckingType coenDuckingType)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::bSetAudioDucking entered %d %d %d ",
         cou16RampDuration, cou8VolumeindB, ETG_ENUM(AUDIO_DUCK_TYPE, coenDuckingType)));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->bSetAudioDucking(cou8SrcNum,cou16RampDuration,
            cou8VolumeindB, coenDuckingType);
   }
   return true;
}//spi_tclService::bSetAudioDucking(const t_U16 cou16RampDuration,...)

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::bSetSourceMute(t_U8)
 ***************************************************************************/
t_Bool spi_tclService::bSetSourceMute(t_U8 u8SourceNum, t_Bool bIsMute)
{
   t_Bool bRetVal = false;
   ETG_TRACE_USR1((" [FUNC]spi_tclService::bSetSourceMute entered for Src = %d, IsMute = %d ",
            u8SourceNum, ETG_ENUM(BOOL, bIsMute)));

   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = (t_Bool)(m_poAudioPolicy->bSetSourceMute(u8SourceNum, bIsMute));
   }
   return bRetVal;
}//spi_tclService::bSetSourceMute(t_U8 u8SourceNum, t_Bool bIsMute)

/***************************************************************************
** FUNCTION:  tBool spi_tclService::bOnSrcActivity(
arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
 ***************************************************************************/
tBool spi_tclService::bOnSrcActivity(arl_tenSource enSrcNum,
      const arl_tSrcActivity& rfcoSrcActivity)
{
   ETG_TRACE_USR1((" [FUNC]spi_tclService::bOnSrcActivity entered %d %d", enSrcNum, rfcoSrcActivity.enType));

   tBool bRetVal = false;
   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = m_poAudioPolicy->bOnSrcActivity(enSrcNum, rfcoSrcActivity);
   }
   return bRetVal;
} //spi_tclService::bOnSrcActivityStart(arl_tenSource,const arl_tSrcActivity&)



/***************************************************************************
** FUNCTION:  tBool spi_tclService::bOnAllocate(arl_tenSource enSrcNum,
                        const arl_tAllocRouteResult& rfcoAllocRoute)
***************************************************************************/
tBool spi_tclService::bOnAllocate(arl_tenSource enSrcNum,
                             const arl_tAllocRouteResult& rfcoAllocRoute)
{
   ETG_TRACE_USR1((" [FUNC]spi_tclService::bOnAllocate entered %d", enSrcNum));

   tBool bRetVal = false;
   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = m_poAudioPolicy->bOnAllocate(enSrcNum, rfcoAllocRoute);
   }
   return bRetVal;
}//spi_tclService::bOnAllocate(arl_tenSource,const arl_tAllocRouteResult&)

/************************************************************************************
 ** FUNCTION:  tBool spi_tclService::bOnDeAllocate(arl_tenSource enSrcNum)
 *************************************************************************************/
tBool spi_tclService::bOnDeAllocate(arl_tenSource enSrcNum)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService:: bOnDeAllocate entered %d", enSrcNum));

   tBool bRetVal = false;
   if (nullptr != m_poAudioPolicy)
   {
      bRetVal = m_poAudioPolicy->bOnDeAllocate(enSrcNum);
   }
   return bRetVal;
}//spi_tclService::bOnDeAllocate(arl_tenSource)

/***************************************************************************
** FUNCTION:  tVoid spi_tclService::vOnError()
 ***************************************************************************/
tVoid spi_tclService::vOnError(tU8 u8SrcNum, arl_tenISourceError cenError)
{
   ETG_TRACE_USR1((" [FUNC]spi_tclService::vOnError entered %d %d ", u8SrcNum, cenError));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->vOnError(u8SrcNum, cenError);
   }
}// spi_tclService::vOnError(tU8 u8SrcNum,arl_tenISourceError cenError)

/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vSetAudioConfig(const trAudioConfig& corfConfig)
 ***************************************************************************/
t_Void spi_tclService::vSetAudioConfig(const trAudioConfig& corfConfig)
{
   ETG_TRACE_USR1((" [FUNC]spi_tclService::vSetAudioConfig entered "));

   if (nullptr != m_poAudioPolicy)
   {
      m_poAudioPolicy->vSetAudioConfig(corfConfig);
   }
}

/***************************End of ARL methods****************************/


/**************************************************************************
** FUNCTION:  t_Void spi_tclService::vInsertKeyCodeToMap()
**************************************************************************/
t_Void spi_tclService::vInsertKeyCodeToMap()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vInsertKeyCodeToMap entered "));

   t_U32 u32Length = sizeof(aKeyCode)/sizeof(trKeyCode);

   for(t_U32 u32Index=0; u32Index < u32Length ;++u32Index)
   {
      m_mapKeyCode.insert(std::pair<spi_tenFiKeyCode,tenKeyCode>
         (aKeyCode[u32Index].e32SpiKeyCode,aKeyCode[u32Index].enKeyCode));

      m_mapFiKeyCode.insert(std::pair<tenKeyCode,spi_tenFiKeyCode>
         (aKeyCode[u32Index].enKeyCode,aKeyCode[u32Index].e32SpiKeyCode));
   }
   
    ETG_TRACE_USR1(("[FUNC]spi_tclService::vInsertKeyCodeToMap Printing Key Value Pair of the Map "));
   //Iterator to iterate through the Key Codes map
   std::map<spi_tenFiKeyCode,tenKeyCode>::const_iterator itKeyCode;
   for(itKeyCode = m_mapKeyCode.begin();itKeyCode != m_mapKeyCode.end();++itKeyCode)
   {
	   ETG_TRACE_USR1(("spi_tclService::vInsertKeyCodeToMap: Key in FI Types-0x%x ",itKeyCode->first));
	   ETG_TRACE_USR1(("spi_tclService::vInsertKeyCodeToMap: Value in SPI Types-0x%x ",itKeyCode->second));
   }
}

/***************************************************************************
** FUNCTION: tenKeyCode spi_tclService::enGetKeyCode()const
***************************************************************************/
tenKeyCode spi_tclService::enGetKeyCode(spi_tenFiKeyCode e32SpiKeyCode)const
{
   //Default KeyCode
   tenKeyCode enKeyCode = e32INVALID_KEY;
   //Iterator to iterate through the Key Codes map
   std::map<spi_tenFiKeyCode,tenKeyCode>::const_iterator itKeyCode;

   //Find the requested value and return the associated enum value with that.
   itKeyCode = m_mapKeyCode.find(e32SpiKeyCode);
   if (m_mapKeyCode.end() != itKeyCode )
   {
      enKeyCode = itKeyCode->second ;
   }

   ETG_TRACE_USR1(("spi_tclService::enGetKeyCode: KeyCode in SPI Types-0x%x ",enKeyCode));

   return enKeyCode;
}
/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSessionStatusInfo()
***************************************************************************/
t_Void spi_tclService::vSendSessionStatusInfo(t_U32 u32DeviceHandle,
                                              tenDeviceCategory enDevCat,
                                              tenSessionStatus enSessionStatus)
{
   ETG_TRACE_USR1(("spi_tclService::vSendSessionStatusInfo:Dev-0x%x Cat-%d Status-%d",
      u32DeviceHandle,ETG_ENUM(DEVICE_CATEGORY,enDevCat),ETG_ENUM(SESSION_STATUS,enSessionStatus)));
   //Update the status to HMI
   vPostSessionStatusInfo(u32DeviceHandle,enDevCat,enSessionStatus);
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vUpdateAppBlockingInfo()
***************************************************************************/
t_Void spi_tclService::vUpdateAppBlockingInfo(t_U32 u32DeviceHandle,
                                              tenDeviceCategory enDevCat,
                                              tenSessionStatus enSessionStatus)
{
   ETG_TRACE_USR1(("spi_tclService::vUpdateAppBlockingInfo:Dev-0x%x Cat-%d Status-%d",
      u32DeviceHandle,ETG_ENUM(DEVICE_CATEGORY,enDevCat),ETG_ENUM(SESSION_STATUS,enSessionStatus)));
   //Update the status to HMI
   vPostSessionStatusInfo(u32DeviceHandle,enDevCat,enSessionStatus);
}

/***************************************************************************
** FUNCTION: t_Void vUpdateSessionStatusInfo()
***************************************************************************/
t_Void spi_tclService::vUpdateSessionStatusInfo(t_U32 u32DeviceHandle,
                                tenDeviceCategory enDevCat,
                                tenSessionStatus enSessionStatus)
{
   ETG_TRACE_USR1(("spi_tclService::vUpdateSessionStatusInfo:Dev-0x%x Cat-%d Status-%d",
      u32DeviceHandle,ETG_ENUM(DEVICE_CATEGORY,enDevCat),ETG_ENUM(SESSION_STATUS,enSessionStatus)));
   //Update the status to HMI
   vPostSessionStatusInfo(u32DeviceHandle,enDevCat,enSessionStatus);
}

// @TODO -Dead Code to be removed
/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vOnGPSData(trGPSData rGPSData)
***************************************************************************/
t_Void spi_tclService::vOnGPSData(trGPSData rGpsData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnGPSData() entered "));

   if(nullptr!= m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vOnGPSData(rGpsData);
   }
}
// @TODO -Dead Code to be removed
/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vOnSensorData(trSensorData rSensorData)
***************************************************************************/
t_Void spi_tclService::vOnSensorData(trSensorData rSensorData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnSensorData() entered "));

   if(nullptr!= m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vOnSensorData(rSensorData);
   }
}
// @TODO -Dead Code to be removed
/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vOnAccSensorData
** (const std::vector<trAccSensorData>& corfvecrAccSensorData)
***************************************************************************/
t_Void spi_tclService::vOnAccSensorData(const std::vector<trAccSensorData>& corfvecrAccSensorData)
{
   if(nullptr!= m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vOnAccSensorData(corfvecrAccSensorData);
   }
}
// @TODO -Dead Code to be removed
/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vOnGyroSensorData
** (const std::vector<trGyroSensorData>& corfvecrGyroSensorData)
***************************************************************************/
t_Void spi_tclService::vOnGyroSensorData(const std::vector<trGyroSensorData>& corfvecrGyroSensorData)
{
   if(nullptr!= m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vOnGyroSensorData(corfvecrGyroSensorData);
   }
}

/**************************************************************************
** FUNCTION   : t_Void spi_tclService:: vSetRegion(tenRegion enRegion)
***************************************************************************/
t_Void spi_tclService::vSetRegion(tenRegion enRegion)
{
   if (nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vSetRegion(enRegion);
   }//if (nullptr != m_poSpiCmdIntf)
}

/***************************************************************************
** FUNCTION: tVoid spi_tclService::vOnMSSetDisplayAttributes
***************************************************************************/
tVoid spi_tclService::vOnMSSetDisplayAttributes(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("spi_tclService::vOnMSSetDisplayAttributes"));

   spi_tMsgSetDisplayAttributesMS oDispAttrMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

   if ((TRUE == oDispAttrMS.bIsValid())&&(nullptr != m_poSpiCmdIntf))
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
      trDisplayAttributes rDispAttr;
      rDispAttr.u16ScreenHeight = oDispAttrMS.DisplayAttributes.u16ScreenHeight;
      rDispAttr.u16ScreenWidth = oDispAttrMS.DisplayAttributes.u16ScreenWidth;
      rDispAttr.u16ScreenHeightMm = oDispAttrMS.DisplayAttributes.u16ScreenHeightMm;
      rDispAttr.u16ScreenWidthMm = oDispAttrMS.DisplayAttributes.u16ScreenWidthMm;
      rDispAttr.enDisplayType =  static_cast<tenDisplayType>(oDispAttrMS.DisplayAttributes.enDisplayType.enType);
      for(t_U8 u8Index=0;((u8Index<oDispAttrMS.DisplayAttributes.DisplayLayerAttributes.size()) && (u8Index < e8DEV_TYPE_MAX));u8Index++)
      {
         trDisplayLayerAttributes rDispLayerAttr;
         midw_fi_tcl_DisplayLayerAttributes oDispLayerAttr = oDispAttrMS.DisplayAttributes.DisplayLayerAttributes[u8Index];
         rDispLayerAttr.enDevCat = static_cast<tenDeviceCategory> (oDispLayerAttr.enDeviceCategory.enType);
         ETG_TRACE_USR4(("Display Config : dev category %d",ETG_ENUM(DEVICE_CATEGORY,rDispLayerAttr.enDevCat)));

         rDispLayerAttr.u16TouchLayerID = oDispLayerAttr.u16TouchLayerID;
         rDispLayerAttr.u16TouchSurfaceID = oDispLayerAttr.u16TouchSurfaceID;
         rDispLayerAttr.u16VideoLayerID = oDispLayerAttr.u16VideoLayerID;
         rDispLayerAttr.u16VideoSurfaceID = oDispLayerAttr.u16VideoSurfaceID;
         rDispLayerAttr.u16LayerHeight = oDispLayerAttr.u16LayerHeight;
         rDispLayerAttr.u16LayerWidth = oDispLayerAttr.u16LayerWidth;
         rDispLayerAttr.u16DisplayWidthMm = oDispLayerAttr.u16LayerWidthInMM;
         rDispLayerAttr.u16DisplayHeightMm = oDispLayerAttr.u16LayerHeightInMM;
         rDispLayerAttr.enTouchEventType = static_cast<tenTouchEventType>(oDispLayerAttr.enDisplayTouchType.enType);
         GET_STRINGDATA_FROM_FI_STRINGOBJ(oDispLayerAttr.szPixelAspectRatio,midw_fi_tclString::FI_EN_UTF8,rDispLayerAttr.szPixelAspectRatio);
         rDispLayerAttr.u16dpi = oDispLayerAttr.u16DPI;
         rDispLayerAttr.u16PriorityIndex = oDispLayerAttr.u16PriorityIndex;
         rDispAttr.vecDisplayLayerAttr.push_back(rDispLayerAttr);
      }//for(t_U8 u8Index=0;u8Index<oDispAttrMS.DisplayLayerAttributes.size();u8Index++)

      m_poSpiCmdIntf->vSetDispAttr(rDispAttr);

      midw_smartphoneintfi_tclMsgSetDisplayAttributesMethodResult oMRSetDisplayAttributes;
      oMRSetDisplayAttributes.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRSetDisplayAttributes.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRSetDisplayAttributes,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetDisplayAttributes:Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage
   }//if (  (TRUE == oDispAttrMS.bIsValid
   else
   {
      ETG_TRACE_ERR(("spi_tclService::vOnMSSetDisplayAttributes- Invalid Update"));
   }
}
/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostKeyIconDataResult()
***************************************************************************/
t_Void spi_tclService::vPostKeyIconDataResult(const t_U32 cou32DevId,
                                              const t_U8* pczKeyIconData,
                                              t_U32 u32Len,
                                              const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclService::vPostKeyIconDataResult"));

   trMsgContext rMsgContext;
   rMsgContext.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgGetKeyIconDataMethodResult oMRKeyIconData;
   oMRKeyIconData.DeviceHandle = cou32DevId;

   if(nullptr != pczKeyIconData)
   {
      for(t_U32 u32Index=0;u32Index<u32Len;++u32Index)
      {
         oMRKeyIconData.KeyIconData.push_back(pczKeyIconData[u32Index]);
      }
   }

   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRKeyIconData,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostKeyIconDataResult:Error in posting Message"));
   }

   //! De-allocate memory used by message
   oMRKeyIconData.vDestroy();
}
/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostMLServerCapInfo()
***************************************************************************/
t_Void spi_tclService::vPostMLServerCapInfo(const t_U32 cou32DevId,
           t_U16 u16NumXDevices,
           trMLSrvKeyCapabilities rSrvKeyCapabilities,
           t_U16 u16ValidityOfData)
{
   //! Note: Initialization of the status message are done by CCA framework, so it is
   //! not required to initialize in SPI.

   //! Populate the Server key capabilities
   m_MLSrvKeyCapabilities.DeviceHandle =cou32DevId;
   m_MLSrvKeyCapabilities.NumXDeviceKeys =u16NumXDevices;
   m_MLSrvKeyCapabilities.ValidityOfData = u16ValidityOfData;
   m_MLSrvKeyCapabilities.VoiceRecognitionSupportInfo.enType = midw_fi_tcl_e8_SupportInfo::FI_EN_SUPPORT_NOT_KNOWN;

   vPopulateSrvKeyCapabilities(m_MLSrvKeyCapabilities.XDeviceKeysList,rSrvKeyCapabilities.vecrXDeviceKeyInfo,
                               m_MLSrvKeyCapabilities.rKeyCapabilities,rSrvKeyCapabilities.rKeyCapabilities,
                               u16NumXDevices);

   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_MLSERVERKEYCAPABILITIES))
     {
        ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostMLServerCapInfo:Error in updating clients"));
     }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostVRSupportInfo()
***************************************************************************/
t_Void spi_tclService::vPostVRSupportInfo(t_U32 cou32DevId, t_U16 u16ValidityOfData,
         t_Bool bVoiceRecognitionSupportInfo)
{
   //! Note: Initialization of the status message are done by CCA framework, so it is
   //! not required to initialize in SPI.

   ETG_TRACE_USR1(("spi_tclService::vPostVRSupportInfo Device id = %d, Validity = %d, VR Support = %d",
            cou32DevId, u16ValidityOfData, ETG_ENUM(BOOL,bVoiceRecognitionSupportInfo)));

   //! Populate the VR capabilities
   m_MLSrvKeyCapabilities.DeviceHandle =cou32DevId;
   m_MLSrvKeyCapabilities.ValidityOfData = u16ValidityOfData;
   m_MLSrvKeyCapabilities.VoiceRecognitionSupportInfo.enType = ((bVoiceRecognitionSupportInfo) ?
                                     (midw_fi_tcl_e8_SupportInfo::FI_EN_SUPPORTED) : (midw_fi_tcl_e8_SupportInfo::FI_EN_NOT_SUPPORTED));

   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_MLSERVERKEYCAPABILITIES))
     {
        ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostVRSupportInfo:Error in updating clients"));
     }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSGetKeyIconData()
***************************************************************************/
t_Void spi_tclService::vOnMSGetKeyIconData(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSGetKeyIconData"));

   spi_tMsgGetKeyIconDataMS oGetKeyIconData(*poMessage,
      SPI_SERVICE_FI_MAJOR_VERSION);

   if (
      (TRUE == oGetKeyIconData.bIsValid())
      &&
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trUserContext rUsrContext;
      CPY_TO_USRCNTXT(poMessage, rUsrContext);

      t_String szIconUrl;
      szIconUrl.assign(oGetKeyIconData.KeyIconURL.szValue);

      t_U32 u32DeviceHandle = oGetKeyIconData.DeviceHandle;

      m_poSpiCmdIntf->vGetKeyIconData(u32DeviceHandle,szIconUrl,rUsrContext);

   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vPopulateSrvKeyCapabilities()
***************************************************************************/
tVoid spi_tclService::vPopulateSrvKeyCapabilities(std::vector<midw_fi_tcl_XDeviceKeys> &rfrvecXDeviceKeyInfo,
                                    std::vector<trXDeviceKeyDetails> vecrXDeviceKeyInfo,
                                    midw_fi_tcl_KeyCapabilities &rKeyCapabilities,
                                    trKeyCapabilities rMLKeyCapabilities,t_U16 u16NumXDevices)
{
   ETG_TRACE_USR1(("spi_tclService::vPopulateSrvKeyCapabilities Number of XDevice Keys :%d",u16NumXDevices));
   //! Since the data types of CCA framework and SPI are not exactly the same
   //! it is required to individually copy each value.

   //! Copy the Key Capabilities
   rKeyCapabilities.u32KnobKeySupport   = rMLKeyCapabilities.u32KnobKeySupport;
   rKeyCapabilities.u32DeviceKeySupport = rMLKeyCapabilities.u32DeviceKeySupport;
   rKeyCapabilities.u32MiscKeySupport   =   rMLKeyCapabilities.u32MiscKeySupport;
   rKeyCapabilities.u32MultimediaKeySupport = rMLKeyCapabilities.u32MultimediaKeySupport;
   rKeyCapabilities.u32PointerTouchSupport = rMLKeyCapabilities.u32PointerTouchSupport;

   //!Copy the XDevice Key Info

   for (t_U16 u16VIndex = 0 ; u16VIndex < u16NumXDevices; ++u16VIndex)
      {
         midw_fi_tcl_XDeviceKeys oXDeviceKeys;
         oXDeviceKeys.szName.bSet(vecrXDeviceKeyInfo[u16VIndex].szXDeviceName.c_str(), midw_fi_tclString::FI_EN_UTF8);

         //This field is deprectated hence setting default values.
         oXDeviceKeys.bMandatory = false;

         //Set the symbol value for the XDevice Key.
         oXDeviceKeys.e32SymbolValue.enType = static_cast<midw_fi_tcl_e32_KeyCode::tenType>
                                              (vecrXDeviceKeyInfo[u16VIndex].enSymbolValue);


         ETG_TRACE_USR4(("X Device Keys[%d]:KeyName-%s",u16VIndex,vecrXDeviceKeyInfo[u16VIndex].szXDeviceName.c_str()));
         ETG_TRACE_USR4(("X Device Keys[%d]:SymbolValue-0x%x Mandatory-%d iconListLength-%d",u16VIndex,
            vecrXDeviceKeyInfo[u16VIndex].enSymbolValue,oXDeviceKeys.bMandatory,vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList.size()));

         t_U8 u8IconListSize = static_cast <t_U8>(vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList.size());
         if (0 < u8IconListSize)
            {
               for (t_U8 u8Index=0; u8Index <u8IconListSize; ++u8Index )
                  {
                     midw_fi_tcl_IconAttributes oIconAttributes;
                     oIconAttributes.u32IconWidth  =  vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList[u8Index].u32IconWidth;
                     oIconAttributes.u32IconHeight =  vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList[u8Index].u32IconHeight;
                     oIconAttributes.u32IconDepth  =  vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList[u8Index].u32IconDepth;
                     oIconAttributes.enIconMimeType.enType = static_cast<midw_fi_tcl_e8_IconMimeType::tenType>
                                                      (vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList[u8Index].enIconMimeType);
                     oIconAttributes.szIconURL.bSet(vecrXDeviceKeyInfo[u16VIndex].tvecKeyIconList[u8Index].szIconURL.c_str(),
                                                    midw_fi_tclString::FI_EN_UTF8);

                     //Push back the Icon list into the XDevice Object
                     oXDeviceKeys.IconList.push_back(oIconAttributes);
                  }
            }

         //Populate each XDevice Key
         rfrvecXDeviceKeyInfo.push_back(oXDeviceKeys);
      }

}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSendRotaryCtrlEvent()
***************************************************************************/

tVoid spi_tclService::vOnMSSendRotaryCtrlEvent(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSSendRotaryCtrlEvent"));

   spi_tMsgRotaryCtrlEventMS oRotaryCtrlEvent(*poMessage,
      SPI_SERVICE_FI_MAJOR_VERSION);

   if (
      (TRUE == oRotaryCtrlEvent.bIsValid())
      &&
      (nullptr != m_poSpiCmdIntf)
      )
   {
      trUserContext rUsrContext;
      CPY_TO_USRCNTXT(poMessage, rUsrContext);

      ETG_TRACE_USR4(("Encoder Delta Counts : %d",oRotaryCtrlEvent.ControllerDeltaCounts));

      m_poSpiCmdIntf->vSendKnobKeyEvent(oRotaryCtrlEvent.DeviceHandle,oRotaryCtrlEvent.ControllerDeltaCounts
                                       ,rUsrContext);

      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      midw_smartphoneintfi_tclMsgRotaryControllerEventMethodResult oMRRotaryControllerEvent;
      oMRRotaryControllerEvent.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRRotaryControllerEvent.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRRotaryControllerEvent,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]vOnMSSendRotaryCtrlEvent:Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage
   }
}


/***************************************************************************
** FUNCTION: tVoid spi_tclService::vPostDeviceUsagePrefResult(t_U32 u32DeviceHandle...
***************************************************************************/
t_Void spi_tclService::vPostDeviceUsagePrefResult(const t_U32 coU32DeviceHandle,
      tenErrorCode enErrorCode,
      tenDeviceCategory enDeviceCategory,
      tenEnabledInfo enUsagePref,
      const trUserContext &corfrUsrCtxt)
{
   SPI_INTENTIONALLY_UNUSED(enDeviceCategory);
   SPI_INTENTIONALLY_UNUSED(enUsagePref);
   ETG_TRACE_USR1(("spi_tclService::vPostDeviceUsagePrefResult:enErrorCode:%d", enErrorCode));
   //! Send ChangeDeviceProjectionEnable method result
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = corfrUsrCtxt;

   midw_smartphoneintfi_tclMsgSetDeviceUsagePreferenceMethodResult oMRSetSetDeviceUsagePreference;
   oMRSetSetDeviceUsagePreference.DeviceHandle = coU32DeviceHandle;
   oMRSetSetDeviceUsagePreference.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType) enErrorCode;
   if (oMRSetSetDeviceUsagePreference.ErrorCode.enType == midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR)
   {
      oMRSetSetDeviceUsagePreference.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
   }
   else
   {
      oMRSetSetDeviceUsagePreference.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_FAILURE;
   }
   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oMRSetSetDeviceUsagePreference, rMsgCntxt, SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("vPostDeviceUsagePrefResult:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage

}//! end of vPostDeviceUsagePrefResult()

/***************************************************************************
** FUNCTION: tVoid spi_tclService::vPopulatePhoneMetadata(...
***************************************************************************/
t_Void spi_tclService::vPopulatePhoneMetadata( std::vector<midw_fi_tcl_ApplicationPhoneCallMetadata> &rfrvecPhoneCallMetadata,
                                               std::vector<trPhoneCallMetaData> vecPhoneCallMetaDataList )
{
   t_U8 u8NoOfPhonCallMetaDataSize = static_cast <t_U8>(vecPhoneCallMetaDataList.size());
   ETG_TRACE_USR1(("spi_tclService::vPopulatePhoneMetadata Number of Phone call metaData list :%d",u8NoOfPhonCallMetaDataSize));

   //clear the vector elements
   rfrvecPhoneCallMetadata.clear();

   //!Copy the phone call metadata info
   if(0 < u8NoOfPhonCallMetaDataSize)
   {
      for (t_U16 u16Index = 0 ; u16Index < u8NoOfPhonCallMetaDataSize; ++u16Index)
      {
         midw_fi_tcl_ApplicationPhoneCallMetadata oApplicationPhoneCallMetadata;

         oApplicationPhoneCallMetadata.PhoneNumber.bSet(vecPhoneCallMetaDataList[u16Index].szPhoneNumber.c_str(),midw_fi_tclString::FI_EN_UTF8);
         oApplicationPhoneCallMetadata.DisplayName.bSet(vecPhoneCallMetaDataList[u16Index].szDisplayName.c_str(),midw_fi_tclString::FI_EN_UTF8);

         oApplicationPhoneCallMetadata.CallState.enType = static_cast<midw_fi_tcl_e8_PhoneCallState::tenType>
                                              (vecPhoneCallMetaDataList[u16Index].enPhoneCallState);

         oApplicationPhoneCallMetadata.CallDirection.enType = static_cast<midw_fi_tcl_e8_PhoneCallDirection::tenType>
                                              (vecPhoneCallMetaDataList[u16Index].enPhoneCallDirection);

         oApplicationPhoneCallMetadata.CallDuration=vecPhoneCallMetaDataList[u16Index].u32CallDuration ;
         oApplicationPhoneCallMetadata.CallerLabel.bSet(vecPhoneCallMetaDataList[u16Index].szCallerLabel.c_str(),midw_fi_tclString::FI_EN_UTF8);
         oApplicationPhoneCallMetadata.ConferencedCall =vecPhoneCallMetaDataList[u16Index].bConferencedCall ;

         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is DisplayName = %s",u16Index,vecPhoneCallMetaDataList[u16Index].szDisplayName.c_str()));
         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is PhoneNumber = %s",u16Index,vecPhoneCallMetaDataList[u16Index].szPhoneNumber.c_str()));
         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is CallerLabel = %s",u16Index,vecPhoneCallMetaDataList[u16Index].szCallerLabel.c_str()));
         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is Phone call state = %d",
               u16Index, ETG_ENUM(PHONE_CALL_STATE, vecPhoneCallMetaDataList[u16Index].enPhoneCallState)));
         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is phone call direction = %d",
               u16Index, ETG_ENUM(PHONE_CALL_DIRECTION, vecPhoneCallMetaDataList[u16Index].enPhoneCallDirection)));

         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is CallDuration : 0x%x, ConferencedCall: %d",u16Index,
            vecPhoneCallMetaDataList[u16Index].u32CallDuration,vecPhoneCallMetaDataList[u16Index].bConferencedCall));

         //Populate each call PhonemetaData
         rfrvecPhoneCallMetadata.push_back(oApplicationPhoneCallMetadata);
      } // for (t_U16 u16Index = 0 ; u16Index < u8NoOfPhonCallMetaDataSize; u16Index++)
   } //if(0 <u8NoOfPhonCallMetaDataSize)

}//! end of vPopulatePhoneMetadata

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPopulatePhoneExtendedMetadata(...
***************************************************************************/
t_Void spi_tclService::vPopulatePhoneExtendedMetadata( std::vector<midw_fi_tcl_ApplicationPhoneCallExtendedMetadata> &rfrvecPhoneCallExtendedMetadata,
                                               std::vector<trPhoneCallExtendedMetaData> vecPhoneCallExtendedMetaDataList )
{
   t_U8 u8NoOfPhonCallExtendedMetaDataSize = static_cast <t_U8>(vecPhoneCallExtendedMetaDataList.size());
   ETG_TRACE_USR1(("spi_tclService::vPopulatePhoneExtendedMetadata Number of Phone call metaData list :%d",u8NoOfPhonCallExtendedMetaDataSize));

   //clear the vector elements
   rfrvecPhoneCallExtendedMetadata.clear();

   //!Copy the phone call metadata info
   if(0 < u8NoOfPhonCallExtendedMetaDataSize)
   {
      for (t_U16 u16Index = 0 ; u16Index < u8NoOfPhonCallExtendedMetaDataSize; ++u16Index)
      {
         midw_fi_tcl_ApplicationPhoneCallExtendedMetadata oApplicationPhoneCallExtendedMetadata;

         oApplicationPhoneCallExtendedMetadata.PhoneNumber.bSet(vecPhoneCallExtendedMetaDataList[u16Index].szPhoneNumber.c_str(),midw_fi_tclString::FI_EN_UTF8);
         oApplicationPhoneCallExtendedMetadata.DisplayName.bSet(vecPhoneCallExtendedMetaDataList[u16Index].szDisplayName.c_str(),midw_fi_tclString::FI_EN_UTF8);
         oApplicationPhoneCallExtendedMetadata.sCallUUID.bSet(vecPhoneCallExtendedMetaDataList[u16Index].szCallUUID.c_str(),midw_fi_tclString::FI_EN_UTF8);
         oApplicationPhoneCallExtendedMetadata.CallState.enType = static_cast<midw_fi_tcl_e8_PhoneCallState::tenType>
                                              (vecPhoneCallExtendedMetaDataList[u16Index].enPhoneCallState);
         oApplicationPhoneCallExtendedMetadata.CallDirection.enType = static_cast<midw_fi_tcl_e8_PhoneCallDirection::tenType>
                                              (vecPhoneCallExtendedMetaDataList[u16Index].enPhoneCallDirection);
         oApplicationPhoneCallExtendedMetadata.CallStateDisconnectReason.enType = static_cast<midw_fi_tcl_e8_CallStateUpdateDisconnectReason::tenType>
                                              (vecPhoneCallExtendedMetaDataList[u16Index].enCallStateUpdateDisconnectReason);
         oApplicationPhoneCallExtendedMetadata.CallerLabel.bSet(vecPhoneCallExtendedMetaDataList[u16Index].szCallerLabel.c_str(),midw_fi_tclString::FI_EN_UTF8);
         oApplicationPhoneCallExtendedMetadata.ConferencedCall =vecPhoneCallExtendedMetaDataList[u16Index].bConferencedCall ;
         oApplicationPhoneCallExtendedMetadata.u64StartTimeStamp = vecPhoneCallExtendedMetaDataList[u16Index].u64StartTimeStamp;

         oApplicationPhoneCallExtendedMetadata.CallProgress.u8Hour = vecPhoneCallExtendedMetaDataList[u16Index].rCallProgress.u8Hour;
         oApplicationPhoneCallExtendedMetadata.CallProgress.u8Minute = vecPhoneCallExtendedMetaDataList[u16Index].rCallProgress.u8Minute;
         oApplicationPhoneCallExtendedMetadata.CallProgress.u8Second = vecPhoneCallExtendedMetaDataList[u16Index].rCallProgress.u8Second;

         oApplicationPhoneCallExtendedMetadata.CallProgressRefFromDevice.u8Hour = vecPhoneCallExtendedMetaDataList[u16Index].rCallProgressRefFromDevice.u8Hour;
         oApplicationPhoneCallExtendedMetadata.CallProgressRefFromDevice.u8Minute = vecPhoneCallExtendedMetaDataList[u16Index].rCallProgressRefFromDevice.u8Minute;
         oApplicationPhoneCallExtendedMetadata.CallProgressRefFromDevice.u8Second = vecPhoneCallExtendedMetaDataList[u16Index].rCallProgressRefFromDevice.u8Second;

         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is DisplayName = %s",u16Index,vecPhoneCallExtendedMetaDataList[u16Index].szDisplayName.c_str()));
         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is PhoneNumber = %s",u16Index,vecPhoneCallExtendedMetaDataList[u16Index].szPhoneNumber.c_str()));
         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is sCallUUID = %s",u16Index,vecPhoneCallExtendedMetaDataList[u16Index].szCallUUID.c_str()));

         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is CallerLabel = %s",u16Index,vecPhoneCallExtendedMetaDataList[u16Index].szCallerLabel.c_str()));
         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is Phone call state = %d",
               u16Index, ETG_ENUM(PHONE_CALL_STATE, vecPhoneCallExtendedMetaDataList[u16Index].enPhoneCallState)));
         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is phone call direction = %d",
               u16Index, ETG_ENUM(PHONE_CALL_DIRECTION, vecPhoneCallExtendedMetaDataList[u16Index].enPhoneCallDirection)))
         ETG_TRACE_USR4(("Phone Call Meta Data for list number : [%d] is call Status disconnect Reason = %d",
               u16Index, ETG_ENUM(CALLDISCONNECT_REASON, vecPhoneCallExtendedMetaDataList[u16Index].enCallStateUpdateDisconnectReason)));;
         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is ConferencedCall: %d",u16Index,
                  vecPhoneCallExtendedMetaDataList[u16Index].bConferencedCall));
         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is u64StartTimeStamp: %s",u16Index,
                  std::to_string(vecPhoneCallExtendedMetaDataList[u16Index].u64StartTimeStamp).c_str()));

         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is CallProgress= %d hour %d mins %d seconds",u16Index,
                  vecPhoneCallExtendedMetaDataList[u16Index].rCallProgress.u8Hour,
                  vecPhoneCallExtendedMetaDataList[u16Index].rCallProgress.u8Minute,
                  vecPhoneCallExtendedMetaDataList[u16Index].rCallProgress.u8Second));

         ETG_TRACE_USR4(("Phone Call Extended Meta Data for list number : [%d] is rCallProgressRefFromDevice= %d hour %d mins %d seconds",u16Index,
                  vecPhoneCallExtendedMetaDataList[u16Index].rCallProgressRefFromDevice.u8Hour,
                  vecPhoneCallExtendedMetaDataList[u16Index].rCallProgressRefFromDevice.u8Minute,
                  vecPhoneCallExtendedMetaDataList[u16Index].rCallProgressRefFromDevice.u8Second));

         //Populate each call PhoneExtendedMetadata
         rfrvecPhoneCallExtendedMetadata.push_back(oApplicationPhoneCallExtendedMetadata);
      } // for (t_U16 u16Index = 0 ; u16Index < u8NoOfPhonCallExtendedMetaDataSize; u16Index++)
   } //if(0 <u8NoOfPhonCallExtendedMetaDataSize)

}//! end of vPopulatePhoneMetadata


/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostDipoRoleSwitchResponse
***************************************************************************/
t_Void spi_tclService::vPostDipoRoleSwitchResponse(tenRoleSwitchResponse enRoleswitchRes,const t_U32 cou32DeviceHandle,
      const trUserContext& rfcorUsrCntxt,  trEAPAppInfo& rfrEAPAppInfo )
{
   ETG_TRACE_USR1(("spi_tclService::vPostDipoRoleSwitchResponse() enRoleswitchRes = %d ", ETG_ENUM(ROLE_SWITCH_RESPONSE, enRoleswitchRes)));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rfcorUsrCntxt;
   midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult oMRDiPoRoleSwitchReq;
   oMRDiPoRoleSwitchReq.u8DeviceTag = static_cast<tU8>(cou32DeviceHandle);
  oMRDiPoRoleSwitchReq.e8DiPOSwitchReqResponse.enType = static_cast<midw_fi_tcl_e8_DiPOSwitchReqResponse::tenType>(enRoleswitchRes);

   if(enRoleswitchRes == e8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE )
   {
	  ETG_TRACE_USR2(("[DESC] spi_tclService::vPostDipoRoleSwitchResponse()  retrieving EAPAPPinfo for Carlife "));
	  oMRDiPoRoleSwitchReq.rEAPAppInfo.szAppName.bSet(rfrEAPAppInfo.szAppName.c_str(),midw_fi_tclString::FI_EN_UTF8);
	  oMRDiPoRoleSwitchReq.rEAPAppInfo.szProtocol.bSet(rfrEAPAppInfo.szProtocol.c_str(),midw_fi_tclString::FI_EN_UTF8);
	  oMRDiPoRoleSwitchReq.rEAPAppInfo.szBundleID.bSet(rfrEAPAppInfo.szBundleID.c_str(),midw_fi_tclString::FI_EN_UTF8);
   }

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRDiPoRoleSwitchReq,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostDipoRoleSwitchResponse:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vUpdateDevAuthAndAccessInfo()
***************************************************************************/
t_Void spi_tclService::vUpdateDevAuthAndAccessInfo(const t_U32 cou32DeviceHandle,
         const tenHandsetInteractionStatus coenHandsetInteractionReqd)
{
   ETG_TRACE_USR1(("spi_tclService::vUpdateDevAuthAndAccessInfo() DeviceHandle = 0x%x HandsetInteractionReqd = %d",
                     cou32DeviceHandle, ETG_ENUM(HANDSET_INTERACTION_STATUS, coenHandsetInteractionReqd)));

   m_SessionStatus.HandsetInteractionStatus.enType =
           static_cast<midw_fi_tcl_e8_HandsetInteraction::tenType>(coenHandsetInteractionReqd);
   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_SESSIONSTATUSINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostSessionStatusInfo:Error in updating clients"));
   } // if(FALSE ==  bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_SESSIONSTATUSINFO))
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vRestoreSettings()
 ***************************************************************************/
t_Void spi_tclService::vRestoreSettings()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vRestoreSettings() entered "));

   if (nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vRestoreSettings();
   }//if (nullptr != m_pSpiCmdIntf)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPostNavigationStatus(...)
 ***************************************************************************/
t_Void spi_tclService:: vPostNavigationStatus(
       const trNavStatusData& corfrNavStatusData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostNavigationStatus entered"));
   ETG_TRACE_USR2(("[DESC]: vPostNavigationStatus: DeviceHandle = 0x%x, Device Category = %d, Navigation Status = %d",
                   corfrNavStatusData.u32DeviceHandle, ETG_ENUM(DEVICE_CATEGORY,corfrNavStatusData.enDeviceCategory),
                   ETG_ENUM(NAVIGATION_STATUS,corfrNavStatusData.enNavAppState)));

   m_NavStatus.DeviceHandle = corfrNavStatusData.u32DeviceHandle;
   m_NavStatus.DeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(corfrNavStatusData.enDeviceCategory);
   m_NavStatus.NavigationStatus.enType=static_cast<midw_fi_tcl_e8_NavigationAppState::tenType>(corfrNavStatusData.enNavAppState);
   //! Update Clients
   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONSTATUSINFO))
   {
      ETG_TRACE_ERR(("[ERR]:vPostNavigationStatus: Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONSTATUSINFO))
}


/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPopulateMLNaviInfoUpdate(...)
 ***************************************************************************/
t_Void spi_tclService:: vPopulateMLNaviInfoUpdate(const trMLNavigationInfo &corfrMLNaviInfo,
         midw_fi_tcl_MLNavigationInfoUpdate &rfctlMLNaviInfoUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclService::vPopulateMLNaviInfoUpdate entered"));

   rfctlMLNaviInfoUpdate.NavAppName.bSet(corfrMLNaviInfo.szAppName.c_str(), midw_fi_tclString::FI_EN_UTF8);
   rfctlMLNaviInfoUpdate.GuidanceState.enType =
            static_cast<midw_fi_tcl_e8_MLGuidanceState::tenType>(corfrMLNaviInfo.enGuidanceState);
   rfctlMLNaviInfoUpdate.GuidanceActive.enType =
            static_cast<midw_fi_tcl_e8_MLGuidanceActive::tenType>(corfrMLNaviInfo.enGuidanceActive);
   rfctlMLNaviInfoUpdate.MetricSystem = corfrMLNaviInfo.bMetric;
   rfctlMLNaviInfoUpdate.RightDriving = corfrMLNaviInfo.bRightDrive;

   ETG_TRACE_USR2(("[DESC]:MLNavigationInfo:AppName=%s",corfrMLNaviInfo.szAppName.c_str()));
   ETG_TRACE_USR2(("[DESC]:MLNavigationInfo:GuidanceState=%d, GuidanceActive=%d, MetricSystem=%d, RightDriving=%d",
            corfrMLNaviInfo.enGuidanceState,
            corfrMLNaviInfo.enGuidanceActive,
            corfrMLNaviInfo.bMetric,
            corfrMLNaviInfo.bRightDrive));
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPopulateMLNaviNextManeuverUpdate(...)
 ***************************************************************************/
t_Void spi_tclService::vPopulateMLNaviNextManeuverUpdate(const trMLNavigationNextManeuver &corfrMLNaviNextManuever,
         midw_fi_tcl_MLNavigationNextManeuverUpdate &rfctlMLNaviNextManeuverUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclService::vPopulateMLNaviNextManeuverUpdate entered"));

   rfctlMLNaviNextManeuverUpdate.NextDirection.enType =
            static_cast<midw_fi_tcl_e8_MLNextDirection::tenType>(corfrMLNaviNextManuever.enManeuverDirection);
   rfctlMLNaviNextManeuverUpdate.NextManeuverIndex = corfrMLNaviNextManuever.u32Index;
   rfctlMLNaviNextManeuverUpdate.NextAngle = corfrMLNaviNextManuever.u32NextAngle;
   rfctlMLNaviNextManeuverUpdate.NextStreetName.bSet(corfrMLNaviNextManuever.szNextStName.c_str(),
            midw_fi_tclString::FI_EN_UTF8);
   rfctlMLNaviNextManeuverUpdate.CurrentStreetName.bSet(corfrMLNaviNextManuever.szCurrStName.c_str(),
            midw_fi_tclString::FI_EN_UTF8);
   rfctlMLNaviNextManeuverUpdate.NumOfSideStreetAngles_1 = static_cast<t_U32>(corfrMLNaviNextManuever.nextSideStAngles_1.size());
   rfctlMLNaviNextManeuverUpdate.NumOfSideStreetAngles_2 = static_cast<t_U32>(corfrMLNaviNextManuever.nextSideStAngles_2.size());
   rfctlMLNaviNextManeuverUpdate.NumOfSideStreetAngles_3 = static_cast<t_U32>(corfrMLNaviNextManuever.nextSideStAngles_3.size());

   ETG_TRACE_USR2(("[DESC]:MLNavigationNextManeuver:Index=%d,NextAngle=%d",
            corfrMLNaviNextManuever.u32Index,
            corfrMLNaviNextManuever.u32NextAngle));
   ETG_TRACE_USR2(("[DESC]:MLNavigationNextManeuver:NextStreetName=%s",corfrMLNaviNextManuever.szNextStName.c_str()));
   ETG_TRACE_USR2(("[DESC]:MLNavigationNextManeuver:CurrentStreetName=%s",corfrMLNaviNextManuever.szCurrStName.c_str()));

   for (t_U16 u16Index = 0; u16Index < corfrMLNaviNextManuever.nextSideStAngles_1.size();
            u16Index = static_cast<t_U16>(u16Index + 1))
   {
      rfctlMLNaviNextManeuverUpdate.NextSideStreetAngles_1.push_back(corfrMLNaviNextManuever.nextSideStAngles_1[u16Index]);
      ETG_TRACE_USR2(("[DESC]:MLNavigationNextManeuver:NextSideStreetAngles_1=%d", corfrMLNaviNextManuever.nextSideStAngles_1[u16Index]));
   }

   for (t_U16 u16Index = 0; u16Index < corfrMLNaviNextManuever.nextSideStAngles_2.size();
            u16Index = static_cast<t_U16>(u16Index + 1))
   {
      rfctlMLNaviNextManeuverUpdate.NextSideStreetAngles_2.push_back(corfrMLNaviNextManuever.nextSideStAngles_2[u16Index]);
      ETG_TRACE_USR2(("[DESC]:MLNavigationNextManeuver:NextSideStreetAngles_2=%d", corfrMLNaviNextManuever.nextSideStAngles_2[u16Index]));
   }

   for (t_U16 u16Index = 0; u16Index < corfrMLNaviNextManuever.nextSideStAngles_3.size();
            u16Index = static_cast<t_U16>(u16Index + 1))
   {
      rfctlMLNaviNextManeuverUpdate.NextSideStreetAngles_3.push_back(corfrMLNaviNextManuever.nextSideStAngles_3[u16Index]);
      ETG_TRACE_USR2(("[DESC]:MLNavigationNextManeuver:NextSideStreetAngles_3=%d", corfrMLNaviNextManuever.nextSideStAngles_3[u16Index]));
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPopulateMLNaviSpeedLimitUpdate(...)
 ***************************************************************************/
t_Void spi_tclService::vPopulateMLNaviSpeedLimitUpdate(const trMLNavigationSpeedLimit &corfrMLNaviSpeedLimit,
         midw_fi_tcl_MLSpeedLimitUpdate &rfctlMLSpeedLimitUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclService::vPopulateMLNaviSpeedLimitUpdate entered"));

   rfctlMLSpeedLimitUpdate.CurrentSpeedLimit = corfrMLNaviSpeedLimit.u32CurrentLimit;
   rfctlMLSpeedLimitUpdate.NextSpeedLimit = corfrMLNaviSpeedLimit.u32NextLimit;
   rfctlMLSpeedLimitUpdate.Distance = corfrMLNaviSpeedLimit.u32Distance;
   rfctlMLSpeedLimitUpdate.DistanceUnit.enType =
            static_cast<midw_fi_tcl_e8_DistanceUnit::tenType>(corfrMLNaviSpeedLimit.enDistanceUnit);

   ETG_TRACE_USR2(("[DESC]:MLNavigationSpeedLimit:CurrentSpeedLimit=%d, NextSpeedLimit=%d, Distance =%d, DistanceUnit =%d",
            corfrMLNaviSpeedLimit.u32CurrentLimit,
            corfrMLNaviSpeedLimit.u32NextLimit,
            corfrMLNaviSpeedLimit.u32Distance,
            corfrMLNaviSpeedLimit.enDistanceUnit));

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPopulateMLNaviNextDistanceUpdate(...)
 ***************************************************************************/
t_Void spi_tclService::vPopulateMLNaviNextDistanceUpdate(const trMLNavigationNextDistance &corfMLNaviNextDistance,
         midw_fi_tcl_MLNavigationNextDistanceUpdate &rfctlMLNaviNextDistanceUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclService::vPopulateMLNaviNextDistanceUpdate entered"));

   rfctlMLNaviNextDistanceUpdate.Distance = corfMLNaviNextDistance.u32Distance;
   rfctlMLNaviNextDistanceUpdate.DistanceUnit.enType =
            static_cast<midw_fi_tcl_e8_DistanceUnit::tenType>(corfMLNaviNextDistance.enDistanceUnit);
   rfctlMLNaviNextDistanceUpdate.Time = corfMLNaviNextDistance.u64TimeToManeuver;
   rfctlMLNaviNextDistanceUpdate.Percentage = corfMLNaviNextDistance.u32Percent;

   ETG_TRACE_USR4(("[DESC]:MLNavigationNextDistance:Distance=%d, DistanceUnit=%d, Percentage = %d",
            corfMLNaviNextDistance.u32Distance,
            corfMLNaviNextDistance.enDistanceUnit,
            corfMLNaviNextDistance.u32Percent));
   ETG_TRACE_USR4(("[DESC]:MLNavigationNextDistance:Time= %s ", std::to_string(corfMLNaviNextDistance.u64TimeToManeuver).c_str()));
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPopulateMLNaviLaneGuidanceUpdate(...)
 ***************************************************************************/
t_Void spi_tclService::vPopulateMLNaviLaneGuidanceUpdate(const trMLNavigationLaneGuidance& corfMLNaviLaneGuidance,
         midw_fi_tcl_MLNavigationLaneGuidanceUpdate &rfctlMLNaviLaneGuidanceUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclService::vPopulateMLNaviLaneGuidanceUpdate entered"));

   rfctlMLNaviLaneGuidanceUpdate.NumOfLaneGuidances = static_cast<t_U32>(corfMLNaviLaneGuidance.nextLaneGuidances.size());
   for (t_U16 u16Index = 0; u16Index < corfMLNaviLaneGuidance.nextLaneGuidances.size(); u16Index =
            static_cast<t_U16>(u16Index + 1))
   {
      rfctlMLNaviLaneGuidanceUpdate.NextLaneGuidances.push_back(corfMLNaviLaneGuidance.nextLaneGuidances[u16Index]);
      ETG_TRACE_USR2(("[DESC]:MLNavigationLaneGuidance:NextLaneGuidance %d", corfMLNaviLaneGuidance.nextLaneGuidances[u16Index]));
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPopulateMLNaviTripInfoUpdate(...)
 ***************************************************************************/
t_Void spi_tclService::vPopulateMLNaviTripInfoUpdate(const trMLNavigationTripInfo& corfrMLNaviTripInfo,
         midw_fi_tcl_MLNavigationTripInfoUpdate &rfctlMLNaviTripInfoUpdate) const
{
   ETG_TRACE_USR1(("[FUNC]:spi_tclService::vPopulateMLNaviTripInfoUpdate entered"));

   rfctlMLNaviTripInfoUpdate.Destination.bSet(corfrMLNaviTripInfo.szDestination.c_str(), midw_fi_tclString::FI_EN_UTF8);
   rfctlMLNaviTripInfoUpdate.Distance = corfrMLNaviTripInfo.u32Distance;
   rfctlMLNaviTripInfoUpdate.DistanceUnit.enType =
            static_cast<midw_fi_tcl_e8_DistanceUnit::tenType>(corfrMLNaviTripInfo.enDistanceUnit);
   rfctlMLNaviTripInfoUpdate.RemainingTravelTime = corfrMLNaviTripInfo.u64TravelTime;
   rfctlMLNaviTripInfoUpdate.RemainingTrafficTime = corfrMLNaviTripInfo.u64TrafficTime;

   ETG_TRACE_USR2(("[DESC]:MLNavigationTripInfo:Destination=%s",corfrMLNaviTripInfo.szDestination.c_str()));
   ETG_TRACE_USR2(("[DESC]:MLNavigationTripInfo:Distance=%d, DistanceUnit =%d",
            corfrMLNaviTripInfo.u32Distance,
            corfrMLNaviTripInfo.enDistanceUnit));
   ETG_TRACE_USR4(("[DESC]:MLNavigationTripInfo:RemainingTravelTime= %s ", std::to_string(corfrMLNaviTripInfo.u64TravelTime).c_str()));
   ETG_TRACE_USR4(("[DESC]:MLNavigationTripInfo:RemainingTrafficTime= %s ", std::to_string(corfrMLNaviTripInfo.u64TrafficTime).c_str()));
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPostNavigationNextTurnDataStatus(...)
 ***************************************************************************/
t_Void spi_tclService:: vPostNavigationNextTurnDataStatus(const trNavNextTurnData& corfrNavNexTurnData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostNavigationNextTurnDataStatus entered"));
   ETG_TRACE_USR2(("[DESC]:vPostNavigationNextTurnDataStatus: DeviceHandle = 0x%x, Device Category = %d, Road Name = %s",
                    corfrNavNexTurnData.u32DeviceHandle, ETG_ENUM(DEVICE_CATEGORY,corfrNavNexTurnData.enDeviceCategory),
                    corfrNavNexTurnData.szRoadName.c_str()));
   ETG_TRACE_USR2(("[DESC]:vPostNavigationNextTurnDataStatus: Next Turn side = %d, Next Turn Event = %d, Turn Angle = %d,"
                   "Turn Number = %d, Image = %s", ETG_ENUM(NEXTTURN_SIDE,corfrNavNexTurnData.enAAPNavNextTurnSide),
                   ETG_ENUM(NEXTTURN_EVENT,corfrNavNexTurnData.enAAPNavNextTurnType),
                   corfrNavNexTurnData.s32TurnAngle,corfrNavNexTurnData.s32TurnNumber,corfrNavNexTurnData.szImage.c_str()));

   m_NavNextTurnStatus.DeviceHandle = corfrNavNexTurnData.u32DeviceHandle;
   m_NavNextTurnStatus.DeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(corfrNavNexTurnData.enDeviceCategory);
   if ( false == corfrNavNexTurnData.szRoadName.empty() )
   {
      m_NavNextTurnStatus.RoadName.bSet(corfrNavNexTurnData.szRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
   }
   m_NavNextTurnStatus.TurnSide.enType = static_cast<midw_fi_tcl_e8_TurnSide::tenType>(corfrNavNexTurnData.enAAPNavNextTurnSide);
   m_NavNextTurnStatus.NextTurnEvent.enType = static_cast<midw_fi_tcl_e8_NextTurnEvent::tenType>(corfrNavNexTurnData.enAAPNavNextTurnType);
   if ( false == corfrNavNexTurnData.szImage.empty() )
   {
      m_NavNextTurnStatus.Image.bSet(corfrNavNexTurnData.szImage.c_str(), midw_fi_tclString::FI_EN_UTF8);
   }
   m_NavNextTurnStatus.TurnAngle = corfrNavNexTurnData.s32TurnAngle;
   m_NavNextTurnStatus.TurnNumber = corfrNavNexTurnData.s32TurnNumber;
   //! Update Clients
   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDATA))
   {
      ETG_TRACE_ERR(("[ERR]:vPostNavigationNextTurnDataStatus: Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDATA))
   m_NavNextTurnStatus.vDestroy();
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPostNavigationNextTurnDistanceDataStatus(...)
 ***************************************************************************/
t_Void spi_tclService:: vPostNavigationNextTurnDistanceDataStatus(
        const trNavNextTurnDistanceData& corfrNavNextTurnDistData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostNavigationNextTurnDistanceDataStatus entered"));
   ETG_TRACE_USR2(("[DESC]: vPostNavigationNextTurnDistanceDataStatus: DeviceHandle = 0x%x, Device Category = %d, Distance = %d, Time = %d",
		   corfrNavNextTurnDistData.u32DeviceHandle, ETG_ENUM(DEVICE_CATEGORY,corfrNavNextTurnDistData.enDeviceCategory),
		   corfrNavNextTurnDistData.s32Distance, corfrNavNextTurnDistData.s32Time));

   m_NavNextTurnDistanceStatus.DeviceHandle = corfrNavNextTurnDistData.u32DeviceHandle;
   m_NavNextTurnDistanceStatus.DeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(corfrNavNextTurnDistData.enDeviceCategory);
   m_NavNextTurnDistanceStatus.DistanceInMeters = corfrNavNextTurnDistData.s32Distance;
   m_NavNextTurnDistanceStatus.TimeInSec = corfrNavNextTurnDistData.s32Time;
   //! Update Clients
   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDISTANCEDATA))
   {
      ETG_TRACE_ERR(("[ERR]:vPostNavigationNextTurnDistanceDataStatus: Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDISTANCEDATA))
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPostNotificationData(...)
 ***************************************************************************/
t_Void spi_tclService::vPostNotificationData(const trNotificationData& corfrNotificationData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostNotificationData entered"));
   ETG_TRACE_USR2(("[DESC]:vPostNotificationData: DeviceHandle = 0x%x, Device Category = %d, Notification Text = %s",
                    corfrNotificationData.u32DeviceHandle, ETG_ENUM(DEVICE_CATEGORY, corfrNotificationData.enDeviceCategory),
                    corfrNotificationData.szNotifText.c_str()));
   ETG_TRACE_USR2(("[DESC]:vPostNotificationData: Has Notification Id = %d, Notification Id = %s",
                    corfrNotificationData.bHasId, corfrNotificationData.szId.c_str()));
   ETG_TRACE_USR2(("[DESC]:vPostNotificationData: Has Icon = %d, Icon size = %d",
                    ETG_ENUM(BOOL, corfrNotificationData.bHasIcon), corfrNotificationData.u32IconSize));

   m_NotificationEventStatus.DeviceHandle = corfrNotificationData.u32DeviceHandle;
   m_NotificationEventStatus.DeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(corfrNotificationData.enDeviceCategory);
   if (false == corfrNotificationData.szId.empty())
   {
	   m_NotificationEventStatus.AAPNotificationId.bSet(corfrNotificationData.szId.c_str(), midw_fi_tclString::FI_EN_UTF8);
   }
   if (false == corfrNotificationData.szNotifText.empty())
   {
	   m_NotificationEventStatus.NotificationText.bSet(corfrNotificationData.szNotifText.c_str(), midw_fi_tclString::FI_EN_UTF8);
   }
   if ((true == corfrNotificationData.bHasIcon) && (NULL != corfrNotificationData.pu8Icon))
   {
	  for(t_U32 u32Index=0; u32Index<corfrNotificationData.u32IconSize; ++u32Index)
	  {
		  m_NotificationEventStatus.NotificationIcon.push_back(corfrNotificationData.pu8Icon[u32Index]);
	  }
   }
   //! Update Clients
   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_AAPNOTIFICATIONEVENT))
   {
      ETG_TRACE_ERR(("[ERR]:vPostNotificationData:Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_AAPNOTIFICATIONEVENT))
   m_NotificationEventStatus.vDestroy();
}

/***************************************************************************
** FUNCTION: tVoid devprj_tclService::vPostInitiateCallInfo(t_U32 u32DeviceHandle...
***************************************************************************/
t_Void spi_tclService::vPostInitiateCallInfo(t_U32 u32DeviceHandle,
         t_String szTelePhoneNumber,
         t_String szDisplayText)
{
   ETG_TRACE_USR1(("spi_tclService::vPostInitiateCallInfo:[%s]", szTelePhoneNumber.c_str()));
   //! Note: Initialization of the status message are done by CCA framework, so it is
   //! not required to initialize in SPI.

   m_DialStatus.DeviceHandle =u32DeviceHandle;
   m_DialStatus.TelephoneNumber.bSet(szTelePhoneNumber.c_str(),MIDWFI_CHAR_SET_UTF8);
   m_DialStatus.DisplayContent.bSet(szDisplayText.c_str(),MIDWFI_CHAR_SET_UTF8);

   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DIAL))
     {
        ETG_TRACE_ERR(("spi_tclService::vPostInitiateCallInfo:Error in updating clients"));
     }
}
/***************************************************************************
** FUNCTION: tVoid devprj_tclService::vPostInitiateCallInfo(t_U32 u32DeviceHandle...
***************************************************************************/
/** This method is deprectated. To be removed.**/
t_Void spi_tclService::vPostMySPINVoiceSessionReq(t_U32 u32DeviceHandle,
                                                  t_U8 u8VoiceSessionReq)
{
   SPI_INTENTIONALLY_UNUSED(u32DeviceHandle);
   ETG_TRACE_USR1(("spi_tclService::vPostMySPINVoiceSessionReq:[%d]", u8VoiceSessionReq));
   //! Note: Initialization of the status message are done by CCA framework, so it is
   //! not required to initialize in SPI.

   m_mySPINVoiceReq.BTVoiceRecRequest.enType = static_cast<midw_fi_tcl_e8_BTVoiceRecRequest::tenType>(u8VoiceSessionReq);

   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_MYSPINBLUETOOTHVOICERECINFO))
   {
      ETG_TRACE_ERR(("spi_tclService::vPostMySPINVoiceSessionReq:Error in updating clients\n"));
   }
}
/**************************************************************************
** FUNCTION   : t_Void spi_tclService::vEvaluateDriveMode(...)
***************************************************************************/
t_Void spi_tclService::vEvaluateDriveMode(t_Bool bParkBrakeActive,
      tenVehicleMovementState enVehMovState)
{
   //! Vehicle is considered to be in PARK mode if:
   //! Park brake is applied OR vehicle state is reported as parked.
   tenVehicleConfiguration enVehicleConfig =
         ((bParkBrakeActive) || (e8VEHICLE_MOVEMENT_STATE_PARKED == enVehMovState)) ?
         (e8PARK_MODE) : (e8DRIVE_MODE);

   if ((nullptr != m_poSpiCmdIntf) && (enVehicleConfig != m_enDriveModeConfig))
   {
      m_poSpiCmdIntf->vSetVehicleConfig(enVehicleConfig, true, corEmptyUsrContext);
   }

   //! Store current drive mode info
   m_enDriveModeConfig = enVehicleConfig;
}


/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMSGetMediaObjectAlbumArt(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vOnMSGetMediaObjectAlbumArt(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSGetMediaObjectAlbumArt() entered."));

   spi_tMsgGetMediaObjectAlbumArt oGetMediaObjAlbumArt(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   tU32 u32DeviceHandle = oGetMediaObjAlbumArt.DeviceHandle;
   t_String sAlbumArt = (t_String)(oGetMediaObjAlbumArt.sAlbumArt.szValue);
   trMsgContext rMsgContext;
   CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
   ETG_TRACE_USR4(("[PARAM]::vOnMSGetMediaObjectAlbumArt - Device Handle: %d, Album Art: %s",
          u32DeviceHandle, sAlbumArt.c_str()));

   if (nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vGetMediaObjectAlbumArt(u32DeviceHandle, sAlbumArt, rMsgContext.rUserContext);
   }//if(nullptr != m_poSpiCmdIntf)
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMSGetSPIVersion(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vOnMSGetSPIVersion(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSGetSPIVersion() entered."));

   spi_tMsgGetSPIVersionMS oGetSPIVersion(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   if(oGetSPIVersion.bIsValid() && nullptr != m_poSpiCmdIntf)
   {
	  trMsgContext rMsgContext;
	  CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
	  midw_smartphoneintfi_tclMsgGetSPIVersionInfoMethodResult oMRGetSPIVersion;
	  oMRGetSPIVersion.SPIVersion.bSet(m_poSpiCmdIntf->szGetSPIVersion().c_str(), midw_fi_tclString::FI_EN_UTF8);
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRGetSPIVersion,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSGetSPIVersion() left with Error in posting Message"));
      } //if( FALSE == oPostMsg.bSendMessage

      //! De-allocate memory used by message
      oMRGetSPIVersion.vDestroy();
   }
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostApplicationMediaAlbumArt(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vPostApplicationMediaAlbumArt(const trAppMediaAlbumArt& corfrAppMediaAlbumArt,
        const trUserContext& corfrUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclService::vPostApplicationMediaAlbumArt() entered."));
   trMsgContext rMsgContext;
   rMsgContext.rUserContext = corfrUsrCntxt;
   
   midw_smartphoneintfi_tclMsgGetMediaObjectAlbumArtMethodResult oMRMediaObjectAlbumArt;
   oMRMediaObjectAlbumArt.oImageData.clear();
   for (size_t u8Index = 0; u8Index
               < corfrAppMediaAlbumArt.u8Items.size(); u8Index++)
   oMRMediaObjectAlbumArt.oImageData.push_back(corfrAppMediaAlbumArt.u8Items[u8Index]);
   
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRMediaObjectAlbumArt, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]: vPostApplicationMediaAlbumArt:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendResMessage

   //! De-allocate memory used by message
   oMRMediaObjectAlbumArt.vDestroy();
}
/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vUpdateTechnologySelectionStatus
 ***************************************************************************/
 t_Void spi_tclService::vUpdateTechnologySelectionStatus(t_U32 u32DevHandle,
         tenDeviceType enDeviceType,
         tenDeviceCategory enSelectedTechnology)
{
    ETG_TRACE_USR1(("spi_tclService::vUpdateTechnologySelectionStatus() entered."));
    m_TechSelectionStatus.DeviceHandle = u32DevHandle;
    m_TechSelectionStatus.DeviceType.enType =  static_cast<midw_fi_tcl_e8_DeviceType::tenType> (enDeviceType);
    m_TechSelectionStatus.SelectedTechnology.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType> (enSelectedTechnology);
    ETG_TRACE_USR4(("[PARAM] spi_tclService::vUpdateTechnologySelectionStatus Device Handle = %d, Device type = %d Selected Technology =%d", m_TechSelectionStatus.DeviceHandle,
             ETG_ENUM(DEVICE_TYPE, m_TechSelectionStatus.DeviceType.enType),
             ETG_ENUM(DEVICE_CATEGORY,m_TechSelectionStatus.SelectedTechnology.enType)));

    //! Update Clients
    if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_TECHNOLOGYSELECTION))
    {
       ETG_TRACE_ERR(("[ERR]:MIDW_SMARTPHONEINTFI_C_U16_TECHNOLOGYSELECTION: Error in updating clients"));
    } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDISTANCEDATA))

}

 /***************************************************************************
  ** FUNCTION: t_Void spi_tclService::vUpdateDeviceAuthorizationStatus
  ***************************************************************************/
 t_Void spi_tclService::vUpdateDeviceAuthorizationStatus(t_U32 u32DevHandle,
          tenDeviceType enDeviceType,
          tenUserAuthorizationStatus enAuthStatus)
 {
    ETG_TRACE_USR1(("spi_tclService::vUpdateDeviceAuthorizationStatus() entered."));
    m_oUnauthDeviceListLock.s16Lock();
    m_DevAuthStatus.DeviceAuthInfoList.clear();
   if (e8_USER_AUTH_ABORTED != enAuthStatus)
   {
      midw_fi_tcl_DeviceAuthInfo rDevAuthInfo;
      rDevAuthInfo.DeviceHandle = u32DevHandle;
      rDevAuthInfo.DeviceType.enType = static_cast<midw_fi_tcl_e8_DeviceType::tenType>(enDeviceType);
      //! only devices with authorization status ,i.e user has not accepted or rejected device usage needs to be sent to HMI.
      rDevAuthInfo.UserAuthorizationStatus.enType =
               static_cast<midw_fi_tcl_e8_UserAuthorizationStatus::tenType>(enAuthStatus);
      ETG_TRACE_USR4(("[PARAM] spi_tclService::vUpdateDeviceAuthorizationStatus Device Handle = %d, Device type = %d", rDevAuthInfo.DeviceHandle, ETG_ENUM(DEVICE_TYPE, rDevAuthInfo.DeviceType.enType)));
      m_DevAuthStatus.DeviceAuthInfoList.push_back(rDevAuthInfo);
      m_DevAuthStatus.NumDevices = 1;
   }
   else
   {
      m_DevAuthStatus.NumDevices = 0;
      m_DevAuthStatus.DeviceAuthInfoList.clear();
   }
   m_oUnauthDeviceListLock.vUnlock();

   //! Update Clients
   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_PROJECTIONDEVICEAUTHORIZATION))
   {
      ETG_TRACE_ERR(("[ERR]:MIDW_SMARTPHONEINTFI_C_U16_PROJECTIONDEVICEAUTHORIZATION: Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDISTANCEDATA))
 }



/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vNativeVideoRenderingStatus
 *********************************************************************************************/
t_Void spi_tclService::vSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus)
{
   //dispatch the status of the video rendering to the cmd interface, further to spi-tclResourceMngr ->AAP
   ETG_TRACE_USR1(("spi_tclService :: vSetNativeVideoRenderingStatus entered"));
   if (nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vSetNativeVideoRenderingStatus(enNativeVideoRenderingStatus);
   }//if(nullptr != m_poSPICmdIntf)
   ETG_TRACE_USR1(("spi_tclService :: vSetNativeVideoRenderingStatus exited"));
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vUpdateProjectionVideoRenderingStatus
 *********************************************************************************************/
t_Void spi_tclService::vUpdateProjectionVideoRenderingStatus(tenProjVideoRenderingStatus enProjVideoRenderingStatus)
{
   ETG_TRACE_USR1(("spi_tclService :: vUpdateProjectionVideoRenderingStatus entered"));
   ETG_TRACE_USR1(("spi_tclService :: vUpdateProjectionVideoRenderingStatus display status - %d", ETG_ENUM(PROJECTION_VIDEO_RENDERING_STATUS,
            enProjVideoRenderingStatus)));

   if (e8_PROJECTION_VIDEO_RENDERING_STOPPED == enProjVideoRenderingStatus)
   {
      m_DeviceDispCntxt.DisplayFlag = false;
      m_DeviceDispCntxt.DisplayContextReason.enType = midw_fi_tcl_e8_DisplayContextReason::FI_EN_DISPLAY_CONTEXT_REASON_UNKNOWN;

      // Update HMI that projection video rendering has stopped so that head unit can display native screen and avoid black screen.
      if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICEDISPLAYCONTEXT))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vUpdateProjectionVideoRenderingStatus: Error in updating clients"));
      } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICEDISPLAYCONTEXT))

#ifndef VARIANT_S_FTR_ENABLE_HMI_SYNC
      vSetNativeVideoRenderingStatus(e8_NATIVE_VIDEO_RENDERING_STARTED);
      ETG_TRACE_USR1(("spi_tclService :: vUpdateProjectionVideoRenderingStatus display status : "
         "This is me projection who is sending native!"));
#endif
   }
   ETG_TRACE_USR1(("spi_tclService :: vUpdateProjectionVideoRenderingStatus exited"));
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMsDeleteDevice(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vOnMsDeleteDevice(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR1(("spi_tclService::vOnMsDeleteDevice() entered."));
   spi_tMsgDeleteDevice oDeleteDevice(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   trMsgContext rMsgContext;
   CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

   std::vector < t_U32 > vecrDeleteDeviceList;
   for (t_U8 u8Index = 0; u8Index < oDeleteDevice.DeviceList.size(); u8Index++)
   {
      vecrDeleteDeviceList.push_back(oDeleteDevice.DeviceList[u8Index]);
      ETG_TRACE_USR1(("spi_tclService::vOnMsDeleteDevice() device handle to be deleted = %d", vecrDeleteDeviceList[u8Index]));
   }
   t_U32 u32NumDevices = static_cast <t_U32>(vecrDeleteDeviceList.size());
   ETG_TRACE_USR1(("spi_tclService::vOnMsDeleteDevice() Number of device to be deleted are %d entered.", u32NumDevices));
   if (oDeleteDevice.bIsValid() && nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vDeleteDevice(vecrDeleteDeviceList, rMsgContext.rUserContext);
   }

}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostDeleteDevice(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vPostDeleteDevice(const std::vector<t_U32> vecrDeleteDeviceResult,
         const tenResponseCode enResponseCode, const trUserContext& crfcorUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclService::vPostDeleteDevice() entered."));
   midw_smartphoneintfi_tclMsgDeleteDeviceMethodResult oMRDeleteDevice;
   trMsgContext rMsgContext;
   rMsgContext.rUserContext = crfcorUsrCntxt;
   if (0 < oMRDeleteDevice.DeviceList.size())
   {
      oMRDeleteDevice.DeviceList.clear();
   }
   if (0 < vecrDeleteDeviceResult.size())
   {
      for (t_U8 u8Index = 0; u8Index < vecrDeleteDeviceResult.size(); u8Index++)
      {
         oMRDeleteDevice.DeviceList.push_back(vecrDeleteDeviceResult[u8Index]);
         ETG_TRACE_USR1(("spi_tclService::vPostDeleteDevice() Device handle failed to delete = %d", oMRDeleteDevice.DeviceList[u8Index]));
      }
   }
   if (enResponseCode == e8SUCCESS)
   {
      oMRDeleteDevice.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
   }
   else
   {
      oMRDeleteDevice.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_FAILURE;
   }

   FIMsgDispatch oPostMsg(_poMainAppl);
   if (FALSE == oPostMsg.bSendResMessage(oMRDeleteDevice, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]: vPostDeleteDevice:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendResMessage

   //! De-allocate memory used by message
   oMRDeleteDevice.vDestroy();

}
/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMSInitiateWirelessDiscovery(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vOnMSInitiateWirelessDiscovery(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSInitiateWirelessDiscovery() entered."));

   spi_tMsgInitiateWirelessDiscoveryMS oInitiateWirelessDscvry(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   if(oInitiateWirelessDscvry.bIsValid() && nullptr != m_poSpiCmdIntf)
   {

     trUserContext rUsrContext;
     CPY_TO_USRCNTXT(poMessage, rUsrContext);

	 t_String szBTMACAddress = (t_String)(oInitiateWirelessDscvry.BTMACAddress.szValue);
	 t_Bool bIsKnownDevice = oInitiateWirelessDscvry.isKnownDevice;
     ETG_TRACE_USR1(("spi_tclService::vOnMSInitiateWirelessDiscovery:technology type:%d, bisKnownDevice:%d, BTMacAddress:%s",
                    ETG_ENUM(DEVICE_CATEGORY,oInitiateWirelessDscvry.Technology.enType),ETG_ENUM(BOOL,bIsKnownDevice),szBTMACAddress.c_str()));
					
     //Convert string to upper case
	 std::transform(szBTMACAddress.begin(), szBTMACAddress.end(), szBTMACAddress.begin(), ::toupper);
	 ETG_TRACE_USR4(("spi_tclService::vOnMSInitiateWirelessDiscovery:BTMacAddress after conversion:%s",szBTMACAddress.c_str()));
     m_poSpiCmdIntf->vInitiateWirelessDiscovery((tenDeviceCategory)oInitiateWirelessDscvry.Technology.enType,szBTMACAddress, rUsrContext,bIsKnownDevice);
   }
}
/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostWiFiCredentials(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostWiFiCredentials(t_String szSSID, t_String szPassPhrase,
                                    		t_U16 u16ChannelNo, tenWifiSecurityType enSecurityType)
{
	ETG_TRACE_USR1(("spi_tclService::vPostWiFiCredentials() entered."));
	
	
	m_rWiFiAPConfig.szSSID.assign(szSSID);
	m_rWiFiAPConfig.szPassphrase.assign(szPassPhrase);
	m_rWiFiAPConfig.u16OperatingChannel = u16ChannelNo;
	m_rWiFiAPConfig.enSecurity = enSecurityType;
	
	
	m_WifiCredentialsStatus.AccessoryWiFiAPCredentials.SSID.bSet(szSSID.c_str(), midw_fi_tclString::FI_EN_UTF8);
	m_WifiCredentialsStatus.AccessoryWiFiAPCredentials.PassPhrase.bSet(szPassPhrase.c_str(), midw_fi_tclString::FI_EN_UTF8);
	m_WifiCredentialsStatus.AccessoryWiFiAPCredentials.ChannelNo = u16ChannelNo;
	m_WifiCredentialsStatus.AccessoryWiFiAPCredentials.SecurityType.enType = static_cast<midw_fi_tcl_e8_WiFiSecurityType::tenType>(enSecurityType);
	if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_WIFICREDENTIALS))
	{
		ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostWiFiCredentials:Error in updating clients"));
	}

}

#ifdef __GNUC__
   #pragma GCC diagnostic push
   #pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
   //Reference file : amt_CCAMessage.cpp
   //Reference method : amt_tclServiceDataError::u16GetErrorData
   // iph1kor, 09.12.2019, deactivated compiler warning
   // warning : 'oTemporaryObject' may be used uninitialized in this function [-Wmaybe-uninitialized]
   // If you take a look into method "amt_tclMappedIntegralType<T>::nGetValue()" defined in file amt_MMObj.h you can see that the template class could consist of simple data types, structs or objects.
   // For each of these data types the way of initializing the data item oTemporaryObject would be different (constructor or assignment of 0) and therefore the way of initialization can not be defined in advance.
   // On the other hand it doesn't really matter if the oTemporaryObject which is returned by nGetValue() is either initialized with 0 or initialized with random values in an error case.
   // The reason for nGetValue() to return a oTemporaryObject which is not filled with valid data can only be that oErrorData is already NULL or pu8GetSharedMemBase() is NULL.
   // In both cases already something went wrong and the caller of amt_tclServiceDataError::u16GetErrorData() in general has to deal with the use cases that either 0 or a random value is returned.
   // Means the call has to verify the validity of the value ranges of the data item(s) and should only accept items which are in within the expected range.
   // Therefore we keep the automatic variable oTemporaryObject of method amt_tclMappedIntegralType<T>::nGetValue() unititialized.
#endif
/***************************************************************************
** FUNCTION:  tBool spi_tclService::vOnLbSPIStateUpdate(amt_tclServiceData* poMessage)
***************************************************************************/
t_Void spi_tclService::vOnLbSPIStateUpdate(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnSPIStateUpdate() entered"));
   if ((nullptr != poMessage) && (nullptr != m_poSpiCmdIntf))
   {
      tLbSPISate oSPIStateUpdate(poMessage);

      tenSPIState enSPIState = static_cast<tenSPIState>(oSPIStateUpdate.u8GetByte());
      if (e8SPI_STATE_OFF == enSPIState)
         {
            t_U32 u32SelDevHandle = m_poSpiCmdIntf->u32GetSelectedDeviceHandle();
            if (cou32InvalidHandle != u32SelDevHandle)
            {
               m_poSpiCmdIntf->vSelectDevice(u32SelDevHandle,
                     e8USB_CONNECTED, /*Device Connection Type*/
                     e8DEVCONNREQ_DESELECT,
                     e8USAGE_ENABLED, /*DAP Usage - not used*/
                     e8USAGE_ENABLED, /*CDB Usage - not used*/
                     e8DEV_TYPE_UNKNOWN,
                     corEmptyUsrContext,
                     e8_REASON_SPM_STATE_CHANGE); /*Not HMI deselection*/
            }
         }//if (e8SPI_STATE_OFF == enSPIState)
      else if (e8SPI_STATE_ON == enSPIState)
          {
             m_poSpiCmdIntf->vApplySelectionStrategy();
          }//if (e8SPI_STATE_ON == enSPIState)

   }//if(NULL != m_poSpiCmdIntf)
   ETG_TRACE_USR1(("spi_tclService::vOnSPIStateUpdate() left"));
}


/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService:: vOnLbAutoRegisterProperty()
 ***************************************************************************/
t_Void spi_tclService::vOnLbAutoRegisterProperty(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnLbAutoRegisterProperty() entered"));
   if ((nullptr != poMessage) && (nullptr != m_poExtClientFactory))
   {
      tLbAutoRegisterProperties oAutoRegProperty(poMessage);
      t_U16 u16FunctionID = oAutoRegProperty.u16GetWord();
      tenLoopRegisterID enLoopRgID = static_cast<tenLoopRegisterID>(oAutoRegProperty.u16GetRegisterID());
      switch(enLoopRgID)
      {
         case e8_LOOPREGISTER_ID_SENSOR_DATA:
         {
            spi_tclSensorDataClientHandler* poSensorClientHandler = m_poExtClientFactory->poGetSensorDataClientHandlerInstance();
            if(NULL != poSensorClientHandler)
            {
              ETG_TRACE_USR4(("[FUNC]spi_tclService::vOnLbAutoRegisterProperty() poSensorClientHandler FunctionID =%d", u16FunctionID));
              poSensorClientHandler->vAddAutoRegisterForProperty(u16FunctionID);
            }
            break;
         }
         case e8_LOOPREGISTER_ID_SENSORPV_DATA:
         {
            spi_tclSensorPVDataClientHandler* poSensorPVClientHandler = m_poExtClientFactory->poGetPosDataClientHandlerInstance();
            if(NULL != poSensorPVClientHandler)
            {
              ETG_TRACE_USR4(("[FUNC]spi_tclService::vOnLbAutoRegisterProperty()poSensorPVClientHandler FunctionID =%d", u16FunctionID));
              poSensorPVClientHandler->vAddAutoRegisterForProperty(u16FunctionID);
            }
            break;
         }
         default:
            ETG_TRACE_ERR(("[FUNC]spi_tclService::vOnLbAutoRegisterProperty Invalid ClientHandler"));
            break;
      }

    }//if(NULL != m_poSpiCmdIntf)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService:: vOnLbAutoUnregisterProperty()
 ***************************************************************************/
t_Void spi_tclService::vOnLbAutoUnregisterProperty(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnLbAutoUnregisterProperty() entered"));
   if ((nullptr != poMessage) && (nullptr != m_poExtClientFactory))
   {
      tLbAutoUnregisterProperties oAutoUnregProperty(poMessage);
      t_U16 u16FunctionID = oAutoUnregProperty.u16GetWord();
      tenLoopRegisterID enLoopRgID = static_cast<tenLoopRegisterID>(oAutoUnregProperty.u16GetRegisterID());

      switch(enLoopRgID)
      {
         case e8_LOOPREGISTER_ID_SENSOR_DATA:
         {
            spi_tclSensorDataClientHandler* poSensorClientHandler = m_poExtClientFactory->poGetSensorDataClientHandlerInstance();
            if(NULL != poSensorClientHandler)
            {
              ETG_TRACE_USR4(("[FUNC]spi_tclService::vOnLbAutoUnregisterProperty() poSensorClientHandler FunctionID =%d", u16FunctionID));
              poSensorClientHandler->vRemoveAutoRegisterForProperty(u16FunctionID);
            }
            break;
         }
         case e8_LOOPREGISTER_ID_SENSORPV_DATA:
         {
            spi_tclSensorPVDataClientHandler* poSensorPVClientHandler = m_poExtClientFactory->poGetPosDataClientHandlerInstance();
            if(NULL != poSensorPVClientHandler)
            {
              ETG_TRACE_USR4(("[FUNC]spi_tclService::vOnLbAutoUnregisterProperty()poSensorPVClientHandler FunctionID =%d", u16FunctionID));
              poSensorPVClientHandler->vRemoveAutoRegisterForProperty(u16FunctionID);
            }
            break;
         }
         default:
            ETG_TRACE_ERR(("[FUNC]spi_tclService::vOnLbAutoUnregisterProperty Invalid ClientHandler"));
            break;
      }
    }//if(NULL != m_poSpiCmdIntf)
}


#ifdef __GNUC__
   #pragma GCC diagnostic pop
#endif

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostInitiateWirelessDiscoveryResult(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostInitiateWirelessDiscoveryResult(tenResponseCode enResponseCode,
                                                            const trUserContext& corfrUsrCntxt)
{
    ETG_TRACE_USR1(("spi_tclService::vPostInitiateWirelessDiscoveryResult() entered. Response Code-%d",enResponseCode));

    trMsgContext rMsgContext;
    rMsgContext.rUserContext = corfrUsrCntxt;
    midw_smartphoneintfi_tclMsgInitiateWirelessDiscoveryMethodResult oMRInitiateWirelessDscvry;
    oMRInitiateWirelessDscvry.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;

    FIMsgDispatch oPostMsg(_poMainAppl);
    if( FALSE == oPostMsg.bSendResMessage(oMRInitiateWirelessDscvry,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
    {
        ETG_TRACE_ERR(("[ERR]:vOnMSInitiateWirelessDiscovery() left with Error in posting Message"));
    } //if( FALSE == oPostMsg.bSendMessage

    //! De-allocate memory used by message
    oMRInitiateWirelessDscvry.vDestroy();
}
/***************************************************************************
** FUNCTION:  t_Void spi_tclService::vPostDeviceLockInfo()
***************************************************************************/
t_Void spi_tclService::vPostDeviceLockInfo(const t_U32& corfu32DeviceHandle,
         const tenDeviceCategory& corfenDevCat, const t_Bool& bDeviceLockEnabled)
{
   ETG_TRACE_USR1(("spi_tclService::vPostDeviceLockInfo:Device Handle = %d, "
            "Device Category = %d,DeviceLockEnabled-%d",corfu32DeviceHandle,
            ETG_ENUM(DEVICE_CATEGORY,corfenDevCat),ETG_ENUM(BOOL,bDeviceLockEnabled)));

   m_DeviceLockStatus.DeviceHandle = corfu32DeviceHandle;
   m_DeviceLockStatus.DeviceCategory.enType = (midw_fi_tcl_e8_DeviceCategory::tenType)(corfenDevCat);
   m_DeviceLockStatus.bDeviceLockStatus = bDeviceLockEnabled;

   // Forward the data to HMI
   if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_DEVICELOCKSTATUS))
   {
      ETG_TRACE_ERR(("[ERR]:MIDW_SMARTPHONEINTFI_C_U16_DEVICELOCKSTATUS: Error in updating clients"));
   } //if(FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_NAVIGATIONNEXTTURNDISTANCEDATA))
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclService::vPostDeviceDTCStatus
 ***************************************************************************/
t_Void spi_tclService::vPostDeviceDTCStatus(tenDTCStatus enDevDTCStatus)
{

   if ((nullptr != m_poDiaglogClient))
   {
      m_poDiaglogClient->vHandleDeviceDTCStatus(enDevDTCStatus);
   }

} 

/***************************************************************************
** FUNCTION:  t_Void  spi_tclService::vSendProjectionVideoAttributes()
***************************************************************************/
t_Void spi_tclService::vSendProjectionVideoAttributes(const t_U32 cou32DevID,const trProjectionVideoAttributes& corfrProjVideoAttributes)
{
   ETG_TRACE_USR1(("spi_tclService::vSendProjectionVideoAttributes() entered.DeviceID = 0x%x UIHeight-%d, UIWidth =%d",
            cou32DevID, corfrProjVideoAttributes.u16ProjectionUIHeight, corfrProjVideoAttributes.u16ProjectionUIWidth));
   m_ProjVideoInfoStatus.DeviceHandle = cou32DevID;
   m_ProjVideoInfoStatus.ProjectedVideoAttributes.u16UIResolutionHeight = corfrProjVideoAttributes.u16ProjectionUIHeight;
   m_ProjVideoInfoStatus.ProjectedVideoAttributes.u16UIResolutionWidth = corfrProjVideoAttributes.u16ProjectionUIWidth;
   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_PROJECTEDVIDEOINFO))
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclService::vSendProjectionVideoAttributes:Error in updating clients"));
   }
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostTurnByTurnInfo(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostTurnByTurnInfo(const trTurnByTurnInfo &corfrTurnByTurnInfo)
{
    ETG_TRACE_USR1(("spi_tclService::vPostTurnByTurnInfo() DeviceHandle = %d",corfrTurnByTurnInfo.u32DeviceHandle));
    ETG_TRACE_USR1(("spi_tclService::vPostTurnByTurnInfo() DeviceCat = %d.",ETG_ENUM(DEVICE_CATEGORY,corfrTurnByTurnInfo.enDeviceCategory)));
    m_rTurnByTurnInfo.DeviceHandle = corfrTurnByTurnInfo.u32DeviceHandle;
    m_rTurnByTurnInfo.DeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(corfrTurnByTurnInfo.enDeviceCategory);
    switch(corfrTurnByTurnInfo.enDeviceCategory)
    {
        case e8DEV_TYPE_DIPO:
        {
#ifdef VARIANT_S_FTR_ENABLE_TBT_OLD
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isDiPoRouteGuidanceUpdateValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rCarPlayTBTUpdate.isDiPoRouteGuidanceUpdateValid)));
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isDiPoRouteGuidanceManeuverUpdateValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rCarPlayTBTUpdate.isDiPoRouteGuidanceManeuverUpdateValid)));
            m_rTurnByTurnInfo.CarPlayTBTUpdate.isDiPoRouteGuidanceUpdateValid = corfrTurnByTurnInfo.rCarPlayTBTUpdate.isDiPoRouteGuidanceUpdateValid;
            m_rTurnByTurnInfo.CarPlayTBTUpdate.isDiPoRouteGuidanceManeuverUpdateValid = corfrTurnByTurnInfo.rCarPlayTBTUpdate.isDiPoRouteGuidanceManeuverUpdateValid;
            if(true == corfrTurnByTurnInfo.rCarPlayTBTUpdate.isDiPoRouteGuidanceUpdateValid)
            {
                const trDiPORouteGuidanceUpdate &corfrDiPORouteGuidanceUpdate = corfrTurnByTurnInfo.rCarPlayTBTUpdate.rDiPORouteGuidanceUpdate;
                midw_fi_tcl_DiPORouteGuidanceUpdate &rftclDiPORouteGuidanceUpdate = m_rTurnByTurnInfo.CarPlayTBTUpdate.DiPoRouteGuidanceUpdate;

                ETG_TRACE_USR1(("RouteGuidanceState=%d, ManeuverState=%d",
                                 ETG_ENUM(DIPO_ROUTE_GUIDANCE_STATE,corfrDiPORouteGuidanceUpdate.enRouteGuidanceState),
                                 ETG_ENUM(DIPO_MANEUVER_STATE,corfrDiPORouteGuidanceUpdate.enManeuverState)));
                ETG_TRACE_USR1(("CurrentRoadName=%s",corfrDiPORouteGuidanceUpdate.szCurrentRoadName.c_str()));
                ETG_TRACE_USR1(("DestinationName=%s",corfrDiPORouteGuidanceUpdate.szDestinationName.c_str()));
                ETG_TRACE_USR1(("EstimatedTimeOfArrival=%s",std::to_string(corfrDiPORouteGuidanceUpdate.u64EstimatedTimeOfArrival).c_str()));
                ETG_TRACE_USR1(("TimeRemainingToDestination=%s",std::to_string(corfrDiPORouteGuidanceUpdate.u64TimeRemainingToDestination).c_str()));
                ETG_TRACE_USR1(("DistanceRemaining=%d, DistanceRemainingDisplayUnits=%d, DistanceRemainingDisplayStr=%s",
                                 corfrDiPORouteGuidanceUpdate.u32DistanceRemaining,
                                 ETG_ENUM(TBT_DISTANCE_UNITS,corfrDiPORouteGuidanceUpdate.enDistanceRemainingDisplayUnits),
                                 corfrDiPORouteGuidanceUpdate.szDistanceRemainingDisplayStr.c_str()));
                ETG_TRACE_USR1(("DistanceToNextManeuver=%d, DistanceToNextManeuverDisplayUnits=%d, DistanceToNextManeuverDisplayStr=%s",
                                 corfrDiPORouteGuidanceUpdate.u32DistanceToNextManeuver,
                                 ETG_ENUM(TBT_DISTANCE_UNITS,corfrDiPORouteGuidanceUpdate.enDistanceToNextManeuverDisplayUnits),
                                 corfrDiPORouteGuidanceUpdate.szDistanceToNextManeuverDisplayStr.c_str()));
                ETG_TRACE_USR1(("RouteGuidanceManeuverCount=%d, RouteGuidanceVisibleInApp=%d",
                                 corfrDiPORouteGuidanceUpdate.u16RouteGuidanceManeuverCount,
                                 ETG_ENUM(BOOL,corfrDiPORouteGuidanceUpdate.bIsRouteGuidanceVisibleInApp)));

                rftclDiPORouteGuidanceUpdate.e8RouteGuidanceState.enType = static_cast<midw_fi_tcl_e8_DiPoRouteGuidanceState::tenType>(corfrDiPORouteGuidanceUpdate.enRouteGuidanceState);
                rftclDiPORouteGuidanceUpdate.e8ManeuverState.enType = static_cast<midw_fi_tcl_e8_DiPoManeuverState::tenType>(corfrDiPORouteGuidanceUpdate.enManeuverState);
                rftclDiPORouteGuidanceUpdate.szCurrentRoadName.bSet(corfrDiPORouteGuidanceUpdate.szCurrentRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceUpdate.szDestinationName.bSet(corfrDiPORouteGuidanceUpdate.szDestinationName.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceUpdate.u64EstimatedTimeOfArrival = corfrDiPORouteGuidanceUpdate.u64EstimatedTimeOfArrival;
                rftclDiPORouteGuidanceUpdate.u64TimeRemainingToDestination = corfrDiPORouteGuidanceUpdate.u64TimeRemainingToDestination;
                rftclDiPORouteGuidanceUpdate.u32DistanceRemaining = corfrDiPORouteGuidanceUpdate.u32DistanceRemaining;
                rftclDiPORouteGuidanceUpdate.szDistanceRemainingDisplayStr.bSet(corfrDiPORouteGuidanceUpdate.szDistanceRemainingDisplayStr.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceUpdate.e8DistanceRemainingDisplayUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrDiPORouteGuidanceUpdate.enDistanceRemainingDisplayUnits);
                rftclDiPORouteGuidanceUpdate.u32DistanceToNextManeuver = corfrDiPORouteGuidanceUpdate.u32DistanceToNextManeuver;
                rftclDiPORouteGuidanceUpdate.szDistanceToNextManeuverDisplayStr.bSet(corfrDiPORouteGuidanceUpdate.szDistanceToNextManeuverDisplayStr.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceUpdate.e8DistanceToNextManeuverDisplayUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrDiPORouteGuidanceUpdate.enDistanceToNextManeuverDisplayUnits);
                for(t_U16 u16Index = 0; u16Index < corfrDiPORouteGuidanceUpdate.u16RouteGuidanceManeuverCurrentList.size();u16Index = static_cast<t_U16>(u16Index+1))
                {
                    rftclDiPORouteGuidanceUpdate.u16RouteGuidanceManeuverCurrentList.push_back(corfrDiPORouteGuidanceUpdate.u16RouteGuidanceManeuverCurrentList[u16Index] );
                }
                rftclDiPORouteGuidanceUpdate.u16RouteGuidanceManeuverCount = corfrDiPORouteGuidanceUpdate.u16RouteGuidanceManeuverCount;
                rftclDiPORouteGuidanceUpdate.bIsRouteGuidanceVisibleInApp = corfrDiPORouteGuidanceUpdate.bIsRouteGuidanceVisibleInApp;
            }
            else
            {
                const trDiPORouteGuidanceManeuverUpdate &corfrDiPORouteGuidanceManeuverUpdate = corfrTurnByTurnInfo.rCarPlayTBTUpdate.rDiPORouteGuidanceManeuverUpdate;
                midw_fi_tcl_DiPORouteGuidanceManeuverUpdate &rftclDiPORouteGuidanceManeuverUpdate = m_rTurnByTurnInfo.CarPlayTBTUpdate.DiPoRouteGuidanceManeuverUpdate;

                ETG_TRACE_USR1(("Index=%d, ManeuverType=%d",
                                 corfrDiPORouteGuidanceManeuverUpdate.u16Index,
                                 corfrDiPORouteGuidanceManeuverUpdate.enManeuverType));
                ETG_TRACE_USR1(("ManeuverDescription=%s",corfrDiPORouteGuidanceManeuverUpdate.szManeuverDescription.c_str()));
                ETG_TRACE_USR1(("AfterManeuverRoadName=%s",corfrDiPORouteGuidanceManeuverUpdate.szAfterManeuverRoadName.c_str()));
                ETG_TRACE_USR1(("DistanceBetweenManeuver=%d, DistanceBetweenManeuverDisplayUnits=%d, DistanceBetweenManeuverDisplayStr=%s",
                                 corfrDiPORouteGuidanceManeuverUpdate.u32DistanceBetweenManeuver,
                                 ETG_ENUM(TBT_DISTANCE_UNITS,corfrDiPORouteGuidanceManeuverUpdate.enDistanceBetweenManeuverDisplayUnits),
                                 corfrDiPORouteGuidanceManeuverUpdate.szDistanceBetweenManeuverDisplayStr.c_str()));
                ETG_TRACE_USR1(("DrivingSide=%d, JunctionType=%d, JunctionElementAngle=%d, JunctionElementExitAngle=%d",
                                ETG_ENUM(DIPO_DRIVING_SIDE,corfrDiPORouteGuidanceManeuverUpdate.enDrivingSide),
                                ETG_ENUM(DIPO_JUNCTION_TYPE,corfrDiPORouteGuidanceManeuverUpdate.enJunctionType),
                                corfrDiPORouteGuidanceManeuverUpdate.s16JunctionElementAngleList[0],
                                corfrDiPORouteGuidanceManeuverUpdate.s16JunctionElementExitAngle));

                rftclDiPORouteGuidanceManeuverUpdate.u16Index = corfrDiPORouteGuidanceManeuverUpdate.u16Index;
                rftclDiPORouteGuidanceManeuverUpdate.szManeuverDescription.bSet(corfrDiPORouteGuidanceManeuverUpdate.szManeuverDescription.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceManeuverUpdate.e8ManeuverType.enType = static_cast<midw_fi_tcl_e8_DiPoManeuverType::tenType>(corfrDiPORouteGuidanceManeuverUpdate.enManeuverType);
                rftclDiPORouteGuidanceManeuverUpdate.szAfterManeuverRoadName.bSet(corfrDiPORouteGuidanceManeuverUpdate.szAfterManeuverRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceManeuverUpdate.u32DistanceBetweenManeuver = corfrDiPORouteGuidanceManeuverUpdate.u32DistanceBetweenManeuver;
                rftclDiPORouteGuidanceManeuverUpdate.szDistanceBetweenManeuverDisplayStr.bSet(corfrDiPORouteGuidanceManeuverUpdate.szDistanceBetweenManeuverDisplayStr.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclDiPORouteGuidanceManeuverUpdate.e8DistanceBetweenManeuverDisplayUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrDiPORouteGuidanceManeuverUpdate.enDistanceBetweenManeuverDisplayUnits);
                rftclDiPORouteGuidanceManeuverUpdate.e8DrivingSide.enType = static_cast<midw_fi_tcl_e8_DiPoDrivingSide::tenType>(corfrDiPORouteGuidanceManeuverUpdate.enDrivingSide);
                rftclDiPORouteGuidanceManeuverUpdate.e8JunctionType.enType = static_cast<midw_fi_tcl_e8_DiPoJunctionType::tenType>(corfrDiPORouteGuidanceManeuverUpdate.enJunctionType);
                rftclDiPORouteGuidanceManeuverUpdate.s16JunctionElementAngle = corfrDiPORouteGuidanceManeuverUpdate.s16JunctionElementAngleList[0];
                rftclDiPORouteGuidanceManeuverUpdate.s16JunctionElementExitAngle = corfrDiPORouteGuidanceManeuverUpdate.s16JunctionElementExitAngle;
            }
#else
        // New implementation for CarPlay TurnByTurnInfo is handled in vPostCarPlayRouteGuidanceUpdate and vPostCarPlayRouteGuidanceManeuverUpdate.
        // Hence, not posting TurnByTurnInfo update here
        return;
#endif
        }
        break;
        case e8DEV_TYPE_ANDROIDAUTO:
        {
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isAAutoNavigationNextTurnDataValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid)));
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isAAutoNavigationNextTurnDistanceDataValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid)));
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isAAutoNavigationStatusValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationStatusValid)));
            m_rTurnByTurnInfo.AAutoTBTUpdate.isAAutoNavigationNextTurnDataValid = corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid;
            m_rTurnByTurnInfo.AAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid = corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid;
            m_rTurnByTurnInfo.AAutoTBTUpdate.isAAutoNavigationStatusValid = corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationStatusValid;
            if(true == corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid)
            {
                const trAAutoNavigationNextTurnData &corfrAAutoNavigationNextTurnData = corfrTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData;
                midw_fi_tcl_AAutoNavigationNextTurnData &rftclAAutoNavigationNextTurnData = m_rTurnByTurnInfo.AAutoTBTUpdate.AAutoNavigationNextTurnData;

                ETG_TRACE_USR2(("RoadName=%s",corfrAAutoNavigationNextTurnData.szRoadName.c_str()));
                ETG_TRACE_USR2(("TurnSide=%d, NextTurnEvent=%d, Image size=%d, TurnAngle=%d,TurnNumber=%d",
                                corfrAAutoNavigationNextTurnData.enTurnSide,
                                corfrAAutoNavigationNextTurnData.enNextTurnEvent,
                                corfrAAutoNavigationNextTurnData.u8Image.size(),
                                corfrAAutoNavigationNextTurnData.s32TurnAngle,
                                corfrAAutoNavigationNextTurnData.s32TurnNumber));

                rftclAAutoNavigationNextTurnData.RoadName.bSet(corfrAAutoNavigationNextTurnData.szRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclAAutoNavigationNextTurnData.TurnSide.enType = static_cast<midw_fi_tcl_e8_AAutoTurnSide::tenType>(corfrAAutoNavigationNextTurnData.enTurnSide);
                rftclAAutoNavigationNextTurnData.NextTurnEvent.enType = static_cast<midw_fi_tcl_e8_AAutoNextTurnEvent::tenType>(corfrAAutoNavigationNextTurnData.enNextTurnEvent);
                for(t_U16 u16Index = 0; u16Index < corfrAAutoNavigationNextTurnData.u8Image.size(); u16Index = static_cast<t_U16>(u16Index+1))
                {
                    rftclAAutoNavigationNextTurnData.Image.push_back(corfrAAutoNavigationNextTurnData.u8Image[u16Index] );
                }
                rftclAAutoNavigationNextTurnData.TurnAngle = corfrAAutoNavigationNextTurnData.s32TurnAngle;
                rftclAAutoNavigationNextTurnData.TurnNumber = corfrAAutoNavigationNextTurnData.s32TurnNumber;
            }
            else if(true == corfrTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid)
            {
                const trAAutoNavigationNextTurnDistanceData &corfrAAutoNavigationNextTurnDistanceData = corfrTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnDistanceData;
                midw_fi_tcl_AAutoNavigationNextTurnDistanceData &rftclAAutoNavigationNextTurnDistanceData = m_rTurnByTurnInfo.AAutoTBTUpdate.AAutoNavigationNextTurnDistanceData;

                ETG_TRACE_USR2(("DistanceInMeters=%d, TimeInSec=%d, DistanceToManeuver=%d, ManeuverDistanceUnits=%d",
                                 corfrAAutoNavigationNextTurnDistanceData.s32DistanceInMeters,
                                 corfrAAutoNavigationNextTurnDistanceData.s32TimeInSec,
                                 corfrAAutoNavigationNextTurnDistanceData.s32DistanceToManeuver,
                                 corfrAAutoNavigationNextTurnDistanceData.enManeuverDistanceUnits));

                rftclAAutoNavigationNextTurnDistanceData.DistanceInMeters = corfrAAutoNavigationNextTurnDistanceData.s32DistanceInMeters;
                rftclAAutoNavigationNextTurnDistanceData.TimeInSec = corfrAAutoNavigationNextTurnDistanceData.s32TimeInSec;
                rftclAAutoNavigationNextTurnDistanceData.DistanceToManeuver = corfrAAutoNavigationNextTurnDistanceData.s32DistanceToManeuver;
                rftclAAutoNavigationNextTurnDistanceData.ManeuverDistanceUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrAAutoNavigationNextTurnDistanceData.enManeuverDistanceUnits);
            }
            else
            {
                ETG_TRACE_USR1(("AAutoNavigationStatus=%d",corfrTurnByTurnInfo.rAAutoTBTUpdate.enAAutoNavigationStatus));
                m_rTurnByTurnInfo.AAutoTBTUpdate.AAutoNavigationStatus.enType = static_cast<midw_fi_tcl_e8_AAutoNavigationAppState::tenType>(corfrTurnByTurnInfo.rAAutoTBTUpdate.enAAutoNavigationStatus);
            }
        }
        break;
        case e8DEV_TYPE_CARLIFE:
        {
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isCarlifeNaviNextTurnInfoValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid)));
            ETG_TRACE_USR2(("spi_tclService::vPostTurnByTurnInfo() isCarlifeNaviAssistantGuideInfoValid = %d",
                    ETG_ENUM(BOOL,corfrTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid)));
            m_rTurnByTurnInfo.BDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid = corfrTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid;
            m_rTurnByTurnInfo.BDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid = corfrTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid;
            if(true == corfrTurnByTurnInfo.rBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid)
            {
                const trCarlifeNaviNextTurnInfo &corfrCarlifeNaviNextTurnInfo = corfrTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviNextTurnInfo;
                midw_fi_tcl_CarlifeNaviNextTurnInfo &rftclCarlifeNaviNextTurnInfo = m_rTurnByTurnInfo.BDCLTBTUpdate.CarlifeNaviNextTurnInfo;

                ETG_TRACE_USR2(("BDCLNavigationAppState=%d, BDCLNaviTurnType=%d, TotalDistance=%d, RemainDistance=%d",
                                 corfrCarlifeNaviNextTurnInfo.enBDCLNavigationAppState,
                                 corfrCarlifeNaviNextTurnInfo.enBDCLNaviTurnType,
                                 corfrCarlifeNaviNextTurnInfo.u32TotalDistance,
                                 corfrCarlifeNaviNextTurnInfo.u32RemainDistance));
                //ETG_TRACE_USR2(("RoadName=%s",corfrCarlifeNaviNextTurnInfo.szRoadName.c_str()));
                ETG_TRACE_USR2(("TurnIconData size=%d",corfrCarlifeNaviNextTurnInfo.u8TurnIconData.size()));

                rftclCarlifeNaviNextTurnInfo.BDCLNavigationAppState.enType = static_cast<midw_fi_tcl_e8_BDCLNavigationAppState::tenType>(corfrCarlifeNaviNextTurnInfo.enBDCLNavigationAppState);
                rftclCarlifeNaviNextTurnInfo.BDCLNaviTurnType.enType = static_cast<midw_fi_tcl_e8_BDCLNextTurnType::tenType>(corfrCarlifeNaviNextTurnInfo.enBDCLNaviTurnType);
                rftclCarlifeNaviNextTurnInfo.RoadName.bSet(corfrCarlifeNaviNextTurnInfo.szRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
                rftclCarlifeNaviNextTurnInfo.TotalDistance = corfrCarlifeNaviNextTurnInfo.u32TotalDistance;
                rftclCarlifeNaviNextTurnInfo.RemainDistance = corfrCarlifeNaviNextTurnInfo.u32RemainDistance;
                for(t_U16 u16Index = 0; u16Index < corfrCarlifeNaviNextTurnInfo.u8TurnIconData.size(); u16Index = static_cast<t_U16>(u16Index+1))
                {
                    rftclCarlifeNaviNextTurnInfo.TurnIconData.push_back(corfrCarlifeNaviNextTurnInfo.u8TurnIconData[u16Index] );
                }
            }
            else
            {
                const trCarlifeNaviAssistantGuideInfo &corfrCarlifeNaviAssistantGuideInfo = corfrTurnByTurnInfo.rBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo;
                midw_fi_tcl_CarlifeNaviAssistantGuideInfo &rftclCarlifeNaviAssistantGuideInfo = m_rTurnByTurnInfo.BDCLTBTUpdate.CarlifeNaviAssistantGuideInfo;

                ETG_TRACE_USR2(("BDCLAssistantGuideAppState=%d, AssistantType=%d, TrafficSignType=%d, TotalDistance=%d, RemainDistance=%d, CameraSpeed=%d",
                                 corfrCarlifeNaviAssistantGuideInfo.enBDCLAssistantGuideAppState,
                                 corfrCarlifeNaviAssistantGuideInfo.enAssistantType,
                                 corfrCarlifeNaviAssistantGuideInfo.enTrafficSignType,
                                 corfrCarlifeNaviAssistantGuideInfo.u32TotalDistance,
                                 corfrCarlifeNaviAssistantGuideInfo.u32RemainDistance,
                                 corfrCarlifeNaviAssistantGuideInfo.u32CameraSpeed));

                rftclCarlifeNaviAssistantGuideInfo.BDCLAssistantGuideAppState.enType = static_cast<midw_fi_tcl_e8_BDCLNavigationAppState::tenType>(corfrCarlifeNaviAssistantGuideInfo.enBDCLAssistantGuideAppState);
                rftclCarlifeNaviAssistantGuideInfo.AssistantType.enType = static_cast<midw_fi_tcl_e8_BDCLAssistantType::tenType>(corfrCarlifeNaviAssistantGuideInfo.enAssistantType);
                rftclCarlifeNaviAssistantGuideInfo.TrafficSignType.enType = static_cast<midw_fi_tcl_e8_BDCLTrafficSignType::tenType>(corfrCarlifeNaviAssistantGuideInfo.enTrafficSignType);;
                rftclCarlifeNaviAssistantGuideInfo.TotalDistance = corfrCarlifeNaviAssistantGuideInfo.u32TotalDistance;
                rftclCarlifeNaviAssistantGuideInfo.RemainDistance = corfrCarlifeNaviAssistantGuideInfo.u32RemainDistance;
                rftclCarlifeNaviAssistantGuideInfo.CameraSpeed = corfrCarlifeNaviAssistantGuideInfo.u32CameraSpeed;
            }
        }
        break;
        case e8DEV_TYPE_MIRRORLINK:
        {
           //! Reset flags to flush out flags set from previous update
           m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationInfoUpdateValid = false;
           m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextManeuverUpdateValid = false;
           m_rTurnByTurnInfo.MLTBTUpdate.isMLSpeedLimitUpdateValid = false;
           m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextDistanceUpdateValid = false;
           m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationLaneGuidanceUpdateValid = false;
           m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationTripInfoUpdateValid = false;

           switch(corfrTurnByTurnInfo.rMLTBTUpdate.enMLNaviUpdateType)
           {
              case e8ML_NAVIGATION_INFO:
              {
                 m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationInfoUpdateValid = true;
                 const trMLNavigationInfo &corfrMLNaviInfo = corfrTurnByTurnInfo.rMLTBTUpdate.MLNaviInfo;
                 midw_fi_tcl_MLNavigationInfoUpdate &rftclMLNaviInfoUpdate =
                          m_rTurnByTurnInfo.MLTBTUpdate.MLNavigationInfoUpdate;
                 vPopulateMLNaviInfoUpdate(corfrMLNaviInfo, rftclMLNaviInfoUpdate);
              }
              break;

              case e8ML_NAVIGATION_NEXT_MANEUVER:
              {
                 m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextManeuverUpdateValid = true;
                 const trMLNavigationNextManeuver &corfrMLNaviNextManeuver = corfrTurnByTurnInfo.rMLTBTUpdate.MLNaviNextManeuver;
                 midw_fi_tcl_MLNavigationNextManeuverUpdate &rfctlMLNaviNextManeuverUpdate =
                          m_rTurnByTurnInfo.MLTBTUpdate.MLNavigationNextManeuverUpdate;
                 vPopulateMLNaviNextManeuverUpdate(corfrMLNaviNextManeuver,rfctlMLNaviNextManeuverUpdate);
              }
              break;

              case e8ML_NAVIGATION_SPD_LIMIT:
              {
                 m_rTurnByTurnInfo.MLTBTUpdate.isMLSpeedLimitUpdateValid = true;
                 const trMLNavigationSpeedLimit &corfMLNaviSpdLimit = corfrTurnByTurnInfo.rMLTBTUpdate.MLNaviSpdLimit;
                 midw_fi_tcl_MLSpeedLimitUpdate &rfctlNaviSpdLimitUpdate = m_rTurnByTurnInfo.MLTBTUpdate.MLSpeedLimitUpdate;
                 vPopulateMLNaviSpeedLimitUpdate(corfMLNaviSpdLimit,rfctlNaviSpdLimitUpdate);
              }
              break;

              case e8ML_NAVIGATION_NEXT_DISTANCE:
              {
                 m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextDistanceUpdateValid = true;
                 const trMLNavigationNextDistance &corfMLNaviNextDistance =
                          corfrTurnByTurnInfo.rMLTBTUpdate.MLNaviNextDistance;
                 midw_fi_tcl_MLNavigationNextDistanceUpdate &rfctlMLNaviNextDistanceUpdate =
                          m_rTurnByTurnInfo.MLTBTUpdate.MLNavigationNextDistanceUpdate;
                 vPopulateMLNaviNextDistanceUpdate(corfMLNaviNextDistance,rfctlMLNaviNextDistanceUpdate);
              }
              break;

              case e8ML_NAVIGATION_LANE_GUIDANCE:
              {
                 m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationLaneGuidanceUpdateValid = true;
                 const trMLNavigationLaneGuidance &corfMLNaviLaneGuidance =
                          corfrTurnByTurnInfo.rMLTBTUpdate.MLNaviLaneGuidance;
                 midw_fi_tcl_MLNavigationLaneGuidanceUpdate &rfctlMLNaviLaneGuidanceUpdate =
                          m_rTurnByTurnInfo.MLTBTUpdate.MLNavigationLaneGuidanceUpdate;
                 vPopulateMLNaviLaneGuidanceUpdate(corfMLNaviLaneGuidance,rfctlMLNaviLaneGuidanceUpdate);
              }
              break;

              case e8ML_NAVIGATION_TRIP_INFO:
              {
                 m_rTurnByTurnInfo.MLTBTUpdate.isMLNavigationTripInfoUpdateValid = true;
                 const trMLNavigationTripInfo &corfrMLNaviTripInfo = corfrTurnByTurnInfo.rMLTBTUpdate.MLNaviTripInfo;
                 midw_fi_tcl_MLNavigationTripInfoUpdate &rfctlMLNaviTripInfoUpdate =
                          m_rTurnByTurnInfo.MLTBTUpdate.MLNavigationTripInfoUpdate;
                 vPopulateMLNaviTripInfoUpdate(corfrMLNaviTripInfo,rfctlMLNaviTripInfoUpdate);
              }
              break;

              case e8ML_NAVIGATION_UNKNOWN:
              default:
              {
                 ETG_TRACE_USR2(("MLTBTUpdate:Unhandled case"));
              }
              break;
           }
        }
        break;

        default:
            ETG_TRACE_USR1(("spi_tclService::vPostTurnByTurnInfo: unsupported technology!!"));
        break;
    }

    if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_TURNBYTURNINFO))
    {
        ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostTurnByTurnInfo:Error in updating clients"));
    }
    m_rTurnByTurnInfo.vDestroy();
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService:: vOnMSGetWiFiCredentials()
***************************************************************************/
t_Void spi_tclService::vOnMSGetWiFiCredentials(amt_tclServiceData* poMessage) 
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSGetWiFiCredentials()"));

   spi_tMsgGetWiFiCredentialsMS oGetWiFiCredentialsMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);

   if(TRUE == oGetWiFiCredentialsMS.bIsValid())
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      t_String szBTMacAddr = oGetWiFiCredentialsMS.BTMACAddress.szValue;
      ETG_TRACE_USR2(("vOnMSGetWiFiCredentials:BT MAC Address:%s",szBTMacAddr.c_str()));

      if(true == szBTMacAddr.empty())
      {
	     ETG_TRACE_USR1(("spi_tclService::vOnMSGetWiFiCredentials() Dispatching MethodResult as ERROR - Coz BT Mac is empty"));
         tenErrorCode enErrorCode = e8OPERATION_REJECTED;
         //If BT Mac address is empty, then send the Response to MP as ERROR
         midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult oMRGetWiFiCredentials;

         //Here BT Mac will be empty and Wifi credentials will not be dispatched
         oMRGetWiFiCredentials.BTMACAddress.bSet(szBTMacAddr.c_str(), midw_fi_tclString::FI_EN_UTF8);
         oMRGetWiFiCredentials.ErrorCode.enType = static_cast<midw_fi_tcl_e8_ErrorType::tenType>(enErrorCode);

         FIMsgDispatch oPostMsg(_poMainAppl);
         if( FALSE == oPostMsg.bSendResMessage(oMRGetWiFiCredentials,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
         {
            ETG_TRACE_ERR(("[ERR]:vSendWiFiCredentials() left with Error in posting Message"));
         } //if( FALSE == oPostMsg.bSendMessage

         oMRGetWiFiCredentials.vDestroy();
      }
      else
      {
         if(OSAL_NULL != m_poSpiCmdIntf)
         {
            m_poSpiCmdIntf->vGetWiFiCredentials(szBTMacAddr,rMsgContext.rUserContext);
         }
      }
   }//if(TRUE == oGetWiFiCredentialsMS.bIsValid())
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vSendWiFiCredentials()
***************************************************************************/
t_Void spi_tclService::vSendWiFiCredentials(t_String szBTMACAddress,
                               tenErrorCode enErrorCode,
							   const trWiFiAPConfig& corfrWiFiAPConfig,
							   const trUserContext& corfrUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclService::vSendWiFiCredentials()"));	

   midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult oMRGetWiFiCredentials;	
   
   oMRGetWiFiCredentials.BTMACAddress.bSet(szBTMACAddress.c_str(), midw_fi_tclString::FI_EN_UTF8); 
   oMRGetWiFiCredentials.ErrorCode.enType = static_cast<midw_fi_tcl_e8_ErrorType::tenType>(enErrorCode);
   
   oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.SSID.bSet(corfrWiFiAPConfig.szSSID.c_str(), midw_fi_tclString::FI_EN_UTF8);
   oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.PassPhrase.bSet(corfrWiFiAPConfig.szPassphrase.c_str(), midw_fi_tclString::FI_EN_UTF8);
   oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.ChannelNo = corfrWiFiAPConfig.u16OperatingChannel;
   oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.SecurityType.enType = static_cast<midw_fi_tcl_e8_WiFiSecurityType::tenType>(corfrWiFiAPConfig.enSecurity);
   
   ETG_TRACE_USR4(("vSendWiFiCredentials:SSID:%s",oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.SSID.szValue));
   ETG_TRACE_USR4(("vSendWiFiCredentials:PassPhrase:%s",oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.PassPhrase.szValue));
   ETG_TRACE_USR4(("vSendWiFiCredentials:Channel:%d, SecurityType:%d",oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.ChannelNo,
                                                                      oMRGetWiFiCredentials.AccessoryWiFiAPCredentials.SecurityType.enType));
   
   trMsgContext rMsgContext;
   rMsgContext.rUserContext = corfrUsrCntxt;
   
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRGetWiFiCredentials,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
       ETG_TRACE_ERR(("[ERR]:vSendWiFiCredentials() left with Error in posting Message"));
   } //if( FALSE == oPostMsg.bSendMessage

   //! De-allocate memory used by message
   oMRGetWiFiCredentials.vDestroy();
   
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vOnMSSendVendorExtensionData(amt_tclServiceData* poMessage)
 *********************************************************************************************/
t_Void spi_tclService::vOnMSSendVendorExtensionData(amt_tclServiceData* poMessage) const
{
    ETG_TRACE_USR1(("spi_tclService::vOnMSSendVendorExtensionData() entered."));

    trUserContext rUsrContext;
    CPY_TO_USRCNTXT(poMessage, rUsrContext);

    //m_poSpiCmdIntf->vSendVendorExtsnData(poVendorExtsnData,uLengthOfData,rUsrContext);
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostVendorExtsnData(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostVendorExtsnData(const t_U8* poVendorExtsnData, size_t uLengthOfData)
{
   SPI_INTENTIONALLY_UNUSED(poVendorExtsnData);
   SPI_INTENTIONALLY_UNUSED(uLengthOfData);
   ETG_TRACE_USR1(("spi_tclService::vPostVendorExtsnData entered."));
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostSendVendorExtsnDataResult(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostSendVendorExtsnDataResult(tenResponseCode enResponseCode,tenErrorCode enErrorCode,
           const trUserContext rcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(enResponseCode);
   SPI_INTENTIONALLY_UNUSED(enErrorCode);
   SPI_INTENTIONALLY_UNUSED(rcUsrCntxt);
   ETG_TRACE_USR1(("spi_tclService::vPostSendVendorExtsnDataResult entered."));
}


/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSetETCStatus()
***************************************************************************/
t_Void spi_tclService::vOnMSSetETCStatus(amt_tclServiceData* poMessage)
{
	   ETG_TRACE_USR1(("spi_tclService::vOnMSSetETCStatus() Entered"));
	   spi_tMsgSetETCStatusMS oSetETCStatus(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
	   if((TRUE == oSetETCStatus.bIsValid()) && (NULL != m_poSpiCmdIntf))
	   {
			trMsgContext rMsgContext;
			CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
			ETG_TRACE_USR4(("ETC Status = %d ",ETG_ENUM(BOOL, oSetETCStatus.ETCStatus)));
			m_poSpiCmdIntf->vSetETCStatus(oSetETCStatus.ETCStatus);

	   }
	   else
	   {
		   ETG_TRACE_ERR(("spi_tclService::vOnMSSetETCStatus - Invalid Update"));
	   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSendVehiclePowerModeState()
***************************************************************************/
t_Void spi_tclService::vOnMSSendVehiclePowerModeState(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSendVehiclePowerModeState() entered"));
   spi_tMsgSendVehiclePowerModeStateMS oSendVehiclePowerModeStateMS(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSendVehiclePowerModeStateMS.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      ETG_TRACE_USR2(("[DESC]:vOnMSSendVehiclePowerModeState() having vehicle power mode state as -%d ",ETG_ENUM(VEHICLE_POWER_MODE,oSendVehiclePowerModeStateMS.VehiclePowerModeState.enType)));

      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);


      tenVehiclePowerMode enVehiclePowerMode = static_cast<tenVehiclePowerMode>(oSendVehiclePowerModeStateMS.VehiclePowerModeState.enType);

      //! there is no INVALID data in the vehicle power mode enum, due to which there is validation done on the data that is being sent by HMI
      tenResponseCode enRespCode = e8SUCCESS;
      tenErrorCode enErrorCode = e8NO_ERRORS;

      m_poSpiCmdIntf->vSendVehiclePowerModeState(enVehiclePowerMode,rUsrCntxt);

      vPostSendVehiclePowerModeStateResponse(enRespCode,enErrorCode,rUsrCntxt);
   }//if( (TRUE == oSendVehiclePowerModeStateMS.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSendKeyEvent()
***************************************************************************/
t_Void spi_tclService::vPostSendVehiclePowerModeStateResponse(tenResponseCode enResponseCode,
                                         tenErrorCode enErrorCode,
                                         const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSendVehiclePowerModeStateResponse:enErrorCode:%d",enErrorCode));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSendVehiclePowerModeStateMethodResult oMRSendVehiclePowerModeStateResponse;
   oMRSendVehiclePowerModeStateResponse.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSendVehiclePowerModeStateResponse.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSendVehiclePowerModeStateResponse,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSendVehiclePowerModeStateResponse:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSendAmbientColour()
***************************************************************************/
t_Void spi_tclService::vOnMSSendAmbientColour(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSSendAmbientColour() entered"));
   spi_tMsgSendAmbientColorMS oSendAmbientColorMS(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if( (TRUE == oSendAmbientColorMS.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
   {
      ETG_TRACE_USR2(("[DESC]:vOnMSSendAmbientColour() Contains RGBAlpha details as follows "));
      ETG_TRACE_USR2(("[DESC]:vOnMSSendAmbientColour() Contains Red Value %2f", oSendAmbientColorMS.AmbientColourData.fRed));
      ETG_TRACE_USR2(("[DESC]:vOnMSSendAmbientColour() Contains Green Value %2f", oSendAmbientColorMS.AmbientColourData.fGreen));
      ETG_TRACE_USR2(("[DESC]:vOnMSSendAmbientColour() Contains Blue Value %2f", oSendAmbientColorMS.AmbientColourData.fBlue));
      ETG_TRACE_USR2(("[DESC]:vOnMSSendAmbientColour() Contains Alpha Value %2f", oSendAmbientColorMS.AmbientColourData.fAlpha));

      trUserContext rUsrCntxt;
      CPY_TO_USRCNTXT(poMessage, rUsrCntxt);

      trAmbientColorData rAmbientColorData;
      rAmbientColorData.fRed = oSendAmbientColorMS.AmbientColourData.fRed;
      rAmbientColorData.fGreen = oSendAmbientColorMS.AmbientColourData.fGreen;
      rAmbientColorData.fBlue = oSendAmbientColorMS.AmbientColourData.fBlue;
      rAmbientColorData.fAlpha = oSendAmbientColorMS.AmbientColourData.fAlpha;


      //! there is no INVALID data in the vehicle power mode enum, due to which there is validation done on the data that is being sent by HMI
      tenResponseCode enRespCode = e8SUCCESS;
      tenErrorCode enErrorCode = e8NO_ERRORS;
      //! do the Validation here


      m_poSpiCmdIntf->vSendAmbientColorData(rAmbientColorData,rUsrCntxt);

      vPostSendAmbientColorDataResponse(enRespCode,enErrorCode,rUsrCntxt);
   }//if( (TRUE == oSendVehiclePowerModeStateMS.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
}

/***************************************************************************
** FUNCTION: t_Void spi_tclService::vPostSendAmbientColorDataResponse()
***************************************************************************/
t_Void spi_tclService::vPostSendAmbientColorDataResponse(tenResponseCode enResponseCode,
                                         tenErrorCode enErrorCode,
                                         const trUserContext rcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostSendAmbientColorDataResponse:enErrorCode:%d",enErrorCode));
   trMsgContext rMsgCntxt;
   rMsgCntxt.rUserContext = rcUsrCntxt;

   midw_smartphoneintfi_tclMsgSendAmbientColourMethodResult oMRSendAmbientColorDataResponse;
   oMRSendAmbientColorDataResponse.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enResponseCode;
   oMRSendAmbientColorDataResponse.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;

   //post Method result to HMI
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRSendAmbientColorDataResponse,rMsgCntxt,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostSendAmbientColorDataResponse:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vClearPrivateDataOnfactoryReset()
***************************************************************************/
t_Void spi_tclService::vClearPrivateDataOnfactoryReset()
{

   ETG_TRACE_USR1(("spi_tclService::vClearPrivateDataOnfactoryReset Entered"));
   vOnFactoryResetClearPrivateData();
}


/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnFactoryResetClearPrivateData()
***************************************************************************/
t_Void spi_tclService::vOnFactoryResetClearPrivateData()
{
   ETG_TRACE_USR1(("spi_tclService::vOnFactoryResetClearPrivateData Entered"));
   if(nullptr != m_poSpiCmdIntf)
   {
      m_poSpiCmdIntf->vClearPrivateDataOnfactoryReset();
   }

   //! Need clear all the Maps that are used in Client Handlers
   if(NULL != m_poExtClientFactory)
   {
      m_poExtClientFactory->vRestoreSettings();
   }
}
/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSSendLanguageSetting() oSendKeyEvent.KeyCode.enType
***************************************************************************/
t_Void spi_tclService::vOnMSSendLanguageSetting(amt_tclServiceData* poMessage)
{
     ETG_TRACE_USR1(("spi_tclService::vOnMSLanguageSetting Entered"));
    spi_tMsgSendLanguageSettingMS oLanguageSetting(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
     if((TRUE == oLanguageSetting.bIsValid())&&(nullptr != m_poSpiCmdIntf) )
     {
        ETG_TRACE_USR2(("[DESC]:vOnMSLanguageSetting() received with LanguageSetting-%d",oLanguageSetting.LanguageSetting.enType));
         trUserContext rUsrContext;
         CPY_TO_USRCNTXT(poMessage, rUsrContext);

         tenLanguageSetting enLanguageSetting = enGetLanguageSetting(oLanguageSetting.LanguageSetting.enType);

         tenResponseCode enRespCode = e8SUCCESS;
         tenErrorCode enErrorCode = e8NO_ERRORS;
         if(e32LANGUAGE_UNSUPPORTED != enLanguageSetting)
         {
            m_poSpiCmdIntf->vOnSendLanguageSetting(enLanguageSetting);
         }
         else
         {
            enRespCode = e8FAILURE;
            enErrorCode = e8UNSUPPORTED_KEY;
         }
         //post Method result to HMI
         FIMsgDispatch oPostMsg(_poMainAppl);
         midw_smartphoneintfi_tclMsgSendLanguageSettingMethodResult oMRSendLanguageSetting;

         trMsgContext rMsgContext;
         rMsgContext.rUserContext = rUsrContext;
         oMRSendLanguageSetting.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enRespCode;
         oMRSendLanguageSetting.ErrorCode.enType = (midw_fi_tcl_e8_ErrorType::tenType)enErrorCode ;
         if( FALSE == oPostMsg.bSendResMessage(oMRSendLanguageSetting, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
         {
             ETG_TRACE_ERR(("[ERR]:vOnMSLanguageSetting() left with Error in posting Method Result"));
         } //if( FALSE == oPostMsg.bSendMessage)
     }
}
/***************************************************************************
** FUNCTION: tenKeyCode spi_tclService::vInsertLanguageToMap()const
***************************************************************************/
t_Void spi_tclService::vInsertLanguageToMap()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vInsertLanguageToMap entered "));

   t_U32 u32Length = sizeof(aLanguageSetting)/sizeof(trLanguageSetting);

   for(t_U32 u32Index=0; u32Index < u32Length ;++u32Index)
   {
      m_mapLanguageSetting.insert(std::pair<spi_tenFiLanguageSetting,tenLanguageSetting>
         (aLanguageSetting[u32Index].e32SpiLanguageSetting,aLanguageSetting[u32Index].enLanguageSetting));
   }

    ETG_TRACE_USR1(("[FUNC]spi_tclService::vInsertLanguageToMap Printing Language Pair of the Map "));
   //Iterator to iterate through the Language Settings Map
   std::map<spi_tenFiLanguageSetting,tenLanguageSetting>::const_iterator itLanguageSetting;
   for(itLanguageSetting = m_mapLanguageSetting.begin();itLanguageSetting != m_mapLanguageSetting.end();++itLanguageSetting)
   {
      ETG_TRACE_USR1(("spi_tclService::vInsertLanguageToMap: Language in FI Types-0x%x ",itLanguageSetting->first));
      ETG_TRACE_USR1(("spi_tclService::vInsertLanguageToMap: Value in SPI Types-0x%x ",itLanguageSetting->second));
   }
}
/***************************************************************************
** FUNCTION: tenKeyCode spi_tclService::enGetLanguageSetting()const
***************************************************************************/
tenLanguageSetting spi_tclService::enGetLanguageSetting(spi_tenFiLanguageSetting e32SpiLanguageSetting)const
{
   //Default LanguageSetting
   tenLanguageSetting enLanguageSetting = e32LANGUAGE_UNSUPPORTED;
   //Iterator to iterate through the LanguageSetting map
   std::map<spi_tenFiLanguageSetting,tenLanguageSetting>::const_iterator itLanguageSetting;

   //Find the requested value and return the associated enum value with that.
   itLanguageSetting = m_mapLanguageSetting.find(e32SpiLanguageSetting);
   if(m_mapLanguageSetting.end() != itLanguageSetting)
   {
      enLanguageSetting = itLanguageSetting->second ;
   }
   ETG_TRACE_USR1(("spi_tclService::enGetLanguageSetting: LanguageSetting in SPI Types-%d ",ETG_ENUM(LANGUAGE_SETTING, enLanguageSetting)));

   return enLanguageSetting;
}
/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSDistanceToEmptyTank()
***************************************************************************/
t_Void spi_tclService::vOnMSDistanceToEmptyTank(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSDistanceToEmptyTank() Entered"));
   spi_tMsgDistanceToEmptyTankMS oDistanceToEmptyTank(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
   if((TRUE == oDistanceToEmptyTank.bIsValid()) && (NULL != m_poSpiCmdIntf))
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);
      ETG_TRACE_USR4(("Distance To Empty Tanks = %d \n", oDistanceToEmptyTank.DistanceToEmptyTank));
      m_poSpiCmdIntf->vDistanceToEmptyTank(oDistanceToEmptyTank.DistanceToEmptyTank);
      trMsgContext rMsgCntxt;
      CPY_TO_USRCNTXT(poMessage, rMsgCntxt.rUserContext);

      midw_smartphoneintfi_tclMsgDistanceToEmptyTankMethodResult oMRDistanceToEmptyTank;
      oMRDistanceToEmptyTank.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
      oMRDistanceToEmptyTank.ErrorCode.enType = midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if( FALSE == oPostMsg.bSendResMessage(oMRDistanceToEmptyTank, rMsgCntxt, SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSDistanceToEmptyTank() left with Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage)
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vPostAAutoTurnByTurnInfo()
***************************************************************************/
t_Void spi_tclService::vPostAAutoTurnByTurnInfo(t_U32 u32DevHandle, const trAAutoTBTUpdate &corfrAAutoTBTUpdate)
{
   ETG_TRACE_USR1(("spi_tclService::vPostAAutoTurnByTurnInfo() DeviceHandle = %d", u32DevHandle));
   m_rAAutoTurnByTurnInfo.DeviceHandle = u32DevHandle;

   ETG_TRACE_USR4(("[DESC]: spi_tclService::vPostAAutoTurnByTurnInfo() isAAutoNavigationNextTurnDataValid = %d",
                    ETG_ENUM(BOOL,corfrAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid)));
   ETG_TRACE_USR4(("[DESC]: spi_tclService::vPostAAutoTurnByTurnInfo() isAAutoNavigationNextTurnDistanceDataValid = %d",
                    ETG_ENUM(BOOL,corfrAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid)));
   ETG_TRACE_USR4(("[DESC]: spi_tclService::vPostAAutoTurnByTurnInfo() isAAutoNavigationStatusValid = %d",
                    ETG_ENUM(BOOL,corfrAAutoTBTUpdate.isAAutoNavigationStatusValid)));

   m_rAAutoTurnByTurnInfo.AAutoTBTUpdate.isAAutoNavigationNextTurnDataValid = corfrAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid;
   m_rAAutoTurnByTurnInfo.AAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid = corfrAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid;
   m_rAAutoTurnByTurnInfo.AAutoTBTUpdate.isAAutoNavigationStatusValid = corfrAAutoTBTUpdate.isAAutoNavigationStatusValid;

   if(true == corfrAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid)
   {
      const trAAutoNavigationNextTurnData &corfrAAutoNavigationNextTurnData = corfrAAutoTBTUpdate.AAutoNavigationNextTurnData;
      midw_fi_tcl_AAutoNavigationNextTurnData &rftclAAutoNavigationNextTurnData = m_rAAutoTurnByTurnInfo.AAutoTBTUpdate.AAutoNavigationNextTurnData;

      ETG_TRACE_USR4(("[DESC]: vPostAAutoTurnByTurnInfo - RoadName = %s", corfrAAutoNavigationNextTurnData.szRoadName.c_str()));
      ETG_TRACE_USR4(("[DESC]: vPostAAutoTurnByTurnInfo - TurnSide = %d, NextTurnEvent = %d, Image size = %d, TurnAngle = %d, TurnNumber = %d",
                       corfrAAutoNavigationNextTurnData.enTurnSide, corfrAAutoNavigationNextTurnData.enNextTurnEvent,
                       corfrAAutoNavigationNextTurnData.u8Image.size(), corfrAAutoNavigationNextTurnData.s32TurnAngle,
                       corfrAAutoNavigationNextTurnData.s32TurnNumber));

      rftclAAutoNavigationNextTurnData.RoadName.bSet(corfrAAutoNavigationNextTurnData.szRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      rftclAAutoNavigationNextTurnData.TurnSide.enType = static_cast<midw_fi_tcl_e8_AAutoTurnSide::tenType>(corfrAAutoNavigationNextTurnData.enTurnSide);
      rftclAAutoNavigationNextTurnData.NextTurnEvent.enType = static_cast<midw_fi_tcl_e8_AAutoNextTurnEvent::tenType>(corfrAAutoNavigationNextTurnData.enNextTurnEvent);

      for(t_U16 u16Index = 0; u16Index < corfrAAutoNavigationNextTurnData.u8Image.size(); u16Index = static_cast<t_U16>(u16Index+1))
      {
         rftclAAutoNavigationNextTurnData.Image.push_back(corfrAAutoNavigationNextTurnData.u8Image[u16Index] );
      }

      rftclAAutoNavigationNextTurnData.TurnAngle = corfrAAutoNavigationNextTurnData.s32TurnAngle;
      rftclAAutoNavigationNextTurnData.TurnNumber = corfrAAutoNavigationNextTurnData.s32TurnNumber;
   }
   else if(true == corfrAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid)
   {
      const trAAutoNavigationNextTurnDistanceData &corfrAAutoNavigationNextTurnDistanceData = corfrAAutoTBTUpdate.AAutoNavigationNextTurnDistanceData;
      midw_fi_tcl_AAutoNavigationNextTurnDistanceData &rftclAAutoNavigationNextTurnDistanceData = m_rAAutoTurnByTurnInfo.AAutoTBTUpdate.AAutoNavigationNextTurnDistanceData;

      ETG_TRACE_USR4(("[DESC]: vPostAAutoTurnByTurnInfo - DistanceInMeters = %d, TimeInSec = %d, DistanceToManeuver = %d, ManeuverDistanceUnits = %d",
                       corfrAAutoNavigationNextTurnDistanceData.s32DistanceInMeters, corfrAAutoNavigationNextTurnDistanceData.s32TimeInSec,
                       corfrAAutoNavigationNextTurnDistanceData.s32DistanceToManeuver, corfrAAutoNavigationNextTurnDistanceData.enManeuverDistanceUnits));

      rftclAAutoNavigationNextTurnDistanceData.DistanceInMeters = corfrAAutoNavigationNextTurnDistanceData.s32DistanceInMeters;
      rftclAAutoNavigationNextTurnDistanceData.TimeInSec = corfrAAutoNavigationNextTurnDistanceData.s32TimeInSec;
      rftclAAutoNavigationNextTurnDistanceData.DistanceToManeuver = corfrAAutoNavigationNextTurnDistanceData.s32DistanceToManeuver;
      rftclAAutoNavigationNextTurnDistanceData.ManeuverDistanceUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrAAutoNavigationNextTurnDistanceData.enManeuverDistanceUnits);
   }
   else
   {
      ETG_TRACE_USR4(("[DESC]: vPostAAutoTurnByTurnInfo - AAutoNavigationStatus = %d", corfrAAutoTBTUpdate.enAAutoNavigationStatus));
      m_rAAutoTurnByTurnInfo.AAutoTBTUpdate.AAutoNavigationStatus.enType = static_cast<midw_fi_tcl_e8_AAutoNavigationAppState::tenType>(corfrAAutoTBTUpdate.enAAutoNavigationStatus);
   }

   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_AAUTOTURNBYTURNINFO))
   {
       ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostAAutoTurnByTurnInfo - Error in updating clients"));
   }
   m_rAAutoTurnByTurnInfo.vDestroy();
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vPostMLTurnByTurnInfo()
***************************************************************************/
t_Void spi_tclService::vPostMLTurnByTurnInfo(t_U32 u32DevHandle, const trMLTBTUpdate &corfrMLTBTUpdate)
{
   ETG_TRACE_USR1(("spi_tclService::vPostMLTurnByTurnInfo() DeviceHandle = %d", u32DevHandle));
   m_rMLTurnByTurnInfo.DeviceHandle = u32DevHandle;

   //! Reset flags to flush out flags set from previous update
   m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationInfoUpdateValid = false;
   m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextManeuverUpdateValid = false;
   m_rMLTurnByTurnInfo.MLTBTUpdate.isMLSpeedLimitUpdateValid = false;
   m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextDistanceUpdateValid = false;
   m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationLaneGuidanceUpdateValid = false;
   m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationTripInfoUpdateValid = false;

   switch(corfrMLTBTUpdate.enMLNaviUpdateType)
   {
      case e8ML_NAVIGATION_INFO:
      {
         m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationInfoUpdateValid = true;
         const trMLNavigationInfo &corfrMLNaviInfo = corfrMLTBTUpdate.MLNaviInfo;
         midw_fi_tcl_MLNavigationInfoUpdate &rftclMLNaviInfoUpdate = m_rMLTurnByTurnInfo.MLTBTUpdate.MLNavigationInfoUpdate;
         vPopulateMLNaviInfoUpdate(corfrMLNaviInfo, rftclMLNaviInfoUpdate);
      }
      break;

      case e8ML_NAVIGATION_NEXT_MANEUVER:
      {
         m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextManeuverUpdateValid = true;
         const trMLNavigationNextManeuver &corfrMLNaviNextManeuver = corfrMLTBTUpdate.MLNaviNextManeuver;
         midw_fi_tcl_MLNavigationNextManeuverUpdate &rfctlMLNaviNextManeuverUpdate = m_rMLTurnByTurnInfo.MLTBTUpdate.MLNavigationNextManeuverUpdate;
         vPopulateMLNaviNextManeuverUpdate(corfrMLNaviNextManeuver,rfctlMLNaviNextManeuverUpdate);
      }
      break;

      case e8ML_NAVIGATION_SPD_LIMIT:
      {
         m_rMLTurnByTurnInfo.MLTBTUpdate.isMLSpeedLimitUpdateValid = true;
         const trMLNavigationSpeedLimit &corfrMLNaviSpdLimit = corfrMLTBTUpdate.MLNaviSpdLimit;
         midw_fi_tcl_MLSpeedLimitUpdate &rfctlNaviSpdLimitUpdate = m_rMLTurnByTurnInfo.MLTBTUpdate.MLSpeedLimitUpdate;
         vPopulateMLNaviSpeedLimitUpdate(corfrMLNaviSpdLimit,rfctlNaviSpdLimitUpdate);
      }
      break;

      case e8ML_NAVIGATION_NEXT_DISTANCE:
      {
         m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationNextDistanceUpdateValid = true;
         const trMLNavigationNextDistance &corfrMLNaviNextDistance = corfrMLTBTUpdate.MLNaviNextDistance;
         midw_fi_tcl_MLNavigationNextDistanceUpdate &rfctlMLNaviNextDistanceUpdate = m_rMLTurnByTurnInfo.MLTBTUpdate.MLNavigationNextDistanceUpdate;
         vPopulateMLNaviNextDistanceUpdate(corfrMLNaviNextDistance,rfctlMLNaviNextDistanceUpdate);
      }
      break;

      case e8ML_NAVIGATION_LANE_GUIDANCE:
      {
         m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationLaneGuidanceUpdateValid = true;
         const trMLNavigationLaneGuidance &corfrMLNaviLaneGuidance = corfrMLTBTUpdate.MLNaviLaneGuidance;
         midw_fi_tcl_MLNavigationLaneGuidanceUpdate &rfctlMLNaviLaneGuidanceUpdate = m_rMLTurnByTurnInfo.MLTBTUpdate.MLNavigationLaneGuidanceUpdate;
         vPopulateMLNaviLaneGuidanceUpdate(corfrMLNaviLaneGuidance,rfctlMLNaviLaneGuidanceUpdate);
      }
      break;

      case e8ML_NAVIGATION_TRIP_INFO:
      {
         m_rMLTurnByTurnInfo.MLTBTUpdate.isMLNavigationTripInfoUpdateValid = true;
         const trMLNavigationTripInfo &corfrMLNaviTripInfo = corfrMLTBTUpdate.MLNaviTripInfo;
         midw_fi_tcl_MLNavigationTripInfoUpdate &rfctlMLNaviTripInfoUpdate = m_rMLTurnByTurnInfo.MLTBTUpdate.MLNavigationTripInfoUpdate;
         vPopulateMLNaviTripInfoUpdate(corfrMLNaviTripInfo,rfctlMLNaviTripInfoUpdate);
      }
      break;

      case e8ML_NAVIGATION_UNKNOWN:
      default:
      {
         ETG_TRACE_USR2(("[DESC]: vPostMLTurnByTurnInfo - Unhandled case"));
      }
      break;
   }

   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_MLTURNBYTURNINFO))
   {
       ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostMLTurnByTurnInfo - Error in updating clients"));
   }
   m_rMLTurnByTurnInfo.vDestroy();
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vPostBDCLTurnByTurnInfo()
***************************************************************************/
t_Void spi_tclService::vPostBDCLTurnByTurnInfo(t_U32 u32DevHandle, const trBDCLTBTUpdate &corfrBDCLTBTUpdate)
{
   ETG_TRACE_USR1(("spi_tclService::vPostBDCLTurnByTurnInfo() DeviceHandle = %d", u32DevHandle));
   m_rBDCLTurnByTurnInfo.DeviceHandle = u32DevHandle;

   ETG_TRACE_USR4(("[DESC}: vPostBDCLTurnByTurnInfo() - isCarlifeNaviNextTurnInfoValid = %d",
                    ETG_ENUM(BOOL,corfrBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid)));
   ETG_TRACE_USR4(("[DESC}: vPostBDCLTurnByTurnInfo() - isCarlifeNaviAssistantGuideInfoValid = %d",
                    ETG_ENUM(BOOL,corfrBDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid)));

   m_rBDCLTurnByTurnInfo.BDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid = corfrBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid;
   m_rBDCLTurnByTurnInfo.BDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid = corfrBDCLTBTUpdate.isCarlifeNaviAssistantGuideInfoValid;
   if(true == corfrBDCLTBTUpdate.isCarlifeNaviNextTurnInfoValid)
   {
      const trCarlifeNaviNextTurnInfo &corfrCarlifeNaviNextTurnInfo = corfrBDCLTBTUpdate.CarlifeNaviNextTurnInfo;
      midw_fi_tcl_CarlifeNaviNextTurnInfo &rftclCarlifeNaviNextTurnInfo = m_rBDCLTurnByTurnInfo.BDCLTBTUpdate.CarlifeNaviNextTurnInfo;

      ETG_TRACE_USR4(("[DESC}: vPostBDCLTurnByTurnInfo() - BDCLNavigationAppState = %d, BDCLNaviTurnType = %d, TotalDistance = %d, RemainDistance = %d",
                       corfrCarlifeNaviNextTurnInfo.enBDCLNavigationAppState, corfrCarlifeNaviNextTurnInfo.enBDCLNaviTurnType,
                       corfrCarlifeNaviNextTurnInfo.u32TotalDistance, corfrCarlifeNaviNextTurnInfo.u32RemainDistance));
      ETG_TRACE_USR4(("[DESC}: vPostBDCLTurnByTurnInfo() - RoadName = %s", corfrCarlifeNaviNextTurnInfo.szRoadName.c_str()));
      ETG_TRACE_USR4(("[DESC}: vPostBDCLTurnByTurnInfo() - TurnIconData size = %d", corfrCarlifeNaviNextTurnInfo.u8TurnIconData.size()));

      rftclCarlifeNaviNextTurnInfo.BDCLNavigationAppState.enType = static_cast<midw_fi_tcl_e8_BDCLNavigationAppState::tenType>(corfrCarlifeNaviNextTurnInfo.enBDCLNavigationAppState);
      rftclCarlifeNaviNextTurnInfo.BDCLNaviTurnType.enType = static_cast<midw_fi_tcl_e8_BDCLNextTurnType::tenType>(corfrCarlifeNaviNextTurnInfo.enBDCLNaviTurnType);
      rftclCarlifeNaviNextTurnInfo.RoadName.bSet(corfrCarlifeNaviNextTurnInfo.szRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);
      rftclCarlifeNaviNextTurnInfo.TotalDistance = corfrCarlifeNaviNextTurnInfo.u32TotalDistance;
      rftclCarlifeNaviNextTurnInfo.RemainDistance = corfrCarlifeNaviNextTurnInfo.u32RemainDistance;

      std::vector<t_U8>::const_iterator itrCarlifeNextTurnInfo;
      for(itrCarlifeNextTurnInfo = corfrCarlifeNaviNextTurnInfo.u8TurnIconData.begin(); itrCarlifeNextTurnInfo != corfrCarlifeNaviNextTurnInfo.u8TurnIconData.end(); itrCarlifeNextTurnInfo++)
      {
         rftclCarlifeNaviNextTurnInfo.TurnIconData.push_back(*itrCarlifeNextTurnInfo);
      }
   }
   else
   {
      const trCarlifeNaviAssistantGuideInfo &corfrCarlifeNaviAssistantGuideInfo = corfrBDCLTBTUpdate.CarlifeNaviAssistantGuideInfo;
      midw_fi_tcl_CarlifeNaviAssistantGuideInfo &rftclCarlifeNaviAssistantGuideInfo = m_rBDCLTurnByTurnInfo.BDCLTBTUpdate.CarlifeNaviAssistantGuideInfo;

      ETG_TRACE_USR4(("[DESC}: vPostBDCLTurnByTurnInfo() - BDCLAssistantGuideAppState=%d, AssistantType=%d, TrafficSignType=%d, TotalDistance=%d, RemainDistance=%d, CameraSpeed=%d",
                        corfrCarlifeNaviAssistantGuideInfo.enBDCLAssistantGuideAppState, corfrCarlifeNaviAssistantGuideInfo.enAssistantType,
                        corfrCarlifeNaviAssistantGuideInfo.enTrafficSignType, corfrCarlifeNaviAssistantGuideInfo.u32TotalDistance,
                        corfrCarlifeNaviAssistantGuideInfo.u32RemainDistance, corfrCarlifeNaviAssistantGuideInfo.u32CameraSpeed));

      rftclCarlifeNaviAssistantGuideInfo.BDCLAssistantGuideAppState.enType = static_cast<midw_fi_tcl_e8_BDCLNavigationAppState::tenType>(corfrCarlifeNaviAssistantGuideInfo.enBDCLAssistantGuideAppState);
      rftclCarlifeNaviAssistantGuideInfo.AssistantType.enType = static_cast<midw_fi_tcl_e8_BDCLAssistantType::tenType>(corfrCarlifeNaviAssistantGuideInfo.enAssistantType);
      rftclCarlifeNaviAssistantGuideInfo.TrafficSignType.enType = static_cast<midw_fi_tcl_e8_BDCLTrafficSignType::tenType>(corfrCarlifeNaviAssistantGuideInfo.enTrafficSignType);;
      rftclCarlifeNaviAssistantGuideInfo.TotalDistance = corfrCarlifeNaviAssistantGuideInfo.u32TotalDistance;
      rftclCarlifeNaviAssistantGuideInfo.RemainDistance = corfrCarlifeNaviAssistantGuideInfo.u32RemainDistance;
      rftclCarlifeNaviAssistantGuideInfo.CameraSpeed = corfrCarlifeNaviAssistantGuideInfo.u32CameraSpeed;
   }

   if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_BDCLTURNBYTURNINFO))
   {
       ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostBDCLTurnByTurnInfo - Error in updating clients"));
   }
   m_rBDCLTurnByTurnInfo.vDestroy();
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostCarPlayRouteGuidanceUpdate(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostCarPlayRouteGuidanceUpdate(const trDiPORouteGuidanceUpdate &corfrRouteGuidanceUpdate)
{
    ETG_TRACE_USR1(("spi_tclService::vPostCarPlayRouteGuidanceUpdate() DeviceHandle = %d",corfrRouteGuidanceUpdate.u32DeviceHandle));
    ETG_TRACE_USR1(("spi_tclService::vPostCarPlayRouteGuidanceUpdate() Device USB Serial Number = %s", corfrRouteGuidanceUpdate.szDeviceSerialNumber.c_str()));

    m_rCarPlayRouteGuidanceUpdate.DeviceHandle = corfrRouteGuidanceUpdate.u32DeviceHandle;
    m_rCarPlayRouteGuidanceUpdate.DeviceUSBSerialNumber.bSet(corfrRouteGuidanceUpdate.szDeviceSerialNumber.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DisplayComponentID list available = %d", ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDisplayComponentListAvailable)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bRouteGuidanceDisplayComponentIDsAvailable = corfrRouteGuidanceUpdate.bIsDisplayComponentListAvailable;
    std::vector<tenDisplayComponentId>::const_iterator itrDisplayCompList;
    for(itrDisplayCompList = corfrRouteGuidanceUpdate.vecDisplayComponentList.begin(); itrDisplayCompList != corfrRouteGuidanceUpdate.vecDisplayComponentList.end(); itrDisplayCompList++)
    {
        midw_fi_tcl_e8_ComponentID oDisplayComponentList;
        oDisplayComponentList.enType = static_cast<midw_fi_tcl_e8_ComponentID::tenType>(*itrDisplayCompList);
        m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.e8RouteGuidanceDisplayComponentIDs.push_back(oDisplayComponentList);
        ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Display component ID = %d", ETG_ENUM(DIPO_COMPONENT_DISPLAYID, *itrDisplayCompList)));
    }

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is RouteGuidanceState available = %d, RouteGuidanceState = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsRouteGuidanceStateAvailable), ETG_ENUM(DIPO_ROUTE_GUIDANCE_STATE, corfrRouteGuidanceUpdate.enRouteGuidanceState)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bRouteGuidanceStateAvailable = corfrRouteGuidanceUpdate.bIsRouteGuidanceStateAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.e8RouteGuidanceState.enType = static_cast<midw_fi_tcl_e8_DiPoRouteGuidanceState::tenType>(corfrRouteGuidanceUpdate.enRouteGuidanceState);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is ManeuverState available = %d, ManeuverState = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsManeuverStateAvailable), ETG_ENUM(DIPO_MANEUVER_STATE,corfrRouteGuidanceUpdate.enManeuverState)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bManeuverStateAvailable = corfrRouteGuidanceUpdate.bIsManeuverStateAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.e8ManeuverState.enType = static_cast<midw_fi_tcl_e8_DiPoManeuverState::tenType>(corfrRouteGuidanceUpdate.enManeuverState);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is CurrentRoadName available = %d, Current Road Name = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsCurrentRoadNameAvailable), corfrRouteGuidanceUpdate.szCurrentRoadName.c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bCurrentRoadNameAvailable = corfrRouteGuidanceUpdate.bIsCurrentRoadNameAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.szCurrentRoadName.bSet(corfrRouteGuidanceUpdate.szCurrentRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DestinationName available = %d, DestinationName = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDestinationNameAvailable), corfrRouteGuidanceUpdate.szDestinationName.c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDestinationNameAvailable = corfrRouteGuidanceUpdate.bIsDestinationNameAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.szDestinationName.bSet(corfrRouteGuidanceUpdate.szDestinationName.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is EstimatedTimeOfArrival available = %d, EstimatedTimeOfArrival = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsEstimatedTimeOfArrivalAvailable), std::to_string(corfrRouteGuidanceUpdate.u64EstimatedTimeOfArrival).c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bEstimatedTimeOfArrivalAvailable = corfrRouteGuidanceUpdate.bIsEstimatedTimeOfArrivalAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.u64EstimatedTimeOfArrival = corfrRouteGuidanceUpdate.u64EstimatedTimeOfArrival;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is TimeRemainingToDestination available = %d, TimeRemainingToDestination=%s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsTimeRemainingToDestAvailable), std::to_string(corfrRouteGuidanceUpdate.u64TimeRemainingToDestination).c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bTimeRemainingToDestinationAvailable = corfrRouteGuidanceUpdate.bIsTimeRemainingToDestAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.u64TimeRemainingToDestination = corfrRouteGuidanceUpdate.u64TimeRemainingToDestination;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DistanceRemaining available = %d, DistanceRemaining = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDistanceRemainingAvailable), corfrRouteGuidanceUpdate.u32DistanceRemaining));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDistanceRemainingAvailable = corfrRouteGuidanceUpdate.bIsDistanceRemainingAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.u32DistanceRemaining = corfrRouteGuidanceUpdate.u32DistanceRemaining;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DistanceRemainingDisplayStr available = %d, DistanceRemaining DisplayStr = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDistanceRemainingDisplayStrAvailable), corfrRouteGuidanceUpdate.szDistanceRemainingDisplayStr.c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDistanceRemainingDisplayStrAvailable = corfrRouteGuidanceUpdate.bIsDistanceRemainingDisplayStrAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.szDistanceRemainingDisplayStr.bSet(corfrRouteGuidanceUpdate.szDistanceRemainingDisplayStr.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DistanceRemainingDisplayUnits available = %d, DistanceRemaining DisplayUnits  = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDistanceRemainingDisplayUnitsAvailable), ETG_ENUM(TBT_DISTANCE_UNITS,corfrRouteGuidanceUpdate.enDistanceRemainingDisplayUnits)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDistanceRemainingDisplayUnitsAvailable = corfrRouteGuidanceUpdate.bIsDistanceRemainingDisplayUnitsAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.e8DistanceRemainingDisplayUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrRouteGuidanceUpdate.enDistanceRemainingDisplayUnits);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DistanceToNextManeuver available = %d, Distance to Next Maneuver = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDistanceToNextManeuverAvailable), corfrRouteGuidanceUpdate.u32DistanceToNextManeuver));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDistanceToNextManeuverAvailable = corfrRouteGuidanceUpdate.bIsDistanceToNextManeuverAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.u32DistanceToNextManeuver = corfrRouteGuidanceUpdate.u32DistanceToNextManeuver;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DistanceToNextManeuverDisplayStr available = %d, DistanceToNextManeuverDisplayStr = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDistanceToNextManeuverDispStrAvailable), corfrRouteGuidanceUpdate.szDistanceToNextManeuverDisplayStr.c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDistanceToNextManeuverDisplayStrAvailable = corfrRouteGuidanceUpdate.bIsDistanceToNextManeuverDispStrAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.szDistanceToNextManeuverDisplayStr.bSet(corfrRouteGuidanceUpdate.szDistanceToNextManeuverDisplayStr.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is DistanceToNextManeuverDisplayUnits available = %d, DistanceToNextManeuverDisplayUnits = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsDistanceToNextManeuverDIspUnitsAvailable), ETG_ENUM(TBT_DISTANCE_UNITS,corfrRouteGuidanceUpdate.enDistanceToNextManeuverDisplayUnits)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bDistanceToNextManeuverDisplayUnitsAvailable = corfrRouteGuidanceUpdate.bIsDistanceToNextManeuverDIspUnitsAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.e8DistanceToNextManeuverDisplayUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrRouteGuidanceUpdate.enDistanceToNextManeuverDisplayUnits);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is RouteGuidanceManeuverCurrentList available = %d", ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsRouteGuidanceManeuverCurrentListAvailable)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bRouteGuidanceManeuverCurrentListAvailable = corfrRouteGuidanceUpdate.bIsRouteGuidanceManeuverCurrentListAvailable;

    std::vector<t_U16>::const_iterator itrRGManeuverCurrentList;
    for(itrRGManeuverCurrentList = corfrRouteGuidanceUpdate.vecRouteGuidanceManeuverCurrentList.begin(); itrRGManeuverCurrentList != corfrRouteGuidanceUpdate.vecRouteGuidanceManeuverCurrentList.end(); itrRGManeuverCurrentList++)
    {
       m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.u16RouteGuidanceManeuverCurrentList.push_back(*itrRGManeuverCurrentList);
    }

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is RouteGuidanceManeuverCount available = %d, RouteGuidanceManeuverCount = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsRouteGuidanceManeuverCountAvailable), corfrRouteGuidanceUpdate.u16RouteGuidanceManeuverCount));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bRouteGuidanceManeuverCountAvailable = corfrRouteGuidanceUpdate.bIsRouteGuidanceManeuverCountAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.u16RouteGuidanceManeuverCount = corfrRouteGuidanceUpdate.u16RouteGuidanceManeuverCount;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is RouteGuidanceVisibleInApp available = %d, RouteGuidanceVisibleInApp = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsRouteGuidanceVisibleInAppAvailable), ETG_ENUM(BOOL,corfrRouteGuidanceUpdate.bIsRouteGuidanceVisibleInApp)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bRouteGuidanceVisibleInAppAvailable = corfrRouteGuidanceUpdate.bIsRouteGuidanceVisibleInAppAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bIsRouteGuidanceVisibleInApp = corfrRouteGuidanceUpdate.bIsRouteGuidanceVisibleInApp;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is SourceName available = %d, Source Name = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsSourceNameAvailable), corfrRouteGuidanceUpdate.szSourceName.c_str()));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bSourceNameAvailable = corfrRouteGuidanceUpdate.bIsSourceNameAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.SourceName.bSet(corfrRouteGuidanceUpdate.szSourceName.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceUpdate - Is SourceSupportsRouteGuidance available = %d, SourceSupportsRouteGuidance = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsSourceSupportsRouteGuidanceAvailable), ETG_ENUM(BOOL, corfrRouteGuidanceUpdate.bIsSourceSupportsRouteGuidance)));
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.bSourceSupportsRouteGuidanceAvailable = corfrRouteGuidanceUpdate.bIsSourceSupportsRouteGuidanceAvailable;
    m_rCarPlayRouteGuidanceUpdate.RouteGuidanceUpdate.SourceSupportsRouteGuidance = corfrRouteGuidanceUpdate.bIsSourceSupportsRouteGuidance;

   if ((true == corfrRouteGuidanceUpdate.vecDisplayComponentList.empty()) || (false == corfrRouteGuidanceUpdate.bIsDisplayComponentListAvailable))
   {
      if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEUPDATE))
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostCarPlayRouteGuidanceUpdate:Error in updating clients"));
      }
   }
   else
   {
      trDiPORouteGuidanceManeuverUpdate rRouteGuidanceManeuverUpdate; // Dummy structure
      vSendCarPlayRouteGuidanceUpdate(false, corfrRouteGuidanceUpdate, rRouteGuidanceManeuverUpdate);
   }
   m_rCarPlayRouteGuidanceUpdate.vDestroy();
}

/********************************************************************************************
 * \FUNCTION   :tVoid spi_tclService:: vPostCarPlayRouteGuidanceManeuverUpdate(...)
 *********************************************************************************************/
t_Void spi_tclService::vPostCarPlayRouteGuidanceManeuverUpdate(const trDiPORouteGuidanceManeuverUpdate &corfrRouteGuidanceManeuverUpdate)
{
    ETG_TRACE_USR1(("spi_tclService::vPostCarPlayRouteGuidanceManeuverUpdate() DeviceHandle = %d", corfrRouteGuidanceManeuverUpdate.u32DeviceHandle));
    ETG_TRACE_USR1(("spi_tclService::vPostCarPlayRouteGuidanceManeuverUpdate() Device USB Serial Number = %s", corfrRouteGuidanceManeuverUpdate.szDeviceSerialNumber.c_str()));

    m_rCarplayRouteGuidanceManeuverUpdate.DeviceHandle = corfrRouteGuidanceManeuverUpdate.u32DeviceHandle;
    m_rCarplayRouteGuidanceManeuverUpdate.DeviceUSBSerialNumber.bSet(corfrRouteGuidanceManeuverUpdate.szDeviceSerialNumber.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is DisplayComponentID list available = %d", ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsDisplayComponentListAvailable)));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bRouteGuidanceDisplayComponentIDsAvailable = corfrRouteGuidanceManeuverUpdate.bIsDisplayComponentListAvailable;
    std::vector<tenDisplayComponentId>::const_iterator itrDisplayCompList;
    for(itrDisplayCompList = corfrRouteGuidanceManeuverUpdate.vecDisplayComponentList.begin(); itrDisplayCompList != corfrRouteGuidanceManeuverUpdate.vecDisplayComponentList.end(); itrDisplayCompList++)
    {
        midw_fi_tcl_e8_ComponentID oDisplayComponentList;
        oDisplayComponentList.enType = static_cast<midw_fi_tcl_e8_ComponentID::tenType>(*itrDisplayCompList);
        m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.RouteGuidanceDisplayComponentIDs.push_back(oDisplayComponentList);
        ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Display component ID = %d", ETG_ENUM(DIPO_COMPONENT_DISPLAYID, *itrDisplayCompList)));
    }

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is Index available = %d, Index = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsIndexAvailable), corfrRouteGuidanceManeuverUpdate.u16Index));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bIndexAvailable = corfrRouteGuidanceManeuverUpdate.bIsIndexAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.u16Index = corfrRouteGuidanceManeuverUpdate.u16Index;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is ManeuverDescription available = %d, ManeuverDescription = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsManeuverDescriptionAvailable), corfrRouteGuidanceManeuverUpdate.szManeuverDescription.c_str()));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bManeuverDescriptionAvailable = corfrRouteGuidanceManeuverUpdate.bIsManeuverDescriptionAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.szManeuverDescription.bSet(corfrRouteGuidanceManeuverUpdate.szManeuverDescription.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is ManeuverType available = %d, ManeuverType = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsManeuverTypeAvailable), corfrRouteGuidanceManeuverUpdate.enManeuverType));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bManeuverTypeAvailable = corfrRouteGuidanceManeuverUpdate.bIsManeuverTypeAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.e8ManeuverType.enType = static_cast<midw_fi_tcl_e8_DiPoManeuverType::tenType>(corfrRouteGuidanceManeuverUpdate.enManeuverType);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is AfterManeuverRoadname available = %d, AfterManeuverRoadName = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsAfterManeuverRoadNameAvailable), corfrRouteGuidanceManeuverUpdate.szAfterManeuverRoadName.c_str()));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bAfterManeuverRoadNameAvailable = corfrRouteGuidanceManeuverUpdate.bIsAfterManeuverRoadNameAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.szAfterManeuverRoadName.bSet(corfrRouteGuidanceManeuverUpdate.szAfterManeuverRoadName.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is DistanceBetweenManeuver available = %d, Distance Between Maneuver = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsDistanceBetweenManeuverAvailable), corfrRouteGuidanceManeuverUpdate.u32DistanceBetweenManeuver));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bDistanceBetweenManeuverAvailable = corfrRouteGuidanceManeuverUpdate.bIsDistanceBetweenManeuverAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.u32DistanceBetweenManeuver = corfrRouteGuidanceManeuverUpdate.u32DistanceBetweenManeuver;

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is DistanceBetweenManeuverDisplayStr available = %d, Distance Between Maneuver DisplayStr = %s",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsDistanceBetweenManeuverDispStrAvailable), corfrRouteGuidanceManeuverUpdate.szDistanceBetweenManeuverDisplayStr.c_str()));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bDistanceBetweenManeuverDisplayStrAvailable = corfrRouteGuidanceManeuverUpdate.bIsDistanceBetweenManeuverDispStrAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.szDistanceBetweenManeuverDisplayStr.bSet(corfrRouteGuidanceManeuverUpdate.szDistanceBetweenManeuverDisplayStr.c_str(), midw_fi_tclString::FI_EN_UTF8);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is DistanceBetweenManeuverDisplayUnits available = %d, Distance Between Maneuver DisplayUnits = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsDistanceBetweenManeuverDispUnitsAvailable), ETG_ENUM(TBT_DISTANCE_UNITS,corfrRouteGuidanceManeuverUpdate.enDistanceBetweenManeuverDisplayUnits)));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bDistanceBetweenManeuverDisplayUnitsAvailable = corfrRouteGuidanceManeuverUpdate.bIsDistanceBetweenManeuverDispUnitsAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.e8DistanceBetweenManeuverDisplayUnits.enType = static_cast<midw_fi_tcl_e8_DistanceUnits::tenType>(corfrRouteGuidanceManeuverUpdate.enDistanceBetweenManeuverDisplayUnits);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is DrivingSide available = %d, DrivingSide = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsDrivingSideAvailable), ETG_ENUM(DIPO_DRIVING_SIDE,corfrRouteGuidanceManeuverUpdate.enDrivingSide)));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bDrivingSideAvailable = corfrRouteGuidanceManeuverUpdate.bIsDrivingSideAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.e8DrivingSide.enType = static_cast<midw_fi_tcl_e8_DiPoDrivingSide::tenType>(corfrRouteGuidanceManeuverUpdate.enDrivingSide);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is JunctionType available = %d, JunctionType = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsJunctionTypeAvailable), ETG_ENUM(DIPO_JUNCTION_TYPE,corfrRouteGuidanceManeuverUpdate.enJunctionType)));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bJunctionTypeAvailable = corfrRouteGuidanceManeuverUpdate.bIsJunctionTypeAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.e8JunctionType.enType = static_cast<midw_fi_tcl_e8_DiPoJunctionType::tenType>(corfrRouteGuidanceManeuverUpdate.enJunctionType);

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is JunctionElementAngle available = %d", ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsJunctionElementAngleAvailable)));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bJunctionElementAngleAvailable = corfrRouteGuidanceManeuverUpdate.bIsJunctionElementAngleAvailable;

    std::vector<t_S16>::const_iterator itrJunctionElementAngleList;
    for(itrJunctionElementAngleList = corfrRouteGuidanceManeuverUpdate.vecJunctionElementAngleList.begin(); itrJunctionElementAngleList != corfrRouteGuidanceManeuverUpdate.vecJunctionElementAngleList.end(); itrJunctionElementAngleList++)
    {
        ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - JunctionElementAngle = %d", *itrJunctionElementAngleList));
        m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.s16JunctionElementAngleList.push_back(*itrJunctionElementAngleList);
    }

    ETG_TRACE_USR4(("[DESC]:vPostCarPlayRouteGuidanceManeuverUpdate - Is JunctionElementExitAngle available = %d, JunctionElementExitAngle = %d",
             ETG_ENUM(BOOL, corfrRouteGuidanceManeuverUpdate.bIsJunctionElementExitAngleAvailable), corfrRouteGuidanceManeuverUpdate.s16JunctionElementExitAngle));
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.bJunctionElementExitAngleAvailable = corfrRouteGuidanceManeuverUpdate.bIsJunctionElementExitAngleAvailable;
    m_rCarplayRouteGuidanceManeuverUpdate.RouteGuidanceManeuverUpdate.s16JunctionElementExitAngle = corfrRouteGuidanceManeuverUpdate.s16JunctionElementExitAngle;

    if ((true == corfrRouteGuidanceManeuverUpdate.vecDisplayComponentList.empty()) || (false == corfrRouteGuidanceManeuverUpdate.bIsDisplayComponentListAvailable))
    {
       if (FALSE == bUpdateClients(MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEMANEUVERUPDATE))
       {
          ETG_TRACE_ERR(("[ERR]:spi_tclService::vPostCarPlayRouteGuidanceManeuverUpdate: Error in updating clients"));
       }
    }
    else
    {
       trDiPORouteGuidanceUpdate rRouteGuidanceUpdate; // Dummy structure
       vSendCarPlayRouteGuidanceUpdate(true, rRouteGuidanceUpdate, corfrRouteGuidanceManeuverUpdate);
    }
    m_rCarplayRouteGuidanceManeuverUpdate.vDestroy();
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSRegRouteGuidanceDisplayConf()
***************************************************************************/
t_Void spi_tclService::vOnMSRegRouteGuidanceDisplayConf(amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR1(("spi_tclService::vOnMSRegRouteGuidanceDisplayConf() Entered"));
    spi_tMsgRegRouteGuidanceDisplayConfMS oRegRouteGuidanceDisplayConfMS(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
    if((TRUE == oRegRouteGuidanceDisplayConfMS.bIsValid()) && (NULL != m_poSpiCmdIntf))
    {
        trMsgContext rMsgContext;
        CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

        std::vector<trDiPORouteGuidanceDisplayComponent> vecrRouteGuidanceDisplayComponent;
        trDiPORouteGuidanceDisplayComponent rRouteGuidDisComp;
        tenResponseCode enRespCode = e8SUCCESS;
        ETG_TRACE_USR4(("[DESC]: vOnMSRegRouteGuidanceDisplayConf - Number of components = %d", oRegRouteGuidanceDisplayConfMS.RouteGuidanceDisplayComponents.size()));
        std::vector<midw_fi_tcl_RouteGuidanceDisplayComponent, std::allocator<midw_fi_tcl_RouteGuidanceDisplayComponent> >::iterator itrRGDisplayCompList;
        for(itrRGDisplayCompList = oRegRouteGuidanceDisplayConfMS.RouteGuidanceDisplayComponents.begin(); itrRGDisplayCompList != oRegRouteGuidanceDisplayConfMS.RouteGuidanceDisplayComponents.end(); itrRGDisplayCompList++)
        {
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - Display component ID = %d", ETG_ENUM(DIPO_COMPONENT_DISPLAYID, itrRGDisplayCompList->ComponentID.enType)));
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - Display Name = %s", itrRGDisplayCompList->DisplayName.szValue));
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - u16MaxCurrentRoadNameLength = %d", itrRGDisplayCompList->u16MaxCurrentRoadNameLength));
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - u16MaxDestinationNameLength = %d", itrRGDisplayCompList->u16MaxDestinationNameLength));
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - u16MaxAfterManeuverRoadNameLength = %d", itrRGDisplayCompList->u16MaxAfterManeuverRoadNameLength));
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - u16MaxManeuverDescriptionLength = %d", itrRGDisplayCompList->u16MaxManeuverDescriptionLength));
             ETG_TRACE_USR4(("[DESC]:vOnMSRegRouteGuidanceDisplayConf - u16MaxGuidanceManeuverCapacity = %d", itrRGDisplayCompList->u16MaxGuidanceManeuverCapacity));

             rRouteGuidDisComp.enDisplayComponent = static_cast<tenDisplayComponentId>(itrRGDisplayCompList->ComponentID.enType);

             if (DISPLAY_ID_MISCELLANEOUS_DISPLAY_10 < rRouteGuidDisComp.enDisplayComponent)
             {
            	 ETG_TRACE_ERR(("[ERR]:vOnMSRegRouteGuidanceDisplayConf - Invalid Display ID"));
            	 enRespCode = e8FAILURE;
             }
             else
             {
                rRouteGuidDisComp.szDisplayName = t_String(itrRGDisplayCompList->DisplayName.szValue);
                rRouteGuidDisComp.u16MaxCurrentRoadNameLength = itrRGDisplayCompList->u16MaxCurrentRoadNameLength;
                rRouteGuidDisComp.u16MaxDestinationNameLength = itrRGDisplayCompList->u16MaxDestinationNameLength;
                rRouteGuidDisComp.u16MaxAfterManeuverRoadNameLength = itrRGDisplayCompList->u16MaxAfterManeuverRoadNameLength;
                rRouteGuidDisComp.u16MaxManeuverDescriptionLength = itrRGDisplayCompList->u16MaxManeuverDescriptionLength;
                rRouteGuidDisComp.u16MaxGuidanceManeuverCapacity = itrRGDisplayCompList->u16MaxGuidanceManeuverCapacity;

                vecrRouteGuidanceDisplayComponent.push_back(rRouteGuidDisComp);
             }
        }

        if ((nullptr != m_poSpiCmdIntf) && (e8FAILURE != enRespCode))
        {
           enRespCode = (true == m_poSpiCmdIntf->bOnRegRouteGuidanceDisplayConf(vecrRouteGuidanceDisplayComponent)) ? e8SUCCESS : e8FAILURE;
        }//if(nullptr != m_poSpiCmdIntf)

        midw_smartphoneintfi_tclMsgRegisterRouteGuidanceDisplayConfigurationMethodResult oMRRegRouteGuidanceDisplayConf;
        oMRRegRouteGuidanceDisplayConf.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enRespCode;

        //post Method result to HMI
        FIMsgDispatch oPostMsg(_poMainAppl);
        if( FALSE == oPostMsg.bSendResMessage(oMRRegRouteGuidanceDisplayConf, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
        {
           ETG_TRACE_ERR(("[ERR]:vOnMSRegRouteGuidanceDisplayConf() - Error in posting Method Result"));
        } //if( FALSE == oPostMsg.bSendMessage)
    }
    else
    {
        ETG_TRACE_ERR(("spi_tclService::vOnMSRegRouteGuidanceDisplayConf - Invalid request"));
    }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSStartRouteGuidanceUpdates()
***************************************************************************/
t_Void spi_tclService::vOnMSStartRouteGuidanceUpdates(amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR1(("spi_tclService::vOnMSStartRouteGuidanceUpdates() Entered"));
    spi_tMsgStartRouteGuidanceUpdatesMS oStartRouteGuidanceUpdatesMS(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
    if((TRUE == oStartRouteGuidanceUpdatesMS.bIsValid()) && (NULL != m_poSpiCmdIntf))
    {
        trMsgContext rMsgContext;
        CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

        trStartRouteGuidanceUpdates rStartRouteGuidanceUpdates;
        tenResponseCode enRespCode = e8SUCCESS;
        tenDisplayComponentId enDispComponentId;
        std::vector<midw_fi_tcl_e8_ComponentID, std::allocator<midw_fi_tcl_e8_ComponentID> >::iterator itrRGComponentList;
        for(itrRGComponentList = oStartRouteGuidanceUpdatesMS.RoutGuidanceComponentID.begin(); itrRGComponentList != oStartRouteGuidanceUpdatesMS.RoutGuidanceComponentID.end(); itrRGComponentList++)
        {
            enDispComponentId = static_cast<tenDisplayComponentId>(itrRGComponentList->enType);
            ETG_TRACE_USR4(("[DESC]:vOnMSStartRouteGuidanceUpdates - Display component ID = %d", ETG_ENUM(DIPO_COMPONENT_DISPLAYID, enDispComponentId)));
            if (DISPLAY_ID_MISCELLANEOUS_DISPLAY_10 < enDispComponentId)
            {
                enRespCode = e8FAILURE;
            }
            else
            {
                rStartRouteGuidanceUpdates.vecDisplayComponent.push_back(enDispComponentId);
                m_oDisplayComponentMapLock.s16Lock();
                m_mapDisplayComponent[enDispComponentId].insert(poMessage->u16GetSourceAppID());
                m_oDisplayComponentMapLock.vUnlock();
            }
        }
        rStartRouteGuidanceUpdates.bNeedAutoStartStopTBTUpdates = oStartRouteGuidanceUpdatesMS.NeedAutoStartStopTBTUpdates;
        ETG_TRACE_USR4(("[DESC]:vOnMSStartRouteGuidanceUpdates - NeedAutoStartStop = %d", ETG_ENUM(BOOL, rStartRouteGuidanceUpdates.bNeedAutoStartStopTBTUpdates)));
        rStartRouteGuidanceUpdates.bSourceName = oStartRouteGuidanceUpdatesMS.SourceName;
        ETG_TRACE_USR4(("[DESC]:vOnMSStartRouteGuidanceUpdates - SourceName required = %d", ETG_ENUM(BOOL, rStartRouteGuidanceUpdates.bSourceName)));
        rStartRouteGuidanceUpdates.bSourceSupportsRouteGuidance = oStartRouteGuidanceUpdatesMS.SourceSupportsRouteGuidance;
        ETG_TRACE_USR4(("[DESC]:vOnMSStartRouteGuidanceUpdates - SourceSupportsRouteGuidance required = %d", ETG_ENUM(BOOL, rStartRouteGuidanceUpdates.bSourceSupportsRouteGuidance)));

        if ((nullptr != m_poSpiCmdIntf) && (e8FAILURE != enRespCode))
        {
            enRespCode = (true == m_poSpiCmdIntf->bOnStartRouteGuidanceUpdates(rStartRouteGuidanceUpdates)) ? e8SUCCESS : e8FAILURE;
        }

        midw_smartphoneintfi_tclMsgStartRouteGuidanceUpdatesMethodResult oMRStartRouteGuidanceUpdates;
        oMRStartRouteGuidanceUpdates.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enRespCode;

        //post Method result to HMI
        FIMsgDispatch oPostMsg(_poMainAppl);
        if( FALSE == oPostMsg.bSendResMessage(oMRStartRouteGuidanceUpdates, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
        {
           ETG_TRACE_ERR(("[ERR]:vOnMSStartRouteGuidanceUpdates() - Error in posting Method Result"));
        } //if( FALSE == oPostMsg.bSendMessage)
    }
    else
    {
        ETG_TRACE_ERR(("spi_tclService::vOnMSStartRouteGuidanceUpdates - Invalid request"));
    }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSStopRouteGuidanceUpdates()
***************************************************************************/
t_Void spi_tclService::vOnMSStopRouteGuidanceUpdates(amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR1(("spi_tclService::vOnMSStopRouteGuidanceUpdates() Entered"));
    spi_tMsgStopRouteGuidanceUpdatesMS oStopRouteGuidanceUpdatesMS(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);
    if((TRUE == oStopRouteGuidanceUpdatesMS.bIsValid()) && (NULL != m_poSpiCmdIntf))
    {
        trMsgContext rMsgContext;
        CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

        trStopRouteGuidanceUpdates rStopRouteGuidanceUpdates;
        tenResponseCode enRespCode = e8SUCCESS;
        tenDisplayComponentId enDispComponentId;
        std::vector<midw_fi_tcl_e8_ComponentID, std::allocator<midw_fi_tcl_e8_ComponentID> >::iterator itrRGComponentList;
        for(itrRGComponentList = oStopRouteGuidanceUpdatesMS.RoutGuidanceComponentID.begin(); itrRGComponentList != oStopRouteGuidanceUpdatesMS.RoutGuidanceComponentID.end(); itrRGComponentList++)
        {
            enDispComponentId = static_cast<tenDisplayComponentId>(itrRGComponentList->enType);
            ETG_TRACE_USR3(("[DESC]:vOnMSStopRouteGuidanceUpdates - Display component ID = %d", ETG_ENUM(DIPO_COMPONENT_DISPLAYID, enDispComponentId)));
            if (DISPLAY_ID_MISCELLANEOUS_DISPLAY_10 < enDispComponentId)
            {
               enRespCode = e8FAILURE;
            }
            else
            {
               rStopRouteGuidanceUpdates.vecDisplayComponent.push_back(enDispComponentId);
               m_oDisplayComponentMapLock.s16Lock();
               m_mapDisplayComponent.erase(enDispComponentId);
               m_oDisplayComponentMapLock.vUnlock();
            }
        }

        if ((nullptr != m_poSpiCmdIntf) && (e8FAILURE != enRespCode))
        {
            enRespCode = (true == m_poSpiCmdIntf->bOnStopRouteGuidanceUpdates(rStopRouteGuidanceUpdates)) ? e8SUCCESS : e8FAILURE;
        }//if(nullptr != m_poSpiCmdIntf)

        midw_smartphoneintfi_tclMsgStopRouteGuidanceUpdatesMethodResult oMRStopRouteGuidanceUpdates;
        oMRStopRouteGuidanceUpdates.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType)enRespCode;

        //post Method result to HMI
        FIMsgDispatch oPostMsg(_poMainAppl);
        if( FALSE == oPostMsg.bSendResMessage(oMRStopRouteGuidanceUpdates, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
        {
           ETG_TRACE_ERR(("[ERR]:vOnMSStopRouteGuidanceUpdates() - Error in posting Method Result"));
        } //if( FALSE == oPostMsg.bSendMessage)
    }
    else
    {
        ETG_TRACE_ERR(("spi_tclService::vOnMSStopRouteGuidanceUpdates - Invalid request"));
    }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnUpReg()
***************************************************************************/
t_Void spi_tclService::vOnUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnUpReg entered"));

   if (NULL != poMessage)
   {
      // Call base class method 
      ahl_tclBaseOneThreadService::vOnUpReg(u16FunctionId, poMessage);

      tU16 u16SrcAppId = 0, u16RegId = 0, u16CmdCntr = 0;
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      // Store the SourceAppId, RegisterId and CmdCounter for CarPlayRouteGuidanceUpdate property
      if (MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEUPDATE == u16FunctionId)
      {
         u16SrcAppId = poMessage->u16GetSourceAppID();
         u16RegId = poMessage->u16GetRegisterID();
         u16CmdCntr = poMessage->u16GetCmdCounter();
         ETG_TRACE_USR4(("[PARAM]:vOnUpReg - FunctionId = %d, SrcAppId = %d, RegId = %d, CmdCounter = %d",
         u16FunctionId, u16SrcAppId, u16RegId, u16CmdCntr));
         m_oCarPlayRGClientsMapLock.s16Lock();
         m_mapCarPlayRGClients.insert(std::make_pair(u16SrcAppId, rMsgContext.rUserContext));
         m_oCarPlayRGClientsMapLock.vUnlock();
      }
      if (MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEMANEUVERUPDATE == u16FunctionId)
      {
         u16SrcAppId = poMessage->u16GetSourceAppID();
         u16RegId = poMessage->u16GetRegisterID();
         u16CmdCntr = poMessage->u16GetCmdCounter();
         ETG_TRACE_USR4(("[PARAM]:vOnUpReg - FunctionId = %d, SrcAppId = %d, RegId = %d, CmdCounter = %d",
         u16FunctionId, u16SrcAppId, u16RegId, u16CmdCntr));
         m_oCarPlayRGMClientsMapLock.s16Lock();
         m_mapCarPlayRGMClients.insert(std::make_pair(u16SrcAppId, rMsgContext.rUserContext));
         m_oCarPlayRGMClientsMapLock.vUnlock();
      }
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnRelUpReg()
***************************************************************************/
t_Void spi_tclService::vOnRelUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnRelUpReg entered"));

   if (NULL != poMessage)
   {
      // Call base class method 
      ahl_tclBaseOneThreadService::vOnRelUpReg(u16FunctionId, poMessage);

      tU16 u16SrcAppId = 0;

      // Store the SourceAppId, RegisterId and CmdCounter for CarPlayRouteGuidanceUpdate property
      if (MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEUPDATE == u16FunctionId)
      {
         u16SrcAppId = poMessage->u16GetSourceAppID();
         ETG_TRACE_USR4(("[PARAM]:vOnRelUpReg - FunctionId = %d, SrcAppId = %d", u16FunctionId, u16SrcAppId));
         m_oCarPlayRGClientsMapLock.s16Lock();
         std::map<tU16, trUserContext>::const_iterator itrCarPlayRGClientsMap = m_mapCarPlayRGClients.find(u16SrcAppId);
         if (itrCarPlayRGClientsMap != m_mapCarPlayRGClients.end())
         {
            m_mapCarPlayRGClients.erase(u16SrcAppId);
         }
         m_oCarPlayRGClientsMapLock.vUnlock();
      }
      if ((MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEMANEUVERUPDATE == u16FunctionId) && (NULL != poMessage))
      {
         u16SrcAppId = poMessage->u16GetSourceAppID();
         ETG_TRACE_USR4(("[PARAM]:vOnRelUpReg - FunctionId = %d, SrcAppId = %d", u16FunctionId, u16SrcAppId));
         m_oCarPlayRGMClientsMapLock.s16Lock();
         std::map<tU16, trUserContext>::const_iterator itrCarPlayRGMClientsMap = m_mapCarPlayRGMClients.find(u16SrcAppId);
         if (itrCarPlayRGMClientsMap != m_mapCarPlayRGMClients.end())
         {
            m_mapCarPlayRGMClients.erase(u16SrcAppId);
         }
         m_oCarPlayRGMClientsMapLock.vUnlock();
      }
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vSendCarPlayRouteGuidanceUpdate()
***************************************************************************/
tVoid spi_tclService::vSendCarPlayRouteGuidanceUpdate(tBool bIsManeuverUpdate,
                                                      const trDiPORouteGuidanceUpdate &corfrRouteGuidanceUpdate,
                                                      const trDiPORouteGuidanceManeuverUpdate &corfrRouteGuidanceManeuverUpdate)
{
   std::vector<tenDisplayComponentId>::const_iterator itrDisplayCompList;
   std::map<tenDisplayComponentId, std::set<tU16>>::const_iterator itrDisplComponentMap;
   std::map<tU16, trUserContext>::const_iterator itrRegClientMap;
   std::map<tU16, trUserContext> mapCarPlayTBTClients;
   amt_tclServiceData oMessage;
   amt_tclServiceData* poMessage = NULL;
   tU16 u16ClientId = 0, u16RegId = 0, u16CmdCounter = 0;
   std::map<tenDisplayComponentId, std::set<tU16>> mapDisplayComponent;
   if (true == bIsManeuverUpdate)
   {
      for(itrDisplayCompList = corfrRouteGuidanceManeuverUpdate.vecDisplayComponentList.begin(); itrDisplayCompList != corfrRouteGuidanceManeuverUpdate.vecDisplayComponentList.end(); itrDisplayCompList++)
      {
         m_oDisplayComponentMapLock.s16Lock();
         mapDisplayComponent = m_mapDisplayComponent;
         m_oDisplayComponentMapLock.vUnlock();
         itrDisplComponentMap = mapDisplayComponent.find(*itrDisplayCompList);
         if (itrDisplComponentMap != mapDisplayComponent.end())
         {
            std::set<tU16> u16ClientSet = itrDisplComponentMap->second;
            for (auto clientId : u16ClientSet)
            {
               m_oCarPlayRGMClientsMapLock.s16Lock();
               itrRegClientMap = m_mapCarPlayRGMClients.find(clientId);
               if (itrRegClientMap != m_mapCarPlayRGMClients.end())
               {
                  mapCarPlayTBTClients.insert(std::make_pair(clientId, itrRegClientMap->second));
                  ETG_TRACE_USR4(("[PARAM]: vSendCarPlayRouteGuidanceUpdate - Component Id = %d, client Id = %d, RegId = %d, CmdCounter = %d", *itrDisplayCompList, clientId, itrRegClientMap->second.u32RegID, itrRegClientMap->second.u32CmdCtr));
               }
               m_oCarPlayRGMClientsMapLock.vUnlock();
            }
         }
      }
      for(itrRegClientMap = mapCarPlayTBTClients.begin(); itrRegClientMap != mapCarPlayTBTClients.end(); ++itrRegClientMap)
      {
         if (true == bStatusMessageFactory(MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEMANEUVERUPDATE, oMessage, poMessage))
         {
            u16ClientId = itrRegClientMap->first;
            u16RegId = static_cast<tU16>(itrRegClientMap->second.u32RegID);
            u16CmdCounter = static_cast<tU16>(itrRegClientMap->second.u32CmdCtr);
            vInitServiceData(oMessage, u16ClientId, u16RegId, u16CmdCounter, MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEMANEUVERUPDATE, AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL);

            ETG_TRACE_USR4(("[PARAM]: vSendCarPlayRouteGuidanceUpdate - Sending updates for client Id = %d, RegId = %d, CmdCounter = %d", u16ClientId, u16RegId, u16CmdCounter));
            ail_tenCommunicationError enCommunicationError = ePostMessage(&oMessage);

            if (AIL_EN_N_NO_ERROR == enCommunicationError)
            {
               ETG_TRACE_USR4(("[PARAM]:vSendCarPlayRouteGuidanceUpdate - Successfully updated client %d", u16ClientId));
            }
            else
            {
               ETG_TRACE_ERR(("[ERR]:spi_tclService::vSendCarPlayRouteGuidanceUpdate: Error in updating clients"));
            }
         }
      }
   }
   else
   {
      for(itrDisplayCompList = corfrRouteGuidanceUpdate.vecDisplayComponentList.begin(); itrDisplayCompList != corfrRouteGuidanceUpdate.vecDisplayComponentList.end(); itrDisplayCompList++)
      {
         m_oDisplayComponentMapLock.s16Lock();
         mapDisplayComponent = m_mapDisplayComponent;
         m_oDisplayComponentMapLock.vUnlock();
         itrDisplComponentMap = mapDisplayComponent.find(*itrDisplayCompList);
         if (itrDisplComponentMap != mapDisplayComponent.end())
         {
            std::set<tU16> u16ClientSet = itrDisplComponentMap->second;
            for (auto clientId : u16ClientSet)
            {
               m_oCarPlayRGClientsMapLock.s16Lock();
               itrRegClientMap = m_mapCarPlayRGClients.find(clientId);
               if (itrRegClientMap != m_mapCarPlayRGClients.end())
               {
                  mapCarPlayTBTClients.insert(std::make_pair(clientId, itrRegClientMap->second));
                  ETG_TRACE_USR4(("[PARAM]: vSendCarPlayRouteGuidanceUpdate - Component Id = %d, client Id = %d, RegId = %d, CmdCounter = %d", *itrDisplayCompList, clientId, itrRegClientMap->second.u32RegID, itrRegClientMap->second.u32CmdCtr));
               }
               m_oCarPlayRGClientsMapLock.vUnlock();
            }
         }
      }
      for(itrRegClientMap = mapCarPlayTBTClients.begin(); itrRegClientMap != mapCarPlayTBTClients.end(); ++itrRegClientMap)
      {
         if (true == bStatusMessageFactory(MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEUPDATE, oMessage, poMessage))
         {
            u16ClientId = itrRegClientMap->first;
            u16RegId = static_cast<tU16>(itrRegClientMap->second.u32RegID);
            u16CmdCounter = static_cast<tU16>(itrRegClientMap->second.u32CmdCtr);
            vInitServiceData(oMessage, u16ClientId, u16RegId, u16CmdCounter, MIDW_SMARTPHONEINTFI_C_U16_CARPLAYROUTEGUIDANCEUPDATE, AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL);

            ETG_TRACE_USR4(("[PARAM]: vSendCarPlayRouteGuidanceUpdate - Sending updates for client Id = %d, RegId = %d, CmdCounter = %d", u16ClientId, u16RegId, u16CmdCounter));
            ail_tenCommunicationError enCommunicationError = ePostMessage(&oMessage);

            if (AIL_EN_N_NO_ERROR == enCommunicationError)
            {
               ETG_TRACE_USR4(("[PARAM]:vSendCarPlayRouteGuidanceUpdate - Successfully updated client %d", u16ClientId));
            }
            else
            {
               ETG_TRACE_ERR(("[ERR]:spi_tclService::vSendCarPlayRouteGuidanceUpdate: Error in updating clients"));
            }
         }
      }
   }
}
/**************************************************************************
 ** FUNCTION   : tVoid spi_tclService:: vOnMSSetClientState()
 ***************************************************************************/
t_Void spi_tclService::vOnMSSetClientState(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("spi_tclService::vOnMSSetClientState() Entered"));
   spi_tMsgSetClientStateMS oSetClientStateMS(*poMessage, SPI_SERVICE_FI_MAJOR_VERSION);
   if ((TRUE == oSetClientStateMS.bIsValid()) && (NULL != m_poSpiCmdIntf))
   {
      trMsgContext rMsgContext;
      CPY_TO_USRCNTXT(poMessage, rMsgContext.rUserContext);

      tenClientState enClientState = static_cast<tenClientState>(oSetClientStateMS.ClientState.enType);
      ETG_TRACE_USR1(("spi_tclService::vOnMSSetClientState() Client State Received is %d", ETG_ENUM(CLIENT_STATE, enClientState)));
      tenResponseCode enRespCode = e8SUCCESS;
      if ((nullptr != m_poSpiCmdIntf))
      {
         enRespCode = (true == m_poSpiCmdIntf->bSetClientState(enClientState)) ? e8SUCCESS : e8FAILURE;
      } //if(nullptr != m_poSpiCmdIntf)

      midw_smartphoneintfi_tclMsgSetClientStateMethodResult oMRSetClientState;
      oMRSetClientState.ResponseCode.enType = (midw_fi_tcl_e8_ResponseCode::tenType) enRespCode;

      //post Method result to HMI
      FIMsgDispatch oPostMsg(_poMainAppl);
      if (FALSE == oPostMsg.bSendResMessage(oMRSetClientState, rMsgContext, SPI_SERVICE_FI_MAJOR_VERSION))
      {
         ETG_TRACE_ERR(("[ERR]:vOnMSSetClientState() - Error in posting Method Result"));
      } //if( FALSE == oPostMsg.bSendMessage)
   }
   else
   {
      ETG_TRACE_ERR(("spi_tclService::vOnMSSetClientState - Invalid request"));
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vOnMSRegisterKeyCodes()
***************************************************************************/
t_Void spi_tclService::vOnMSRegisterKeyCodes(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vOnMSRegisterKeyCodes() entered"));
   trUserContext rUsrCntxt;
   CPY_TO_USRCNTXT(poMessage, rUsrCntxt);
   std::map<tenDeviceCategory,std::set<tenKeyCode>> mapTechSuppHardKeys;
   std::map<tenDeviceCategory,std::set<tenKeyCode>> mapTechSuppSoftKeys;

   spi_tMsgRegisterKeyCodes oRegisterKeyCodes(*poMessage,SPI_SERVICE_FI_MAJOR_VERSION);

   for(auto itTech = oRegisterKeyCodes.SupportedKeys.begin(); itTech < oRegisterKeyCodes.SupportedKeys.end();itTech++)
   {
      mapTechSuppHardKeys[static_cast<tenDeviceCategory>(itTech->enDeviceCategory.enType)];
      if(static_cast<tenDeviceCategory>(itTech->enDeviceCategory.enType) == e8DEV_TYPE_DIPO)
      {
          mapTechSuppSoftKeys[static_cast<tenDeviceCategory>(itTech->enDeviceCategory.enType)];
      }
      for(auto itKeyInfo = itTech->KeyInfo.begin();itKeyInfo < itTech->KeyInfo.end();itKeyInfo++)
      {
        if(itKeyInfo->KeyType.enType == midw_fi_tcl_e32_KeyType::FI_EN_HARD_KEY)
        {
           mapTechSuppHardKeys[static_cast<tenDeviceCategory>(itTech->enDeviceCategory.enType)].
                         insert(m_mapKeyCode[itKeyInfo->KeyCode.enType]);
        }
        else
        {
           mapTechSuppSoftKeys[static_cast<tenDeviceCategory>(itTech->enDeviceCategory.enType)].
                         insert(m_mapKeyCode[itKeyInfo->KeyCode.enType]);
        }
      }
   }
   if(NULL != m_poSpiCmdIntf)
   {
     m_poSpiCmdIntf->vRegisterKeyCodes(mapTechSuppHardKeys,mapTechSuppSoftKeys,rUsrCntxt);
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService::vPostKeyInfoResult()
***************************************************************************/
t_Void spi_tclService::vPostKeyInfoResult(t_Bool bKeyInfoStatus,
                                          std::map<tenDeviceCategory,std::set<tenKeyCode>>& rfrmapTechUnSuppHardkeys,
                                          std::map<tenDeviceCategory,std::set<tenKeyCode>>& rfrmapTechUnSuppSoftkeys,
                                          const trUserContext& rfrcUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPostKeyInfoResult() entered with KeyInfoStatus %d", ETG_ENUM(BOOL,bKeyInfoStatus)));
   midw_smartphoneintfi_tclMsgRegisterKeyCodesMethodResult oMRRegisterKeyCodes;
   trMsgContext rMsgContext;
   rMsgContext.rUserContext = rfrcUsrCntxt;

   if(true == bKeyInfoStatus)
   {
     oMRRegisterKeyCodes.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_SUCCESS;
   }
   else
   {
     oMRRegisterKeyCodes.ResponseCode.enType = midw_fi_tcl_e8_ResponseCode::FI_EN_FAILURE;
     midw_fi_tcl_TechnologyKeyConfig oTechConfig;
     for(auto enTech : rfrmapTechUnSuppHardkeys)
     {
       oTechConfig.enDeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(enTech.first);
       for(auto enHardKeys : enTech.second)
       {
          midw_fi_tcl_KeyInfo oKeyInfo;
          oKeyInfo.KeyCode.enType = static_cast<midw_fi_tcl_e32_KeyCode::tenType>(m_mapFiKeyCode[enHardKeys]);
          oKeyInfo.KeyType.enType = static_cast<midw_fi_tcl_e32_KeyType::tenType>(HARD_KEY);
          oTechConfig.KeyInfo.push_back(oKeyInfo);
       }
       oMRRegisterKeyCodes.UnSupportedKeys.push_back(oTechConfig);
     }
 
     oTechConfig.KeyInfo.clear();

     for(auto enTech : rfrmapTechUnSuppSoftkeys)
     {
       oTechConfig.enDeviceCategory.enType = static_cast<midw_fi_tcl_e8_DeviceCategory::tenType>(enTech.first);
       for(auto enSoftKeys : enTech.second)
       {
          midw_fi_tcl_KeyInfo oKeyInfo;
          oKeyInfo.KeyCode.enType = static_cast<midw_fi_tcl_e32_KeyCode::tenType>(m_mapFiKeyCode[enSoftKeys]);
          oKeyInfo.KeyType.enType = static_cast<midw_fi_tcl_e32_KeyType::tenType>(SOFT_KEY);
          oTechConfig.KeyInfo.push_back(oKeyInfo);
       }

       auto techit = std::find_if(oMRRegisterKeyCodes.UnSupportedKeys.begin(),oMRRegisterKeyCodes.UnSupportedKeys.end(),
         [&](const midw_fi_tcl_TechnologyKeyConfig &Tech)
           {
             if(Tech.enDeviceCategory.enType == oTechConfig.enDeviceCategory.enType)
                 return true;
             else
                 return false;
           });
       if(techit != oMRRegisterKeyCodes.UnSupportedKeys.end())
       {
          techit->KeyInfo
                .insert(techit->KeyInfo.begin(),
                  oTechConfig.KeyInfo.begin(),oTechConfig.KeyInfo.end());
       }
       else
       {
          oMRRegisterKeyCodes.UnSupportedKeys.push_back(oTechConfig);
       }
     }
   }
   //post Method result to Clients
   FIMsgDispatch oPostMsg(_poMainAppl);
   if( FALSE == oPostMsg.bSendResMessage(oMRRegisterKeyCodes,rMsgContext,SPI_SERVICE_FI_MAJOR_VERSION))
   {
      ETG_TRACE_ERR(("[ERR]:vPostKeyInfo:Error in posting Method Result"));
   } //if( FALSE == oPostMsg.bSendMessage
}


/***************************************************************************
 ** FUNCTION:  t_Void spi_tclService::vPrepareForRestoreSettings()
 ***************************************************************************/
t_Void spi_tclService::vPrepareForRestoreSettings()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclService::vPrepareForRestoreSettings() entered "));

   if(NULL != m_poExtClientFactory)
   {
      m_poExtClientFactory->vPrepareForRestoreSettings();
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclService:: vRestoreSettingsComplete()
***************************************************************************/
t_Void spi_tclService::vRestoreSettingsComplete()
{

   ETG_TRACE_USR1(("spi_tclService::vRestoreSettingsComplete Entered"));

   //! Need clear all the Maps that are used in Client Handlers
   if(NULL != m_poExtClientFactory)
   {
      m_poExtClientFactory->vRestoreSettingsComplete();
   }
}


///////////////////////////////////////////////////////////////////////////////
// <EOF>
