//	*****************************************************************************
//	* FILE:         vds_basemessages.h
//	* SW_COMPONENT: VD-Sensor
//	* DESCRIPTION:  base-messages for vdsensor-communication
//	* AUTHOR:       CM-DI/ESA1-Fischer
//	* COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//	* HISTORY:
//	* 16.08.02 Rev. 1.0 CM-DI/ESA1-Fischer
//	*          Initial Revision.
//    * 26.08.09 sak9kor RBEI/ECF1 - Manual FI classes functions which have been replaced by XML
//                                                  generated FI have been removed and other functions related 
//                                                 including get,upreg and relupreg have been commented for most of the 
//                                                 properies and methods of vdsensor
//	*****************************************************************************

#ifndef vds_basemessages_h
#define vds_basemessages_h 1

class vds_tclMsg0 : public amt_tclServiceDataMsg0
{
public:
	vds_tclMsg0 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode);
	vds_tclMsg0 (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclMsgU8 : public amt_tclServiceDataMsg1<tU8>
{
public:
	vds_tclMsgU8 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tU8 u8Value);
	vds_tclMsgU8 (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclMsgU16 : public amt_tclServiceDataMsg1<tU16>
{
public:
	vds_tclMsgU16 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tU16 u16Value);
	vds_tclMsgU16 (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclMsgU32 : public amt_tclServiceDataMsg1<tU32>
{
public:
	vds_tclMsgU32 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tU32 u32Value);
	vds_tclMsgU32 (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclMsgF32 : public amt_tclServiceDataMsg1<tF32>
{
public:
	vds_tclMsgF32 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tF32 f32Value);
	vds_tclMsgF32 (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclMsgBool : public amt_tclServiceDataMsg1<tBool>
{
public:
	vds_tclMsgBool (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tBool boolValue);
	vds_tclMsgBool (amt_tclBaseMessage *poBaseMessage);
};

// following classes were replaced with base-messages:

class vds_tclGpsCommunicationProtocolGet : public vds_tclMsg0
{
public:
	vds_tclGpsCommunicationProtocolGet (tU16 u16Source, tU16 u16Target);
	vds_tclGpsCommunicationProtocolGet (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclGpsDataUpReg : public vds_tclMsg0
{
public:
	vds_tclGpsDataUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGpsDataUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsDataRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGpsDataRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGpsDataRelUpReg (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclGpsValidContentGet : public vds_tclMsg0
{
public:
	vds_tclGpsValidContentGet (tU16 u16Source, tU16 u16Target);
	vds_tclGpsValidContentGet (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclGyroDataInitGet : public vds_tclMsg0
{
public:
	vds_tclGyroDataInitGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroDataInitGet (amt_tclBaseMessage *poBaseMessage);
};
/*
class vds_tclGyroDataUpdateUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroDataUpdateUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroDataUpdateUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroDataUpdateRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroDataUpdateRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroDataUpdateRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
*/
class vds_tclGyroADCBitResolutionGet : public vds_tclMsg0
{
public:
	vds_tclGyroADCBitResolutionGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroADCBitResolutionGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroADCBitResolutionSet : public vds_tclMsgU8
{
public:
	vds_tclGyroADCBitResolutionSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
	vds_tclGyroADCBitResolutionSet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroADCBitResolutionStatus : public vds_tclMsgU8
{
public:
	vds_tclGyroADCBitResolutionStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value);
	vds_tclGyroADCBitResolutionStatus (amt_tclBaseMessage *poBaseMessage);
};
/*
class vds_tclGyroManufacturerGet : public vds_tclMsg0
{
public:
	vds_tclGyroManufacturerGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroManufacturerGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroManufacturerSet : public vds_tclMsgU8
{
public:
	vds_tclGyroManufacturerSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
};
class vds_tclGyroManufacturerStatus : public vds_tclMsgU8
{
public:
	vds_tclGyroManufacturerStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclGyroOffsetGet : public vds_tclMsg0
{
public:
	vds_tclGyroOffsetGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroOffsetGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroOffsetUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroOffsetUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroOffsetUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroOffsetRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroOffsetRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroOffsetRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroOffsetSet : public vds_tclMsgU32
{
public:
	vds_tclGyroOffsetSet (tU16 u16Source, tU16 u16Target, tU32 u32Value);
};
class vds_tclGyroOffsetStatus : public vds_tclMsgU32
{
public:
	vds_tclGyroOffsetStatus (amt_tclBaseMessage *poBaseMessage);
};
*/

/*
class vds_tclGyroScalefactorGet : public vds_tclMsg0
{
public:
	vds_tclGyroScalefactorGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroScalefactorGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroScalefactorUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroScalefactorUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroScalefactorUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroScalefactorRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroScalefactorRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroScalefactorRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroScalefactorSet : public vds_tclMsgU16
{
public:
	vds_tclGyroScalefactorSet (tU16 u16Source, tU16 u16Target, tU16 u16Value);
};
class vds_tclGyroScalefactorStatus : public vds_tclMsgU16
{
public:
	vds_tclGyroScalefactorStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclGyroTypeGet : public vds_tclMsg0
{
public:
	vds_tclGyroTypeGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroTypeGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroTypeSet : public vds_tclMsgU8
{
public:
	vds_tclGyroTypeSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
};
class vds_tclGyroTypeStatus : public vds_tclMsgU8
{
public:
	vds_tclGyroTypeStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclSetDefaultGyroParametersMethodStart : public vds_tclMsg0
{
public:
	vds_tclSetDefaultGyroParametersMethodStart (tU16 u16Source, tU16 u16Target);
	vds_tclSetDefaultGyroParametersMethodStart (amt_tclBaseMessage *poBaseMessage);
};
*/
class vds_tclOdometerDataInitGet : public vds_tclMsg0
{
public:
	vds_tclOdometerDataInitGet (tU16 u16Source, tU16 u16Target);
	vds_tclOdometerDataInitGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerDataUpdateUpReg : public vds_tclMsg0
{
public:
	vds_tclOdometerDataUpdateUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclOdometerDataUpdateUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerDataUpdateRelUpReg : public vds_tclMsg0
{
public:
	vds_tclOdometerDataUpdateRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclOdometerDataUpdateRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
/*
class vds_tclTyreExpansionValueGet : public vds_tclMsg0
{
public:
	vds_tclTyreExpansionValueGet (tU16 u16Source, tU16 u16Target);
	vds_tclTyreExpansionValueGet (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclCalcOdometerCalibrationMethodStart : public vds_tclMsgU8
{
public:
	vds_tclCalcOdometerCalibrationMethodStart (tU16 u16Source, tU16 u16Target, tU8 u8Value);
};
class vds_tclCalcOdometerCalibrationMethodResult : public vds_tclMsg0
{
public:
	vds_tclCalcOdometerCalibrationMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclDistanceCalibrationValueGet : public vds_tclMsg0
{
public:
	vds_tclDistanceCalibrationValueGet (tU16 u16Source, tU16 u16Target);
	vds_tclDistanceCalibrationValueGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclDistanceCalibrationValueUpReg : public vds_tclMsg0
{
public:
	vds_tclDistanceCalibrationValueUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclDistanceCalibrationValueUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclDistanceCalibrationValueRelUpReg : public vds_tclMsg0
{
public:
	vds_tclDistanceCalibrationValueRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclDistanceCalibrationValueRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclDistanceCalibrationValueSet : public vds_tclMsgU32
{
public:
	vds_tclDistanceCalibrationValueSet (tU16 u16Source, tU16 u16Target, tU32 u32Value);
};
class vds_tclDistanceCalibrationValueStatus : public vds_tclMsgU32
{
public:
	vds_tclDistanceCalibrationValueStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclPulsesPerTyreCircumferenceGet : public vds_tclMsg0
{
public:
	vds_tclPulsesPerTyreCircumferenceGet (tU16 u16Source, tU16 u16Target);
	vds_tclPulsesPerTyreCircumferenceGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclPulsesPerTyreCircumferenceSet : public vds_tclMsgU32
{
public:
	vds_tclPulsesPerTyreCircumferenceSet (tU16 u16Source, tU16 u16Target, tU32 u32Value);
};
class vds_tclPulsesPerTyreCircumferenceStatus : public vds_tclMsgU32
{
public:
	vds_tclPulsesPerTyreCircumferenceStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclRimDiameterGet : public vds_tclMsg0
{
public:
	vds_tclRimDiameterGet (tU16 u16Source, tU16 u16Target);
	vds_tclRimDiameterGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclRimDiameterSet : public vds_tclMsgU16
{
public:
	vds_tclRimDiameterSet (tU16 u16Source, tU16 u16Target, tU16 u16Value);
};
class vds_tclRimDiameterStatus : public vds_tclMsgU16
{
public:
	vds_tclRimDiameterStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclTyreCircumferenceGet : public vds_tclMsg0
{
public:
	vds_tclTyreCircumferenceGet (tU16 u16Source, tU16 u16Target);
	vds_tclTyreCircumferenceGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclTyreCircumferenceSet : public vds_tclMsgU16
{
public:
	vds_tclTyreCircumferenceSet (tU16 u16Source, tU16 u16Target, tU16 u16Value);
};
class vds_tclTyreCircumferenceStatus : public vds_tclMsgU16
{
public:
	vds_tclTyreCircumferenceStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclTyreConditionGet : public vds_tclMsg0
{
public:
	vds_tclTyreConditionGet (tU16 u16Source, tU16 u16Target);
	vds_tclTyreConditionGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclTyreConditionSet : public vds_tclMsgU8
{
public:
	vds_tclTyreConditionSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
};
class vds_tclTyreConditionStatus : public vds_tclMsgU8
{
public:
	vds_tclTyreConditionStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclTyreHeightWidthRatioGet : public vds_tclMsg0
{
public:
	vds_tclTyreHeightWidthRatioGet (tU16 u16Source, tU16 u16Target);
	vds_tclTyreHeightWidthRatioGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclTyreHeightWidthRatioSet : public vds_tclMsgU8
{
public:
	vds_tclTyreHeightWidthRatioSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
};
class vds_tclTyreHeightWidthRatioStatus : public vds_tclMsgU8
{
public:
	vds_tclTyreHeightWidthRatioStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclTyreWidthGet : public vds_tclMsg0
{
public:
	vds_tclTyreWidthGet (tU16 u16Source, tU16 u16Target);
	vds_tclTyreWidthGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclTyreWidthSet : public vds_tclMsgU16
{
public:
	vds_tclTyreWidthSet (tU16 u16Source, tU16 u16Target, tU16 u16Value);
};
class vds_tclTyreWidthStatus : public vds_tclMsgU16
{
public:
	vds_tclTyreWidthStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/* Manual FI for GpsTemperature property are not commented becuase there was a build issue with NISSAN  if commented*/
class vds_tclGpsTemperatureGet : public vds_tclMsg0
{
public:
   vds_tclGpsTemperatureGet (tU16 u16Source, tU16 u16Target);
   vds_tclGpsTemperatureGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTemperatureUpReg : public vds_tclMsgU16
{
public:
   vds_tclGpsTemperatureUpReg (tU16 u16Source, tU16 u16Target, tU16 u16Value);
   vds_tclGpsTemperatureUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTemperatureRelUpReg : public vds_tclMsg0
{
public:
   vds_tclGpsTemperatureRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGpsTemperatureRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTemperatureStatus : public vds_tclMsgF32
{
public:
   vds_tclGpsTemperatureStatus (tU16 u16Source, tU16 u16Target, tF32 f32Value);
   vds_tclGpsTemperatureStatus (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclGpsFilterModeGet : public vds_tclMsg0
{
public:
   vds_tclGpsFilterModeGet (tU16 u16Source, tU16 u16Target);
   vds_tclGpsFilterModeGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsFilterModeSet : public vds_tclMsgU8
{
public:
   vds_tclGpsFilterModeSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
   vds_tclGpsFilterModeSet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsFilterModeStatus : public vds_tclMsgU8
{
public:
   vds_tclGpsFilterModeStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value);
   vds_tclGpsFilterModeStatus (amt_tclBaseMessage *poBaseMessage);
};
/*
class vds_tclGpsXoCompensationGet : public vds_tclMsg0
{
public:
   vds_tclGpsXoCompensationGet (tU16 u16Source, tU16 u16Target);
   vds_tclGpsXoCompensationGet (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclGpsAntennaCurrentGet : public vds_tclMsg0
{
public:
   vds_tclGpsAntennaCurrentGet (tU16 u16Source, tU16 u16Target);
   vds_tclGpsAntennaCurrentGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsAntennaCurrentUpReg : public vds_tclMsg0
{
public:
   vds_tclGpsAntennaCurrentUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGpsAntennaCurrentUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsAntennaCurrentRelUpReg : public vds_tclMsg0
{
public:
   vds_tclGpsAntennaCurrentRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGpsAntennaCurrentRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsAntennaCurrentStatus : public vds_tclMsgF32
{
public:
   vds_tclGpsAntennaCurrentStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
class vds_tclGpsTestModeMethodAbort : public vds_tclMsg0
{
public:
   vds_tclGpsTestModeMethodAbort (tU16 u16Source, tU16 u16Target);
   vds_tclGpsTestModeMethodAbort (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTestModeAbortResult : public vds_tclMsg0
{
public:
   vds_tclGpsTestModeAbortResult (tU16 u16Source, tU16 u16Target);
   vds_tclGpsTestModeAbortResult (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclOdometerManualCalibrationMethodAbort : public vds_tclMsg0
{
public:
   vds_tclOdometerManualCalibrationMethodAbort (tU16 u16Source, tU16 u16Target);
   vds_tclOdometerManualCalibrationMethodAbort (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerManualCalibrationAbortResult : public vds_tclMsg0
{
public:
   vds_tclOdometerManualCalibrationAbortResult (tU16 u16Source, tU16 u16Target);
   vds_tclOdometerManualCalibrationAbortResult (amt_tclBaseMessage *poBaseMessage);
};
/*
class vds_tclGyroADCBitRangeGet : public vds_tclMsg0
{
public:
	vds_tclGyroADCBitRangeGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroADCBitRangeGet (amt_tclBaseMessage *poBaseMessage);
};
*/

class vds_tclTimeOfDayGet : public vds_tclMsg0
{
public:
   vds_tclTimeOfDayGet (tU16 u16Source, tU16 u16Target);
   vds_tclTimeOfDayGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclTimeOfDaySet : public vds_tclMsgU16
{
public:
   vds_tclTimeOfDaySet (tU16 u16Source, tU16 u16Target, tU16 u16Value);
   vds_tclTimeOfDaySet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclTimeOfDayStatus : public vds_tclMsgU16
{
public:
   vds_tclTimeOfDayStatus (tU16 u16Source, tU16 u16Target, tU16 u16Value);
   vds_tclTimeOfDayStatus (amt_tclBaseMessage *poBaseMessage);
};


/*
class vds_tclOdometerPrepareManCalGet : public vds_tclMsg0
{
public:
   vds_tclOdometerPrepareManCalGet (tU16 u16Source, tU16 u16Target);
   vds_tclOdometerPrepareManCalGet (amt_tclBaseMessage *poBaseMessage);
};
*/
class vds_tclOdometerPrepareManCalSet : public vds_tclMsgU16
{
public:
   vds_tclOdometerPrepareManCalSet (tU16 u16Source, tU16 u16Target, tU16 u16Value);
   vds_tclOdometerPrepareManCalSet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerPrepareManCalStatus : public vds_tclMsgU16
{
public:
   vds_tclOdometerPrepareManCalStatus (tU16 u16Source, tU16 u16Target, tU16 u16Value);
   vds_tclOdometerPrepareManCalStatus (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclGyroSelftestMethodStart : public vds_tclMsg0
{
public:
	vds_tclGyroSelftestMethodStart (tU16 u16Source, tU16 u16Target);
	vds_tclGyroSelftestMethodStart (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroSelftestMethodResult : public vds_tclMsgBool
{
public:
	vds_tclGyroSelftestMethodResult (tU16 u16Source, tU16 u16Target, tBool bValue);
	vds_tclGyroSelftestMethodResult (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroSelftestMethodAbort : public vds_tclMsg0
{
public:
	vds_tclGyroSelftestMethodAbort (tU16 u16Source, tU16 u16Target);
	vds_tclGyroSelftestMethodAbort (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroSelftestAbortResult : public vds_tclMsg0
{
public:
	vds_tclGyroSelftestAbortResult (tU16 u16Source, tU16 u16Target);
	vds_tclGyroSelftestAbortResult (amt_tclBaseMessage *poBaseMessage);
};


class vds_tclOdometerUsageGet : public vds_tclMsg0
{
public:
   vds_tclOdometerUsageGet (tU16 u16Source, tU16 u16Target);
   vds_tclOdometerUsageGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerUsageSet : public vds_tclMsgU8
{
public:
   vds_tclOdometerUsageSet (tU16 u16Source, tU16 u16Target, tU8 u8Value);
   vds_tclOdometerUsageSet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerUsageUpReg : public vds_tclMsg0
{
public:
	vds_tclOdometerUsageUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclOdometerUsageUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOdometerUsageRelUpReg : public vds_tclMsg0
{
public:
	vds_tclOdometerUsageRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclOdometerUsageRelUpReg (amt_tclBaseMessage *poBaseMessage);
}; 
class vds_tclOdometerUsageStatus : public vds_tclMsgU8
{
public:
   vds_tclOdometerUsageStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value);
   vds_tclOdometerUsageStatus (amt_tclBaseMessage *poBaseMessage);
};


// Da die Nachrichten unaligned sind, der Code aber immer mit 4-byte-alignment
// compiliert wird, kann die Template-Klasse amt_tclArrayN nicht fuer unaligned
// Strukturen verwendet werden, deshalb ist die Klasse vds_tclGyroList hier
// implementiert. Sie speichert die Elemente
//	tU32	u32Timestamp;				// sensor-tics (wrap around counter)
//	tU32	u32GyroValue;				// adc-value (range depends on used ad-converter bit-range)
//	tU16	u16GyroStatus;				// tbd

#define VDS_C_U32_SIZEOF_GYRODATA   (tU32)10

//-- class vds_tclGyroData

class vds_tclGyroData : public amt_tclMappableType
{
  friend class amt_tclMappableMessage;
  public:
      vds_tclGyroData ();
      virtual tU32 u32GetSizeOfType () const;
      tVoid vSetValue (amt_tclMappableMessage* prMMsg, vds_trGyroData value);
      vds_trGyroData nGetValue (const amt_tclMappableMessage* prMMsg) const;
};


//-- class vds_tclGyroList

class vds_tclGyroList : public amt_tclMappableType
{
  public:
      vds_tclGyroList ();
      virtual tU32 u32GetSizeOfType () const;
      tBool bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trGyroData value);
      tBool bGetElement (const amt_tclMappableMessage* prMMsg, vds_trGyroData* pResult, const tU32 u32Index) const;
      tU32 u32Link (amt_tclMappableMessage* prMMsg);
      tVoid vSetMaxIndex (tU32 u32NewMaxIndex);
      tU32 u32GetMaxIndex () const;
      tBool bWriteMaxIndex (amt_tclMappableMessage* prMMsg);
      tVoid vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclGyroList* pSourceArrayN);
  private:
      tU32 u32MaxIndex;
};

#define VDS_C_U32_SIZEOF_ABSDATA   (tU32)20

//-- class vds_tclAbsData

class vds_tclAbsData : public amt_tclMappableType
{
  friend class amt_tclMappableMessage;
  public:
      vds_tclAbsData ();
      virtual tU32 u32GetSizeOfType () const;
      tVoid vSetValue (amt_tclMappableMessage* prMMsg, vds_trAbsData value);
      vds_trAbsData nGetValue (const amt_tclMappableMessage* prMMsg) const;
};


//-- class vds_tclAbsList

class vds_tclAbsList : public amt_tclMappableType
{
  public:
      vds_tclAbsList ();
      virtual tU32 u32GetSizeOfType () const;
      tBool bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trAbsData value);
      tBool bGetElement (const amt_tclMappableMessage* prMMsg, vds_trAbsData* pResult, const tU32 u32Index) const;
      tU32 u32Link (amt_tclMappableMessage* prMMsg);
      tVoid vSetMaxIndex (tU32 u32NewMaxIndex);
      tU32 u32GetMaxIndex () const;
      tBool bWriteMaxIndex (amt_tclMappableMessage* prMMsg);
      tVoid vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclAbsList* pSourceArrayN);
  private:
      tU32 u32MaxIndex;
};


#define VDS_C_U32_SIZEOF_STEERINGDATA   (tU32)14

//-- class vds_tclSteeringData

class vds_tclSteeringData : public amt_tclMappableType
{
  friend class amt_tclMappableMessage;
  public:
      vds_tclSteeringData ();
      virtual tU32 u32GetSizeOfType () const;
      tVoid vSetValue (amt_tclMappableMessage* prMMsg, vds_trSteeringData value);
      vds_trSteeringData nGetValue (const amt_tclMappableMessage* prMMsg) const;
};


//-- class vds_tclSteeringList

class vds_tclSteeringList : public amt_tclMappableType
{
  public:
      vds_tclSteeringList ();
      virtual tU32 u32GetSizeOfType () const;
      tBool bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trSteeringData value);
      tBool bGetElement (const amt_tclMappableMessage* prMMsg, vds_trSteeringData* pResult, const tU32 u32Index) const;
      tU32 u32Link (amt_tclMappableMessage* prMMsg);
      tVoid vSetMaxIndex (tU32 u32NewMaxIndex);
      tU32 u32GetMaxIndex () const;
      tBool bWriteMaxIndex (amt_tclMappableMessage* prMMsg);
      tVoid vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclSteeringList* pSourceArrayN);
  private:
      tU32 u32MaxIndex;
};




//-- same for DiagLog test results

#define VDS_C_U32_SIZEOF_TESTRESULT   (tU32)3

//-- class vds_tclDiagLogTestResult

class vds_tclDiagLogTestResult : public amt_tclMappableType
{
  friend class amt_tclMappableMessage;
  public:
      vds_tclDiagLogTestResult ();
      virtual tU32 u32GetSizeOfType () const;
      tVoid vSetValue (amt_tclMappableMessage* prMMsg, vds_trDiagLogTestResult value);
      vds_trDiagLogTestResult nGetValue (const amt_tclMappableMessage* prMMsg) const;
};


//-- class vds_tclDiagLogTestResultList

class vds_tclDiagLogTestResultList : public amt_tclMappableType
{
  public:
      vds_tclDiagLogTestResultList ();
      virtual tU32 u32GetSizeOfType () const;
      tBool bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trDiagLogTestResult value);
      tBool bGetElement (const amt_tclMappableMessage* prMMsg, vds_trDiagLogTestResult* pResult, const tU32 u32Index) const;
      tU32 u32Link (amt_tclMappableMessage* prMMsg);
      tVoid vSetMaxIndex (tU32 u32NewMaxIndex);
      tU32 u32GetMaxIndex () const;
      tBool bWriteMaxIndex (amt_tclMappableMessage* prMMsg);
      tVoid vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclDiagLogTestResultList* pSourceArrayN);
  private:
      tU32 u32MaxIndex;
};


/*
//-- class vds_tclGpsTestModeMethodStart
class vds_tclGpsTestModeMethodStart : public amt_tclServiceData
{
  public:
      vds_tclGpsTestModeMethodStart (tU16 u16Source, tU16 u16Target, tSetTestmode &rfrSetTestmode);
      tVoid vSetTestMode (tSetTestmode &rfrSetTestmode);
  private:
    // Data Members for Class Attributes
      vds_tclGpsSetData oSetData;
};
*/
//-- class vds_tclGpsTestModeMethodResult
/*
class vds_tclGpsTestModeMethodResult : public amt_tclServiceData
{
  public:
      vds_tclGpsTestModeMethodResult (amt_tclBaseMessage *poBaseMessage);
      tVoid vGetTestModeData (tTestmodeData &rfrTestmodeData);
  private:
    // Data Members for Class Attributes
      vds_tclGpsTestmodeData oTestmodeData;
};
*/


//-- class vds_tclOdometerManualCalibrationMethodStart
class vds_tclOdometerManualCalibrationMethodStart : public amt_tclServiceData
{
  public:
      vds_tclOdometerManualCalibrationMethodStart (tU16 u16Source, tU16 u16Target, tU16 u16Distance);
      vds_tclOdometerManualCalibrationMethodStart (amt_tclBaseMessage *poBaseMessage);
      tVoid vSetOdometerManualCalibration (tU16 &u16Distance);
      tVoid vGetOdometerManualCalibration (tU16 &u16Distance);
  private:
    // Data Members for Class Attributes
      vds_tclSetOdometerManualCalibration oSetDistance;
};

//-- class vds_tclOdometerManualCalibrationMethodResult
class vds_tclOdometerManualCalibrationMethodResult : public amt_tclServiceData
{
  public:
      vds_tclOdometerManualCalibrationMethodResult (tU16 u16Source, tU16 u16Target, const tU16 u16RetValue);
      vds_tclOdometerManualCalibrationMethodResult (amt_tclBaseMessage *poBaseMessage);
      tVoid vSetOdometerManualCalibrationData (const tU16 &u16RetValue);
      tVoid vGetOdometerManualCalibrationData (tU16 &u16RetValue);
  private:
    // Data Members for Class Attributes
      vds_tclOdometerManualCalibrationData oSetRetValue;
};



//-- class vds_tclGpsXoCompensation
class vds_tclGpsXoCompensation : public amt_tclServiceData
{
  public:
      vds_tclGpsXoCompensation (tU16 u16Source, tU16 u16Target, tXoCompensationData &rfrXoCompensationData, tU8 u8OpCode);
      vds_tclGpsXoCompensation (amt_tclBaseMessage *poBaseMessage);
      tVoid vSetXoCompensation (const tXoCompensationData &rfrXoCompensation);
      tVoid vGetXoCompensation (tXoCompensationData &rfrXoCompensation) const;
  private:
    // Data Members for Class Attributes
      vds_tclGpsXoCompensationData oXoCompensation;
};
/*
class vds_tclGpsXoCompensationSet : public vds_tclGpsXoCompensation
{
public:
	vds_tclGpsXoCompensationSet (tU16 u16Source, tU16 u16Target, tXoCompensationData &rfrXoCompensationData);
};
class vds_tclGpsXoCompensationStatus : public vds_tclGpsXoCompensation
{
public:
	vds_tclGpsXoCompensationStatus (amt_tclBaseMessage *poBaseMessage);
};
*/

class vds_tclOsalTimeEventGet : public vds_tclMsg0
{
public:
	vds_tclOsalTimeEventGet (tU16 u16Source, tU16 u16Target);
	vds_tclOsalTimeEventGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOsalTimeEventUpReg : public vds_tclMsg0
{
public:
	vds_tclOsalTimeEventUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclOsalTimeEventUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOsalTimeEventRelUpReg : public vds_tclMsg0
{
public:
	vds_tclOsalTimeEventRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclOsalTimeEventRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclOsalTimeEventStatus : public vds_tclMsgU8
{
public:
	vds_tclOsalTimeEventStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value);
	vds_tclOsalTimeEventStatus (amt_tclBaseMessage *poBaseMessage);
};


/*
class vds_tclGyroErrorGet : public vds_tclMsg0
{
public:
	vds_tclGyroErrorGet (tU16 u16Source, tU16 u16Target);
	vds_tclGyroErrorGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroErrorUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroErrorUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroErrorUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroErrorRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGyroErrorRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGyroErrorRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGyroErrorStatus : public vds_tclMsgU8
{
public:
	vds_tclGyroErrorStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/* -- data types for GpsSetHints method ------------------------------------ */
/*
class vds_tclGpsSetHintsMethodStart : public amt_tclServiceData
{
  public:
      vds_tclGpsSetHintsMethodStart (tU16 u16Source, tU16 u16Target, tGpsHints &rfrGpsHints);
      tVoid vSetHints (tGpsHints &rfrGpsHints);
  private:
    // Data Members for Class Attributes
      vds_tclGpsHints oGpsHints;
};
class vds_tclGpsSetHintsMethodResult : public vds_tclMsg0
{
public:
	vds_tclGpsSetHintsMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclGpsSetExtHintsMethodStart : public amt_tclServiceData
{
  public:
      vds_tclGpsSetExtHintsMethodStart (tU16 u16Source, tU16 u16Target, tGpsExtHints &rfrGpsExtHints);
      tVoid vSetExtHints (tGpsExtHints &rfrGpsExtHints);
  private:
    // Data Members for Class Attributes
      vds_tclGpsExtHints oGpsExtHints;
};

class vds_tclGpsSetExtHintsMethodResult : public vds_tclMsg0
{
public:
	vds_tclGpsSetExtHintsMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/


/* -- data types for GpsTestAdditionalData property ------------------------ */
/*
class vds_tclGpsTestAdditionalDataGet : public vds_tclMsg0
{
public:
	vds_tclGpsTestAdditionalDataGet (tU16 u16Source, tU16 u16Target);
	vds_tclGpsTestAdditionalDataGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTestAdditionalDataUpReg : public vds_tclMsg0
{
public:
	vds_tclGpsTestAdditionalDataUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGpsTestAdditionalDataUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTestAdditionalDataRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGpsTestAdditionalDataRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGpsTestAdditionalDataRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTestAdditionalDataStatus : public amt_tclServiceData
{
  public:
      vds_tclGpsTestAdditionalDataStatus (amt_tclBaseMessage *poBaseMessage);
      tVoid vGetTestAdditionalData (vds_trGpsNormalModeTestResult &rfrTestResult);
  private:
    // Data Members for Class Attributes
      vds_tclGpsNormalModeTestResult oTestResult;
};
*/
/* -- definitions for GpsTightCouplingData -- */

/* -- data types for GpsTightCouplingData property ------------------------ */
/*
class vds_tclGpsTightCouplingDataGet : public vds_tclMsg0
{
public:
	vds_tclGpsTightCouplingDataGet (tU16 u16Source, tU16 u16Target);
	vds_tclGpsTightCouplingDataGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTightCouplingDataUpReg : public vds_tclMsg0
{
public:
	vds_tclGpsTightCouplingDataUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGpsTightCouplingDataUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTightCouplingDataRelUpReg : public vds_tclMsg0
{
public:
	vds_tclGpsTightCouplingDataRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclGpsTightCouplingDataRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsTightCouplingDataStatus : public amt_tclServiceData
{
  public:
      vds_tclGpsTightCouplingDataStatus (amt_tclBaseMessage *poBaseMessage);
      tVoid vGetGpsTightCouplingData (vds_trGpsTightCouplingData &rfrData);
  private:
    // Data Members for Class Attributes
      vds_tclGpsTightCouplingCommonData oCommonData;
      vds_tclGpsTightCouplingChannelDataList oChannelDataList;
};
*/
/* -- insert generated code here ---------------------------------------- */


/* ---------------------------------------------------------------------- */

/*
class vds_tclGpsFrontEndTestMethodStart : public vds_tclMsgU8
{
public:
   vds_tclGpsFrontEndTestMethodStart (tU16 u16Source, tU16 u16Target, tU8 u8Value);
};


class vds_tclGpsFrontEndTestMethodResult : public vds_tclMsgU32
{
public:
   vds_tclGpsFrontEndTestMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/


/* ---------------------------------------------------------------------- */


class vds_tclDiagLogSaveTestResultMethodStart : public amt_tclServiceData
{
 public:
   vds_tclDiagLogSaveTestResultMethodStart (tU16 u16Source, tU16 u16Target, tU32 u32MaxDataElements);
   vds_tclDiagLogSaveTestResultMethodStart (amt_tclBaseMessage *poBaseMessage);

   tBool bSetTestResultList (vds_trDiagLogTestResult *parTestResultList, tU32 u32NumOfTestResults);
   tBool bGetTestResultList (vds_trDiagLogTestResult *parTestResultList, tU32 u32MaxTestResults);
   tU32 u32GetNumOfTestResults ();

 private:
   vds_tclDiagLogTestResultList oTestResultList;
};

/* ---------------------------------------------------------------------- */
/*
class vds_tclUpdateDiagLogMethodStart : public vds_tclMsg0
{
public:
	vds_tclUpdateDiagLogMethodStart (tU16 u16Source, tU16 u16Target);
	vds_tclUpdateDiagLogMethodStart (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclUpdateDiagLogMethodResult : public vds_tclMsg0
{
public:
	vds_tclUpdateDiagLogMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/
/* ---------------------------------------------------------------------- */
/*
class vds_tclAbsDataStatus : public amt_tclServiceData
{
 public:
   //vds_tclAbsDataStatus (tU16 u16Source, tU16 u16Target, tU32 u32MaxDataElements);
   vds_tclAbsDataStatus (amt_tclBaseMessage *poBaseMessage);

   //tBool bSetAbsData (vds_trAbsData *parAbsData, tU32 u32NumOfAbsData);
   tBool bGetAbsData (vds_trAbsData *parAbsData, tU32 u32MaxAbsData);
   tU32 u32GetNumOfAbsData ();

 private:
   vds_tclAbsList oAbsList;
};
*/
/* ---------------------------------------------------------------------- */
/*
class vds_tclSteeringDataStatus : public amt_tclServiceData
{
 public:
   vds_tclSteeringDataStatus (amt_tclBaseMessage *poBaseMessage);

   tBool bGetSteeringData (vds_trSteeringData *parSteeringData, tU32 u32MaxSteeringData);
   tU32 u32GetNumOfSteeringData ();

 private:
   vds_tclSteeringList oSteeringList;
};
*/
/* ---------------------------------------------------------------------- */

//-- class vds_tclGpsTestModeMethodStart
/*
class vds_tclGpsExtTestModeMethodStart : public amt_tclServiceData
{
  public:
      vds_tclGpsExtTestModeMethodStart (tU16 u16Source, tU16 u16Target);
      tVoid vSetSvId (tU8 &rfru8SvId);
      tVoid vSetGpsSearchMask (tU16 &rfru16SearchMask);
  private:
    // Data Members for Class Attributes
      vds_tclU8 oSvId;
      vds_tclU16 oSearchMask;
};
*/
class vds_tclGpsExtTestModeMethodAbort : public vds_tclMsg0
{
public:
   vds_tclGpsExtTestModeMethodAbort (tU16 u16Source, tU16 u16Target);
   vds_tclGpsExtTestModeMethodAbort (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsExtTestModeAbortResult : public vds_tclMsg0
{
public:
   vds_tclGpsExtTestModeAbortResult (tU16 u16Source, tU16 u16Target);
   vds_tclGpsExtTestModeAbortResult (amt_tclBaseMessage *poBaseMessage);
};
/*
//-- class vds_tclGpsTestModeMethodResult
class vds_tclGpsExtTestModeMethodResult : public amt_tclServiceData
{
  public:
      vds_tclGpsExtTestModeMethodResult (amt_tclBaseMessage *poBaseMessage);
      tVoid vGetExtTestModeData (vds_trExtTestModeData &rfrExtTestModeData);
  private:
    // Data Members for Class Attributes
    vds_tclS32 oCurrentClkOffset;
    vds_tclU32 oCurrentClkValue;
    vds_tclU32 oGpsDebugChanStatusA;
    vds_tclU32 oGpsDebugChanStatusB;
    vds_tclU32 oGpsDebugChanStatusC;
    vds_tclU32 oGpsDebugChanStatusD;
    vds_tclU8   oCalcTestResult;
    vds_tclU8   oTestResult;
    vds_tclS16 oGpsAverageChannelSNR;
    vds_tclS16 oGpsActualChannelPower;

    vds_tclS16List  oGpsExtTestResultList;
};
*/
//-- classe vds_tclGpsDiagPosition
class vds_tclGpsDiagPosition : public amt_tclServiceData
{
  public:
      vds_tclGpsDiagPosition(tU16 u16Source, tU16 u16Target,tU8 u8OpCode);
     vds_tclGpsDiagPosition (amt_tclBaseMessage *poBaseMessage);
      tVoid vSetParameters (
        tS16 &rfrs16LatDeg, tS16 &rfrs16LatMin, tS16 &rfrs16LatSec, 
        tS16 &rfrs16LongDeg, tS16 &rfrs16LongMin, tS16 &rfrs16LongSec, 
        tS16 &rfrs16Altitude);
      tVoid vGetParameters (      
        tS16 &rfrs16LatDeg, tS16 &rfrs16LatMin, tS16 &rfrs16LatSec, 
        tS16 &rfrs16LongDeg, tS16 &rfrs16LongMin, tS16 &rfrs16LongSec, 
        tS16 &rfrs16Altitude);
  private:
    // Data Members for Class Attributes
      vds_tclS16 oLatDeg;
      vds_tclS16 oLatMin;    
      vds_tclS16 oLatSec;
      vds_tclS16 oLongDeg;
      vds_tclS16 oLongMin;
      vds_tclS16 oLongSec;
      vds_tclS16 oAltitude;
};
/*
class vds_tclGpsDiagPositionSet : public vds_tclGpsDiagPosition
{
public:
	vds_tclGpsDiagPositionSet (tU16 u16Source, tU16 u16Target);
};
class vds_tclGpsDiagPositionStatus : public vds_tclGpsDiagPosition
{
public:
	vds_tclGpsDiagPositionStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
//-- classe vds_tclDiagGyroRawData
class vds_tclDiagGyroRawData : public amt_tclServiceData
{
  public:
      vds_tclDiagGyroRawData(tU16 u16Source, tU16 u16Target,tU8 u8OpCode);
     vds_tclDiagGyroRawData (amt_tclBaseMessage *poBaseMessage);
      tVoid vSetParameters (
        tU32 &rfu32GyroVdd, tU32 &rfu32GyroValue);
  private:
    // Data Members for Class Attributes
      vds_tclU32 oGyroVdd;
      vds_tclU32 oGyroValue;    
};
/*
class vds_tclDiagGyroRawDataStatus : public vds_tclDiagGyroRawData
{
public:
	vds_tclDiagGyroRawDataStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/* ---------------------------------------------------------------------- */
/*
class vds_tclOdometerRangeGet : public vds_tclMsg0
{
public:
	vds_tclOdometerRangeGet (tU16 u16Source, tU16 u16Target);
	vds_tclOdometerRangeGet (amt_tclBaseMessage *poBaseMessage);
};
*/
class vds_tclOdometerRangeSet : public amt_tclServiceDataMsg3<tF32, tF32, tU8>
{
  public:
   vds_tclOdometerRangeSet (tU16 u16Source, tU16 u16Target, tF32 f32Min, tF32 f32Max, tU8 u8Status);
   vds_tclOdometerRangeSet (amt_tclBaseMessage *poBaseMessage);
};
/*
class vds_tclOdometerRangeStatus : public amt_tclServiceDataMsg3<tF32, tF32, tU8>
{
  public:
      vds_tclOdometerRangeStatus (amt_tclBaseMessage *poBaseMessage);
};
*/

/*
class vds_tclFactorySettingsMethodStart : public vds_tclMsg0
{
public:
	vds_tclFactorySettingsMethodStart (tU16 u16Source, tU16 u16Target);
	vds_tclFactorySettingsMethodStart (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclFactorySettingsMethodResult : public vds_tclMsg0
{
public:
	vds_tclFactorySettingsMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclUpdateFactorySettingsMethodStart : public vds_tclMsg0
{
public:
	vds_tclUpdateFactorySettingsMethodStart (tU16 u16Source, tU16 u16Target);
};
class vds_tclUpdateFactorySettingsMethodResult : public vds_tclMsg0
{
public:
	vds_tclUpdateFactorySettingsMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/

/* ---------------------------------------------------------------------- */

class vds_tclSPMCvmEventUpReg : public vds_tclMsg0
{
public:
	vds_tclSPMCvmEventUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclSPMCvmEventUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclSPMCvmEventRelUpReg : public vds_tclMsg0
{
public:
	vds_tclSPMCvmEventRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclSPMCvmEventRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclSPMCvmEventStatus : public vds_tclMsgU32
{
public:
	vds_tclSPMCvmEventStatus (tU16 u16Source, tU16 u16Target, tU32 u32Value);
	vds_tclSPMCvmEventStatus (amt_tclBaseMessage *poBaseMessage);
};

/* ---------------------------------------------------------------------- */
/*
class vds_tclGalaSpeedGet : public vds_tclMsg0
{
public:
   vds_tclGalaSpeedGet (tU16 u16Source, tU16 u16Target);
   vds_tclGalaSpeedGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGalaSpeedUpReg : public vds_tclMsg0
{
public:
   vds_tclGalaSpeedUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGalaSpeedUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGalaSpeedRelUpReg : public vds_tclMsg0
{
public:
   vds_tclGalaSpeedRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGalaSpeedRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGalaSpeedStatus : public vds_tclMsgF32
{
public:
   vds_tclGalaSpeedStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/* ---------------------------------------------------------------------- */
/*
class vds_tclDriveDirectionStatus : public vds_tclMsgU8
{
public:
   vds_tclDriveDirectionStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/*
class vds_tclDeactivateGpsEncoderMethodStart : public vds_tclMsgBool
{
public:
	vds_tclDeactivateGpsEncoderMethodStart (tU16 u16Source, tU16 u16Target, tBool bValue);
};
class vds_tclDeactivateGpsEncoderMethodResult : public vds_tclMsg0
{
public:
	vds_tclDeactivateGpsEncoderMethodResult (amt_tclBaseMessage *poBaseMessage);
};
*/

/* ---------------------------------------------------------------------- */
/*
class vds_tclGpsNoiselevelTimePosValidityStatus : public amt_tclServiceDataMsg2<tF32, tU32>
{
public:
   vds_tclGpsNoiselevelTimePosValidityStatus (amt_tclBaseMessage *poBaseMessage);
};
*/
/* ---------------------------------------------------------------------- */
/*
class vds_tclGpsOscillatorGet : public vds_tclMsg0
{
public:
   vds_tclGpsOscillatorGet (tU16 u16Source, tU16 u16Target);
   vds_tclGpsOscillatorGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsOscillatorUpReg : public vds_tclMsg0
{
public:
   vds_tclGpsOscillatorUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGpsOscillatorUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsOscillatorRelUpReg : public vds_tclMsg0
{
public:
   vds_tclGpsOscillatorRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclGpsOscillatorRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclGpsOscillatorStatus : public amt_tclServiceDataMsg4<tF32, tF32, tF32, tF32>
{
public:
   vds_tclGpsOscillatorStatus (amt_tclBaseMessage *poBaseMessage);
};
*/

#endif /*vds_basemessages_h*/
