//	*****************************************************************************
//	* FILE:         vds_basemessages.cpp
//	* SW_COMPONENT: VD-Sensor
//	* DESCRIPTION:  base-messages for vdsensor-communication
//	* AUTHOR:       CM-DI/ESA1-Fischer
//	* COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//	* HISTORY:
//	* 16.08.02 Rev. 1.0 CM-DI/ESA1-Fischer
//	*          Initial Revision.
//    * 26.08.09 sak9kor RBEI/ECF1 - Manual FI classes functions which have been replaced by XML
//                                                  generated FI have been removed and other functions related 
//                                                 including get,upreg and relupreg have been commented for most of the 
//                                                 properies and methods of vdsensor
//	*****************************************************************************

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#include "FunctionIDs.h"
#include "DataTypes.h"

#include "vds_basemessages.h"

// Class vds_tclMsg0
vds_tclMsg0::vds_tclMsg0 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode)
{
	if ( bIsValid() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
	}
}

vds_tclMsg0::vds_tclMsg0 (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg0( poBaseMessage )
{
}

// Class vds_tclMsgU8
vds_tclMsgU8::vds_tclMsgU8 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tU8 u8Value)
{
	if ( bIsValid() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
		vSetData1( u8Value );
	}
}

vds_tclMsgU8::vds_tclMsgU8 (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg1<tU8>( poBaseMessage )
{
}

// Class vds_tclMsgU16
vds_tclMsgU16::vds_tclMsgU16 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tU16 U16Value)
{
	if ( bIsValid() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
		vSetData1( U16Value );
	}
}

vds_tclMsgU16::vds_tclMsgU16 (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg1<tU16>( poBaseMessage )
{
}

// Class vds_tclMsgU32
vds_tclMsgU32::vds_tclMsgU32 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tU32 u32Value)
{
	if ( bIsValid() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
		vSetData1( u32Value );
	}
}

vds_tclMsgU32::vds_tclMsgU32 (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg1<tU32>( poBaseMessage )
{
}

// Class vds_tclMsgF32
vds_tclMsgF32::vds_tclMsgF32 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tF32 f32Value)
{
	if ( bIsValid() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
		vSetData1( f32Value );
	}
}

vds_tclMsgF32::vds_tclMsgF32 (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg1<tF32>( poBaseMessage )
{
}

// Class vds_tclMsgBool
vds_tclMsgBool::vds_tclMsgBool (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tBool boolValue)
{
	if ( bIsValid() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
		vSetData1( boolValue );
	}
}

vds_tclMsgBool::vds_tclMsgBool (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg1<tBool>( poBaseMessage )
{
}


//vds_tclGpsCommunicationProtocolGet
vds_tclGpsCommunicationProtocolGet::vds_tclGpsCommunicationProtocolGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_COMM_PROTOCOL, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsCommunicationProtocolGet::vds_tclGpsCommunicationProtocolGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsDataUpReg
vds_tclGpsDataUpReg::vds_tclGpsDataUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSDATA, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGpsDataUpReg::vds_tclGpsDataUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsDataRelUpReg
vds_tclGpsDataRelUpReg::vds_tclGpsDataRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSDATA, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGpsDataRelUpReg::vds_tclGpsDataRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsValidContentGet
vds_tclGpsValidContentGet::vds_tclGpsValidContentGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSDATA_VALID_CONTENT, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsValidContentGet::vds_tclGpsValidContentGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGyroDataInitGet
vds_tclGyroDataInitGet::vds_tclGyroDataInitGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRODATA_INIT, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroDataInitGet::vds_tclGyroDataInitGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
/*
//vds_tclGyroDataUpdateUpReg
vds_tclGyroDataUpdateUpReg::vds_tclGyroDataUpdateUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRODATA_UPDATE, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGyroDataUpdateUpReg::vds_tclGyroDataUpdateUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGyroDataUpdateRelUpReg
vds_tclGyroDataUpdateRelUpReg::vds_tclGyroDataUpdateRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRODATA_UPDATE, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGyroDataUpdateRelUpReg::vds_tclGyroDataUpdateRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
// vds_tclGyroADCBitResolutionGet
vds_tclGyroADCBitResolutionGet::vds_tclGyroADCBitResolutionGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_BIT_RESOLUTION, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroADCBitResolutionGet::vds_tclGyroADCBitResolutionGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
// vds_tclGyroADCBitResolutionSet
vds_tclGyroADCBitResolutionSet::vds_tclGyroADCBitResolutionSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_BIT_RESOLUTION, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
vds_tclGyroADCBitResolutionSet::vds_tclGyroADCBitResolutionSet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
// vds_tclGyroADCBitResolutionStatus
vds_tclGyroADCBitResolutionStatus::vds_tclGyroADCBitResolutionStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_BIT_RESOLUTION, AMT_C_U8_CCAMSG_OPCODE_STATUS, u8Value){}
vds_tclGyroADCBitResolutionStatus::vds_tclGyroADCBitResolutionStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}

/*   
//vds_tclGyroManufacturerGet
vds_tclGyroManufacturerGet::vds_tclGyroManufacturerGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_MANUFACTURER, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroManufacturerGet::vds_tclGyroManufacturerGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroManufacturerSet
vds_tclGyroManufacturerSet::vds_tclGyroManufacturerSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_MANUFACTURER, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
//vds_tclGyroManufacturerStatus
vds_tclGyroManufacturerStatus::vds_tclGyroManufacturerStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
*/
/*
//vds_tclGyroOffsetGet
vds_tclGyroOffsetGet::vds_tclGyroOffsetGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_OFFSET, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroOffsetGet::vds_tclGyroOffsetGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroOffsetUpReg
vds_tclGyroOffsetUpReg::vds_tclGyroOffsetUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_OFFSET, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGyroOffsetUpReg::vds_tclGyroOffsetUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroOffsetRelUpReg
vds_tclGyroOffsetRelUpReg::vds_tclGyroOffsetRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_OFFSET, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGyroOffsetRelUpReg::vds_tclGyroOffsetRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroOffsetSet
vds_tclGyroOffsetSet::vds_tclGyroOffsetSet (tU16 u16Source, tU16 u16Target, tU32 u32Value)
	:vds_tclMsgU32 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_OFFSET, AMT_C_U8_CCAMSG_OPCODE_SET, u32Value){}
//vds_tclGyroOffsetStatus
vds_tclGyroOffsetStatus::vds_tclGyroOffsetStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU32 (poBaseMessage){}
*/
/*
//vds_tclGyroScalefactorGet
vds_tclGyroScalefactorGet::vds_tclGyroScalefactorGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SCALEFACTOR, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroScalefactorGet::vds_tclGyroScalefactorGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroScalefactorUpReg
vds_tclGyroScalefactorUpReg::vds_tclGyroScalefactorUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SCALEFACTOR, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGyroScalefactorUpReg::vds_tclGyroScalefactorUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroScalefactorRelUpReg
vds_tclGyroScalefactorRelUpReg::vds_tclGyroScalefactorRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SCALEFACTOR, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGyroScalefactorRelUpReg::vds_tclGyroScalefactorRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroScalefactorSet
vds_tclGyroScalefactorSet::vds_tclGyroScalefactorSet (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SCALEFACTOR, AMT_C_U8_CCAMSG_OPCODE_SET, u16Value){}
//vds_tclGyroScalefactorStatus
vds_tclGyroScalefactorStatus::vds_tclGyroScalefactorStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
*/

/*
//vds_tclGyroTypeGet
vds_tclGyroTypeGet::vds_tclGyroTypeGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_TYPE, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroTypeGet::vds_tclGyroTypeGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroTypeSet
vds_tclGyroTypeSet::vds_tclGyroTypeSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_TYPE, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
//vds_tclGyroTypeStatus
vds_tclGyroTypeStatus::vds_tclGyroTypeStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
*/
/*
//vds_tclSetDefaultGyroParametersMethodStart
vds_tclSetDefaultGyroParametersMethodStart::vds_tclSetDefaultGyroParametersMethodStart (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_SET_DEFAULT_GYRO_PARAM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART){}
vds_tclSetDefaultGyroParametersMethodStart::vds_tclSetDefaultGyroParametersMethodStart (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
//vds_tclOdometerDataInitGet
vds_tclOdometerDataInitGet::vds_tclOdometerDataInitGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMDATA_INIT, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclOdometerDataInitGet::vds_tclOdometerDataInitGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOdometerDataUpdateUpReg
vds_tclOdometerDataUpdateUpReg::vds_tclOdometerDataUpdateUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMDATA_INIT, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclOdometerDataUpdateUpReg::vds_tclOdometerDataUpdateUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOdometerDataUpdateRelUpReg
vds_tclOdometerDataUpdateRelUpReg::vds_tclOdometerDataUpdateRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMDATA_INIT, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclOdometerDataUpdateRelUpReg::vds_tclOdometerDataUpdateRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
/*
//vds_tclTyreExpansionValueGet
vds_tclTyreExpansionValueGet::vds_tclTyreExpansionValueGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_EXPANSION, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclTyreExpansionValueGet::vds_tclTyreExpansionValueGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
//vds_tclCalcOdometerCalibrationMethodStart
/*
vds_tclCalcOdometerCalibrationMethodStart::vds_tclCalcOdometerCalibrationMethodStart (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_CALC_ODOM_CALIBRATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, u8Value){}
//vds_tclCalcOdometerCalibrationMethodResult
vds_tclCalcOdometerCalibrationMethodResult::vds_tclCalcOdometerCalibrationMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
//vds_tclDistanceCalibrationValueGet
/*
vds_tclDistanceCalibrationValueGet::vds_tclDistanceCalibrationValueGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_DISTCAL, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclDistanceCalibrationValueGet::vds_tclDistanceCalibrationValueGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclDistanceCalibrationValueUpReg
vds_tclDistanceCalibrationValueUpReg::vds_tclDistanceCalibrationValueUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_DISTCAL, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclDistanceCalibrationValueUpReg::vds_tclDistanceCalibrationValueUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclDistanceCalibrationValueRelUpReg
vds_tclDistanceCalibrationValueRelUpReg::vds_tclDistanceCalibrationValueRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_DISTCAL, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclDistanceCalibrationValueRelUpReg::vds_tclDistanceCalibrationValueRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclDistanceCalibrationValueSet
vds_tclDistanceCalibrationValueSet::vds_tclDistanceCalibrationValueSet (tU16 u16Source, tU16 u16Target, tU32 u32Value)
	:vds_tclMsgU32 (u16Source, u16Target, VDS_C_U16_FKTID_DISTCAL, AMT_C_U8_CCAMSG_OPCODE_SET, u32Value){}
//vds_tclDistanceCalibrationValueStatus
vds_tclDistanceCalibrationValueStatus::vds_tclDistanceCalibrationValueStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU32 (poBaseMessage){}
*/
/*
//vds_tclPulsesPerTyreCircumferenceGet
vds_tclPulsesPerTyreCircumferenceGet::vds_tclPulsesPerTyreCircumferenceGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_PULSES_PER_TYRE_CIRCUM, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclPulsesPerTyreCircumferenceGet::vds_tclPulsesPerTyreCircumferenceGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclPulsesPerTyreCircumferenceSet
vds_tclPulsesPerTyreCircumferenceSet::vds_tclPulsesPerTyreCircumferenceSet (tU16 u16Source, tU16 u16Target, tU32 u32Value)
	:vds_tclMsgU32 (u16Source, u16Target, VDS_C_U16_FKTID_PULSES_PER_TYRE_CIRCUM, AMT_C_U8_CCAMSG_OPCODE_SET, u32Value){}
//vds_tclPulsesPerTyreCircumferenceStatus
vds_tclPulsesPerTyreCircumferenceStatus::vds_tclPulsesPerTyreCircumferenceStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU32 (poBaseMessage){}
*/
/*
//vds_tclRimDiameterGet
vds_tclRimDiameterGet::vds_tclRimDiameterGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_RIM_DIAMETER, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclRimDiameterGet::vds_tclRimDiameterGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclRimDiameterSet
vds_tclRimDiameterSet::vds_tclRimDiameterSet (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_RIM_DIAMETER, AMT_C_U8_CCAMSG_OPCODE_SET, u16Value){}
//vds_tclRimDiameterStatus
vds_tclRimDiameterStatus::vds_tclRimDiameterStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
*/
/*
//vds_tclTyreCircumferenceGet
vds_tclTyreCircumferenceGet::vds_tclTyreCircumferenceGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_CIRCUMFERENCE, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclTyreCircumferenceGet::vds_tclTyreCircumferenceGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclTyreCircumferenceSet
vds_tclTyreCircumferenceSet::vds_tclTyreCircumferenceSet (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_CIRCUMFERENCE, AMT_C_U8_CCAMSG_OPCODE_SET, u16Value){}
//vds_tclTyreCircumferenceStatus
vds_tclTyreCircumferenceStatus::vds_tclTyreCircumferenceStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
*/
/*
//vds_tclTyreConditionGet
vds_tclTyreConditionGet::vds_tclTyreConditionGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_CONDITION, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclTyreConditionGet::vds_tclTyreConditionGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclTyreConditionSet
vds_tclTyreConditionSet::vds_tclTyreConditionSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_CONDITION, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
//vds_tclTyreConditionStatus
vds_tclTyreConditionStatus::vds_tclTyreConditionStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
*/

/*
//vds_tclTyreHeightWidthRatioGet
vds_tclTyreHeightWidthRatioGet::vds_tclTyreHeightWidthRatioGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_HEIGHT_WIDTH_RATIO, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclTyreHeightWidthRatioGet::vds_tclTyreHeightWidthRatioGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclTyreHeightWidthRatioSet
vds_tclTyreHeightWidthRatioSet::vds_tclTyreHeightWidthRatioSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_HEIGHT_WIDTH_RATIO, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
//vds_tclTyreHeightWidthRatioStatus
vds_tclTyreHeightWidthRatioStatus::vds_tclTyreHeightWidthRatioStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
*/
/*
//vds_tclTyreWidthGet
vds_tclTyreWidthGet::vds_tclTyreWidthGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_WIDTH, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclTyreWidthGet::vds_tclTyreWidthGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclTyreWidthSet
vds_tclTyreWidthSet::vds_tclTyreWidthSet (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_TYRE_WIDTH, AMT_C_U8_CCAMSG_OPCODE_SET, u16Value){}
//vds_tclTyreWidthStatus
vds_tclTyreWidthStatus::vds_tclTyreWidthStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
*/

//-- vds_tclGyroData
vds_tclGyroData::vds_tclGyroData ()
{
}

tU32 vds_tclGyroData::u32GetSizeOfType () const
{
  return VDS_C_U32_SIZEOF_GYRODATA;
}

tVoid vds_tclGyroData::vSetValue (amt_tclMappableMessage* prMMsg, vds_trGyroData value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), (char*)&value, VDS_C_U32_SIZEOF_GYRODATA);
   }
}

vds_trGyroData vds_tclGyroData::nGetValue (const amt_tclMappableMessage* prMMsg) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      vds_trGyroData oTemporaryObject;
      OSAL_pvMemoryCopy((char*)&oTemporaryObject, 
                        (char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), 
                        VDS_C_U32_SIZEOF_GYRODATA);
      return oTemporaryObject;
   }
   else
   {
      vds_trGyroData oTemporaryObject = {0};
      return oTemporaryObject;
   }
}


//-- vds_tclGyroList
vds_tclGyroList::vds_tclGyroList ()
{
   u32MaxIndex = 0;
}

tU32 vds_tclGyroList::u32GetSizeOfType () const
{
   // The length of the array is stored at the front of the buffer. If the 
   // message is posted to a client this first field is read to determine 
   // the lentgh of the data region for the string in the message.
   tU32 nLengthOverall = sizeof(tU32)              // first tU32 is used for
                                                   // string length
                       + u32MaxIndex * VDS_C_U32_SIZEOF_GYRODATA;  // length of data region
   return (nLengthOverall);
}

tBool vds_tclGyroList::bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trGyroData value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // first: set the length of the string in the first tU32 field
         char *pcMaxIndexField32 = (char*)(prMMsg->pu8GetSharedMemBase())+u32Offset;

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy(pcMaxIndexField32, &u32MaxIndex, sizeof(tU32));

         // copy data to message's data region
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset
                              + sizeof(tU32)                   // the maxIndex
                              + (u32Index * VDS_C_U32_SIZEOF_GYRODATA));       // move in array

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy(pcDataRegion, &value.u32Timestamp, sizeof(tU32));
         OSAL_pvMemoryCopy(pcDataRegion+sizeof(tU32), &value.u32GyroValue, sizeof(tU32));
         OSAL_pvMemoryCopy(pcDataRegion+sizeof(tU32)+sizeof(tU32), &value.u16GyroStatus, sizeof(tU16));
         return TRUE;
      }
   }
   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tBool vds_tclGyroList::bGetElement (const amt_tclMappableMessage* prMMsg, vds_trGyroData* pResult, const tU32 u32Index) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // Simply read the data region. The maximum lentgh must have been set by 
         // calling "u32Link" at the appropriate time. nLink ensures that 
         // "u32MaxIndex" has the correct value.
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset                        // start of field
                              + sizeof(tU32)                     // field "maxIndex"
                              + (u32Index * VDS_C_U32_SIZEOF_GYRODATA));         // move in array

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy((char*)(&pResult->u32Timestamp), pcDataRegion, sizeof(tU32));
         OSAL_pvMemoryCopy((char*)(&pResult->u32GyroValue), pcDataRegion+sizeof(tU32), sizeof(tU32));
         OSAL_pvMemoryCopy((char*)(&pResult->u16GyroStatus), pcDataRegion+sizeof(tU32)+sizeof(tU32), sizeof(tU16));
         return TRUE;
      }
   }

   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tU32 vds_tclGyroList::u32Link (amt_tclMappableMessage* prMMsg)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // "u32Link" simply updates the u32MaxIndex field by reading the first tU32
      // of the atual message position. 
      // Thus "u32Link" MUST (!!!) be called after all preceeding types have been
      // added to the message (by vAddType) and the message's actual size is at
      // the beginning of the String --> the string length is coded in the next 
      // tU32 field of the message and can be read out.
      char *pcLengthField32 =   (char*)( (prMMsg->pu8GetSharedMemBase())
                              + (prMMsg->u32GetDynMsgSize()) );

      // REMARK: do aligned copy of data --> use memcpy

      tU32 u32StoredLength;
      OSAL_pvMemoryCopy((char*)&u32StoredLength, pcLengthField32, sizeof(tU32));

      u32MaxIndex = u32StoredLength;

      return u32StoredLength;
   }
   else
   {
      u32MaxIndex = 0;
      return 0;
   }
}

tVoid vds_tclGyroList::vSetMaxIndex (tU32 u32NewMaxIndex)
{
   u32MaxIndex = u32NewMaxIndex;
}

tU32 vds_tclGyroList::u32GetMaxIndex () const
{
   return u32MaxIndex;
}

tBool vds_tclGyroList::bWriteMaxIndex (amt_tclMappableMessage* prMMsg)
{
   tBool bSuccess = FALSE;
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // set the length of the string in the first tU32 field
      tPU8 pu8MaxIndexField32 = (tPU8)(prMMsg->pu8GetSharedMemBase())+u32Offset;

      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((tPVoid)pu8MaxIndexField32, (tPCVoid)&u32MaxIndex, sizeof(tU32));

      bSuccess = TRUE;
   } // else NULL-pointer or msg-memory not allocated --> FALSE
   return (bSuccess);
}

tVoid vds_tclGyroList::vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclGyroList* pSourceArrayN)
{
   // copy size field, assumes correct length in source (!)

   u32MaxIndex          = pSourceArrayN->u32MaxIndex;
   tU32 u32FieldSize    =   sizeof(tU32)                               // first tU32 is used for "maxIndex" 
                          + (pSourceArrayN->u32MaxIndex * VDS_C_U32_SIZEOF_GYRODATA);  // Rest is data region

   // copy whole data including size field
   tChar *pcSourceField = (tChar*)((pSourceMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);
   tChar *pcDestiField  = (tChar*)((pDestiMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);

   // REMARK: do aligned copy of data --> use memcpy

   OSAL_pvMemoryCopy(pcDestiField, pcSourceField, u32FieldSize);
}


//-- vds_tclAbsData
vds_tclAbsData::vds_tclAbsData ()
{
}

tU32 vds_tclAbsData::u32GetSizeOfType () const
{
  return VDS_C_U32_SIZEOF_ABSDATA;
}

tVoid vds_tclAbsData::vSetValue (amt_tclMappableMessage* prMMsg, vds_trAbsData value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), (char*)&value, VDS_C_U32_SIZEOF_ABSDATA);
   }
}

vds_trAbsData vds_tclAbsData::nGetValue (const amt_tclMappableMessage* prMMsg) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      vds_trAbsData oTemporaryObject;
      OSAL_pvMemoryCopy((char*)&oTemporaryObject, 
                        (char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), 
                        VDS_C_U32_SIZEOF_ABSDATA);
      return oTemporaryObject;
   }
   else
   {
      vds_trAbsData oTemporaryObject = {0};
      return oTemporaryObject;
   }
}


//-- vds_tclAbsList
vds_tclAbsList::vds_tclAbsList ()
{
   u32MaxIndex = 0;
}

tU32 vds_tclAbsList::u32GetSizeOfType () const
{
   // The length of the array is stored at the front of the buffer. If the 
   // message is posted to a client this first field is read to determine 
   // the lentgh of the data region for the string in the message.
   tU32 nLengthOverall = sizeof(tU32)              // first tU32 is used for
                                                   // string length
                       + u32MaxIndex * VDS_C_U32_SIZEOF_ABSDATA;  // length of data region
   return (nLengthOverall);
}

tBool vds_tclAbsList::bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trAbsData value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // first: set the length of the string in the first tU32 field
         char *pcMaxIndexField32 = (char*)(prMMsg->pu8GetSharedMemBase())+u32Offset;

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy(pcMaxIndexField32, &u32MaxIndex, sizeof(tU32));

         // copy data to message's data region
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset
                              + sizeof(tU32)                   // the maxIndex
                              + (u32Index * VDS_C_U32_SIZEOF_ABSDATA));       // move in array

         OSAL_pvMemoryCopy(pcDataRegion + 0, &value.u32TimeStamp, sizeof(tU32));
         OSAL_pvMemoryCopy(pcDataRegion + 4, &value.u16CounterFrontLeft, sizeof(tU16));
         OSAL_pvMemoryCopy(pcDataRegion + 6, &value.u16CounterFrontRight, sizeof(tU16));
         OSAL_pvMemoryCopy(pcDataRegion + 8, &value.u16CounterRearLeft, sizeof(tU16));
         OSAL_pvMemoryCopy(pcDataRegion + 10, &value.u16CounterRearRight, sizeof(tU16));
         OSAL_pvMemoryCopy(pcDataRegion + 12, &value.u8StatusFrontLeft, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 13, &value.u8StatusFrontRight, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 14, &value.u8StatusRearLeft, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 15, &value.u8StatusRearRight, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 16, &value.u8DirectionFrontLeft, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 17, &value.u8DirectionFrontRight, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 18, &value.u8DirectionRearLeft, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 19, &value.u8DirectionRearRight, sizeof(tU8));

         return TRUE;
      }
   }
   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tBool vds_tclAbsList::bGetElement (const amt_tclMappableMessage* prMMsg, vds_trAbsData* pResult, const tU32 u32Index) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // Simply read the data region. The maximum lentgh must have been set by 
         // calling "u32Link" at the appropriate time. nLink ensures that 
         // "u32MaxIndex" has the correct value.
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset                        // start of field
                              + sizeof(tU32)                     // field "maxIndex"
                              + (u32Index * VDS_C_U32_SIZEOF_ABSDATA));         // move in array

         OSAL_pvMemoryCopy((char*)(&pResult->u32TimeStamp), pcDataRegion + 0, sizeof(tU32));
         OSAL_pvMemoryCopy((char*)(&pResult->u16CounterFrontLeft), pcDataRegion + 4, sizeof(tU16));
         OSAL_pvMemoryCopy((char*)(&pResult->u16CounterFrontRight), pcDataRegion + 6, sizeof(tU16));
         OSAL_pvMemoryCopy((char*)(&pResult->u16CounterRearLeft), pcDataRegion + 8, sizeof(tU16));
         OSAL_pvMemoryCopy((char*)(&pResult->u16CounterRearRight), pcDataRegion + 10, sizeof(tU16));
         OSAL_pvMemoryCopy((char*)(&pResult->u8StatusFrontLeft), pcDataRegion + 12, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8StatusFrontRight), pcDataRegion + 13, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8StatusRearLeft), pcDataRegion + 14, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8StatusRearRight), pcDataRegion + 15, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8DirectionFrontLeft), pcDataRegion + 16, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8DirectionFrontRight), pcDataRegion + 17, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8DirectionRearLeft), pcDataRegion + 18, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8DirectionRearRight), pcDataRegion + 19, sizeof(tU8));

         return TRUE;
      }
   }

   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tU32 vds_tclAbsList::u32Link (amt_tclMappableMessage* prMMsg)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // "u32Link" simply updates the u32MaxIndex field by reading the first tU32
      // of the atual message position. 
      // Thus "u32Link" MUST (!!!) be called after all preceeding types have been
      // added to the message (by vAddType) and the message's actual size is at
      // the beginning of the String --> the string length is coded in the next 
      // tU32 field of the message and can be read out.
      char *pcLengthField32 =   (char*)( (prMMsg->pu8GetSharedMemBase())
                              + (prMMsg->u32GetDynMsgSize()) );

      // REMARK: do aligned copy of data --> use memcpy

      tU32 u32StoredLength;
      OSAL_pvMemoryCopy((char*)&u32StoredLength, pcLengthField32, sizeof(tU32));

      u32MaxIndex = u32StoredLength;

      return u32StoredLength;
   }
   else
   {
      u32MaxIndex = 0;
      return 0;
   }
}

tVoid vds_tclAbsList::vSetMaxIndex (tU32 u32NewMaxIndex)
{
   u32MaxIndex = u32NewMaxIndex;
}

tU32 vds_tclAbsList::u32GetMaxIndex () const
{
   return u32MaxIndex;
}

tBool vds_tclAbsList::bWriteMaxIndex (amt_tclMappableMessage* prMMsg)
{
   tBool bSuccess = FALSE;
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // set the length of the string in the first tU32 field
      tPU8 pu8MaxIndexField32 = (tPU8)(prMMsg->pu8GetSharedMemBase())+u32Offset;

      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((tPVoid)pu8MaxIndexField32, (tPCVoid)&u32MaxIndex, sizeof(tU32));

      bSuccess = TRUE;
   } // else NULL-pointer or msg-memory not allocated --> FALSE
   return (bSuccess);
}

tVoid vds_tclAbsList::vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclAbsList* pSourceArrayN)
{
   // copy size field, assumes correct length in source (!)

   u32MaxIndex          = pSourceArrayN->u32MaxIndex;
   tU32 u32FieldSize    =   sizeof(tU32)                               // first tU32 is used for "maxIndex" 
                          + (pSourceArrayN->u32MaxIndex * VDS_C_U32_SIZEOF_ABSDATA);  // Rest is data region

   // copy whole data including size field
   tChar *pcSourceField = (tChar*)((pSourceMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);
   tChar *pcDestiField  = (tChar*)((pDestiMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);

   // REMARK: do aligned copy of data --> use memcpy

   OSAL_pvMemoryCopy(pcDestiField, pcSourceField, u32FieldSize);
}




//-- vds_tclSteeringData
vds_tclSteeringData::vds_tclSteeringData ()
{
}

tU32 vds_tclSteeringData::u32GetSizeOfType () const
{
  return VDS_C_U32_SIZEOF_STEERINGDATA;
}

tVoid vds_tclSteeringData::vSetValue (amt_tclMappableMessage* prMMsg, vds_trSteeringData value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), (char*)&value, VDS_C_U32_SIZEOF_STEERINGDATA);
   }
}

vds_trSteeringData vds_tclSteeringData::nGetValue (const amt_tclMappableMessage* prMMsg) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      vds_trSteeringData oTemporaryObject;
      OSAL_pvMemoryCopy((char*)&oTemporaryObject, 
                        (char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), 
                        VDS_C_U32_SIZEOF_STEERINGDATA);
      return oTemporaryObject;
   }
   else
   {
      vds_trSteeringData oTemporaryObject = {0};
      return oTemporaryObject;
   }
}


//-- vds_tclSteeringList
vds_tclSteeringList::vds_tclSteeringList ()
{
   u32MaxIndex = 0;
}

tU32 vds_tclSteeringList::u32GetSizeOfType () const
{
   // The length of the array is stored at the front of the buffer. If the 
   // message is posted to a client this first field is read to determine 
   // the lentgh of the data region for the string in the message.
   tU32 nLengthOverall = sizeof(tU32)              // first tU32 is used for
                                                   // string length
                       + u32MaxIndex * VDS_C_U32_SIZEOF_STEERINGDATA;  // length of data region
   return (nLengthOverall);
}

tBool vds_tclSteeringList::bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trSteeringData value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // first: set the length of the string in the first tU32 field
         char *pcMaxIndexField32 = (char*)(prMMsg->pu8GetSharedMemBase())+u32Offset;

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy(pcMaxIndexField32, &u32MaxIndex, sizeof(tU32));

         // copy data to message's data region
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset
                              + sizeof(tU32)                   // the maxIndex
                              + (u32Index * VDS_C_U32_SIZEOF_STEERINGDATA));       // move in array

         OSAL_pvMemoryCopy(pcDataRegion + 0, &value.u32TimeStamp, sizeof(tU32));
         OSAL_pvMemoryCopy(pcDataRegion + 4, &value.s32WheelAngle, sizeof(tS32));
         OSAL_pvMemoryCopy(pcDataRegion + 8, &value.s32WheelRate, sizeof(tS32));
         OSAL_pvMemoryCopy(pcDataRegion + 12, &value.u8StatusWheelAngle, sizeof(tU8));
         OSAL_pvMemoryCopy(pcDataRegion + 13, &value.u8StatusWheelRate, sizeof(tU8));

         return TRUE;
      }
   }
   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tBool vds_tclSteeringList::bGetElement (const amt_tclMappableMessage* prMMsg, vds_trSteeringData* pResult, const tU32 u32Index) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // Simply read the data region. The maximum lentgh must have been set by 
         // calling "u32Link" at the appropriate time. nLink ensures that 
         // "u32MaxIndex" has the correct value.
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset                        // start of field
                              + sizeof(tU32)                     // field "maxIndex"
                              + (u32Index * VDS_C_U32_SIZEOF_STEERINGDATA));         // move in array

         OSAL_pvMemoryCopy((char*)(&pResult->u32TimeStamp), pcDataRegion + 0, sizeof(tU32));
         OSAL_pvMemoryCopy((char*)(&pResult->s32WheelAngle), pcDataRegion + 4, sizeof(tS32));
         OSAL_pvMemoryCopy((char*)(&pResult->s32WheelRate), pcDataRegion + 8, sizeof(tS32));
         OSAL_pvMemoryCopy((char*)(&pResult->u8StatusWheelAngle), pcDataRegion + 12, sizeof(tU8));
         OSAL_pvMemoryCopy((char*)(&pResult->u8StatusWheelRate), pcDataRegion + 13, sizeof(tU8));

         return TRUE;
      }
   }

   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tU32 vds_tclSteeringList::u32Link (amt_tclMappableMessage* prMMsg)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // "u32Link" simply updates the u32MaxIndex field by reading the first tU32
      // of the atual message position. 
      // Thus "u32Link" MUST (!!!) be called after all preceeding types have been
      // added to the message (by vAddType) and the message's actual size is at
      // the beginning of the String --> the string length is coded in the next 
      // tU32 field of the message and can be read out.
      char *pcLengthField32 =   (char*)( (prMMsg->pu8GetSharedMemBase())
                              + (prMMsg->u32GetDynMsgSize()) );

      // REMARK: do aligned copy of data --> use memcpy

      tU32 u32StoredLength;
      OSAL_pvMemoryCopy((char*)&u32StoredLength, pcLengthField32, sizeof(tU32));

      u32MaxIndex = u32StoredLength;

      return u32StoredLength;
   }
   else
   {
      u32MaxIndex = 0;
      return 0;
   }
}

tVoid vds_tclSteeringList::vSetMaxIndex (tU32 u32NewMaxIndex)
{
   u32MaxIndex = u32NewMaxIndex;
}

tU32 vds_tclSteeringList::u32GetMaxIndex () const
{
   return u32MaxIndex;
}

tBool vds_tclSteeringList::bWriteMaxIndex (amt_tclMappableMessage* prMMsg)
{
   tBool bSuccess = FALSE;
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // set the length of the string in the first tU32 field
      tPU8 pu8MaxIndexField32 = (tPU8)(prMMsg->pu8GetSharedMemBase())+u32Offset;

      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((tPVoid)pu8MaxIndexField32, (tPCVoid)&u32MaxIndex, sizeof(tU32));

      bSuccess = TRUE;
   } // else NULL-pointer or msg-memory not allocated --> FALSE
   return (bSuccess);
}

tVoid vds_tclSteeringList::vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclSteeringList* pSourceArrayN)
{
   // copy size field, assumes correct length in source (!)

   u32MaxIndex          = pSourceArrayN->u32MaxIndex;
   tU32 u32FieldSize    =   sizeof(tU32)                               // first tU32 is used for "maxIndex" 
                          + (pSourceArrayN->u32MaxIndex * VDS_C_U32_SIZEOF_STEERINGDATA);  // Rest is data region

   // copy whole data including size field
   tChar *pcSourceField = (tChar*)((pSourceMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);
   tChar *pcDestiField  = (tChar*)((pDestiMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);

   // REMARK: do aligned copy of data --> use memcpy

   OSAL_pvMemoryCopy(pcDestiField, pcSourceField, u32FieldSize);
}






//-- vds_tclDiagLogTestResult
vds_tclDiagLogTestResult::vds_tclDiagLogTestResult ()
{
}

tU32 vds_tclDiagLogTestResult::u32GetSizeOfType () const
{
  return VDS_C_U32_SIZEOF_TESTRESULT;
}

tVoid vds_tclDiagLogTestResult::vSetValue (amt_tclMappableMessage* prMMsg, vds_trDiagLogTestResult value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), (char*)&value, VDS_C_U32_SIZEOF_TESTRESULT);
   }
}

vds_trDiagLogTestResult vds_tclDiagLogTestResult::nGetValue (const amt_tclMappableMessage* prMMsg) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // REMARK: do aligned copy of data --> use memcpy

      vds_trDiagLogTestResult oTemporaryObject;
      OSAL_pvMemoryCopy((char*)&oTemporaryObject, 
                        (char*)((prMMsg->pu8GetSharedMemBase())+u32Offset), 
                        VDS_C_U32_SIZEOF_TESTRESULT);
      return oTemporaryObject;
   }
   else
   {
      vds_trDiagLogTestResult oTemporaryObject = {0};
      return oTemporaryObject;
   }
}


//-- vds_tclDiagLogTestResultList
vds_tclDiagLogTestResultList::vds_tclDiagLogTestResultList ()
{
   u32MaxIndex = 0;
}

tU32 vds_tclDiagLogTestResultList::u32GetSizeOfType () const
{
   // The length of the array is stored at the front of the buffer. If the 
   // message is posted to a client this first field is read to determine 
   // the lentgh of the data region for the string in the message.
   tU32 nLengthOverall = sizeof(tU32)              // first tU32 is used for
                                                   // string length
                       + u32MaxIndex * VDS_C_U32_SIZEOF_TESTRESULT;  // length of data region
   return (nLengthOverall);
}

tBool vds_tclDiagLogTestResultList::bSetElement (amt_tclMappableMessage* prMMsg, tU32 u32Index, vds_trDiagLogTestResult value)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // first: set the length of the string in the first tU32 field
         char *pcMaxIndexField32 = (char*)(prMMsg->pu8GetSharedMemBase())+u32Offset;

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy(pcMaxIndexField32, &u32MaxIndex, sizeof(tU32));

         // copy data to message's data region
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset
                              + sizeof(tU32)                   // the maxIndex
                              + (u32Index * VDS_C_U32_SIZEOF_TESTRESULT));       // move in array

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy(pcDataRegion, &value.u16TroubleCode, sizeof(tU16));
         OSAL_pvMemoryCopy(pcDataRegion+sizeof(tU16), &value.u8Result, sizeof(tU8));
         return TRUE;
      }
   }
   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tBool vds_tclDiagLogTestResultList::bGetElement (const amt_tclMappableMessage* prMMsg, vds_trDiagLogTestResult* pResult, const tU32 u32Index) const
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // region check... 
      if(//(u32Index >= 0) &&
         (u32Index < u32MaxIndex))
      {
         // Simply read the data region. The maximum lentgh must have been set by 
         // calling "u32Link" at the appropriate time. nLink ensures that 
         // "u32MaxIndex" has the correct value.
         char *pcDataRegion = (char*)
                              ((prMMsg->pu8GetSharedMemBase())   // the base
                              + u32Offset                        // start of field
                              + sizeof(tU32)                     // field "maxIndex"
                              + (u32Index * VDS_C_U32_SIZEOF_TESTRESULT));         // move in array

         // REMARK: do aligned copy of data --> use memcpy

         OSAL_pvMemoryCopy((char*)(&pResult->u16TroubleCode), pcDataRegion, sizeof(tU16));
         OSAL_pvMemoryCopy((char*)(&pResult->u8Result), pcDataRegion+sizeof(tU16), sizeof(tU8));
         return TRUE;
      }
   }

   // if index exceeds array size or NULL-pointer --> FALSE
   return FALSE;
}

tU32 vds_tclDiagLogTestResultList::u32Link (amt_tclMappableMessage* prMMsg)
{
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // "u32Link" simply updates the u32MaxIndex field by reading the first tU32
      // of the atual message position. 
      // Thus "u32Link" MUST (!!!) be called after all preceeding types have been
      // added to the message (by vAddType) and the message's actual size is at
      // the beginning of the String --> the string length is coded in the next 
      // tU32 field of the message and can be read out.
      char *pcLengthField32 =   (char*)( (prMMsg->pu8GetSharedMemBase())
                              + (prMMsg->u32GetDynMsgSize()) );

      // REMARK: do aligned copy of data --> use memcpy

      tU32 u32StoredLength;
      OSAL_pvMemoryCopy((char*)&u32StoredLength, pcLengthField32, sizeof(tU32));

      u32MaxIndex = u32StoredLength;

      return u32StoredLength;
   }
   else
   {
      u32MaxIndex = 0;
      return 0;
   }
}

tVoid vds_tclDiagLogTestResultList::vSetMaxIndex (tU32 u32NewMaxIndex)
{
   u32MaxIndex = u32NewMaxIndex;
}

tU32 vds_tclDiagLogTestResultList::u32GetMaxIndex () const
{
   return u32MaxIndex;
}

tBool vds_tclDiagLogTestResultList::bWriteMaxIndex (amt_tclMappableMessage* prMMsg)
{
   tBool bSuccess = FALSE;
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // set the length of the string in the first tU32 field
      tPU8 pu8MaxIndexField32 = (tPU8)(prMMsg->pu8GetSharedMemBase())+u32Offset;

      // REMARK: do aligned copy of data --> use memcpy

      OSAL_pvMemoryCopy((tPVoid)pu8MaxIndexField32, (tPCVoid)&u32MaxIndex, sizeof(tU32));

      bSuccess = TRUE;
   } // else NULL-pointer or msg-memory not allocated --> FALSE
   return (bSuccess);
}

tVoid vds_tclDiagLogTestResultList::vClone (amt_tclMappableMessage* pDestiMsg, const amt_tclMappableMessage* pSourceMsg, const vds_tclDiagLogTestResultList* pSourceArrayN)
{
   // copy size field, assumes correct length in source (!)

   u32MaxIndex          = pSourceArrayN->u32MaxIndex;
   tU32 u32FieldSize    =   sizeof(tU32)                               // first tU32 is used for "maxIndex" 
                          + (pSourceArrayN->u32MaxIndex * VDS_C_U32_SIZEOF_TESTRESULT);  // Rest is data region

   // copy whole data including size field
   tChar *pcSourceField = (tChar*)((pSourceMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);
   tChar *pcDestiField  = (tChar*)((pDestiMsg->pu8GetSharedMemBase()) 
                                  + pSourceArrayN->u32Offset);

   // REMARK: do aligned copy of data --> use memcpy

   OSAL_pvMemoryCopy(pcDestiField, pcSourceField, u32FieldSize);
}




/* Manual FI for GpsTemperature property are not commented becuase there was a build issue with NISSAN if commented*/
//vds_tclGpsTemperatureGet
vds_tclGpsTemperatureGet::vds_tclGpsTemperatureGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_TEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsTemperatureGet::vds_tclGpsTemperatureGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsTemperatureUpReg
vds_tclGpsTemperatureUpReg::vds_tclGpsTemperatureUpReg (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_TEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_UPREG, u16Value){}
vds_tclGpsTemperatureUpReg::vds_tclGpsTemperatureUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
//vds_tclGpsTemperatureRelUpReg
vds_tclGpsTemperatureRelUpReg::vds_tclGpsTemperatureRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_TEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGpsTemperatureRelUpReg::vds_tclGpsTemperatureRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsTemperatureStatus
vds_tclGpsTemperatureStatus::vds_tclGpsTemperatureStatus (tU16 u16Source, tU16 u16Target, tF32 f32Value)
	:vds_tclMsgF32 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_TEMPERATURE, AMT_C_U8_CCAMSG_OPCODE_STATUS, f32Value){}
vds_tclGpsTemperatureStatus::vds_tclGpsTemperatureStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgF32 (poBaseMessage){}

//vds_tclGpsFilterModeGet
vds_tclGpsFilterModeGet::vds_tclGpsFilterModeGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_FILTERMODE, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsFilterModeGet::vds_tclGpsFilterModeGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsFilterModeSet
vds_tclGpsFilterModeSet::vds_tclGpsFilterModeSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_FILTERMODE, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
vds_tclGpsFilterModeSet::vds_tclGpsFilterModeSet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
//vds_tclGpsFilterModeStatus
vds_tclGpsFilterModeStatus::vds_tclGpsFilterModeStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_FILTERMODE, AMT_C_U8_CCAMSG_OPCODE_STATUS, u8Value){}
vds_tclGpsFilterModeStatus::vds_tclGpsFilterModeStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
/*
//vds_tclGpsTestModeMethodStart
vds_tclGpsTestModeMethodStart::vds_tclGpsTestModeMethodStart (tU16 u16Source, tU16 u16Target, tSetTestmode &rfrSetTestmode)
{
	vAddType( &oSetData );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_GPS_TESTMODE,				// nFunctionID, 
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,		// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);

      vSetTestMode(rfrSetTestmode);
	}
}

tVoid vds_tclGpsTestModeMethodStart::vSetTestMode (tSetTestmode &rfrSetTestmode)
{
	oSetData.vSetValue(this, rfrSetTestmode);
}
*/
//vds_tclGpsTestModeMethodAbort
vds_tclGpsTestModeMethodAbort::vds_tclGpsTestModeMethodAbort (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_TESTMODE, AMT_C_U8_CCAMSG_OPCODE_METHODABORT){}
vds_tclGpsTestModeMethodAbort::vds_tclGpsTestModeMethodAbort (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsTestModeAbortResult
vds_tclGpsTestModeAbortResult::vds_tclGpsTestModeAbortResult (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_TESTMODE, AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT){}
vds_tclGpsTestModeAbortResult::vds_tclGpsTestModeAbortResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
/*
//vds_tclGpsTestModeMethodResult
vds_tclGpsTestModeMethodResult::vds_tclGpsTestModeMethodResult (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oTestmodeData );
}
tVoid vds_tclGpsTestModeMethodResult::vGetTestModeData (tTestmodeData &rfrTestmodeData)
{
	rfrTestmodeData = oTestmodeData.nGetValue(this);
}
*/






//vds_tclOdometerManualCalibrationMethodStart
vds_tclOdometerManualCalibrationMethodStart::vds_tclOdometerManualCalibrationMethodStart (tU16 u16Source, tU16 u16Target, tU16 u16Distance)
{
	vAddType( &oSetDistance );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_ODO_MAN_CALIB,			// nFunctionID, 
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,		// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);

      vSetOdometerManualCalibration(u16Distance);
	}
}

vds_tclOdometerManualCalibrationMethodStart::vds_tclOdometerManualCalibrationMethodStart (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oSetDistance );
}

tVoid vds_tclOdometerManualCalibrationMethodStart::vSetOdometerManualCalibration (tU16 &u16Distance)
{
	oSetDistance.vSetValue(this, u16Distance);
}

tVoid vds_tclOdometerManualCalibrationMethodStart::vGetOdometerManualCalibration (tU16 &u16Distance)
{
	u16Distance = oSetDistance.nGetValue(this);
}

//vds_tclOdometerManualCalibrationMethodAbort
vds_tclOdometerManualCalibrationMethodAbort::vds_tclOdometerManualCalibrationMethodAbort (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODO_MAN_CALIB, AMT_C_U8_CCAMSG_OPCODE_METHODABORT){}
vds_tclOdometerManualCalibrationMethodAbort::vds_tclOdometerManualCalibrationMethodAbort (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclOdometerManualCalibrationAbortResult
vds_tclOdometerManualCalibrationAbortResult::vds_tclOdometerManualCalibrationAbortResult (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODO_MAN_CALIB, AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT){}
vds_tclOdometerManualCalibrationAbortResult::vds_tclOdometerManualCalibrationAbortResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclOdometerManualCalibrationMethodResult
vds_tclOdometerManualCalibrationMethodResult::vds_tclOdometerManualCalibrationMethodResult (tU16 u16Source, tU16 u16Target, const tU16 u16RetValue)
{
	vAddType( &oSetRetValue );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_ODO_MAN_CALIB,			// nFunctionID, 
			AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,	// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);

      vSetOdometerManualCalibrationData(u16RetValue);
	}
}

vds_tclOdometerManualCalibrationMethodResult::vds_tclOdometerManualCalibrationMethodResult (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oSetRetValue );
}

tVoid vds_tclOdometerManualCalibrationMethodResult::vSetOdometerManualCalibrationData (const tU16 &u16RetValue)
{
	oSetRetValue.vSetValue(this, u16RetValue);
}

tVoid vds_tclOdometerManualCalibrationMethodResult::vGetOdometerManualCalibrationData (tU16 &u16RetValue)
{
	u16RetValue = oSetRetValue.nGetValue(this);
}

/*
//vds_tclGpsXoCompensationGet
vds_tclGpsXoCompensationGet::vds_tclGpsXoCompensationGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_XOCOMPENSATION, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsXoCompensationGet::vds_tclGpsXoCompensationGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
//vds_tclGpsXoCompensation
vds_tclGpsXoCompensation::vds_tclGpsXoCompensation (tU16 u16Source, tU16 u16Target, tXoCompensationData &rfrXoCompensationData, tU8 u8OpCode)
{
	vAddType( &oXoCompensation );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_GPS_XOCOMPENSATION,		// nFunctionID, 
			u8OpCode,                     			// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);

      vSetXoCompensation(rfrXoCompensationData);
	}
}

vds_tclGpsXoCompensation::vds_tclGpsXoCompensation (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oXoCompensation );
}

tVoid vds_tclGpsXoCompensation::vSetXoCompensation (const tXoCompensationData &rfrXoCompensation)
{
	oXoCompensation.vSetValue(this, rfrXoCompensation);
}

tVoid vds_tclGpsXoCompensation::vGetXoCompensation (tXoCompensationData &rfrXoCompensation) const
{
	rfrXoCompensation = oXoCompensation.nGetValue(this);
}
/*
//vds_tclGpsXoCompensationSet
vds_tclGpsXoCompensationSet::vds_tclGpsXoCompensationSet(tU16 u16Source, tU16 u16Target, tXoCompensationData &rfrXoCompensationData)
	:vds_tclGpsXoCompensation (u16Source, u16Target, rfrXoCompensationData, AMT_C_U8_CCAMSG_OPCODE_SET){}

//vds_tclGpsXoCompensationStatus
vds_tclGpsXoCompensationStatus::vds_tclGpsXoCompensationStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclGpsXoCompensation (poBaseMessage){}
   */
/*
//vds_tclGpsAntennaCurrentGet
vds_tclGpsAntennaCurrentGet::vds_tclGpsAntennaCurrentGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_ANTENNACURRENT, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsAntennaCurrentGet::vds_tclGpsAntennaCurrentGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsAntennaCurrentUpReg
vds_tclGpsAntennaCurrentUpReg::vds_tclGpsAntennaCurrentUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_ANTENNACURRENT, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGpsAntennaCurrentUpReg::vds_tclGpsAntennaCurrentUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsAntennaCurrentRelUpReg
vds_tclGpsAntennaCurrentRelUpReg::vds_tclGpsAntennaCurrentRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPS_ANTENNACURRENT, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGpsAntennaCurrentRelUpReg::vds_tclGpsAntennaCurrentRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsAntennaCurrentStatus
vds_tclGpsAntennaCurrentStatus::vds_tclGpsAntennaCurrentStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgF32 (poBaseMessage){}
*/
/*
//vds_tclGyroADCBitRangeGet
vds_tclGyroADCBitRangeGet::vds_tclGyroADCBitRangeGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_ADCBITRANGE, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroADCBitRangeGet::vds_tclGyroADCBitRangeGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
//vds_tclTimeOfDayGet
vds_tclTimeOfDayGet::vds_tclTimeOfDayGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_TIME_OF_DAY, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclTimeOfDayGet::vds_tclTimeOfDayGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclTimeOfDaySet
vds_tclTimeOfDaySet::vds_tclTimeOfDaySet (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_TIME_OF_DAY, AMT_C_U8_CCAMSG_OPCODE_SET, u16Value){}
vds_tclTimeOfDaySet::vds_tclTimeOfDaySet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
//vds_tclTimeOfDayStatus
vds_tclTimeOfDayStatus::vds_tclTimeOfDayStatus (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_TIME_OF_DAY, AMT_C_U8_CCAMSG_OPCODE_STATUS, u16Value){}
vds_tclTimeOfDayStatus::vds_tclTimeOfDayStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}

//vds_tclOdometerPrepareManCalGet
/*
vds_tclOdometerPrepareManCalGet::vds_tclOdometerPrepareManCalGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODO_PREP_MAN_CALIB, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclOdometerPrepareManCalGet::vds_tclOdometerPrepareManCalGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
//vds_tclOdometerPrepareManCalSet
vds_tclOdometerPrepareManCalSet::vds_tclOdometerPrepareManCalSet (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_ODO_PREP_MAN_CALIB, AMT_C_U8_CCAMSG_OPCODE_SET, u16Value){}
vds_tclOdometerPrepareManCalSet::vds_tclOdometerPrepareManCalSet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}
//vds_tclOdometerPrepareManCalStatus
vds_tclOdometerPrepareManCalStatus::vds_tclOdometerPrepareManCalStatus (tU16 u16Source, tU16 u16Target, tU16 u16Value)
	:vds_tclMsgU16 (u16Source, u16Target, VDS_C_U16_FKTID_ODO_PREP_MAN_CALIB, AMT_C_U8_CCAMSG_OPCODE_STATUS, u16Value){}
vds_tclOdometerPrepareManCalStatus::vds_tclOdometerPrepareManCalStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU16 (poBaseMessage){}


//vds_tclOsalTimeEventGet
vds_tclOsalTimeEventGet::vds_tclOsalTimeEventGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_OSAL_TIME_EVENT, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclOsalTimeEventGet::vds_tclOsalTimeEventGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOsalTimeEventUpReg
vds_tclOsalTimeEventUpReg::vds_tclOsalTimeEventUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_OSAL_TIME_EVENT, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclOsalTimeEventUpReg::vds_tclOsalTimeEventUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOsalTimeEventRelUpReg
vds_tclOsalTimeEventRelUpReg::vds_tclOsalTimeEventRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_OSAL_TIME_EVENT, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclOsalTimeEventRelUpReg::vds_tclOsalTimeEventRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOsalTimeEventStatus
vds_tclOsalTimeEventStatus::vds_tclOsalTimeEventStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_OSAL_TIME_EVENT, AMT_C_U8_CCAMSG_OPCODE_STATUS, u8Value){}
vds_tclOsalTimeEventStatus::vds_tclOsalTimeEventStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
 


//vds_tclGyroErrorGet
/*
vds_tclGyroErrorGet::vds_tclGyroErrorGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYROERROR, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGyroErrorGet::vds_tclGyroErrorGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroErrorUpReg
vds_tclGyroErrorUpReg::vds_tclGyroErrorUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYROERROR, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGyroErrorUpReg::vds_tclGyroErrorUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroErrorRelUpReg
vds_tclGyroErrorRelUpReg::vds_tclGyroErrorRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYROERROR, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGyroErrorRelUpReg::vds_tclGyroErrorRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroErrorStatus
vds_tclGyroErrorStatus::vds_tclGyroErrorStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
 */

//vds_tclGyroSelftestMethodStart
vds_tclGyroSelftestMethodStart::vds_tclGyroSelftestMethodStart (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SELFTEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART){}
vds_tclGyroSelftestMethodStart::vds_tclGyroSelftestMethodStart (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroSelftestMethodAbort
vds_tclGyroSelftestMethodAbort::vds_tclGyroSelftestMethodAbort (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SELFTEST, AMT_C_U8_CCAMSG_OPCODE_METHODABORT){}
vds_tclGyroSelftestMethodAbort::vds_tclGyroSelftestMethodAbort (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGyroSelftestMethodResult
vds_tclGyroSelftestMethodResult::vds_tclGyroSelftestMethodResult (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SELFTEST, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, bValue){}
vds_tclGyroSelftestMethodResult::vds_tclGyroSelftestMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgBool (poBaseMessage){}
//vds_tclGyroSelftestAbortResult
vds_tclGyroSelftestAbortResult::vds_tclGyroSelftestAbortResult (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GYRO_SELFTEST, AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT){}
vds_tclGyroSelftestAbortResult::vds_tclGyroSelftestAbortResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
	

//vds_tclOdometerUsageGet
vds_tclOdometerUsageGet::vds_tclOdometerUsageGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMETER_USAGE, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclOdometerUsageGet::vds_tclOdometerUsageGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOdometerUsageSet
vds_tclOdometerUsageSet::vds_tclOdometerUsageSet (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMETER_USAGE, AMT_C_U8_CCAMSG_OPCODE_SET, u8Value){}
vds_tclOdometerUsageSet::vds_tclOdometerUsageSet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
//vds_tclOdometerUsageUpReg
vds_tclOdometerUsageUpReg::vds_tclOdometerUsageUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMETER_USAGE, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclOdometerUsageUpReg::vds_tclOdometerUsageUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOdometerUsageRelUpReg
vds_tclOdometerUsageRelUpReg::vds_tclOdometerUsageRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMETER_USAGE, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclOdometerUsageRelUpReg::vds_tclOdometerUsageRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclOdometerUsageStatus
vds_tclOdometerUsageStatus::vds_tclOdometerUsageStatus (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMETER_USAGE, AMT_C_U8_CCAMSG_OPCODE_STATUS, u8Value){}
vds_tclOdometerUsageStatus::vds_tclOdometerUsageStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}



/*
//vds_tclGpsSetHintsMethodStart
vds_tclGpsSetHintsMethodStart::vds_tclGpsSetHintsMethodStart (tU16 u16Source, tU16 u16Target, tGpsHints &rfrGpsHints)
{
	vAddType( &oGpsHints );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target, // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
			0,	// StreamCounter
			0,	// RegisterID
			0,	// nCmdCounter, 
			0,	// nServiceID, 
			VDS_C_U16_FKTID_GPSSETHINTS, // nFunctionID, 
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART, // OpCode
			0	// Asynchronous Completion Token (ACT)
			);

      vSetHints(rfrGpsHints);
	}
}

tVoid vds_tclGpsSetHintsMethodStart::vSetHints (tGpsHints &rfrGpsHints)
{
	oGpsHints.vSetValue(this, rfrGpsHints);
}
*/

//vds_tclGpsSetHintsMethodResult
/*
vds_tclGpsSetHintsMethodResult::vds_tclGpsSetHintsMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
/*
//vds_tclGpsSetExtHintsMethodStart
vds_tclGpsSetExtHintsMethodStart::vds_tclGpsSetExtHintsMethodStart (tU16 u16Source, tU16 u16Target, tGpsExtHints &rfrGpsExtHints)
{
	vAddType( &oGpsExtHints );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target, // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
			0,	// StreamCounter
			0,	// RegisterID
			0,	// nCmdCounter, 
			0,	// nServiceID, 
			VDS_C_U16_FKTID_GPSSETEXTHINTS, // nFunctionID, 
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART, // OpCode
			0	// Asynchronous Completion Token (ACT)
			);

      vSetExtHints(rfrGpsExtHints);
	}
}

tVoid vds_tclGpsSetExtHintsMethodStart::vSetExtHints (tGpsExtHints &rfrGpsExtHints)
{
	oGpsExtHints.vSetValue(this, rfrGpsExtHints);
}
*/

/*
//vds_tclGpsSetExtHintsMethodResult
vds_tclGpsSetExtHintsMethodResult::vds_tclGpsSetExtHintsMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/


/*
//vds_tclGpsTestAdditionalDataGet
vds_tclGpsTestAdditionalDataGet::vds_tclGpsTestAdditionalDataGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSTESTADDITIONALDATA, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsTestAdditionalDataGet::vds_tclGpsTestAdditionalDataGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsTestAdditionalDataUpReg
vds_tclGpsTestAdditionalDataUpReg::vds_tclGpsTestAdditionalDataUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSTESTADDITIONALDATA, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGpsTestAdditionalDataUpReg::vds_tclGpsTestAdditionalDataUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsTestAdditionalDataRelUpReg
vds_tclGpsTestAdditionalDataRelUpReg::vds_tclGpsTestAdditionalDataRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSTESTADDITIONALDATA, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGpsTestAdditionalDataRelUpReg::vds_tclGpsTestAdditionalDataRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsTestAdditionalDataStatus

vds_tclGpsTestAdditionalDataStatus::vds_tclGpsTestAdditionalDataStatus (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oTestResult );
}

tVoid vds_tclGpsTestAdditionalDataStatus::vGetTestAdditionalData (vds_trGpsNormalModeTestResult &rfrTestResult)
{
	rfrTestResult = oTestResult.nGetValue(this);
}
*/

/* -- definitions for GpsTightCouplingData -- */
/*
//vds_tclGpsTightCouplingDataGet
vds_tclGpsTightCouplingDataGet::vds_tclGpsTightCouplingDataGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSTCDATA, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsTightCouplingDataGet::vds_tclGpsTightCouplingDataGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsTightCouplingDataUpReg
vds_tclGpsTightCouplingDataUpReg::vds_tclGpsTightCouplingDataUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSTCDATA, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGpsTightCouplingDataUpReg::vds_tclGpsTightCouplingDataUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsTightCouplingDataRelUpReg
vds_tclGpsTightCouplingDataRelUpReg::vds_tclGpsTightCouplingDataRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSTCDATA, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGpsTightCouplingDataRelUpReg::vds_tclGpsTightCouplingDataRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsTightCouplingDataStatus
vds_tclGpsTightCouplingDataStatus::vds_tclGpsTightCouplingDataStatus (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
   vAddType( &oCommonData );
   oChannelDataList.u32Link( this );
   vAddType( &oChannelDataList );
}

tVoid vds_tclGpsTightCouplingDataStatus::vGetGpsTightCouplingData (vds_trGpsTightCouplingData &rfrData)
{
   rfrData.rCommon = oCommonData.nGetValue(this);
   if( oChannelDataList.u32GetMaxIndex() == OSAL_C_S32_GPS_NO_CHANNELS )
   {
      for( int i = 0 ; i < OSAL_C_S32_GPS_NO_CHANNELS ; ++i )
      {
         if( !oChannelDataList.bGetElement( this, &rfrData.arChannel[i], i ) )
         {
            return;
         }
      }
   }
}
*/
/* -- insert generated code here ---------------------------------------- */



/*
//vds_tclGpsFrontEndTestMethodStart
vds_tclGpsFrontEndTestMethodStart::vds_tclGpsFrontEndTestMethodStart (tU16 u16Source, tU16 u16Target, tU8 u8Value)
	:vds_tclMsgU8 (u16Source, u16Target, VDS_C_U16_FKTID_GPSFRONTENDTEST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, u8Value){}

//vds_tclGpsFrontEndTestMethodResult
vds_tclGpsFrontEndTestMethodResult::vds_tclGpsFrontEndTestMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU32 (poBaseMessage){}
*/







vds_tclDiagLogSaveTestResultMethodStart::vds_tclDiagLogSaveTestResultMethodStart (tU16 u16Source, tU16 u16Target, tU32 u32MaxDataElements)
{
   oTestResultList.vSetMaxIndex( u32MaxDataElements );
   vAddType( &oTestResultList );
   if ( bAllocateMessage() )
   {
      vInitServiceData ( u16Source, u16Target, // Source, Target
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
         0,			// StreamCounter
         0,			// RegisterID
         0,			// nCmdCounter, 
         CCA_C_U16_SRV_DIAGLOG,			// nServiceID, 
         VDS_C_U16_FKTID_DIAGLOG_SAVETESTRESULT, // nFunctionID, 
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART, // OpCode
         0			// Asynchronous Completion Token (ACT)
                         );
      // write max-index to msg (shared-mem)
      oTestResultList.bWriteMaxIndex( this );
   }
}

vds_tclDiagLogSaveTestResultMethodStart::vds_tclDiagLogSaveTestResultMethodStart (amt_tclBaseMessage *poBaseMessage)
   :  amt_tclServiceData( poBaseMessage )
{
   oTestResultList.u32Link(this);
   vAddType( &oTestResultList );
}



tBool vds_tclDiagLogSaveTestResultMethodStart::bSetTestResultList (
   vds_trDiagLogTestResult *parTestResultList,
   tU32 u32NumOfTestResults)
{
   tBool bSuccess = TRUE;

   // param-check
   if (	NULL != parTestResultList
      &&	(oTestResultList.u32GetMaxIndex()
         == u32NumOfTestResults ) )
   {
      for ( tU32 iu32ListElem = 0; iu32ListElem < u32NumOfTestResults; iu32ListElem++ )
      {
         if ( !oTestResultList.bSetElement(
                 this, iu32ListElem, parTestResultList[iu32ListElem]) )
         {
            bSuccess = FALSE;
            break;
         }
      }
   }
   else
      bSuccess = FALSE;


   return bSuccess;
}

tBool vds_tclDiagLogSaveTestResultMethodStart::bGetTestResultList (
   vds_trDiagLogTestResult *parTestResultList,
   tU32 u32MaxTestResults)
{
   tBool bSuccess = TRUE;

   // param-check
   if (	NULL != parTestResultList
      &&	0    != u32MaxTestResults )
   {
      // enough data?
      if ( oTestResultList.u32GetMaxIndex() >= u32MaxTestResults )
      {
         // copy var data
         for ( tU32 iu32ListElem = 0; iu32ListElem < u32MaxTestResults; iu32ListElem++ )
         {
            // get data from msg
            if ( !oTestResultList.bGetElement(
                    this, &parTestResultList[iu32ListElem], iu32ListElem ) )
            {
               bSuccess = FALSE;
               break;
            }
         }
      }
      else
         bSuccess = FALSE;
   }
   else
      bSuccess = FALSE;

   return bSuccess;	

}

tU32 vds_tclDiagLogSaveTestResultMethodStart::u32GetNumOfTestResults ()
{
   return ( oTestResultList.u32GetMaxIndex() );
}


/*
//vds_tclUpdateDiagLogMethodStart
vds_tclUpdateDiagLogMethodStart::vds_tclUpdateDiagLogMethodStart (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_UPDATEDIAGLOG, AMT_C_U8_CCAMSG_OPCODE_METHODSTART){}
vds_tclUpdateDiagLogMethodStart::vds_tclUpdateDiagLogMethodStart (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclUpdateDiagLogMethodResult
vds_tclUpdateDiagLogMethodResult::vds_tclUpdateDiagLogMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
/*
//vds_tclGpsExtTestModeMethodStart
vds_tclGpsExtTestModeMethodStart::vds_tclGpsExtTestModeMethodStart (tU16 u16Source, tU16 u16Target)
{
	vAddType( &oSvId );
	vAddType( &oSearchMask );

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_GPSEXTTESTMODE,				// nFunctionID, 
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,		// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);

 	}
}

tVoid vds_tclGpsExtTestModeMethodStart::vSetSvId (tU8 &rfru8SvId)
{
	oSvId.vSetValue(this, rfru8SvId);
}

tVoid vds_tclGpsExtTestModeMethodStart::vSetGpsSearchMask (tU16 &rfru16SearchMask)
{
	oSearchMask.vSetValue(this, rfru16SearchMask);
}
*/

//vds_tclGpsExtTestModeMethodAbort
vds_tclGpsExtTestModeMethodAbort::vds_tclGpsExtTestModeMethodAbort (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSEXTTESTMODE, AMT_C_U8_CCAMSG_OPCODE_METHODABORT){}
vds_tclGpsExtTestModeMethodAbort::vds_tclGpsExtTestModeMethodAbort (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}

//vds_tclGpsExtTestModeAbortResult
vds_tclGpsExtTestModeAbortResult::vds_tclGpsExtTestModeAbortResult (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSEXTTESTMODE, AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT){}
vds_tclGpsExtTestModeAbortResult::vds_tclGpsExtTestModeAbortResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
/*
//vds_tclGpsExtTestModeMethodResult
vds_tclGpsExtTestModeMethodResult::vds_tclGpsExtTestModeMethodResult (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oCurrentClkOffset );
	vAddType( &oCurrentClkValue );
       vAddType( &oGpsDebugChanStatusA );
       vAddType( &oGpsDebugChanStatusB );
       vAddType( &oGpsDebugChanStatusC );
       vAddType( &oGpsDebugChanStatusD );
	vAddType( &oCalcTestResult );
	vAddType( &oTestResult );
	vAddType( &oGpsAverageChannelSNR );
       vAddType( &oGpsActualChannelPower );
      oGpsExtTestResultList.u32Link( this );
	vAddType( &oGpsExtTestResultList);
}

tVoid vds_tclGpsExtTestModeMethodResult::vGetExtTestModeData (vds_trExtTestModeData &rfrExtTestModeData)
{
	rfrExtTestModeData.s32CurrentClkOffset = oCurrentClkOffset.nGetValue(this);
	rfrExtTestModeData.u32CurrentClkValue = oCurrentClkValue.nGetValue(this);
	rfrExtTestModeData.u32GpsDebugChanStatusA = oGpsDebugChanStatusA.nGetValue(this);
	rfrExtTestModeData.u32GpsDebugChanStatusB = oGpsDebugChanStatusB.nGetValue(this);
	rfrExtTestModeData.u32GpsDebugChanStatusC = oGpsDebugChanStatusC.nGetValue(this);
	rfrExtTestModeData.u32GpsDebugChanStatusD = oGpsDebugChanStatusD.nGetValue(this);
	rfrExtTestModeData.u8CalcTestResult = oCalcTestResult.nGetValue(this);
	rfrExtTestModeData.u8TestResult = oTestResult.nGetValue(this);
	rfrExtTestModeData.s16GpsAverageChannelSNR = oGpsAverageChannelSNR.nGetValue(this);
	rfrExtTestModeData.s16GpsActualChannelPower = oGpsActualChannelPower.nGetValue(this);

	for(int i = 0;i < 13;++i)
	{
	    oGpsExtTestResultList.bGetElement(this, &rfrExtTestModeData.as16GpsActualChannelSNR[i], i);
 	}

}
*/

vds_tclGpsDiagPosition::vds_tclGpsDiagPosition (tU16 u16Source, tU16 u16Target,tU8 u8OpCode)
{
	vAddType( &oLatDeg );		
	vAddType( &oLatMin );	
	vAddType( &oLatSec );
	vAddType( &oLongDeg );	
	vAddType( &oLongMin );	
	vAddType( &oLongSec );	
	vAddType( &oAltitude);	

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_GPSPOSITION,				// nFunctionID, 
			u8OpCode,		// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);


	}
}

vds_tclGpsDiagPosition::vds_tclGpsDiagPosition (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oLatDeg );		
	vAddType( &oLatMin );	
	vAddType( &oLatSec );
	vAddType( &oLongDeg );	
	vAddType( &oLongMin );	
	vAddType( &oLongSec );	
	vAddType( &oAltitude);	
}

tVoid vds_tclGpsDiagPosition::vSetParameters (
        tS16 &rfrs16LatDeg, tS16 &rfrs16LatMin, tS16 &rfrs16LatSec, 
        tS16 &rfrs16LongDeg, tS16 &rfrs16LongMin, tS16 &rfrs16LongSec, 
        tS16 &rfrs16Altitude)
{
	oLatDeg.vSetValue( this, rfrs16LatDeg );
	oLatMin.vSetValue( this, rfrs16LatMin );
	oLatSec.vSetValue( this, rfrs16LatSec );
	oLongDeg.vSetValue( this, rfrs16LongDeg );
	oLongMin.vSetValue( this, rfrs16LongMin );
	oLongSec.vSetValue( this, rfrs16LongSec );
	oAltitude.vSetValue( this, rfrs16Altitude );
	
}

tVoid vds_tclGpsDiagPosition::vGetParameters (      
        tS16 &rfrs16LatDeg, tS16 &rfrs16LatMin, tS16 &rfrs16LatSec, 
        tS16 &rfrs16LongDeg, tS16 &rfrs16LongMin, tS16 &rfrs16LongSec, 
        tS16 &rfrs16Altitude)
{
	rfrs16LatDeg = oLatDeg.nGetValue( this );
	rfrs16LatMin = oLatMin.nGetValue( this );
	rfrs16LatSec = oLatSec.nGetValue( this );
	rfrs16LongDeg = oLongDeg.nGetValue( this );
	rfrs16LongMin = oLongMin.nGetValue( this );
	rfrs16LongSec = oLongSec.nGetValue( this );
	rfrs16Altitude = oAltitude.nGetValue( this );
}

/*
//vds_tclGpsDiagPositionSet
vds_tclGpsDiagPositionSet::vds_tclGpsDiagPositionSet(tU16 u16Source, tU16 u16Target)
	:vds_tclGpsDiagPosition (u16Source, u16Target,  AMT_C_U8_CCAMSG_OPCODE_SET){}
//vds_tclGpsDiagPositionStatus
vds_tclGpsDiagPositionStatus::vds_tclGpsDiagPositionStatus(amt_tclBaseMessage *poBaseMessage)
	:vds_tclGpsDiagPosition (poBaseMessage){}
*/

vds_tclDiagGyroRawData::vds_tclDiagGyroRawData (tU16 u16Source, tU16 u16Target,tU8 u8OpCode)
{
	vAddType( &oGyroVdd );		
	vAddType( &oGyroValue );	

	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,  // Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,											      // StreamCounter
			0,											      // RegisterID
			0,											      // nCmdCounter, 
			0,											      // nServiceID, 
			VDS_C_U16_FKTID_GYRODIAGRAWVALUES,				// nFunctionID, 
			u8OpCode,		// OpCode
			0											      // Asynchronous Completion Token (ACT)
			);


	}
}

vds_tclDiagGyroRawData::vds_tclDiagGyroRawData (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceData( poBaseMessage )
{
	vAddType( &oGyroVdd );		
	vAddType( &oGyroValue );	
}

tVoid vds_tclDiagGyroRawData::vSetParameters (
       tU32 &rfu32GyroVdd, tU32 &rfu32GyroValue) 
{
	oGyroVdd.vSetValue( this, rfu32GyroVdd );
	oGyroValue.vSetValue( this, rfu32GyroValue );
}


//vds_tclGpsDiagPositionStatus
/*
vds_tclDiagGyroRawDataStatus::vds_tclDiagGyroRawDataStatus(amt_tclBaseMessage *poBaseMessage)
	:vds_tclDiagGyroRawData (poBaseMessage){}
*/


/*
vds_tclAbsDataStatus::vds_tclAbsDataStatus (amt_tclBaseMessage *poBaseMessage)
   :  amt_tclServiceData( poBaseMessage )
{
   oAbsList.u32Link(this);
   vAddType( &oAbsList );
}

tBool vds_tclAbsDataStatus::bGetAbsData (
   vds_trAbsData *parAbsList,
   tU32 u32MaxAbsData)
{
   tBool bSuccess = TRUE;

   // param-check
   if (	NULL != parAbsList
      &&	0    != u32MaxAbsData )
   {
      // enough data?
      if ( oAbsList.u32GetMaxIndex() >= u32MaxAbsData )
      {
         // copy var data
         for ( tU32 iu32ListElem = 0; iu32ListElem < u32MaxAbsData; iu32ListElem++ )
         {
            // get data from msg
            if ( !oAbsList.bGetElement(
                    this, &parAbsList[iu32ListElem], iu32ListElem ) )
            {
               bSuccess = FALSE;
               break;
            }
         }
      }
      else
         bSuccess = FALSE;
   }
   else
      bSuccess = FALSE;

   return bSuccess;	

}

tU32 vds_tclAbsDataStatus::u32GetNumOfAbsData ()
{
   return ( oAbsList.u32GetMaxIndex() );
}
*/
/*
vds_tclSteeringDataStatus::vds_tclSteeringDataStatus (amt_tclBaseMessage *poBaseMessage)
   :  amt_tclServiceData( poBaseMessage )
{
   oSteeringList.u32Link(this);
   vAddType( &oSteeringList );
}

tBool vds_tclSteeringDataStatus::bGetSteeringData (
   vds_trSteeringData *parSteeringList,
   tU32 u32MaxSteeringData)
{
   tBool bSuccess = TRUE;

   // param-check
   if (	NULL != parSteeringList
      &&	0    != u32MaxSteeringData )
   {
      // enough data?
      if ( oSteeringList.u32GetMaxIndex() >= u32MaxSteeringData )
      {
         // copy var data
         for ( tU32 iu32ListElem = 0; iu32ListElem < u32MaxSteeringData; iu32ListElem++ )
         {
            // get data from msg
            if ( !oSteeringList.bGetElement(
                    this, &parSteeringList[iu32ListElem], iu32ListElem ) )
            {
               bSuccess = FALSE;
               break;
            }
         }
      }
      else
         bSuccess = FALSE;
   }
   else
      bSuccess = FALSE;

   return bSuccess;	

}

tU32 vds_tclSteeringDataStatus::u32GetNumOfSteeringData ()
{
   return ( oSteeringList.u32GetMaxIndex() );
}
*/

// ----------------------------------------------------------------------
/*
vds_tclOdometerRangeGet::vds_tclOdometerRangeGet (tU16 u16Source, tU16 u16Target) :
   vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ODOMETERRANGE, AMT_C_U8_CCAMSG_OPCODE_GET)
{
   
}

vds_tclOdometerRangeGet::vds_tclOdometerRangeGet (amt_tclBaseMessage *poBaseMessage) :
   vds_tclMsg0( poBaseMessage )
{
   
}
*/
// ----------------------------------------------------------------------

vds_tclOdometerRangeSet::vds_tclOdometerRangeSet (tU16 u16Source, tU16 u16Target, tF32 f32Min, tF32 f32Max, tU8 u8Status)
{
   if ( bIsValid() )
   {
      vInitServiceData (
         u16Source, u16Target,  // Source, Target
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
         0,			// StreamCounter
         0,			// RegisterID
         0,			// nCmdCounter, 
         0,			// nServiceID, 
         VDS_C_U16_FKTID_ODOMETERRANGE, // nFunctionID, 
         AMT_C_U8_CCAMSG_OPCODE_SET, // OpCode
         0			// Asynchronous Completion Token (ACT)
                        );
      vSetData1( f32Min );
      vSetData2( f32Max );
      vSetData3( u8Status );
   }
}

vds_tclOdometerRangeSet::vds_tclOdometerRangeSet (amt_tclBaseMessage *poBaseMessage) :
   amt_tclServiceDataMsg3<tF32, tF32, tU8>( poBaseMessage )
{
   
}

// ----------------------------------------------------------------------

/*vds_tclOdometerRangeStatus::vds_tclOdometerRangeStatus (amt_tclBaseMessage *poBaseMessage) :
   amt_tclServiceDataMsg3<tF32, tF32, tU8>( poBaseMessage )
{
   
}
*/


/*
//vds_tclFactorySettingsMethodStart
vds_tclFactorySettingsMethodStart::vds_tclFactorySettingsMethodStart (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_FACTORYSETTINGS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART){}
vds_tclFactorySettingsMethodStart::vds_tclFactorySettingsMethodStart (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclFactorySettingsMethodResult
vds_tclFactorySettingsMethodResult::vds_tclFactorySettingsMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/


/*
//vds_tclUpdateFactorySettingsMethodStart
vds_tclUpdateFactorySettingsMethodStart::vds_tclUpdateFactorySettingsMethodStart (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_UPDATEFACTORYSETTINGS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART){}
//vds_tclUpdateFactorySettingsMethodResult
vds_tclUpdateFactorySettingsMethodResult::vds_tclUpdateFactorySettingsMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/



//vds_tclSPMCvmEventUpReg
vds_tclSPMCvmEventUpReg::vds_tclSPMCvmEventUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_SPM_CVMEVENT, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclSPMCvmEventUpReg::vds_tclSPMCvmEventUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclSPMCvmEventRelUpReg
vds_tclSPMCvmEventRelUpReg::vds_tclSPMCvmEventRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_SPM_CVMEVENT, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclSPMCvmEventRelUpReg::vds_tclSPMCvmEventRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclSPMCvmEventStatus
vds_tclSPMCvmEventStatus::vds_tclSPMCvmEventStatus (tU16 u16Source, tU16 u16Target, tU32 u32Value)
	:vds_tclMsgU32 (u16Source, u16Target, VDS_C_U16_FKTID_SPM_CVMEVENT, AMT_C_U8_CCAMSG_OPCODE_STATUS, u32Value){}
vds_tclSPMCvmEventStatus::vds_tclSPMCvmEventStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU32 (poBaseMessage){}
/*
//vds_tclGalaSpeedGet
vds_tclGalaSpeedGet::vds_tclGalaSpeedGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GALASPEED, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGalaSpeedGet::vds_tclGalaSpeedGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGalaSpeedUpReg
vds_tclGalaSpeedUpReg::vds_tclGalaSpeedUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GALASPEED, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGalaSpeedUpReg::vds_tclGalaSpeedUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGalaSpeedRelUpReg
vds_tclGalaSpeedRelUpReg::vds_tclGalaSpeedRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GALASPEED, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGalaSpeedRelUpReg::vds_tclGalaSpeedRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGalaSpeedStatus
vds_tclGalaSpeedStatus::vds_tclGalaSpeedStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgF32 (poBaseMessage){}
*/
   /*
vds_tclDriveDirectionStatus::vds_tclDriveDirectionStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsgU8 (poBaseMessage){}
*/
   /*
   //vds_tclDeactivateGpsEncoderMethodStart
vds_tclDeactivateGpsEncoderMethodStart::vds_tclDeactivateGpsEncoderMethodStart (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_DEACTIVATEGPSENCODER, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, bValue){}
//vds_tclDeactivateGpsEncoderMethodResult
vds_tclDeactivateGpsEncoderMethodResult::vds_tclDeactivateGpsEncoderMethodResult (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
*/
   /*
//vds_tclGpsNoiselevelTimePosValidityStatus
vds_tclGpsNoiselevelTimePosValidityStatus::vds_tclGpsNoiselevelTimePosValidityStatus (amt_tclBaseMessage *poBaseMessage)
	:amt_tclServiceDataMsg2<tF32, tU32>(poBaseMessage){}
*/
/*
//vds_tclGpsOscillatorGet
vds_tclGpsOscillatorGet::vds_tclGpsOscillatorGet (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSOSCILLATOR, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclGpsOscillatorGet::vds_tclGpsOscillatorGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsOscillatorUpReg
vds_tclGpsOscillatorUpReg::vds_tclGpsOscillatorUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSOSCILLATOR, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclGpsOscillatorUpReg::vds_tclGpsOscillatorUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsOscillatorRelUpReg
vds_tclGpsOscillatorRelUpReg::vds_tclGpsOscillatorRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_GPSOSCILLATOR, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclGpsOscillatorRelUpReg::vds_tclGpsOscillatorRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclMsg0 (poBaseMessage){}
//vds_tclGpsOscillatorStatus
vds_tclGpsOscillatorStatus::vds_tclGpsOscillatorStatus (amt_tclBaseMessage *poBaseMessage)
	:amt_tclServiceDataMsg4<tF32, tF32, tF32, tF32>(poBaseMessage){}
*/

