//	*****************************************************************************
//	* FILE:         vds_err_basemessages.cpp
//	* SW_COMPONENT: VD-Sensor
//	* DESCRIPTION:  base-messages for vdsensor-communication
//	* AUTHOR:       R. Schedel
//	* COPYRIGHT:    (c) 2003 Blaupunkt GmbH
//	* HISTORY:
//	* 05.06.03 R. Schedel
//	*          Initial Revision.
//	*****************************************************************************

#if defined (VARIANT_S_FTR_ENABLE_FORDTPEX) || defined (VARIANT_S_FTR_ENABLE_VWRNSLL) || defined (VARIANT_S_FTR_ENABLE_PARAMOUNT) || defined (VARIANT_S_FTR_ENABLE_HUL6)

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#include "vds_err_FunctionIDs.h"

#include "vds_err_basemessages.h"

// Class vds_tclErrMsg0
vds_tclErrMsg0::vds_tclErrMsg0 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode)
{
	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
	}
}

vds_tclErrMsg0::vds_tclErrMsg0 (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg0( poBaseMessage )
{
}
// Class vds_tclErrMsgBool
vds_tclErrMsgBool::vds_tclErrMsgBool (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tBool bValue)
{
	if ( bAllocateMessage() )
	{
		vInitServiceData ( u16Source, u16Target,	// Source, Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,		// StreamType
			0,										// StreamCounter
			0,										// RegisterID
			0,										// nCmdCounter, 
			0,										// nServiceID, 
			u16FunctionID,							// nFunctionID, 
			u8OpCode,								// OpCode
			0										// Asynchronous Completion Token (ACT)
			);
		vSetData1( bValue );
	}
}

vds_tclErrMsgBool::vds_tclErrMsgBool (amt_tclBaseMessage *poBaseMessage)
  :  amt_tclServiceDataMsg1<tBool>( poBaseMessage )
{
}
	
//vds_tclErrorInvalidOdometerGet
vds_tclErrorInvalidOdometerGet::vds_tclErrorInvalidOdometerGet (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_INVAL_ODOM, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclErrorInvalidOdometerGet::vds_tclErrorInvalidOdometerGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorInvalidOdometerUpReg
vds_tclErrorInvalidOdometerUpReg::vds_tclErrorInvalidOdometerUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_INVAL_ODOM, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclErrorInvalidOdometerUpReg::vds_tclErrorInvalidOdometerUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorInvalidOdometerRelUpReg
vds_tclErrorInvalidOdometerRelUpReg::vds_tclErrorInvalidOdometerRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_INVAL_ODOM, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclErrorInvalidOdometerRelUpReg::vds_tclErrorInvalidOdometerRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorInvalidOdometerStatus
vds_tclErrorInvalidOdometerStatus::vds_tclErrorInvalidOdometerStatus (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclErrMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_ERR_INVAL_ODOM, AMT_C_U8_CCAMSG_OPCODE_STATUS, bValue){}
vds_tclErrorInvalidOdometerStatus::vds_tclErrorInvalidOdometerStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsgBool (poBaseMessage){}

//vds_tclErrorGpsAntennaBreakGet
vds_tclErrorGpsAntennaBreakGet::vds_tclErrorGpsAntennaBreakGet (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_BREAK, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclErrorGpsAntennaBreakGet::vds_tclErrorGpsAntennaBreakGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGpsAntennaBreakUpReg
vds_tclErrorGpsAntennaBreakUpReg::vds_tclErrorGpsAntennaBreakUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_BREAK, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclErrorGpsAntennaBreakUpReg::vds_tclErrorGpsAntennaBreakUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGpsAntennaBreakRelUpReg
vds_tclErrorGpsAntennaBreakRelUpReg::vds_tclErrorGpsAntennaBreakRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_BREAK, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclErrorGpsAntennaBreakRelUpReg::vds_tclErrorGpsAntennaBreakRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGpsAntennaBreakStatus
vds_tclErrorGpsAntennaBreakStatus::vds_tclErrorGpsAntennaBreakStatus (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclErrMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_BREAK, AMT_C_U8_CCAMSG_OPCODE_STATUS, bValue){}
vds_tclErrorGpsAntennaBreakStatus::vds_tclErrorGpsAntennaBreakStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsgBool (poBaseMessage){}

//vds_tclErrorGpsAntennaShortGet
vds_tclErrorGpsAntennaShortGet::vds_tclErrorGpsAntennaShortGet (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_SHORT, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclErrorGpsAntennaShortGet::vds_tclErrorGpsAntennaShortGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGpsAntennaShortUpReg
vds_tclErrorGpsAntennaShortUpReg::vds_tclErrorGpsAntennaShortUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_SHORT, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclErrorGpsAntennaShortUpReg::vds_tclErrorGpsAntennaShortUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGpsAntennaShortRelUpReg
vds_tclErrorGpsAntennaShortRelUpReg::vds_tclErrorGpsAntennaShortRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_SHORT, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclErrorGpsAntennaShortRelUpReg::vds_tclErrorGpsAntennaShortRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGpsAntennaShortStatus
vds_tclErrorGpsAntennaShortStatus::vds_tclErrorGpsAntennaShortStatus (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclErrMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GPS_ANT_SHORT, AMT_C_U8_CCAMSG_OPCODE_STATUS, bValue){}
vds_tclErrorGpsAntennaShortStatus::vds_tclErrorGpsAntennaShortStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsgBool (poBaseMessage){}

//vds_tclErrorGyroExtensivTestGet
vds_tclErrorGyroExtensivTestGet::vds_tclErrorGyroExtensivTestGet (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GYRO_EXT_TEST, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclErrorGyroExtensivTestGet::vds_tclErrorGyroExtensivTestGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGyroExtensivTestUpReg
vds_tclErrorGyroExtensivTestUpReg::vds_tclErrorGyroExtensivTestUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GYRO_EXT_TEST, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclErrorGyroExtensivTestUpReg::vds_tclErrorGyroExtensivTestUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGyroExtensivTestRelUpReg
vds_tclErrorGyroExtensivTestRelUpReg::vds_tclErrorGyroExtensivTestRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GYRO_EXT_TEST, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclErrorGyroExtensivTestRelUpReg::vds_tclErrorGyroExtensivTestRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorGyroExtensivTestStatus
vds_tclErrorGyroExtensivTestStatus::vds_tclErrorGyroExtensivTestStatus (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclErrMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_ERR_GYRO_EXT_TEST, AMT_C_U8_CCAMSG_OPCODE_STATUS, bValue){}
vds_tclErrorGyroExtensivTestStatus::vds_tclErrorGyroExtensivTestStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsgBool (poBaseMessage){}

//vds_tclErrorOdometerNoInfoGet
vds_tclErrorOdometerNoInfoGet::vds_tclErrorOdometerNoInfoGet (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_NOINFO, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclErrorOdometerNoInfoGet::vds_tclErrorOdometerNoInfoGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorOdometerNoInfoUpReg
vds_tclErrorOdometerNoInfoUpReg::vds_tclErrorOdometerNoInfoUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_NOINFO, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclErrorOdometerNoInfoUpReg::vds_tclErrorOdometerNoInfoUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorOdometerNoInfoRelUpReg
vds_tclErrorOdometerNoInfoRelUpReg::vds_tclErrorOdometerNoInfoRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_NOINFO, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclErrorOdometerNoInfoRelUpReg::vds_tclErrorOdometerNoInfoRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorOdometerNoInfoStatus
vds_tclErrorOdometerNoInfoStatus::vds_tclErrorOdometerNoInfoStatus (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclErrMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_NOINFO, AMT_C_U8_CCAMSG_OPCODE_STATUS, bValue){}
vds_tclErrorOdometerNoInfoStatus::vds_tclErrorOdometerNoInfoStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsgBool (poBaseMessage){}

//vds_tclErrorOdometerErrorGet
vds_tclErrorOdometerErrorGet::vds_tclErrorOdometerErrorGet (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_ERROR, AMT_C_U8_CCAMSG_OPCODE_GET){}
vds_tclErrorOdometerErrorGet::vds_tclErrorOdometerErrorGet (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorOdometerErrorUpReg
vds_tclErrorOdometerErrorUpReg::vds_tclErrorOdometerErrorUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_ERROR, AMT_C_U8_CCAMSG_OPCODE_UPREG){}
vds_tclErrorOdometerErrorUpReg::vds_tclErrorOdometerErrorUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorOdometerErrorRelUpReg
vds_tclErrorOdometerErrorRelUpReg::vds_tclErrorOdometerErrorRelUpReg (tU16 u16Source, tU16 u16Target)
	:vds_tclErrMsg0 (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_ERROR, AMT_C_U8_CCAMSG_OPCODE_RELUPREG){}
vds_tclErrorOdometerErrorRelUpReg::vds_tclErrorOdometerErrorRelUpReg (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsg0 (poBaseMessage){}
//vds_tclErrorOdometerErrorStatus
vds_tclErrorOdometerErrorStatus::vds_tclErrorOdometerErrorStatus (tU16 u16Source, tU16 u16Target, tBool bValue)
	:vds_tclErrMsgBool (u16Source, u16Target, VDS_C_U16_FKTID_ERR_ODOM_ERROR, AMT_C_U8_CCAMSG_OPCODE_STATUS, bValue){}
vds_tclErrorOdometerErrorStatus::vds_tclErrorOdometerErrorStatus (amt_tclBaseMessage *poBaseMessage)
	:vds_tclErrMsgBool (poBaseMessage){}
	
#endif // VARIANT_S_FTR_ENABLE_FORDTPEX
