/*!
 * \file vds_types.h
 */


#ifndef VDS_TYPES_H_INCLUDE
#define VDS_TYPES_H_INCLUDE

/*!
 * \brief timemode
 *
 * should be the same as tenType in sensor_fi_tcl_e8_timeMode but more handy
 */
typedef enum
{
   enTimeModeDefault = 0UL,
   enTimeModeAuto    = 1UL,
   enTimeModeManual  = 2UL,
   enTimeModeInvalid = 254UL
} vds_tenTimeMode;

/*!
 * \brief  flags of tclGpsThread, used to enable or disable different features.
 *         update this enum if new flags are added.
 */
typedef enum
{
   enbFlushGnssBuf          = 0UL,
   enbInformVdsServiceAvail = 1UL
}vds_tenGpsThreadFlags;

/*If any new sensory devices adds in vds_types.h, please
 *increse the value for below mentioned macro
 */
#define VDS_C_U32_ACTIVE_SENSORS 7

#define VDS_C_U32_SENSOR_GPS              1
#define VDS_C_U32_SENSOR_GYRO             2
#define VDS_C_U32_SENSOR_ODO              4
#define VDS_C_U32_SENSOR_ABS              8
#define VDS_C_U32_SENSOR_ODO_FAKE        16
#define VDS_C_U32_SENSOR_ACC             32
#define VDS_C_U32_SENSOR_GNSS_FEATURE    64


/*!
 * \brief Global system information
 *
 * This structure is available to all components of VD Sensor.  It
 * contains general information about the system configuration.  The
 * data fields describe values which never change (that is, do not
 * change over time, but may be different in two different systems) or
 * default values for values which can change.  E.g. the gyro value
 * range will never change in any one device, but is different between
 * Arion and Tuareg based systems.
 *
 * The rationale behind it is to collect all system specific settings
 * in one place and make the rest of VD Sensor access them through
 * this data structure.  Only the initialization will be system
 * dependent.
 */
typedef struct
{
   /*!
    * \brief General system information
    */
   struct
   {

      /*!
       * \brief Bit field indicating available sensor types.
       *
       * The bits of this field are defined by the VDS_C_U32_SENSOR_*
       * constants.
       */
      tU32 u32SensorTypes;

   } rSystem;

   /*!
    * \brief Gyro information
    */
   struct
   {
      /*!
       * \brief Number of gyro samples to read in one go.
       *
       * This is the number of gyro samples the gyro thread requests
       * from the gyro device driver in one read request.  It
       * determines the time granularity of the gyro data processing.
       */
      tU16 u16BlockSize;
      sensor_fi_tcl_3dGyroHwInfo r3dGyroHWInfo;
   } rGyro;

   /*!
   * \brief Accelerometer information
   */
   struct
   {
      /*!
       * \brief Number of Acc samples to read in one go.
       *
       * This is the number of Acc samples the Acc thread requests
       * from the Acc device driver in one read request.  It
       * determines the time granularity of the Acc data processing.
       */
      tU16 u16BlockSize;
      /*!
       * \brief hardware info of the ACC
       */
      sensor_fi_tcl_3dAccHwInfo r3dAccHWInfo;
   }rAcc;
} vds_trSystemInformation;


#endif /*VDS_TYPES_H_INCLUDE*/
