/************************************************************************
 * FILE:         vds_trace.h
 * PROJECT:      VASCO
 * SW-COMPONENT: VDSensor
 *----------------------------------------------------------------------
 * DESCRIPTION:  prototypes to handle traces
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2002 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      |   Modification                         | Author
 * 20.09.02  |   Initial revision                     | CM-DI/ESA1-Fischer
 * 28.08.09  | New Trace function vTraceMsgReadableVal| RBEI/ECF1-Sainath K.
 *           | has been added                         |
 * 08.09.09  |   Trace levels have been modified      | RBEI/ECF1-Sainath K.
 * 30.09.09  |   Added doxygen headers for all        | RBEI/ECF1-Sainath K.
 *           |   classes/funcs                        |
 *************************************************************************/

#ifndef vds_trace_h
#define vds_trace_h 1


//-- defines for trace-levels
#define VDS_C_TRACELEVEL_FATAL             TR_tenTraceLevel(0)
#define VDS_C_TRACELEVEL_ERROR             TR_tenTraceLevel(1)
#define VDS_C_TRACELEVEL_SYSTEM_MIN        TR_tenTraceLevel(2)
#define VDS_C_TRACELEVEL_SYSTEM            TR_tenTraceLevel(3)
#define VDS_C_TRACELEVEL_COMPONENT         TR_tenTraceLevel(4)
#define VDS_C_TRACELEVEL_STATE_TRANSITION  TR_tenTraceLevel(5)
#define VDS_C_TRACELEVEL_EVENT             TR_tenTraceLevel(6)
#define VDS_C_TRACELEVEL_MESSAGE           TR_tenTraceLevel(7)
#define VDS_C_TRACELEVEL_DATA              TR_tenTraceLevel(8)
//-- turn on/off unimportant msgs
#define  VDS_S_TRACE_COMPONENT

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//  brief
//   Opens the Trace Device
//
//  return
//   Returns the status regarding the Opening of Trace Device\n
//   Success code in case of success is:
//      TRUE : Success\n
//   Error code in case of failure are:\n
//      FALSE : Failed
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tBool bOpenTraceDevice( OSAL_tIODescriptor *pTrace );

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
// brief
//    Close the Trace Device
//
// return
//    None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tVoid vCloseTraceDevice( OSAL_tIODescriptor *pTrace );

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
// brief
//    Write trace message to trace device
//
// return
//    None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tVoid vTraceMsg( TR_tenTraceLevel enTraceLevel, const tChar *pcFormatString, ... );

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
// brief
//    Write trace message to error memory
//
// return
//    None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tVoid vWriteToErrorMemory( const tChar *pcBuffer, tU32 u32NumOfBytes );

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//  brief
//   This Function frames a TTFis buffer based on the sensor type.\n
//   This buffer contains the names of active sensor devices.
// 
//  return
//    None
//  HISTORY:
// Date         |  Author                | MODIFICATION
// ----------------------------------------------------------------------------
// 28.08.2009   | sak9kor (RBEI/ECF1)    | XML generated FI has been adapted
//                                         instead manual generated FI
//******************************************************************************
tVoid vTraceMsgReadableVal( TR_tenTraceLevel enTraceLevel, const tChar *pcFormatString, tU32 u32NumofBytes );

//***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//  brief
//   Sanity check for gyro data.
// 
//   If the sanity check fails, an error memory entry is made.
// 
//  return
//    None
//  HISTORY:
// Date         |  Author                | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
void vGyroDataSanityCheck( tS32 s32Pass, const vds_trGyroData *prGyroData, tU32 u32Elems );


// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
// brief
//  Sanity check for odometer data.
//
//  If the sanity check fails, an error memory entry is made.
//
// return
//   None
//  HISTORY:
// Date         |  Author                | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
void vOdoDataSanityCheck( tS32 s32Pass, const vds_trOdometerData *prOdoData, tU32 u32Elems );

#endif


