#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_ERRMEM_DEF
#include "system_pif.h"

#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_ERRORCODES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_SERVICEINFO
#include "sensor_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fi_msgfw_if.h"

#define SENSOR_S_IMPORT_INTERFACE_SERVER
#include "vds2_if.h"

#define VDS_S_IMPORT_INTERFACE_SUBSCRIBER_MANAGER
#define VDS_S_IMPORT_INTERFACE_MESSAGE_INTERFACES
#define VDS_S_IMPORT_INTERFACE_PERSISTENT_DATA
#define VDS_S_IMPORT_INTERFACE_SENSOR_DATATYPES
#define VDS_S_IMPORT_INTERFACE_TRACE
#include "vds_internal_if.h"

#include "vds_tclSimpleThread.h"
#include "vds_tclAbsThread.h"

extern void vGetTimeStamp( tPU32 pu32TimeStamp );
vds_tclMsgAbsIf *vds_tclMsgAbsIf::poThisInstance = OSAL_NULL;

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Reques permission to send CCA message
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tBool vds_tclAbsProperty::bMaySend()
{
   return true;
}

//!  \brief  Listener class for ABS. Gets notified of Synchronisation events.
class vds_tclAbsSynchListener : public vds_tclSynchListenerIf
{
   private:
      vds_tclMsgAbsIf *poAbsIf;
   public:
      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!    Default Constructor
      //!
      //! \return
      //!   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      vds_tclAbsSynchListener( vds_tclMsgAbsIf *poAbsIfArg )
      {
         poAbsIf = poAbsIfArg;
      }

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!    Synchronises the ABS Interface, and prepares a CCA message with ABS data
      //!
      //! \return
      //!   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      virtual void vSynch( void )
      {
         vTraceMsg( VDS_C_TRACELEVEL_EVENT, "Synch (ABS)" );

         if ( poAbsIf != OSAL_NULL )
         {
            poAbsIf->vSynch( );
         }
      }
};

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Default Constructor
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
vds_tclMsgAbsIf::vds_tclMsgAbsIf() :
      oCS( "VDS_SEM_ABS" ),
      oAbsData( VDS_C_U16_FKTID_ABSDATA, oCS, this ),
      s32InternalState( VDS_C_S32_STATE_UNINITIALIZED ),
      poAbsThread( OSAL_NULL ),
      pfs32SendSubscriberMessage( OSAL_NULL )
{
   poThisInstance = this;
   poAbsSynchListener = new vds_tclAbsSynchListener( this );
   vds_goSensorPropertySynchManager.bAddListener( poAbsSynchListener );
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Default destructor
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
vds_tclMsgAbsIf::~vds_tclMsgAbsIf()
{
   delete poAbsThread; 
   poAbsThread = NULL;
   delete poAbsSynchListener;
   poAbsSynchListener = NULL;
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Initializes members of this class
//!
//! \return
//!   Incase of Success
//!   -  \c  VDS_E_NOERROR - Success.
//!   Incase of Failure
//!   -  \c  VDS_E_ALLOC_ERROR - Error in allocating the Ring Buffer.
//!   -  \c  VDS_E_INVALID_PARAMETER - Error because the Function pointer is NULL
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tS32 vds_tclMsgAbsIf::s32Init
(
   //!  (I) Function pointer to Send Subscriber Message Parameters
   tS32( *pfs32SendSubscriberMessageParam )( amt_tclServiceData *, tclSubscriberManager * )
)
{
   pfs32SendSubscriberMessage = pfs32SendSubscriberMessageParam;
   tU32 u32AbsCycleTime ;
   tU32 u32RingBufferSize;

   //Create resources(semaphore) to manage critical sections.
   if ( !oCS.bInit() )
   {
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:couldn't create Semaphore.");
      return VDS_E_ALLOC_ERROR;
   }

   poAbsThread = poMakeAbsThread( s32AddAbsDataWrapper );

   if ( poAbsThread == OSAL_NULL )
   {
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:couldn't create ABS thread.");
      return VDS_E_ALLOC_ERROR;
   }

   u32AbsCycleTime = poAbsThread->u32GetSensorCycleTime();
   if(u32AbsCycleTime != 0)
   {

      u32RingBufferSize = ( tU32 )( VDS_C_U32_BUFFERSIZE_SECONDS *
                                      ( 1000000000.0 /( tF64 ) u32AbsCycleTime ) );

      vTraceMsg( VDS_C_TRACELEVEL_EVENT,"AbsIf:ABS u32RingBufferSize = %d",u32RingBufferSize );
   }
   else 
   {
      vTraceMsg( VDS_C_TRACELEVEL_FATAL,
                             "AbsIf:s32Init:VDS_E_ALLOC_ERROR :Invalid Abs cycle time .");
      return VDS_E_ALLOC_ERROR;
   }
   if ( VDS_E_ALLOC_ERROR == oAbsData.s32Init( u32RingBufferSize, pfs32SendSubscriberMessage ))
   {
       vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:couldn't create ring buffer.");
       return VDS_E_ALLOC_ERROR;
   }

   return VDS_E_NO_ERROR;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Start the thread for ABS Interface class
//!
//! \return
//!   Success code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_GYROIF_THREADSTART_ERROR : ABS Interface Start Error
//!   - \c VDS_E_GYROIF_NOT_INITIALIZED   : ABS Interface object uninitialized
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 vds_tclMsgAbsIf::s32StartThread()
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // start ABS thread
   if ( NULL != poAbsThread )
   {
      if ( VDS_C_S32_THREAD_RUNNING != poAbsThread->s32ThreadStart() )
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR, "AbsIf: couldn't start AbsThread" );
         s32RetVal = VDS_E_GYROIF_THREADSTART_ERROR;
      }
   }
   else
      s32RetVal = VDS_E_GYROIF_NOT_INITIALIZED;

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Stops the thread for ABS Interface class
//!
//! \return
//!   Success code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_GYROIF_THREADSTOP_ERROR : ABS Interface Thread Stop Error
//!   - \c VDS_E_GYROIF_NOT_INITIALIZED   : ABS Interface object uninitialized
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 vds_tclMsgAbsIf::s32StopThread()
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // stop ABS thread
   if ( NULL != poAbsThread )
   {
      if ( VDS_C_S32_THREAD_INITIALIZED != poAbsThread->s32ThreadStop() )
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR, "AbsIf: couldn't stop AbsThread" );
         s32RetVal = VDS_E_GYROIF_THREADSTOP_ERROR;
      }
   }
   else
      s32RetVal = VDS_E_GYROIF_NOT_INITIALIZED;

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Stops the thread for ABS IF class and deletes the associated
//!   resources
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_GYROIF_THREADSTOP_ERROR : ABS IF Thread Stop Error
//!   - \c VDS_E_GYROIF_NOT_INITIALIZED  : ABS IF Thread object uninitialized
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//*****************************************************************************
tS32 vds_tclMsgAbsIf::s32DeleteThread()
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // delete ABS thread
   if ( NULL != poAbsThread )
   {
      if ( VDS_C_S32_THREAD_INITIALIZED != poAbsThread->s32ThreadStop() )
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR, "AbsIf: couldn't stop AbsThread" );
         s32RetVal = VDS_E_GYROIF_THREADSTOP_ERROR;
      }

      delete poAbsThread;
      poAbsThread = NULL;
   }
   else
      s32RetVal = VDS_E_GYROIF_NOT_INITIALIZED;

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Wrapper for the s32AddList() method, to hold the ABS Data
//!
//! \return
//!   Returns the actual number of elements added
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 vds_tclMsgAbsIf::s32AddAbsDataWrapper
(
   //!  (I) List of data to be added to the main list
   vds_trAbsData *prData,
   //! (I) Number of elements
   tU32 u32NData
)
{
   return poThisInstance->oAbsData.s32AddList( prData, u32NData );
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Create a CCA message and fill it with ABS data from the ring buffer.
//!
//! \return
//! The number of data elements in the CCA message (a
//! positive value or zero) or an error code (a negative value).
//!   -  \c  0                            : Success. No Error.\n
//!   -  \c  VDS_E_GYROIF_ALLOC_ERROR     : Error in Allocation of Data.\n
//!   -  \c  VDS_E_GYROIF_NOT_INITIALIZED : Uninitialized pointer.\n
//!   -  \c  VDS_E_INVALID_PARAMETER      : Invalid Parameter.\n
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 vds_tclMsgAbsIf::s32GetAbsMessage
(
   //! (I) Pointer to a variable where the CCA message object is stored.
   amt_tclServiceData **ppoServiceData,
   //! (I) Index of the next element to read.
   tU32 &rfu32NextElemToRead,
   //! (I) Target ID for the CCA message.
   tU16 u16TargetAppId,
   //! (I) Unused Variable
   tBool bSendInitMessage,
   //! (I) Unused Variable
   tBool bCreateInvalidMessage
)
{
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( bSendInitMessage );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( bCreateInvalidMessage );
   return oAbsData.s32GetMessage(
             ppoServiceData,
             rfu32NextElemToRead,
             u16TargetAppId );
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Create a CCA message and fill it with ABS data from the ring buffer.
//!
//!
//! \return
//! The number of data elements in the CCA message (a
//! positive value or zero) or an error code (a negative value).
//!   -  \c  VDS_E_NO_ERROR            : Success. No Error.\n
//!   -  \c  VDS_E_POST_MESSAGE_FAILED : Subscriber Message Posting failed.\n
//!   -  \c  VDS_E_INVALID_PARAMETER   : Invalid Parameter.\n
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//****************************************************************************
void vds_tclMsgAbsIf::vSynch ( )
{
   oAbsData.s32CheckForSubscriber( );
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Changes/Updates the Internal State with that from the argument
//!
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ---------------------------------------------------------------------------
//****************************************************************************
void vds_tclMsgAbsIf::vSetState
(
   //!  New State to be stored
   tS32 s32NewState
)
{
   s32InternalState = s32NewState;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Gets the current Internal State
//!
//!
//! \return
//!   Returns current internal state
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ---------------------------------------------------------------------------
//****************************************************************************
tS32 vds_tclMsgAbsIf::s32GetState( )
{
   return s32InternalState;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   creates ABS-status-message.
//!
//!
//! \return
//! The number of data elements in the CCA message (a
//! positive value or zero) or an error code (a negative value).
//!   -  \c  num of data in message - In case of Success\n
//!   -  \c  Error code - In case of error\n
//  HISTORY:
//    Date      |         Author      |      MODIFICATION
// ----------------------------------------------------------------------------
//  27.07.2009  | sak9kor (RBEI/ECF1) | XML generated FI has been adapted
//              |                     | instead manual generated FI
//  14.08.2009  | sak9kor (RBEI/ECF1) | u32GetTimeStamp has been changed to
//              |                     | vGetTimeStamp
//****************************************************************************
amt_tclServiceData* vds_tclAbsProperty::poCreateMessage
(
   //!  (I) AbsData
   vds_trAbsData* prData,
   //!  (I) No of elements
   tU32 u32Elems,
   //!  (I) TargetAppID required for CCA Message
   tU16 u16TargetAppId
)
{
   sensor_locationfi_tclMsgAbsDataStatus oStatus;
   oStatus.AbsData.resize( u32Elems );

   for ( tU32 u32Loop = 0; u32Loop < u32Elems; u32Loop++ )
   {
      oStatus.AbsData[u32Loop].AbsTimeStamp = prData[u32Loop].u32TimeStamp;
      oStatus.AbsData[u32Loop].WheelCounterFrontLeft =  prData[u32Loop].u16CounterFrontLeft;
      oStatus.AbsData[u32Loop].WheelCounterFrontRight = prData[u32Loop].u16CounterFrontRight;
      oStatus.AbsData[u32Loop].WheelCounterRearLeft =  prData[u32Loop].u16CounterRearLeft;
      oStatus.AbsData[u32Loop].WheelCounterRearRight = prData[u32Loop].u16CounterRearRight;
      oStatus.AbsData[u32Loop].StatusFrontLeft.enType = ( sensor_fi_tcl_e8_AbsStatus::tenType )prData[u32Loop].u8StatusFrontLeft;
      oStatus.AbsData[u32Loop].StatusFrontRight.enType = ( sensor_fi_tcl_e8_AbsStatus::tenType )prData[u32Loop].u8StatusFrontRight;
      oStatus.AbsData[u32Loop].StatusRearLeft.enType  = ( sensor_fi_tcl_e8_AbsStatus::tenType )prData[u32Loop].u8StatusRearLeft;
      oStatus.AbsData[u32Loop].StatusRearRight.enType =  ( sensor_fi_tcl_e8_AbsStatus::tenType )prData[u32Loop].u8StatusRearRight;
      oStatus.AbsData[u32Loop].DirectionFrontLeft.enType =  ( sensor_fi_tcl_e8_AbsDirection::tenType )prData[u32Loop].u8DirectionFrontLeft;
      oStatus.AbsData[u32Loop].DirectionFrontRight.enType = ( sensor_fi_tcl_e8_AbsDirection::tenType )prData[u32Loop].u8DirectionFrontRight;
      oStatus.AbsData[u32Loop].DirectionRearLeft.enType =  ( sensor_fi_tcl_e8_AbsDirection::tenType )prData[u32Loop].u8DirectionRearLeft;
      oStatus.AbsData[u32Loop].DirectionRearRight.enType =  ( sensor_fi_tcl_e8_AbsDirection::tenType )prData[u32Loop].u8DirectionRearRight;
   }

   /* Create the object of visitor message and insert the FI object*/
   fi_tclVisitorMessage* poResultMessage = OSAL_NEW fi_tclVisitorMessage( oStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

   if ( OSAL_NULL != poResultMessage )
   {
      tU32 u32TimeStamp = 0;
      vGetTimeStamp( &u32TimeStamp );

      if ( poResultMessage->bIsValid() )
      {
         // create answer-message
         poResultMessage->vInitServiceData
         (  CCA_C_U16_APP_SENSOR,               // Source
            u16TargetAppId,                     // Target
            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
            0,                                  // StreamCounter
            0,                                  // RegisterID
            0,                                  // nCmdCounter,
            CCA_C_U16_SRV_SENSOR_LOCATION,              // nServiceID,
            SENSOR_LOCATIONFI_C_U16_ABSDATA,         // nFunctionID,
            AMT_C_U8_CCAMSG_OPCODE_STATUS,      // OpCode
            0,                            // Asynchronous Completion Token (ACT)
            AMT_C_U16_DEFAULT_NULL,       // Source Sub
            AMT_C_U16_DEFAULT_NULL,       // Target Sub
            u32TimeStamp                  // TimeStamp
         );
      }
   }

   return poResultMessage;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!  Collects ABS records for "AllSensorData" property. 
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_GYROIF_NOT_INITIALIZED :if vdsensor is not initialized.
//!   - \c VDS_E_GYROIF_ALLOC_ERROR :if failed to allocate memory.
//!   - \c VDS_E_GYROIF_GETGYRODATA_FAILED: if unable to get data.
//!   - \c VDS_E_GYROIF_DATA_UNAVAILABLE:if no ABS data is available. 
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 vds_tclMsgAbsIf::s32GetAbsRecords
(
   //! (O) :cmb-fi object to copy ABS data.
   sensor_fi_tcl_AllSensorData *pCmbFiAbsData,
   //! (I) :Next element to read
   tU32 &u32NextelementToRead
)
{
   tS32 s32RetVal=VDS_E_NO_ERROR;
   static vds_trAbsData *prAbsData = OSAL_NULL;

   if ( oCS.bLocked() )
   {

      tU32 u32NumOfElemToSend = u32GetNumOfElmFrom( u32NextelementToRead );

      //Elements available ?
      if ( u32NumOfElemToSend > 0 )
      {
         prAbsData = OSAL_NEW vds_trAbsData[u32NumOfElemToSend];

         if( OSAL_NULL != prAbsData )
         {
            if ( (tS32)u32NumOfElemToSend != oAbsData.s32GetData( prAbsData,
                                                                  u32NextelementToRead,
                                                                  u32NumOfElemToSend ) )
            {
                s32RetVal = VDS_E_GYROIF_GETGYRODATA_FAILED;
                vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:AbsAllSen:Getting data failed" );
            }
         }
         else
         {
            s32RetVal = VDS_E_GYROIF_ALLOC_ERROR;
            vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:AbsAllSen:Allocation error" );
         }

         //Are there any elements to send?
         if( ( OSAL_NULL != prAbsData ) && ( s32RetVal == VDS_E_NO_ERROR ) )
         {
            //Resize memory to accommodate all the elements.
            pCmbFiAbsData->AbsUpdate.resize(u32NumOfElemToSend);

            for( tU32 u32Loop = 0; u32Loop < u32NumOfElemToSend; u32Loop++ )
            {
               //Copy values from array to list
               pCmbFiAbsData->AbsUpdate[u32Loop].AbsTimeStamp = prAbsData[u32Loop].u32TimeStamp;

               pCmbFiAbsData->AbsUpdate[u32Loop].WheelCounterFrontLeft = prAbsData[u32Loop].u16CounterFrontLeft;
               pCmbFiAbsData->AbsUpdate[u32Loop].WheelCounterFrontRight = prAbsData[u32Loop].u16CounterFrontRight;
               pCmbFiAbsData->AbsUpdate[u32Loop].WheelCounterRearLeft = prAbsData[u32Loop].u16CounterRearLeft;
               pCmbFiAbsData->AbsUpdate[u32Loop].WheelCounterRearRight = prAbsData[u32Loop].u16CounterRearRight;

               pCmbFiAbsData->AbsUpdate[u32Loop].StatusFrontLeft.enType
                            = (sensor_fi_tcl_e8_AbsStatus::tenType)prAbsData[u32Loop].u8StatusFrontLeft;
               pCmbFiAbsData->AbsUpdate[u32Loop].StatusFrontRight.enType
                            = (sensor_fi_tcl_e8_AbsStatus::tenType)prAbsData[u32Loop].u8StatusFrontRight;
               pCmbFiAbsData->AbsUpdate[u32Loop].StatusRearLeft.enType
                            = (sensor_fi_tcl_e8_AbsStatus::tenType)prAbsData[u32Loop].u8StatusRearLeft;
               pCmbFiAbsData->AbsUpdate[u32Loop].StatusRearRight.enType
                            = (sensor_fi_tcl_e8_AbsStatus::tenType)prAbsData[u32Loop].u8StatusRearRight;

               pCmbFiAbsData->AbsUpdate[u32Loop].DirectionFrontLeft.enType
                            = (sensor_fi_tcl_e8_AbsDirection::tenType)prAbsData[u32Loop].u8DirectionFrontLeft;
               pCmbFiAbsData->AbsUpdate[u32Loop].DirectionFrontRight.enType
                            = (sensor_fi_tcl_e8_AbsDirection::tenType)prAbsData[u32Loop].u8DirectionFrontRight;
               pCmbFiAbsData->AbsUpdate[u32Loop].DirectionRearLeft.enType
                            = (sensor_fi_tcl_e8_AbsDirection::tenType)prAbsData[u32Loop].u8DirectionRearLeft;
               pCmbFiAbsData->AbsUpdate[u32Loop].DirectionRearRight.enType
                            = (sensor_fi_tcl_e8_AbsDirection::tenType)prAbsData[u32Loop].u8DirectionRearRight;
            }
         }

         //(If exists)Delete temp buffer
         if ( prAbsData != OSAL_NULL)
         {
            //Delete temporary buffer
            OSAL_DELETE [] prAbsData;
            prAbsData = OSAL_NULL;
         }
      }
      else
      {
         //No elements to send
         s32RetVal = VDS_E_GYROIF_DATA_UNAVAILABLE;
         vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:AbsAllSen:Data Unavailable" );
      }
   }
   else
   {
      s32RetVal = VDS_E_GYROIF_NOT_INITIALIZED;
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:AbsAllSen:Not Initialized" );
   }

   VDS_PREVIOUSLY_ASSIGNED_VALUE_INTENTIONALLY_UNUSED(prAbsData);

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Gets the last ABS element index.
//! \return
//!  The index of last element in the buffer.
//  HISTORY:
//    Date      |         Author      |      MODIFICATION
// ----------------------------------------------------------------------------
//
//****************************************************************************      
tU32 vds_tclMsgAbsIf::u32GetLastAbsElemIndex()
{
   return ( oAbsData.u32NumOfElmInBuf() - 1);
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Tells number of elements present in the buffer starting from the
//!   requested element.
//! \return
//!  Number of elements available in the buffer from "u32FromElem" element.
//  HISTORY:
//    Date      |         Author      |      MODIFICATION
// ----------------------------------------------------------------------------
//
//**************************************************************************** 
tU32 vds_tclMsgAbsIf::u32GetNumOfElmFrom(tU32 u32FromElem)
{

   return oAbsData.u32GetNumOfElemsFrom(u32FromElem);
}

//EOF


