/*!
 * \file vds_tclCriticalSection.h
 */

/*!
 * \brief Critical section.
 *
 * This is a convenience class for all uses of critical sections in VD
 * Sensor.
 */
class vds_tclCriticalSection
{
   private:
      tCString pszName;
      OSAL_tSemHandle hSem;
      static tBool bLogging;

   public:

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //   brief
      //     Default Constructor
      //
      //   return
      //    None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      vds_tclCriticalSection ( tCString pszName );

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Initialize the critical section.
      //    This function creates the semaphore that is used to implement
      //    the critical section.
      //
      // return
      //   True if Semaphore creation was successful, else False.
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      tBool bInit();

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      // brief
      //   Free system resources allocated in bInit().
      //
      // return
      //   True if Semaphore closing and deletion was successful, else False.
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      tBool bShutdown();

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Enter the critical section.
      //
      // return
      //   true if the critical section was entered; false if it
      //   was not entered (this is normally a serious error and should
      //   never happen).
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      tBool bEnter();

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Leave the critical section.
      //
      // return
      //   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      void vLeave();

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Check if the critical section is locked.
      //
      // return
      //   true if the semphore is locked, else false in all other cases
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      tBool bLocked();
};

/*!
 * \brief The master lock for VD Sensor.
 *
 * Whenever a thread wishes to enter more than one critical section at
 * once, this must be the first one to be entered.
 */
extern vds_tclCriticalSection vds_goMasterLock;

