#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#include "sensor_fi_if.h"

#define VDS_S_IMPORT_INTERFACE_MESSAGE_INTERFACES
#define VDS_S_IMPORT_INTERFACE_SENSOR_DEFINES
#define VDS_S_IMPORT_INTERFACE_TRACE
#include "vds_internal_if.h"

tBool vds_tclCriticalSection::bLogging = false;

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Default Constructor
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
vds_tclCriticalSection::vds_tclCriticalSection
(
   //! (I) Semaphore Name
   tCString pszNameParam
) :   pszName( pszNameParam ),
      hSem( OSAL_C_INVALID_HANDLE )
{
   if ( bLogging )
   {
      vTraceMsg(
         VDS_C_TRACELEVEL_DATA,
         "CS(%s): create", pszName );
   }
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Initialize the critical section.
//!    This function creates the semaphore that is used to implement
//!    the critical section.
//!
//! \return
//!   True if Semaphore creation was successful, else False.
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tBool vds_tclCriticalSection::bInit()
{
   if ( OSAL_ERROR == OSAL_s32SemaphoreCreate( pszName, &hSem, 1 ) )
   {
      if ( bLogging )
      {
         vTraceMsg(
            VDS_C_TRACELEVEL_ERROR,
            "CS(%s): init error", pszName );
      }

      return false;
   }
   else
   {
      if ( bLogging )
      {
         vTraceMsg(
            VDS_C_TRACELEVEL_DATA,
            "CS(%s): init", pszName );
      }

      return true;
   }
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Free system resources allocated in bInit().
//!
//! \return
//!   True if Semaphore closing and deletion was successful, else False.
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tBool vds_tclCriticalSection::bShutdown()
{
   if ( OSAL_C_INVALID_HANDLE != hSem )
   {
      OSAL_s32SemaphoreClose( hSem );
      OSAL_s32SemaphoreDelete( pszName );
      hSem = OSAL_C_INVALID_HANDLE;

      if ( bLogging )
      {
         vTraceMsg(
            VDS_C_TRACELEVEL_DATA,
            "CS(%s): shutdown", pszName );
      }

      return true;
   }
   else
      return false;
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Enter the critical section.
//!
//! \return
//!   true if the critical section was entered; false if it
//!   was not entered (this is normally a serious error and should
//!   never happen).
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tBool vds_tclCriticalSection::bEnter()
{
   tBool bEntered = false;

   if ( hSem != OSAL_C_INVALID_HANDLE )
   {
      if ( OSAL_ERROR != OSAL_s32SemaphoreWait(
               hSem, OSAL_C_TIMEOUT_FOREVER ) )
      {
         if ( bLogging )
         {
            vTraceMsg(
               VDS_C_TRACELEVEL_DATA,
               "CS(%s): locked, thread %08x", pszName, OSAL_ThreadWhoAmI() );
         }

         bEntered = true;
      }
   }

   return bEntered;
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Leave the critical section.
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
void vds_tclCriticalSection::vLeave()
{
   if ( hSem != OSAL_C_INVALID_HANDLE )
   {
      if ( bLogging )
      {
         vTraceMsg(
            VDS_C_TRACELEVEL_DATA,
            "CS(%s): unlocking, thread %08x", pszName, OSAL_ThreadWhoAmI() );
      }

      OSAL_s32SemaphorePost( hSem );
   }
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Check if the critical section is locked.
//!
//! \return
//!   true if the semphore is locked, else false in all other cases
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tBool vds_tclCriticalSection::bLocked()
{
   tS32 s32SemValue;

   if ( hSem != OSAL_C_INVALID_HANDLE )
   {
      if ( OSAL_OK == OSAL_s32SemaphoreGetValue( hSem, &s32SemValue ) )
      {
         if ( bLogging )
         {
            vTraceMsg(
               VDS_C_TRACELEVEL_DATA,
               "CS(%s): checking, semaphore value = %d", pszName, s32SemValue );
         }

         return s32SemValue <= 0;
      }
      else
         return false;
   }
   else
      return false;
}

vds_tclCriticalSection vds_goMasterLock( "VDS_MSTR" );

