#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#include "sensor_fi_if.h"

#define ABS_SENSOR_DEFAULT_CYCLE_TIME_IN_NS 50000000
#define VDS_S_IMPORT_INTERFACE_SENSOR_THREADS
#define VDS_S_IMPORT_INTERFACE_SENSOR_DEFINES
#define VDS_S_IMPORT_INTERFACE_TRACE
#include "vds_internal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC // CCA_C_U16_APP_SENSOR
#include "cca_if.h"
#define SCD_S_IMPORT_INTERFACE_GENERIC // scd_s32GetThreadConfiguration
#include "scd_if.h"

#include "regkeys.h"    // THREADNAME_C_STRING_SENSOR_VDS_ODO


#include "vds_tclSimpleThread.h"
//#include "osal_if_abs.h"
#include "vds_tclAbsThread.h"

void vAbsTraceList
(
   //! (I) ABS Data
   const OSAL_trAbsData *parData,
   //! (I) Number of elements
   tU32 u32NData
);

// class vds_tclDummyAbsSource : public vds_tclDataSourceIf<OSAL_trAbsData>
// {
// private:
//    tU32 u32SeqNo;

// public:
//    virtual tBool bInit()
//    {
//       u32SeqNo = 0;
//       return true;
//    }

//    virtual tBool bShutdown()
//    {
//       return true;
//    }

//    virtual tS32 s32GetData(OSAL_trAbsData *parData, tU32 u32MaxElems)
//    {
//       int i;
//       OSAL_trAbsData rData;

//       OSAL_pvMemorySet( &rData, 0, sizeof( rData ) );
//       for( i = 0 ; i < u32MaxElems ; ++i )
//       {
//          OSAL_s32ThreadWait( 100 );
//          parData[i]                      = rData;
//          parData[i].u32TimeStamp         = u32SeqNo*100;
//          parData[i].u32CounterFrontLeft  = u32SeqNo*100 + 1;
//          parData[i].u32CounterFrontRight = u32SeqNo*100 + 2;
//          parData[i].u32CounterRearLeft   = u32SeqNo*100 + 3;
//          parData[i].u32CounterRearRight  = u32SeqNo*100 + 4;

//          ++u32SeqNo;
//       }
//       return i;
//    }

//    virtual tU32 u32CycleTime()
//    {
//       return 100000000;
//    }
// };

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Send contents of the ABS buffer into the trace channel
//!
//! \return
//!   Number of elements in buffer
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
void vAbsTraceList
(
   //! (I) ABS Data
   const OSAL_trAbsData *parData,
   //! (I) Number of elements
   tU32 u32NData
)
{
   for ( tU32 i = 0 ; i < u32NData ; ++i )
   {
      vTraceMsg( VDS_C_TRACELEVEL_DATA,
                 "ABS: ts = %d, cfl = %d, cfr = %d, crl = %d, crr = %d,"
                               "sfl,sfr,srl,srr(%d,%d,%d,%d)"
                               "dfl,dfr,drl,drr(%d,%d,%d,%d)",
                 parData[i].u32TimeStamp,
                 parData[i].u32CounterFrontLeft,
                 parData[i].u32CounterFrontRight,
                 parData[i].u32CounterRearLeft,
                 parData[i].u32CounterRearRight,
                 parData[i].u8StatusFrontLeft,
                 parData[i].u8StatusFrontRight,
                 parData[i].u8StatusRearLeft,
                 parData[i].u8StatusRearRight,
                 parData[i].u8DirectionFrontLeft,
                 parData[i].u8DirectionFrontRight,
                 parData[i].u8DirectionRearLeft,
                 parData[i].u8DirectionRearRight);
   }
}


//! \brief  Interface for ABS sensor data source.
class vds_tclAbsSource : public vds_tclDataSourceIf<OSAL_trAbsData>
{
   private:
      OSAL_tIODescriptor hAbs;

   public:
      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Default Destructor
      //!
      //! \return
      //!   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      virtual ~vds_tclAbsSource( ) {}

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Pure Virtual Function. Used for initializing/opening the device
      //!
      //! \return
      //!   Success code in case of success is:
      //!   - \c  true : Success\n
      //!   Error code in case of failure are:\n
      //!   - \c false : Error in intializing the device
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      virtual tBool bInit()
      {
         if ( OSAL_ERROR != ( hAbs = OSAL_IOOpen( "/dev/abs", OSAL_EN_READONLY ) ) )
         {
            return true;
         }
         else
         {
            vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsThread:couldn't Open ABS proxy.");
            return false;
         }
      }

      // ***************** F U N C T I O N  H E A D E R ***************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Pure Virtual Function. Used for closing the device
      //!
      //! \return
      //!   Success code in case of success is:
      //!   - \c  true : Success\n
      //!   Error code in case of failure are:\n
      //!   - \c false : Error in closing the device
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // --------------------------------------------------------------------------
      //***************************************************************************
      virtual tBool bShutdown()
      {
         if ( hAbs != OSAL_ERROR )
         {
            OSAL_s32IOClose( hAbs );
         }

         return true;
      }

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Pure Virtual Function. Used for Reading data from the device.
      //!
      //! \return
      //!   Number of elements read.
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      virtual tS32 s32GetData
      (
         //! (O) Buffer to store the read data
         OSAL_trAbsData *parData,
         //! (I) Maximum Elements to read
         tU32 u32MaxElems
      )
      {
         tS32 s32OsalReturn;

         if ( hAbs == OSAL_ERROR )
         {
            return 0;
         }

         s32OsalReturn = OSAL_s32IORead( hAbs, ( tPS8 )parData, u32MaxElems * (tU32) sizeof( OSAL_trAbsData ) );
         if ( s32OsalReturn > 0 )
         {
            tU32 u32Elems = ( ( tU32 )s32OsalReturn ) / (tU32) sizeof( OSAL_trAbsData );
            vAbsTraceList( parData, u32Elems );
            return (tS32)u32Elems;
         }
         else
         {
            vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:IORead failed with error %u",OSAL_u32ErrorCode());
            return 0;
         }
      }

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Pure Virtual Function. Returns the Cycle time
      //!
      //! \return
      //!   Returns a single constant, which is the cycle time
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      virtual tU32 u32GetCycleTime()
      {
      
         tU32 u32AbsCycleTime = 0;  
         
         if ( hAbs == OSAL_ERROR )
         {
            u32AbsCycleTime = ABS_SENSOR_DEFAULT_CYCLE_TIME_IN_NS;
            vTraceMsg( VDS_C_TRACELEVEL_FATAL,"AbsThread: IO descriptor ERROR , used ABS sensor default cycle time - %d.",u32AbsCycleTime);       
         }
         
         //PQM_authorized_multi_549 ,PQM_authorized_multi_548
         if( ( OSAL_ERROR != OSAL_s32IOControl( hAbs, OSAL_C_S32_IOCTRL_ABS_GET_SAMPLING_INTERVAL,
                                                      (tLong)&u32AbsCycleTime )) &&( u32AbsCycleTime != 0))//lint !e774  !e845 */
         { 
            vTraceMsg( VDS_C_TRACELEVEL_DATA,"AbsThread: Abs sensor cycle time - %d.",u32AbsCycleTime);            
         }
         else
         {
            u32AbsCycleTime=ABS_SENSOR_DEFAULT_CYCLE_TIME_IN_NS;//assigning the default value as 50000000 NS 
            vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsThread: Abs get sampling interval IOCTRL failed , used default cycle time - %d.",u32AbsCycleTime);      
         }       
        
         return u32AbsCycleTime;
      }
         
      
};

vds_tclDataSourceIf<OSAL_trAbsData> *poMakeAbsSource()
{
   //return new vds_tclDummyAbsSource;
   return new vds_tclAbsSource;
}


//! \brief  Convert an OSAL data type to an internal VD Sensor datatype.
class vds_tclDummyAbsConverter :
      public vds_tclDataConverterIf<vds_trAbsData, OSAL_trAbsData>
{
   public:

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Default destructor
      //!
      //! \return
      //!   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      virtual ~vds_tclDummyAbsConverter( ) {}

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Converts the OSAL ABS Data  to the VDS ABS data
      //!
      //! \return
      //!   Success code in case of success is:
      //!   - \c  true : Success\n
      //!   Error code in case of failure are:\n
      //!   - \c false : Error in conversion.
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      virtual tBool bConvert
      (
         //! (O) Destination Buffer
         vds_trAbsData *poTo,
         //! (I) Source Buffer
         OSAL_trAbsData *poFrom
      )
      {
         if ( poTo != OSAL_NULL && poFrom != OSAL_NULL )
         {
            poTo->u32TimeStamp          = poFrom->u32TimeStamp;
            poTo->u16CounterFrontLeft   = ( tU16 ) poFrom->u32CounterFrontLeft;
            poTo->u16CounterFrontRight  = ( tU16 ) poFrom->u32CounterFrontRight;
            poTo->u16CounterRearLeft    = ( tU16 ) poFrom->u32CounterRearLeft;
            poTo->u16CounterRearRight   = ( tU16 ) poFrom->u32CounterRearRight;
            poTo->u8StatusFrontLeft     = poFrom->u8StatusFrontLeft;
            poTo->u8StatusFrontRight    = poFrom->u8StatusFrontRight;
            poTo->u8StatusRearLeft      = poFrom->u8StatusRearLeft;
            poTo->u8StatusRearRight     = poFrom->u8StatusRearRight;
            poTo->u8DirectionFrontLeft  = poFrom->u8DirectionFrontLeft;
            poTo->u8DirectionFrontRight = poFrom->u8DirectionFrontRight;
            poTo->u8DirectionRearLeft   = poFrom->u8DirectionRearLeft;
            poTo->u8DirectionRearRight  = poFrom->u8DirectionRearRight;
            return true;
         }
         else
         {
            return false;
         }
      }
};

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!   Returns a reference to a newly created object of vds_tclDummyAbsConverter.
//!
//! \return
//!   Returns a reference to a newly created object of vds_tclDummyAbsConverter.
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
vds_tclDataConverterIf<vds_trAbsData, OSAL_trAbsData> *poMakeAbsConverter()
{
   return new vds_tclDummyAbsConverter;
}

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!   Creates a thread to add ABS data into the ring buffer
//!
//! \return
//!   Returns a reference thread handle if successful. Else, NULL pointer.
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
tclSensorThread* poMakeAbsThread
(
   //! (I) function for the ThreadInit() operation, that
   //!  does the adding of ABS data to the list
   tS32 ( *pfs32AddList )( vds_trAbsData *parData, tU32 u32NData )
)
{
   vds_tclSimpleThread<vds_trAbsData, OSAL_trAbsData> *poThread;
   vds_tclDataSourceIf<OSAL_trAbsData> *poSource;
   vds_tclDataConverterIf<vds_trAbsData, OSAL_trAbsData> *poConverter;

   if ( ( poSource = poMakeAbsSource() ) == OSAL_NULL )
   {
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:couldn't create ABS source.");
      return OSAL_NULL;
   }

   //Converter is a class which copies data from OSAL to vds specific structure.
   try
   {
      poConverter = poMakeAbsConverter();
   }
   catch(std::bad_alloc& ba)
   {
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AbsIf:couldn't create ABS Converter.");
      vTraceMsg( VDS_C_TRACELEVEL_FATAL,"AbsIf:exception bad_alloc caught:%s",ba.what());
      delete poSource;
      return OSAL_NULL;
   }

   try
   {
      poThread = new vds_tclSimpleThread<vds_trAbsData, OSAL_trAbsData>();
   }
   catch(std::bad_alloc& ba)
   {
      vTraceMsg( VDS_C_TRACELEVEL_FATAL,"AbsIf:exception bad_alloc caught:%s",ba.what());
      delete poSource;
      delete poConverter;
      return OSAL_NULL;
   }

   if( VDS_E_NO_ERROR != (poThread->s32ThreadInit(
         const_cast<tString>(THREADNAME_C_STRING_SENSOR_VDS_ABS),
         pfs32AddList,
         poSource,
         poConverter )) )
         {
            vTraceMsg( VDS_C_TRACELEVEL_FATAL,"AbsIf:Thread Initialization Failed.");
            delete poSource;
            delete poThread;
            delete poConverter;
            return OSAL_NULL;
         }
   return poThread;
}
