#include<iostream>

// template class definition for starting and stopping CCA applications
template <class CCA_Class> CCA_Class *pCreateCcaApp(CCA_Class *, const char *, int);
#define CCA_CREATE_APP(CCA_ClassName, poCCA_Class, ccaId) ( pCreateCcaApp<CCA_ClassName>(poCCA_Class, #CCA_ClassName, ccaId))
template <class CCA_Class> CCA_Class *vDestroyCcaApp(CCA_Class *, const char *);
#define CCA_DESTROY_APP(CCA_ClassName, poCCA_Class) (vDestroyCcaApp<CCA_ClassName>(poCCA_Class, #CCA_ClassName))

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

//#include <new>
#define SPM_S_IMPORT_INTERFACE_GENERIC
#include "spm_if.h"




#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"


#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#include "sensor_fi_if.h"

#define SENSOR_S_IMPORT_INTERFACE_SENSOR_MESSAGE
#include "vds2_if.h"

#define SENSOR_S_IMPORT_INTERFACE_AIL
#include "vds2_if.h"
static tclAilVDSensor* poVDSensor = NULL;

#ifdef VARIANT_S_FTR_ENABLE_BPSTL
extern tBool exh_bInitExceptionHandling(tVoid);
#endif

#define EVENT_SHUTDOWN_NAME "SHUTDOWN_VDSENSOR"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"



// #ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS
// extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[])
// #else
// extern "C" OSAL_DECL tS32 OSAL_s32Boot(tS32 cPar, tString aPar[]) 
// #endif

extern "C" OSAL_DECL tS32 main(tS32 cPar, tString aPar[]) 
{
  tBool bRetVal = OSAL_OK;
  tBool bCreateAppFlag = TRUE;
  OSAL_tEventHandle  hEvShutdown = 0;
  OSAL_tEventMask    hEvRequest  = 0x00000001;

  (tVoid)aPar;  //Lint
  (tVoid)cPar;  //Lint
  et_vTraceOpen();
  et_vTraceBuffer(TR_TTFIS_SYSMANAGER, TR_LEVEL_DATA, 9, "START VD-Sensor ");
  scd_init();

  if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
  {
    //ETG_TRACE_ERR(("tclAilVDSensor: Creation of SPM shutdown event failed!!!"));
    NORMAL_M_ASSERT_ALWAYS();
  }

  try
  {
     poVDSensor = CCA_CREATE_APP(tclAilVDSensor, poVDSensor, CCA_C_U16_APP_SENSOR);
  }
  catch(std::bad_alloc& ba)
  {
     std::cout<<"exception bad_alloc caught: "<<ba.what()<<'\n';
     bCreateAppFlag = FALSE;
     bRetVal = OSAL_ERROR;
  }

  if(TRUE == bCreateAppFlag)
  {
     // Wait for Shutdown-Signal
     if(OSAL_OK != OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest))
     {
        bRetVal = OSAL_ERROR;
     }
     CCA_DESTROY_APP(tclAilVDSensor, poVDSensor);
  }
  printf("\nVD-sensor: Exiting...\n");
  OSAL_s32EventClose(hEvShutdown);
  OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
  et_vTraceClose();
  return bRetVal?OSAL_OK:OSAL_ERROR;
}

// template calsses for creating and destroying a CCA Service
template <class CCA_Class> 
CCA_Class *pCreateCcaApp(CCA_Class *poCcsApp, const char *pCCA_ClassName, int iCcaId)
{
	if (poCcsApp == NULL)
	{
		//ET_TRACE_INFO1(TR_CLASS_CCABR, (tChar*)"%s: create application", pCCA_ClassName);
		(tVoid)pCCA_ClassName;    //Lint
		poCcsApp = new CCA_Class();
		if (poCcsApp != NULL)
		{
			if ( !poCcsApp->bInitInstance( 0, iCcaId))
			{
				//ET_TRACE_ERROR1(TR_CLASS_CCABR, (tChar*)"%s: init failed", pCCA_ClassName);
			} 
			else 
			{
				//ET_TRACE_INFO2(TR_CLASS_CCABR, (tChar*)"%s: create application for ccaId=0x%x", pCCA_ClassName, iCcaId);
			}
		}
		else
		{
			//ET_TRACE_ERROR1(TR_CLASS_CCABR, (tChar*)"%s: construction failed", pCCA_ClassName);
		}
	}
	else
	{
		//ET_TRACE_INFO1(TR_CLASS_CCABR, (tChar*)"%s: already initialized.", pCCA_ClassName);
	}

	return poCcsApp; 
}

template <class CCA_Class> 
CCA_Class *vDestroyCcaApp(CCA_Class *poCcsApp, const char *pCCA_ClassName)
{
	//ET_TRACE_INFO1(TR_CLASS_CCABR, (tChar*)"%s: delete", pCCA_ClassName);
	(tVoid)pCCA_ClassName;  //Lint
	if(poCcsApp != NULL)
	{
		poCcsApp->vDeinitInstance();

		delete poCcsApp;
	}

	return NULL; 
}
