#ifndef VDS_DEFINES_H_INCLUDE
#define VDS_DEFINES_H_INCLUDE

#define VARIANT_S_FTR_DISABLE_DIAGLOG
#define VARIANT_S_FTR_DISABLE_DIAGNOSIS
#define VARIANT_S_FTR_DISABLE_ODOCALIBRATIONCHECK

/*
 * Currently there is no need of low voltage handling 
 * since low voltage is being handled in Autosar.
 */
#if 0
#define VDS_S_ENABLE_LOW_VOLTAGE_HANDLING
#endif

// error-values
#define VDS_E_NO_ERROR             0
#define VDS_E_INVALID_PARAMETER   -1
#define VDS_E_POST_MESSAGE_FAILED -2
#define VDS_E_ALLOC_ERROR         -3
#define VDS_E_NOT_INITIALIZED     -4

// interface-states
#define VDS_C_S32_STATE_UNINITIALIZED   (tS32)0
// normal interface available (e.g. app.state NORMAL)
#define VDS_C_S32_STATE_NORMAL          (tS32)1

// normal and diagnostic interface available (=app.state DIAGNOSIS):
#define VDS_C_S32_STATE_NORMAL_DIAG       (tS32)2
// all interfaces pending:
#define VDS_C_S32_STATE_PENDING           (tS32)3

// sensor-thread
#define VDS_C_U32_SENSORTHREAD_WAITTIME      (tU32)2000
//#define VDS_C_U32_BUFFERSIZE_SECONDS         (tU32)10
#define VDS_C_U32_BUFFERSIZE_SECONDS         (tU32)30

// gyro-thread
#define VDS_C_U16_GYROTHREAD_BLOCKREADSIZE	 (tU16)1
#define VDS_C_U16_ACCTHREAD_BLOCKREADSIZE     (tU16)1

// odometer-thread
#ifdef VARIANT_S_FTR_ODOMETER_VIA_CAN
        // We support two different odometer types (OvL/OvC).
        // Depending on this we must set different block sizes and cycle times,
        // as each odometer device provides its data in different cycle periods:
        // OVL: 16Hz (~62,5ms cycle time), 4 values per block => block rate 4/16s
        // OVC: 300ms cycle time, 1 value per block => blockrate 0.3s

// Note: OvC constant below must NOT exceed OvL constant,
//       as the latter is used for buffer dimensioning!
#define VDS_C_U16_ODOMTHREAD_BLOCKREADSIZE_OVC  ((tU16)2)    // OvC
#define VDS_C_U16_ODOMTHREAD_BLOCKREADSIZE      ((tU16)4)    // OvL

#else   // VARIANT_S_FTR_ENABLE_FORDTPEX
#define VDS_C_U16_ODOMTHREAD_BLOCKREADSIZE  (tU16)6
#endif


#define VDS_C_U32_REPORTMEM_GYRO_INVALID_TIME   (tU32)30000 /* set error after 30s with invalid gyro-output */

// DI_IRC_GPS_RECEIVER
#define VDS_C_U32_GPS_INVALID_TIMEDIFF          (tU32)60000 /* set error after 60s with no received gps-telegram */

#define VDS_C_F64_DEFAULT_CLOCKRATE               (tDouble)16.0
// *** persistent data ***

#if 0
#define VDS_C_U32_PERSISTENT_MAGIC_NUMBER          (tU32)0x40534456
#define VDS_C_U32_PERSISTENT_POSCALC_PARAMS     (tU32)1
#define VDS_C_U32_PERSISTENT_GPSCOMM_PROTOCOLS  (tU32)2

#define VDS_C_U32_PERSISTENT_CONTENT_ODOMETER   (tU32)1
#define VDS_C_U32_PERSISTENT_CONTENT_GYRO          (tU32)2
#define VDS_C_U32_PERSISTENT_CONTENT_GPS           (tU32)3

// 2007-09-21 oej2hi: Add persistent pulses and circumference from CAN
// for 0 km calibration, bump major version to 2
#define VDS_C_U32_PERSISTENT_ODOMETER_MAJOR_VERSION (tU32)2
#define VDS_C_U32_PERSISTENT_ODOMETER_MINOR_VERSION (tU32)0

#define VDS_C_U32_PERSISTENT_GYRO_MAJOR_VERSION     (tU32)1
// 2003-01-23 Fr: Minor-Version incremented, added gyro-adc-bit-range
#define VDS_C_U32_PERSISTENT_GYRO_MINOR_VERSION     (tU32)1

#define VDS_C_U32_PERSISTENT_GPS_MAJOR_VERSION      (tU32)1
#define VDS_C_U32_PERSISTENT_GPS_MINOR_VERSION      (tU32)0
#endif

// maxsize of the persistent gps data in bytes
#define VDS_C_U32_PERSISTENT_GPS_MAX_SIZE (tU32) 40000 

// Existing GPS events
#define VDS_GPS_EVENT_NOEVENT  0
#define VDS_GPS_EVENT_RESTART  1
#define VDS_GPS_EVENT_START    2
#define VDS_GPS_EVENT_STOP     3
#define VDS_GPS_EVENT_SEND_OSAL_TIME_UPDATE  4
#define VDS_GPS_EVENT_FRONT_END_TEST 5
#define VDS_GPS_EVENT_FACTORY_SETTINGS 6


// Existing CVM events
#define VDS_CVM_EVENT_NOEVENT  0
#define VDS_CVM_EVENT_START    1
#define VDS_CVM_EVENT_STOP     2

// ToDo!!! 1s?
#define VDS_C_S32_GPS_TIMEOUT          (tS32)1000

// errors
#define VDS_E_GPSTHREAD_NOT_INITIALIZED            -1
#define VDS_E_GPSTHREAD_STORAGE_ERROR           -2
#define VDS_E_GPSTHREAD_IOCTRL_ERROR            -3

#define VDS_E_GPSTHREAD_ALLOC_ERROR             -4
#define VDS_E_GPSTHREAD_COMMPORT_ERROR          -5
#define VDS_E_GPSTHREAD_UNKNOWN_PROTOCOL        -6
#define VDS_E_GPSTHREAD_DEVICE_NOT_FOUND        -7
#define VDS_E_GPSTHREAD_SEM_ERROR               -8
#define VDS_E_GPSTHREAD_THREADCREATE_FAILED        -9
#define VDS_E_GPSTHREAD_NOT_UNINITIALIZED       -10
#define VDS_E_GPSTHREAD_PERSISTENT_GET_ERROR    -11
#define VDS_E_GPSTHREAD_PERSISTENT_SET_ERROR    -12
#define VDS_E_GPSTHREAD_PERSISTENT_UNINITIALIZED   -13
#define VDS_E_GPSTHREAD_NO_DEFAULT_TABLE        -14
#define VDS_E_GPSTHREAD_RECEIVER_UNKNOWN        -15
#define VDS_E_GPSTHREAD_UNINITIALIZED           -16

/*!
 * \brief Event mask for the state "GPS receiver is on"
 */
#define VDS_C_GPSTHREAD_EV_ON  1
/*!
 * \brief Event mask for the state "GPS receiver is off"
 */
#define VDS_C_GPSTHREAD_EV_OFF 2

// GPS Definitions:

#define PI       (OSAL_C_DOUBLE_PI)
#define DEG2RAD  (PI/180.)
#define RAD2DEG  (180./PI)

#define B_FIXTYPE_TIME        1
#define B_FIXTYPE_2D          2
#define B_FIXTYPE_3D          4
#define B_FIXTYPE_1SVFIX      8
#define B_FIXTYPE_2SVFIX      16
#define B_FIXTYPE_COLDSTART   128


#define VDS_PREVIOUSLY_ASSIGNED_VALUE_INTENTIONALLY_UNUSED(x) (void)(x);

#endif /*VDS_DEFINES_H_INCLUDE*/
