/*!
 * \file tclPersistentData.h
 */

// *****************************************************************************
// * FILE:         tclPersistentDataAccess.h
// * SW_COMPONENT: VD-Sensor
// * DESCRIPTION:  class-declaration: handles access to persistent-data
// * AUTHOR:       CM-DI/ESA1-Fischer
// * COPYRIGHT:    (c) 2002 Blaupunkt GmbH
// * HISTORY:
// * 20.03.02 Rev. 1.0 CM-DI/ESA1-Fischer
// *          Initial Revision.
// *****************************************************************************

#ifndef tclPersistentData_h
#define tclPersistentData_h 1

#define VDS_C_S32_PERSISTENTDATA_UNINITIALIZED  (tS32)0
#define VDS_C_S32_PERSISTENTDATA_INITIALIZED    (tS32)1

#define VDS_C_U32_INVALID_CHECKSUM        (tU32)0xFFFFFFFF

#define VDS_C_STRING_CONFIG_DIR_NAME      "Configuration"
#define VDS_C_STRING_NAVI_DIR_NAME        "Navi"
#define VDS_C_STRING_VDSENSOR_DIR_NAME    "vdsensor"

#define VDS_C_STRING_VDSENSOR_PATH_NAME   OSAL_C_STRING_DEVICE_FFS "/" \
                                             VDS_C_STRING_VDSENSOR_DIR_NAME

#define VDS_C_STRING_GPS_CFG_FILE_NAME    "/gpsdata.bin"
#define VDS_C_STRING_GYRO_CFG_FILE_NAME   "/gyrodata.bin"
#define VDS_C_STRING_ODOM_CFG_FILE_NAME   "/odomdata.bin"

// errors
#define VDS_E_PERSISTENT_SEM_ERROR        -1
#define VDS_E_PERSISTENT_UNINITIALIZED    -2
#define VDS_E_PERSISTENT_DATA_UNAVAILABLE -3
#define VDS_E_PERSISTENT_FILE_WRITE_ERROR -4
#define VDS_E_PERSISTENT_ALLOC_ERROR      -5
#define VDS_E_PERSISTENT_DATA_INVALID     -6
#define VDS_E_PERSISTENT_FILE_ERROR       -7
#define VDS_E_PERSISTENT_FILEWRITE_ERROR  -8
#define VDS_E_PERSISTENT_FILECREATE_ERROR -9
#define VDS_E_PERSISTENT_FILEREAD_ERROR   -10
#define VDS_E_PERSISTENT_FILEOPEN_ERROR   -11
#define VDS_E_PERSISTENT_FILECLOSE_ERROR  -12

/*!
 * \brief Wrapper class around the global system information
 *
 * All information VD Sensor needs about the system it is running on
 * should be encapsulated here.
 */
class tclSystemInformation
{
   public:
      /*!
       * \brief Information about the system VD Sensor is running on.
       *
       * The data fields of this structure can be read by all parts of VD
       * Sensor.  They should only be set by member functions of
       * tclSystemInformation.
       */
      static vds_trSystemInformation rInfo;

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //     Initialize system information
      //
      //     This function has to be called before any attempts are made to
      //     access rInfo.
      //
      //     Some fields may be invalid even after vInit(), e.g. the gyro
      //     information is dependent on the gyro type, which is unknown
      //     until the gyro device is opened.
      //
      //  return
      //    None
      //
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      static void vInit( void );

};

#endif
