// *****************************************************************************
// * FILE:         tclMsgGyroIf.h
// * SW_COMPONENT: VD-Sensor
// * DESCRIPTION:  class-declaration: handles access to gyro-data,
// *               handles subscriber-messages
// * AUTHOR:       CM-DI/ESA1-Fischer
// * COPYRIGHT:    (c) 2002 Blaupunkt GmbH
// * HISTORY:
// * 20.03.02 Rev. 1.0 CM-DI/ESA1-Fischer
// *          Initial Revision.
//  * 07.07.09 - sak9kor - APIs "s32GetGyroScalefactorMessage","s32GetGyroErrorMessage", and
//  *                      "s32GetGyroMessage" have been modified to
//  *                      to adopt the XML generated FI
//  * 10.08.09 - sak9kor - New parameter poSubscriber has been added
//  *                      in to 's32GetGyroScalefactorMessage',"s32GetGyroErrorMessage"
//  *                      "s32GetGyroMessage" functions
//  * 11.09.09 RBEI/ECF1 - sak9kor - Comments generated by Rational Rose have been removed
//  * 30.09.09 - sak9kor - Added doxygen headers for all classes/funcs
// *****************************************************************************

#ifndef tclMsgGyroIf_h
#define tclMsgGyroIf_h 1

#define VDS_C_U32_GYROIF_RINGBUFFERSIZE     (tU32)160
#define VDS_C_S32_GYROIF_UNINITIALIZED      (tS32)0
#define VDS_C_S32_GYROIF_NORMAL             (tS32)1
#define VDS_C_S32_GYROIF_PENDING            (tS32)2

// errors
#define VDS_E_GYROIF_ALLOC_ERROR             -1
#define VDS_E_GYROIF_THREADINIT_ERROR        -2
#define VDS_E_GYROIF_SEM_ERROR               -3
#define VDS_E_GYROIF_THREADSTART_ERROR       -4
#define VDS_E_GYROIF_NOT_INITIALIZED         -5
#define VDS_E_GYROIF_THREADSTOP_ERROR        -6
#define VDS_E_GYROIF_GETGYRODATA_FAILED      -7
#define VDS_E_GYROIF_SETGYROMSG_FAILED       -8
#define VDS_E_GYROIF_SUBSCRIBER_ERROR        -9
#define VDS_E_GYROIF_VALUE_UNSET             -10
#define VDS_E_GYROIF_GET_GYRO_OFFSET_FAILED  -11
#define VDS_E_GYROIF_GET_GYRO_SCALE_FAILED   -12
#define VDS_E_GYROIF_DATA_UNAVAILABLE        -13
#define VDS_E_GYROIF_TEMPERATURE_UNAVAILABLE -14
#define VDS_E_GYROIF_UNKNOWN_ERROR           -99

/*!
* \brief Defines the interface for Gyro Message.
*/
class tclMsgGyroIf
{

   public:
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //   Default constructor
      //  Parameters: None
      //  return
      //   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tclMsgGyroIf();
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    Default Destructor
      //  Parameters : None
      //  return
      //    None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      virtual ~tclMsgGyroIf();
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    initializes gyro-interface create and initialize instance of gyro-thread,
      //    create semaphore, create ringbuffer for gyro-data, initialize
      //    member-attributes
      //  PARAMETERS:
      //      tS32(*pfs32SendSubscriberMessage)( amt_tclServiceData *, tclSubscriberManager * ))
      //        - pointer to function, which sends given answer message with given
      //          parameters to subscribers
      //  return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_GYROIF_ALLOC_ERROR : Gyro interface allocation error
      //      VDS_E_GYROIF_SEM_ERROR :  Gyro sempahore error
      //      VDS_E_GYROIF_THREADINIT_ERROR : Gyro interface thread interface error
      //      VDS_E_INVALID_PARAMETER : Invalid parameter
      //  return
      //    None
      //  HISTORY:
      // Date         |  Author                | MODIFICATION
      // ----------------------------------------------------------------------------
      //  21.03.02       CM-DI/ESA1-Fischer     Initial Revision
      //  17.04.02       CM-DI/ESA1-Fischer     parameter changed
      //******************************************************************************
      tS32 s32Init ( 
         tS32( *pfs32SendSubscriberMessage )( amt_tclServiceData *, tclSubscriberManager * ) );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    start gyro-thread
      //  PARAMETERS: None
      //  return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_GYROIF_THREADSTART_ERROR : Thread start error
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //  21.03.02         CM-DI/ESA1-Fischer               Initial Revision
      //******************************************************************************
      tS32 s32StartThread ();

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //   stop gyro-thread
      //  Parameters: None
      //  return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //      VDS_E_GYROIF_THREADSTOP_ERROR : Thread stop error
      //      VDS_E_GYROIF_NOT_INITIALIZED : Gyro interface not initialized
      //  HISTORY:
      // Date            |  Author              | MODIFICATION
      // ----------------------------------------------------------------------------
      //  21.03.02        CM-DI/ESA1-Fischer       Initial Revision.
      //******************************************************************************
      tS32 s32StopThread ();

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //   delete gyro-thread
      //  Parameters : None
      //  return
      //    Succes code in case of success is:
      //       VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //       VDS_E_GYROIF_THREADSTOP_ERROR : Thread stop error
      //       VDS_E_GYROIF_NOT_INITIALIZED : Gyro interface not initialized
      //  HISTORY:
      // Date          |  Author                | MODIFICATION
      // ----------------------------------------------------------------------------
      //  21.03.02       CM-DI/ESA1-Fischer       Initial Revision.
      //******************************************************************************
      tS32 s32DeleteThread ();

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    set internal state (normal or pending)
      //  PARAMETER:
      //       tS32 s32NewState: (I)
      //            new state (VDS_C_S32_GYROIF_NORMAL
      //            or VDS_C_S32_GYROIF_PENDING
      //
      //  return
      //   None
      //  HISTORY:
      // Date            |  Author                    | MODIFICATION
      // ----------------------------------------------------------------------------
      //  28.05.02         CM-DI/ESA1-Fischer            Initial Revision.
      //******************************************************************************
      tVoid vSetState ( tS32 s32NewState );

      tS32 s32Add3dGyroData ( sensor_fi_tcl_3dGyroData *pr3dGyroData );
      tS32 s32Add3dGyroList ( const sensor_fi_tcl_3dGyroData *pr3dGyroData, tU32 u32NumOfData );
      static tS32 s32Add3dDataWrapper ( const sensor_fi_tcl_3dGyroData *pr3dGyroData, 
                                        tU32 u32NumOfData );
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    Prepares s32GetGyroTemperatureMessage-status-message.
      //  return
      //     Succes code in case of success is:
      //   - \c  OSAL_OK : Success\n
      //   Error code in case of failure are:\n
      //   - \c VDS_E_INVALID_PARAMETER : Invalid parameter
      //   - \c VDS_E_GYROIF_TEMPERATURE_UNAVAILABLE : Gyro temeperature not available
      //   - \c VDS_E_GYROIF_ALLOC_ERROR : Allocation error
      //   - \c VDS_E_GYROIF_NOT_INITIALIZED : Gyro interface not initialized
      //   - \c VDS_E_INVALID_PARAMETER : Invalid parameter
      //  HISTORY:
      // Date        |  Author             | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32GetGyroTemperatureMessage ( amt_tclServiceData const *poRequestMessage,
                                         tclSubscriberManager *poSubscriber,
                                         amt_tclServiceData **ppoResponseMessage );	  
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    creates gyro-status-message.
      //  PARAMETER:
      //               amt_tclServiceData **ppoServiceData: (->O)
      //                  pointer to created message
      //               tU16 u16TargetAppId: (I)
      //                  target-application-id
      //  return
      //                 [0..n] : num of data in message
      //                  error: VDS_E_INVALID_PARAMETER,
      //                         VDS_E_GYROIF_ALLOC_ERROR,
      //                         VDS_E_GYROIF_GETGYRODATA_FAILED,
      //                         VDS_E_GYROIF_SETGYROMSG_FAILED
      //  HISTORY:
      // Date            |  Author                 | MODIFICATION
      // ----------------------------------------------------------------------------
      //   03.03.03        CM-DI/ESA1-Fischer         Initial Revision.
      //******************************************************************************
      tS32 s32GetGyroInitMessage ( amt_tclServiceData **ppoServiceData, 
                                   tU16 u16TargetAppId );


      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    creates gyro-status-message.
      //  Parameters:
      //      amt_tclServiceData const *poRequestMessage - pointer to service data
      //      tclSubscriberManager *poSubscriber - pointer to subscriber data
      //      amt_tclServiceData **ppoServiceData - pointer to a location where a pointer
      //      to the reply message is available
      //      vds_trGyroData *prGyroData - pointer to Gyro data
      //      tU32 u32NumOfData - : Number of data
      //      tU32 &rfu32NextElemToRead - number of element that has to be read the next time
      //      tBool - TRUE: init-message, FALSE: update-message
      //      tBool bCreateInvalidMessage - TRUE: create message with state=invalid
      //  return
      //    Succes code in case of success is:
      //    - Number of elements created\n
      //    Error code in case of failure are:\n
      //      VDS_E_GYROIF_GETGYRODATA_FAILED : Get gyro data failed
      //      VDS_E_GYROIF_ALLOC_ERROR : Allocation error
      //      VDS_E_GYROIF_DATA_UNAVAILABLE : Data unavailable
      //      VDS_E_GYROIF_NOT_INITIALIZED : Data unavailable
      //      VDS_E_INVALID_PARAMETER : Invalid parameter
      //  HISTORY:
      // Date       |  Author               | MODIFICATION
      // ----------------------------------------------------------------------------
      // 21.05.02   | CM-DI/ESA1-Fischer    | Initial Revision.
      // 03-07-09   | sak9kor (RBEI/ECF1)   | Interface has been modified.
      //                                    | New parameter *poRequestMessage has been added and
      //                                    | old parameter u16TargetAppId has been removed.
      // 10.08.2009 | sak9kor (RBEI/ECF1)   | New parameter poSubscriber has been added
      //******************************************************************************
      tS32 s32Get3dGyroMessage ( amt_tclServiceData const *poRequestMessage, 
                                 tclSubscriberManager *poSubscriber, 
                                 amt_tclServiceData **ppoServiceData, 
                                 sensor_fi_tcl_3dGyroData *pr3dGyroData, 
                                 tU32 u32NumOfData, 
                                 tU32 &rfu32NextElemToRead, 
                                 tBool bSendInitMessage, 
                                 tBool bCreateInvalidMessage = FALSE );


      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    returns a list of gyro-datas from ringbuffer.the number of the element
      //    from where to be read could be determined from rfu32NextElemToRead.
      //    if the number is smaller than the ones in the list, the oldest datas
      //    will be returned, if the number is bigger than the ones in the list,
      //    no data is returned. rfu32NextElemToRead will be set to
      //    the number of the last returned data-set + 1.
      //  PARAMETER:
      //     vds_trGyroData *prGyroData: (->O)
      //       storage for gyro-list
      //     tU32 &rfu32NextElemToRead: (->IO)
      //       number of element that has to be read the next time
      //     tU32 u32ElemsToRead: (I)
      //       number of elements to be read
      //  return
      //    Elements copied in case of success
      //    Error code in case of failure are:\n
      //      VDS_E_GYROIF_NOT_INITIALIZED : Gyro interface not initialized
      //      VDS_E_INVALID_PARAMETER : Invalid parameter
      //  HISTORY:
      // Date            |  Author                 | MODIFICATION
      // ----------------------------------------------------------------------------
      //  21.03.02         CM-DI/ESA1-Fischer        Initial Revision.
      //******************************************************************************

      tS32 s32Get3dGyroData ( sensor_fi_tcl_3dGyroData *prGyroData, 
                              tU32 &rfu32NextElemToRead, 
                              tU32 u32ElemsToRead );



      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   returns number of gyro-data-sets in ring-buffer.
      //!   the number of available data-sets in the ringbuffer
      //!   is returned (since u32NextElemToRead to
      //!   the newest data-set)
      //! \return
      //!   number of elements available
      //  HISTORY:
      // Date            |  Author             | MODIFICATION
      // ----------------------------------------------------------------------------
      //  21.03.02        CM-DI/ESA1-Fischer     Initial Revision.
      //******************************************************************************
      tU32 u32GetNumOfElem
      (
         //! (I) : number of element that has to be read the next time
         tU32 u32NextElemToRead
      );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    check for subscribers and send message. the actual list of gyro-data is given,
      //    so we normally don't need to create a temporary storage for the answer-message.
      //  PARAMETER:
      //               vds_trGyroData *prGyroData: (->I)
      //                  received list of gyro-data
      //               tU32 u32NumOfData: (I)
      //                  num of gyro-data in list
      //  return
      //    Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //     VDS_E_GYROIF_UNKNOWN_ERROR :   Unknown error
      //     VDS_E_POST_MESSAGE_FAILED :  Message posting failed
      //  HISTORY:
      // Date       |  Author               | MODIFICATION
      // ----------------------------------------------------------------------------
      // 21.03.02   | CM-DI/ESA1-Fischer    | Initial Revision.
      //******************************************************************************

      tS32 s32CheckFor3dGyroSubscriber ( sensor_fi_tcl_3dGyroData *pr3dGyroData, 
                                         tU32 u32NumOfData );

      tU32 u32CheckForGyroTemperature(tVoid);

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    Set Application state
      //  Parameters : None
      //  return
      //    None
      //  HISTORY:
      // Date         |  Author              | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tVoid vSetAppState( tU32 u32AppState );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    Performs the synch operation
      //  Parameters : None
      //  return
      //    None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      void vSynch( void );

      vds_tclCriticalSection oCS;
      
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!  Collects Gyro records for "AllSensorData" property and updates in cmb fi object. 
      //! \return
      //!   Succes code in case of success is:
      //!   - \c  VDS_E_NO_ERROR : Success\n
      //!   Error code in case of failure are:\n
      //!   - \c VDS_E_GYROIF_NOT_INITIALIZED :if vdsensor is not initialized.
      //!   - \c VDS_E_GYROIF_ALLOC_ERROR :if failed to allocate memory.
      //!   - \c VDS_E_GYROIF_GETGYRODATA_FAILED: if unable to get data.
      //!   - \c VDS_E_GYROIF_DATA_UNAVAILABLE:if no ABS data is available. 
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************      
      tS32 s32GetGyroRecords( sensor_fi_tcl_AllSensorData *pCmbFiGnssData,
                              tU32 &NextelementToRead
      );
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //   brief
      //   Gets the index of last element in the buffer.
      //   return
      //    The index of last element in the buffer.
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //****************************************************************************
     tU32 u32GetLastGyroElemIndex(tVoid);
     // ***************** F U N C T I O N  H E A D E R *****************************
     //! \brief
     //!       Start Gyro self test.
     //! \return
     //!   - \c TRUE  : Self test finished successfully.
     //!   - \c FALSE : Unable to start self test.
     //  HISTORY:
     // Date            |  Author                       | MODIFICATION
     // ----------------------------------------------------------------------------
     //******************************************************************************
     tBool bStartSelftest(tS32 *ps32SelfTestResult);
   private:
      // Data Members for Class Attributes
      tclGyroThread *poGyroThread;
      tS32(*pfs32SendSubscriberMessage)( amt_tclServiceData *, tclSubscriberManager * );
      //tU16 u16GyroFrequency;
      vds_tclRingBuffer<sensor_fi_tcl_3dGyroData> oRingBuffer3d;
      static tclMsgGyroIf *poThisMsgGyroIf;
      tS32 s32InternalState;
      tU32 u32NextTimeToSend;
};

#endif

