/*
* RootDaemonServer.h
*
* The RootDaemonServer class is the server side implementation of the root daemon responsible for waiting for command execution requests, running commands as root and 
* sending results back to the clients
*
*  Created on: Oct 27, 2014
*      Author: Mohamed Mostafa
*/

#ifndef _ROOT_DAEMON_SERVER_H_
#define _ROOT_DAEMON_SERVER_H_

using namespace std;

#include "RootDaemonTypes.h"
#include <string>
#include <map>
#include <vector>

const char * SHARED_LIB_PATH = "/opt/bosch/security/lib/";
const char * ROOTD_SERVER = "RootDaemonServer";
vector<string> allowed_libs_vec =
{
    "libbtsettings_rootdaemon_client_so.so",
    "libfc_internetapplications_rootdaemon_client_so.so",
    "libwup_rootdaemon_client_so.so",
    "libhmi_rootdaemon_client-gm_so.so",
    "libfc_il_rootdaemon_client-gm_so.so",
    "libsaal_rootdaemon_client_so.so",
    "libfc_spm_rootdaemon_client_so.so",
    "libfc_connectrootdaemonclient_so.so",
    "libfcota_rootdaemon_so.so",
    "libfc_engineeringmode_rootdaemon_client_so.so",
    "libbtsettings_rootdaemon_client-qt5_so.so",
    "libcea_rootdaemonclient_so.so",
    "libwifi_rootdaemon_client_so.so",
    "libmediaplayer_rootdaemon_client_so.so",      //[GMP] Mediaplayer generic full bosch
    "libmultimediaplayer_rootdaemon_client_so.so", //[MMP] Mediaplayer using cinemo
    "libsxmaudiorootdaemonclient_so.so",
    "libdevicemanager_rootdaemon_client_so.so",
    "libmediaengine_rootdaemon_client_so.so",
    "libhmibase_rootdaemon_client_so.so",
	"libextnav_rootdaemon_client_so.so",
	"libsecurityrootdaemonclient_so.so"
};

typedef CmdData (*commandPtr_t)(const int, string);//function pointer to command execution function
typedef const char * (*getNamePtr_t)();

typedef struct
{
	void * lib_handle;
	commandPtr_t cmd_func_ptr;
	int command_pipe_fd;
	int result_pipe_fd;
	int user_id;
	int group_id;
	string cmd_fifo_path;
	string result_fifo_path;

}client_lib_handles_t;

typedef struct
{
	int command_num;
	string command_args;
	commandPtr_t cmd_func_ptr;
	int res_pipe_fd;
}cmd_thread_params_t;

//This class is implemented as singleton
class RootDaemonServer
{
public:
	static RootDaemonServer& getInstance()
	{
		static RootDaemonServer	instance;  //Lazily Instantiated on first use. Guaranteed to be destroyed
		return instance;
	}
	
	static void start();
	static void stop();
	
private:
	RootDaemonServer() {}; 
	RootDaemonServer(RootDaemonServer const&); // Don't Implement (prevents using copy constructors)
	void operator=(RootDaemonServer const&);   // Don't implement (prevent using assignment operators)
	
	static void* thread_callback(void *thread_args);
	
	static int loadClientSharedLibs();
	static int createClientServerPipe(const string & pipePath, const int uid, const int gid, int flags);
	static int waitForCommands();
	static void releaseLibHandlesMap();
    static uid_t getUidByName(const char *userName);
    static uid_t getGidByName(const char *groupName);

	
	static int isStarted;
	static map<int, client_lib_handles_t> * pipeCommandMap_ptr;
};

#endif //#ifndef _ROOT_DAEMON_SERVER_H_
 
