/*
 * IClientSharedlib.h
 *
 *  This file declares a list of non-member methods that has to be implemented by each root daemon client
 * 	These functions should be compiled as a shared library with the extern "C" linkage specification to be loadable from the root daemon server side
 *
 *  Created on: Oct 24, 2014
 *      Author: Mohamed Mostafa
 */
 
#ifndef _I_CLIENT_SHAREDLIB_H_
#define _I_CLIENT_SHAREDLIB_H_

#include <RootDaemonTypes.h>
#include <string>
#include <unistd.h>
#include <sys/types.h>
#include <RootDaemonHelper.h>

#ifdef __cplusplus
extern "C"
{
#endif
	/**
		return root daemon client name
	*/
	const char * getClientName();
	/**
		return root daemon client process group id
	*/
	const char * getClientGroupName();
	/**
		return root daemon client process user id
	*/
	const char * getClientUserName();
	/**
		implementation of the command to be executed by the root daemon
		ex. should have a different system command to execute for each command number and arguments
		should return the result of the executed command
	*/
	CmdData command(const int cmdNum, std::string args);
#ifdef __cplusplus
}
#endif

#endif //#ifndef _I_CLIENT_SHAREDLIB_H_
