/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.

History -- 0.1 (version) mpr3hi (USER)
***************************************************************************/
#include "dbus/com/bosch/NativeTestComponent.h"

namespace com {
namespace bosch {	

DLT_DECLARE_CONTEXT(NATIVE_TEST_COMPONENT);

NativeTestComponent::NativeTestComponent():
 ::asf::core::BaseComponent()
{ 
	/* register NATIVE_TEST_COMPONENT app for DLT logging */
	DLT_REGISTER_APP("NATIVE_TEST_COMPONENT","NATIVE_TEST_COMPONENT Component Registration for Logging");
	/* register NATIVE_TEST_COMPONENT context */
	DLT_REGISTER_CONTEXT(NATIVE_TEST_COMPONENT,"NATIVE_TEST_COMPONENT","NATIVE_TEST_COMPONENT context for Logging"); 		
    DEBUG_TRACE(("NativeTestComponent::NativeTestComponent Ctor"));	 
	
	execSockServer();
}

NativeTestComponent::~NativeTestComponent()
{  
	DLT_UNREGISTER_CONTEXT(NATIVE_TEST_COMPONENT);
	DLT_UNREGISTER_APP();	
}

NativeDbusService::NativeDbusService()
: NativeService1Stub(NATIVE_COMPONENT_SERV1_PORT) ,
  NativeService2Stub(NATIVE_COMPONENT_SERV2_PORT)
{		
		DEBUG_TRACE(("NativeDbusService::NativeDbusService Ctor"));	 		
}

NativeDbusService::~NativeDbusService()
{ 		
		DEBUG_TRACE(("NativeDbusService::NativeDbusService Dtor"));	 
}

void NativeDbusService::onMountNavishareRequest (const ::boost::shared_ptr< MountNavishareRequest >& request){	
	DEBUG_TRACE(("NativeDbusService::onMountNavishareRequest is invoked !!"));		
	// mount bin, mounts the NAVISHARED_SHARED_POINT to NAVISHARED_MOUNT_POINT
	system(NAVISHARED_MOUNT);
	
// Notes::
// “In this example mount/umount is executed via a small test executable with SUID bit. 
//	This test executable is not part of the standard root file system. In a real scenario mount/umount must be executed via a root-daemon.”
	
}

void NativeDbusService::onUmountNavishareRequest(const ::boost::shared_ptr< UmountNavishareRequest >& request){
	DEBUG_TRACE(("NativeDbusService::onUmountNavishareRequest is invoked !!"));
	// mount bin, umounts the NAVISHARED_MOUNT_POINT
	system(NAVISHARED_UMOUNT);
}

void NativeDbusService::onService2Method1Request(const ::boost::shared_ptr< Service2Method1Request >& request){
	DEBUG_TRACE(("NativeDbusService::onService2Method1Request is invoked !!"));		
}

void NativeTestComponent::execSockServer(){
	
	pid_t pid = fork();	
	if (pid == -1)
	{		
		DEBUG_TRACE(("NativeTestComponent::execSockServer : Fork Error"));			
		return ;
	} 
	else if (pid > 0)
	{
		int status;
		// Not wait for slave. 
		// The slave is dedicated socket server for clients in testcontainer
		// waitpid(pid, &status, 0);							
		
	}
	else 
	{
		char *argv[] = { strdup(NATIVE_SOCKET_SERVER_BIN), 0};		
		char *envp[] =
		{
			strdup(NATIVE_SOCKET_SERVER_HOME),
			strdup(NATIVE_SOCKET_SERVER_PATH),
			strdup(NATIVE_SOCKET_SERVER_USER),
			strdup(NATIVE_SOCKET_SERVER_LOG),
			NULL
		};		
		execve(argv[0], &argv[0], envp);
		DEBUG_TRACE(("NativeTestComponent::execSockServer:Exec Failure !"));						
	}	
}

}
}