#ifndef CONNMANPROXY_H_
#define CONNMANPROXY_H_

#define CONNMANPROXY_ERROR 1
#define CONNMANPROXY_USER_RESOLUTION_FAILED 1
#define CONNMANPROXY_SESSION_RESOLUTION_FAILED 2
#define CONNMANPROXY_CREDENTIALS_MISMATCH 3
#define CONNMANPROXY_NOTIFICATION_CLIENT_SETUP_FAILED 5
#define CONNMANPROXY_NOTIFICATION_CLIENT_RELEASE_FAILED 6
#define CONNMAN_BUS_NAME "net.connman"
#define CONNMANPROXY_BUS_NAME "net.connman"
#define CONNMANPROXY_SYSTEMBUS_TIMEOUT 60000
#define CONNMANPROXY_IDDBUS_TIMEOUT 25000
//TODO: this defines how long we wait for pending client answer until we remove session
#define CONNMANPROXY_CLIENT_TIMEOUT = 300

#include "ConnManProxyManager.h"
#include "ConnManProxyNotification.h"
#include "ConnManProxySession.h"
#include <dlt/dlt.h>
#include <glib.h>

#ifndef DLT_APPID_ISO_CONNMANPROXY
#define DLT_APPID_ISO_CONNMANPROXY 				"CMPR"
#endif

// DLT Macro
#define INF_TRACE(format)			_INFO_TRACE format

#define _INFO_TRACE(ctx,format,args...) do { \
    char log_buff[1024]; \
    char final_string[1024]; \
    snprintf(final_string, sizeof(final_string),"LINE:%d ", __LINE__); \
    snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string)); \
    DLT_LOG(ctx, DLT_LOG_INFO, DLT_STRING(final_string)); \
} while(0)

// DLT Macro
#define ERR_TRACE(format)			_ERR_TRACE format

#define _ERR_TRACE(ctx,format,args...) do {                            \
    char log_buff[1024];                                                \
    char final_string[1024];                                            \
    snprintf(final_string, sizeof(final_string),"LINE:%d ", __LINE__);  \
    snprintf(log_buff, sizeof(log_buff), format,##args);                \
    strncat(final_string, log_buff, sizeof(final_string));              \
    DLT_LOG(ctx, DLT_LOG_ERROR, DLT_STRING(final_string));               \
  } while(0)


// DLT Macro
#define DBG_TRACE(format)			_DEBUG_TRACE format

#define _DEBUG_TRACE(ctx,format,args...) do { \
    char log_buff[1024]; \
    char final_string[1024]; \
    snprintf(final_string, sizeof(final_string),"LINE:%d ", __LINE__); \
    snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string)); \
    DLT_LOG(ctx, DLT_LOG_DEBUG, DLT_STRING(final_string)); \
} while(0)



#define POLICY_FILE "/var/lib/connman/session_policy_local/services.policy"

#ifdef USECONTEXTID
#define CONTEXT_IDENTIFIER "ContextIdentifier"
#else
#define CONTEXT_IDENTIFIER "Service"
#endif

typedef struct client_session {
  gchar *notifier;
  gchar *new_notifier;
  gchar *sender;
  gchar *session;
  guint uid;
  guint watchid;
  gboolean connman_initiated_closing;
  ConnManProxyNotificationNotification *notification_server;    // towards connman
  ConnManProxyNotificationNotification *notification_client;    // towards client
  ConnManProxySessionSession *session_server;                   // towards client
  ConnManProxySessionSession *session_client;                   // towards connman
} client_session;

typedef struct dbus_cb_parameters {
  GObject *client_proxy;
  GDBusMethodInvocation *invocation;
  struct client_session *csession;
  gpointer user_data;
} dbus_cb_parameters;
#endif                          /* CONNMANPROXY_H_ */
