/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.

History -- 0.1 (version) mpr3hi (USER)
        -- 0.2 (version) thb1hi (USER) extended with net.connman (Changelog)
		-- 0.3 (version) mpr3hi, AGW LCM,Audio Manager examples
***************************************************************************/
#ifndef TEST_COMPONENT_H_
#define TEST_COMPONENT_H_

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sstream>	
#include <string>     

#include <dlt/dlt.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <curl/curl.h>

/* Native Service includes */
#include "com/bosch/NativeService1Proxy.h"
#include "com/bosch/NativeService2Proxy.h"

/* following includes are needed for session-api */
#include "net/connman/ManagerProxy.h"
#include "net/connman/SessionProxy.h"
#include "net/connman/NotificationStub.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
/* end */

/* LCM Proxy includes*/
#include "com/bosch/AutomotiveProxy/LifeCycleManagerProxy.h"

/* Audio Manager Proxy includes */
#include "com/bosch/AutomotiveProxy/AudioManagerProxy.h"

/* ASF includes */
#include "asf/core/ApplicationIF.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

/* Util/Defines */
#include "../../../tinyxml/tinyxml.h"
#include "../../../TestComponent_defines.h"

using namespace ::asf::core;
using namespace std;
using namespace com::bosch::NativeService1;
using namespace com::bosch::NativeService2;
using namespace net::connman::Session;
using namespace net::connman::Manager;
using namespace net::connman::Notification;
using namespace com::bosch::AutomotiveProxy::LifeCycleManager;
using namespace com::bosch::AutomotiveProxy::AudioManager;

namespace com {
namespace bosch {

class TestComponent
: public BaseComponent,
  public ServiceAvailableIF,
  public MountNavishareCallbackIF,
  public UmountNavishareCallbackIF,
  public Service2Method1CallbackIF,
  public CreateSessionCallbackIF,
  public DestroySessionCallbackIF,
  public RegisterCallbackIF,
  public LifecycleRequestCallbackIF,
  public LifecycleRequestCompleteCallbackIF,
  public SourceAvailabilityCallbackIF,
  public AudioRouteRequestCallbackIF,
  public SourceActivityResultCallbackIF,
  public SourceActivityCallbackIF,
  public OnAllocateCallbackIF,  
  NotificationStub {

public:
  TestComponent();
  virtual ~TestComponent();     
  
  // proxy availablity Methods (for all interfaces)
   virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange);
   virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange);
   
   // Native Service virutal Methods
   virtual void onMountNavishareError(const ::boost::shared_ptr< NativeService1Proxy >& proxy, const ::boost::shared_ptr< MountNavishareError >& error);
   virtual void onMountNavishareResponse(const ::boost::shared_ptr< NativeService1Proxy >& proxy, const ::boost::shared_ptr< MountNavishareResponse >& response);
   
   virtual void onUmountNavishareError(const ::boost::shared_ptr< NativeService1Proxy >& proxy, const ::boost::shared_ptr< UmountNavishareError >& error);
   virtual void onUmountNavishareResponse(const ::boost::shared_ptr< NativeService1Proxy >& proxy, const ::boost::shared_ptr< UmountNavishareResponse >& response);
   
   virtual void onService2Method1Error(const ::boost::shared_ptr< NativeService2Proxy >& proxy, const ::boost::shared_ptr< Service2Method1Error >& error);
   virtual void onService2Method1Response(const ::boost::shared_ptr< NativeService2Proxy >& proxy, const ::boost::shared_ptr< Service2Method1Response >& response);

   // Conman Service virutal Methods
   virtual void onDestroySessionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DestroySessionError >& error);
   virtual void onDestroySessionResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DestroySessionResponse >& response);
   
   virtual void onCreateSessionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error);
   virtual void onCreateSessionResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response);

   virtual void onReleaseRequest (const ::boost::shared_ptr< ReleaseRequest >& request);
   virtual void onUpdateRequest (const ::boost::shared_ptr< UpdateRequest >& request);
   
   // AGW LCM proxy virutal methods
   virtual void onRegisterError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< RegisterError >& error);
   virtual void onRegisterResponse(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< RegisterResponse >& response);
   
   virtual void onLifecycleRequestError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestError >& error);
   virtual void onLifecycleRequestSignal(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestSignal >& signal);
   
   virtual void onLifecycleRequestCompleteError(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestCompleteError >& error);
   virtual void onLifecycleRequestCompleteResponse(const ::boost::shared_ptr< LifeCycleManagerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestCompleteResponse >& response);   
   
   // AGW Audio Manager proxy virutal methods 
   virtual void onSourceAvailabilityError(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< SourceAvailabilityError >& error);
   virtual void onSourceAvailabilityResponse(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< SourceAvailabilityResponse >& response);   
   
   virtual void onAudioRouteRequestError(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< AudioRouteRequestError >& error);
   virtual void onAudioRouteRequestResponse(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< AudioRouteRequestResponse >& response);
   
   virtual void onSourceActivityResultError(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< SourceActivityResultError >& error);
   virtual void onSourceActivityResultResponse(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< SourceActivityResultResponse >& response);
   
   virtual void onOnAllocateError(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< OnAllocateError >& error);
   virtual void onOnAllocateSignal(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< OnAllocateSignal >& signal);
   
   virtual void onSourceActivityError(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< SourceActivityError >& error);
   virtual void onSourceActivitySignal(const ::boost::shared_ptr< AudioManagerProxy >& proxy, const ::boost::shared_ptr< SourceActivitySignal >& signal);

   // parse Test Configuration XML file tags, and handle test cases
   void parseTestConfig();
   void parseSocketTest(std::string);
   void parseNetworkTest(std::string);
   void parseDbusTest(std::string,std::string);
   void parseFileHandleTest(std::string,std::string);	

   // restart container
   static void resetContainer(int);
   
   // DLT injection callback
   static int uIntDLTTraceInjectionCallback(unsigned int, void *, unsigned int);
  
  //step 4.1, socket communication tests
   void notifyTestServer(std::string);    
   void execSlave(std::string);
  
   //step 4.2, dbus communication tests
   void sendMountNavishareReq();
   void sendUmountNavishareReq();
   void sendService2Method1();
   
   void createFile(std::string,int);   
   // LCM test cases
   void sendLcmRegisteration();   
   // Audio Manager test case
   void allocateAudioChannel();
   
   //network test cases
   void testSessionSSC();
   void fetch_page();  
   
  enum connman_session_state {
	CONNMAN_SESSION_STATE_DISCONNECTED   = 0,
	CONNMAN_SESSION_STATE_CONNECTED      = 1,
	CONNMAN_SESSION_STATE_ONLINE         = 2,
  };
 
  // LCM shutdown mode requests 
  enum shutdown_mode {
    shutdown_normal = 1,
    shutdown_fast
  }shutdownMode; 
  
  // a way to get the handle of component
  static TestComponent *getInstance(){
        return _instance;
  }

private: 
  boost::shared_ptr< NativeService1Proxy > m_NativeService1Proxy;
  boost::shared_ptr< NativeService2Proxy > m_NativeService2Proxy;
  boost::shared_ptr< SessionProxy > m_SessionProxy;
  boost::shared_ptr< ManagerProxy > m_ManagerProxy;
  boost::shared_ptr< NotificationStub > m_NotificationStub;
  boost::shared_ptr< LifeCycleManagerProxy > m_LCMProxy;
  boost::shared_ptr< AudioManagerProxy > m_AMProxy;
  
  // store request id, from LCM
  uint32 request_id;
  
  // restart config val
  uint restartConfigTimer;
  
  bool OnAllocateSignalRcvd;
  bool SourceActivityRcvd;
  
  static TestComponent *_instance;
};

} // namespace com
} // namespace bosch



#endif // TEST_COMPONENT_H_
