/*************************************************************************************************
 FILE:           scd_ssc_Utility.cpp
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    Class definition
                 This is utility class - performs some basic operation on data
 	 	 	 	 The goal is to have minimum data processing in a client component -
 	 	 	 	 loose coupled component

 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#include "scd_ssc_utility.h"

/*************************************************************************************************
	FUNCTION: scd_ssc_tclUtility
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: Constructor
	HISTORY:

*************************************************************************************************/
scd_ssc_tclUtility::scd_ssc_tclUtility()
{

}

/*************************************************************************************************
* FUNCTION: scd_ssc_tclProperty
* DESCRIPTION: Copy constructor
* PARAMETER: scd_ssc_tclProperty
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclUtility::scd_ssc_tclUtility(const scd_ssc_tclUtility & outility)
{
}

/*************************************************************************************************
* FUNCTION: scd_ssc_tclUtility
* DESCRIPTION: Assignment operator
* PARAMETER: scd_ssc_tclUtility
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclUtility & scd_ssc_tclUtility::operator=(const scd_ssc_tclUtility & outility)
{
	return (*this);
}

/*************************************************************************************************
	FUNCTION: ~scd_ssc_tclUtility
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: Destructor
	HISTORY:

*************************************************************************************************/
scd_ssc_tclUtility::~scd_ssc_tclUtility()
{

}

/*************************************************************************************************
	FUNCTION: setResponse
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE: bool, true - success, false - failed
	DESCRIPTION: this function takes all data (seed, serial, lock level, key, and signature) and
				 creates a response (1400 byte)
	HISTORY:

*************************************************************************************************/

bool scd_ssc_tclUtility::setResponse(scd_ssc_tclProperty *smartcardProperty, bool option)
{
	bool status = true;
	static int offset = 0;
	char *ptr = smartcardProperty->getResponseIn();

	if(option == true)
	{
		/* put the challenge (seed) into response  											    */
		/* seed size = 96 bytes	                                                                */

		memcpy(&ptr[offset], smartcardProperty->getAldChallengeOut(), smartcardProperty->getAldChallengeSize());

		/* append the smartcard' serial  													    */
		/* serial id size = 25 bytes                                                            */
		offset += smartcardProperty->getAldChallengeSize();
		memcpy(&ptr[offset], smartcardProperty->getSerial(), smartcardProperty->getSerialSize());

		/* get the lock level  - mandatory                                                      */
		/* append the lock level  															    */
		/* lock level size = 4 bytes                                                            */
		offset += smartcardProperty->getSerialSize();
		memcpy(&ptr[offset], smartcardProperty->getLockLevel(), smartcardProperty->getRequestUnlockLevelSize());

		/* get the public key - mandatory                                                       */
		/* append the public key - 																*/
		/* public key size = 512 bytes                                                          */
		offset += smartcardProperty->getRequestUnlockLevelSize();
		memcpy(&ptr[offset], smartcardProperty->getPublicKey(), smartcardProperty->getPublicKeyUserSize());

		/* append the reserved - do nothing													    */
		/* reserved size = 251 bytes                                                            */
		offset += smartcardProperty->getPublicKeyUserSize();
	}
	else
	{
		/* get the signature - mandatory                                                        */
		/* append the signature  																*/
		/* signature size = 512 bytes                                                           */
		offset += smartcardProperty->getReservedSize();
		memcpy(&ptr[offset], smartcardProperty->getSignature(), smartcardProperty->getSignatureSize());
	}
	return status;
}

/*************************************************************************************************
	FUNCTION: isChallenge
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: tests ecu id
	HISTORY: not finished and not used

*************************************************************************************************/

bool scd_ssc_tclUtility::isChallenge(scd_ssc_tclProperty *smartcardProperty)
{
	bool status = true;
	unsigned int i = 0;
	unsigned int y = smartcardProperty->getEcuPosition();

	char *challenge = smartcardProperty->getAldChallengeOut();
	char *ecu_id = smartcardProperty->getAldEcuIdIn();

	for(i = 0; i < smartcardProperty->getAldEcuIdSize(); i++)
	{
		if((*ecu_id++) != (*(challenge + y + i)))
		{
			status = false;
			break;
		}
	}

	return status;
}

/*************************************************************************************************
	FUNCTION: isResponse
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: tests the result - data returned from ALD
	HISTORY:

*************************************************************************************************/

bool scd_ssc_tclUtility::isResponse(scd_ssc_tclProperty *smartcardProperty)
{
	bool status = true;
	/* check for the return or error only                                                       */
	if(smartcardProperty->getAldResultOut() != 0)
		status = false;

	return status;
}

/*************************************************************************************************
	FUNCTION: intToString
	PARAMETERS: intl
	RETURN VALUE: const char *
	DESCRIPTION: converts an int into a string
	HISTORY:
l
*************************************************************************************************/
const char * scd_ssc_tclUtility::scd_ssc_tclUtility::intToString(int val)const
{
	std::string data;
	std::stringstream snumber;
	snumber << val;
	data = snumber.str();
	const char * ch = (char*)data.c_str();
	return ch;
}

/*************************************************************************************************
	FUNCTION: longToString
	PARAMETERS: long
	RETURN VALUE: const char *
	DESCRIPTION:  converts a long into a string
	HISTORY:

*************************************************************************************************/
const char * scd_ssc_tclUtility::longToString(long val)const
{
	std::string data;

	std::stringstream snumber;
	snumber << val;
	data = snumber.str();
	const char * ch = (char*)data.c_str();
	return ch;
}

/*************************************************************************************************
	FUNCTION: stringToInt
	PARAMETERS: const std::string str
	RETURN VALUE: int
	DESCRIPTION: converts a string into an int
	HISTORY:

*************************************************************************************************/

int scd_ssc_tclUtility::scd_ssc_tclUtility::stringToInt(const std::string str)const
{
	bool status = true;
	int data = 0;
	unsigned int i;

	for(i = 0; i < str.size(); i++)
	{
		if(!(isdigit(str[i])))
		{
			status = false;
			break;
		}
	}
	if(status == true)
		data = atoi(str.c_str());

	return data;

}


/*************************************************************************************************
	FUNCTION: stringToLong
	PARAMETERS: const std::string str
	RETURN VALUE: long
	DESCRIPTION: converts a string into a long
	HISTORY:

*************************************************************************************************/
long scd_ssc_tclUtility::stringToLong(const std::string str) const
{
	long data = 0;
	bool status = true;
	unsigned int i;

	for(i = 0; i < str.size(); i++)
	{
		if(!(isdigit(str[i])))
		{
			status = false;
			break;
		}
	}
	if(status == true)
		data = atol(str.c_str());

	return data;
}




/*************************************************************************************************
	FUNCTION: getProductFirmCode
	PARAMETERS: scd_ssc_tclProperty *m_poProperty
	RETURN VALUE: bool, true - success, false - failed
	DESCRIPTION: Get product and firm code from config file, all of them, and store them
	HISTORY:

*************************************************************************************************/
bool scd_ssc_tclUtility::getProductFirmCode(scd_ssc_tclProperty *m_poProperty,
		                                    scd_ssc_tclLogger  *m_poLogger)
{
	bool status = false;
	unsigned int state = 0, found;
	m_poLogger->log("entering scd_ssc_tclUtility -> getProductFirmCode() ... ");

	std::string line;
	std::ifstream mystream;
	mystream.open(m_poProperty->getPathToWibuConfig(), std::ios::in);

    /* if the file for reading is open                                                          */
	if(mystream.is_open())
	{
		/* get line                                                                             */
		while(getline(mystream, line))
		{
			/* skip the line that starts with #                                                 */
			if(line.at(0) =='#')
				continue;
			else
			{
				/* we keep the line track                                                       */
				switch(state)
				{
					case 0:
                        /* this line is where customer is located - if not found do not proceed */
						if (line.find(m_poProperty->getCustomer()) != std::string::npos)
							state = 1;

						break;

					case 1:
                        /* we are looking now for a productcode                                 */
						if ((found = line.find("=")) != std::string::npos)
						{
							std::string str = line.substr(found + 1);
							char *token = strtok(&str[0], ",");

							while(token != NULL)
							{
								std::string temp_str(token);
								temp_str.erase(std::remove(temp_str.begin(), temp_str.end(), ' '),
										                   temp_str.end());
								m_poProperty->addProductCode((unsigned int)stringToInt(temp_str));
								token = strtok(NULL, ",");
								m_poLogger->log("scd_ssc_tclUtility -> getProductFirmCode() - "
										        "productCode from config file: " + temp_str);

							}
							state = 2;
						}
						else
							state = 0;

						break;

					case 2:
						/* we are looking now for a firmcode                                    */
						if ((found = line.find("=")) != std::string::npos)
						{
							std::string str = line.substr(found + 1);
							char *token = strtok(&str[0], ",");

							while(token != NULL)
							{
								std::string temp_str(token);
								temp_str.erase(std::remove(temp_str.begin(),
										                   temp_str.end(), ' '), temp_str.end());
								m_poProperty->addFirmCode((unsigned int)stringToInt(temp_str));
								token = strtok(NULL, ",");

								m_poLogger->log("scd_ssc_tclUtility -> getProductFirmCode() "
										      "- firmCode from config file: " + temp_str);

							}
							status = true;
						}
						else
							status = false;

						state = 0;
						break;

					default:

						break;
				}/* end switch                                                                  */
			} /* end condition                                                                  */
		}/* end of file                                                                         */

		mystream.close();
	}
	else
	{
		status = false;
		m_poLogger->log("scd_ssc_tclUtility -> getProductFirmCode() -> open() - failed - file: " +
				         std::string(m_poProperty->getPathToWibuConfig()) + " doesn't exist");
	}
	m_poLogger->log("exiting scd_ssc_tclUtility -> getProductFirmCode()");
	return status;
}


/*************************************************************************************************
	FUNCTION: getMode
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: test for the value in environment
	HISTORY:
l
*************************************************************************************************/
bool scd_ssc_tclUtility::getMode(scd_ssc_tclProperty *m_poProperty)
{
	bool status = false;
	char *mode;

	mode = getenv(m_poProperty->getModeOfOperation());
	if(mode != NULL)
		status = true;

	return status;
}

