/*************************************************************************************************
 FILE:           scd_ssc_tclLogger.cpp
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    Definition of the scd_ssc_tclLogger class
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 19.10.2015      | sva1fh                | initial version - class definition

 ************************************************************************************************/

#include "scd_ssc_logger.h"
/*************************************************************************************************
	FUNCTION:
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION:

	HISTORY:
    Date        | Author                | Modification
    19.10.2015  | sva1fh                | initial version

*************************************************************************************************/
scd_ssc_tclLogger::scd_ssc_tclLogger(bool logging, bool term):
                   PATH_TO_LOG_FILE("/var/opt/bosch/dynamic/scd_ssc/scd_ssc.log")
{
	this->logging = logging;
	this->term = term;
	counter = 0;

	if(logging == true)
		scd_ssc_log.open(PATH_TO_LOG_FILE, std::ios::app);
}

/*************************************************************************************************
	FUNCTION:
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION:

	HISTORY:
    Date        | Author                | Modification
    19.10.2015  | sva1fh                | initial version

*************************************************************************************************/
scd_ssc_tclLogger::~scd_ssc_tclLogger()
{
	if(scd_ssc_log.is_open())
		scd_ssc_log.close();
}

/*************************************************************************************************
	FUNCTION:
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION:

	HISTORY:
    Date        | Author                | Modification
    19.10.2015  | sva1fh                | initial version

*************************************************************************************************/
void scd_ssc_tclLogger::log(std::string msg)
{
	counter++;
	std::string now_time = getDateTime();

	if(scd_ssc_log.is_open() && (logging == true) && (term == true))
	{
		scd_ssc_log << now_time + " - " + msg << std::endl;
		std::cout << " - " << counter << " - " +  msg << std::endl;
	}
	else if(scd_ssc_log.is_open() && (logging == true))
	{
		scd_ssc_log << now_time + " - " + msg << std::endl;
	}
	else if(term == true)
	{
		std::cout << " - " << counter << " - " +  msg << std::endl;
	}
	else
	{
		// do nothing
	}
}

/*************************************************************************************************
	FUNCTION:
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION:

	HISTORY:
    Date        | Author                | Modification
    19.10.2015  | sva1fh                | initial version

*************************************************************************************************/
const std::string scd_ssc_tclLogger::getDateTime(void)
{
	char fmt[64], buff[64]; /* decrease it to 32 if return is (s:milliseconds)                  */
	struct timeval tv;
	struct tm *tm;

	gettimeofday(&tv, NULL);

	if((tm = localtime(&tv.tv_sec)) != NULL)
	 {
		strftime(fmt, sizeof fmt, "%Y-%m-%d %H:%M:%S.%%06u", tm);   /* return year-h:m:s:us     */
		//strftime(fmt, sizeof fmt, "%S.%%06u", tm);
	    snprintf(buff, sizeof buff, fmt, tv.tv_usec); /* return just seconds and milliseconds   */
	 }

	return buff;
}






