/*************************************************************************************************
 FILE:           scd_ssc_Utility.h
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    Class declaration
                 This is utility class - performs some basic operation on data
 	 	 	 	 The goal is to have minimum data processing in a client component -
 	 	 	 	 loose coupled component

 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
  05.10.2015     | sva1fh                | initial version - class definition

 ************************************************************************************************/
#ifndef SCD_SSC_UTILITY_H_
#define SCD_SSC_UTILITY_H_

#include "scd_ssc_property.h"
#include "scd_ssc_logger.h"
#include "scd_ssc_utility.h"

#include <cstring>
#include <sstream>
#include <string>
#include <cctype>
#include <algorithm>
#include <vector>


class scd_ssc_tclUtility
{
public:
/*************************************************************************************************
* FUNCTION: scd_ssc_tclUtility
* DESCRIPTION: Constructor
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	scd_ssc_tclUtility();

/*************************************************************************************************
* FUNCTION: scd_ssc_tclUtility
* DESCRIPTION: Assignment operator
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	scd_ssc_tclUtility & operator=(const scd_ssc_tclUtility & outility);

/*************************************************************************************************
* FUNCTION: scd_ssc_tclUtility
* DESCRIPTION: Copy constructor
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	scd_ssc_tclUtility(const scd_ssc_tclUtility & outility);


/*************************************************************************************************
* FUNCTION: ~scd_ssc_tclUtility
* DESCRIPTION: Destructor
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	virtual ~scd_ssc_tclUtility();

/*************************************************************************************************
* FUNCTION: setResponse
* DESCRIPTION: Generates 1400 bytes of data - response
* PARAMETER: scd_ssc_tclProperty
* RETURNVALUE: true - success, false - failed

*************************************************************************************************/
	bool setResponse(scd_ssc_tclProperty *smartcardProperty, bool option);

/*************************************************************************************************
* FUNCTION: isChallenge
* DESCRIPTION: Tests the content of challenge data received from ALD
* PARAMETER: scd_ssc_tclProperty
* RETURNVALUE:  bool, true - success, false - failed

*************************************************************************************************/
	bool isChallenge(scd_ssc_tclProperty *smartcardProperty);

/*************************************************************************************************
* FUNCTION: isResponse
* DESCRIPTION: tests the result - data returned from ALD
* PARAMETER: scd_ssc_tclProperty
* RETURNVALUE:  bool, true - success, false - failed

*************************************************************************************************/
	bool isResponse(scd_ssc_tclProperty *smartcardProperty);

/*************************************************************************************************
* FUNCTION: intToString
* DESCRIPTION: converts an int into a string
* PARAMETER: int
* RETURNVALUE: const char *

*************************************************************************************************/
	const char * intToString(int val)const;

/*************************************************************************************************
* FUNCTION: longToString
* DESCRIPTION: converts a long into a string
* PARAMETER: long
* RETURNVALUE: const char *

*************************************************************************************************/
	const char * longToString(long val)const;

/*************************************************************************************************
* FUNCTION: stringToInt
* DESCRIPTION: converts a string into an int
* PARAMETER: const std::string str
* RETURNVALUE: int

*************************************************************************************************/
	int stringToInt(std::string str)const;

/*************************************************************************************************
* FUNCTION: stringToLong
* DESCRIPTION: converts a string into a long
* PARAMETER: const std::string str
* RETURNVALUE: long

*************************************************************************************************/
	long stringToLong(std::string str)const;


/*************************************************************************************************
	FUNCTION: getProductFirmCode
	PARAMETERS: scd_ssc_tclProperty *m_poProperty
	RETURN VALUE: bool, true - success, false - failed
	DESCRIPTION: gets product and firm code from config file
	HISTORY:

*************************************************************************************************/
	bool getProductFirmCode(scd_ssc_tclProperty *m_poProperty, scd_ssc_tclLogger  *m_poLogger);


/*************************************************************************************************
	FUNCTION: getMode
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: test for the value in environment

*************************************************************************************************/
	bool getMode(scd_ssc_tclProperty *m_poProperty);


private:



};

#endif /* SCD_SSC_UTILITY_H_ */
