/*************************************************************************************************
 FILE:           scd_ssc_smartcardhandler.h
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:
 DESCRIPTION:    declaration of the smartcard client class
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#ifndef SCD_SSC_SMARTCARDHANDLER_H_
#define SCD_SSC_SMARTCARDHANDLER_H_

#include "CCodeMeter.h"
#include "scd_ssc_property.h"
#include "scd_ssc_utility.h"
#include "scd_ssc_logger.h"

#include <libudev.h>
#include <stdlib.h>
#include <cstdio>
#include <cstddef>
#include <cstring>


class scd_ssc_tclSmartcardHandler
{
public:
/*************************************************************************************************
* 	FUNCTION: scd_ssc_tclSmartcardHandler
* 	DESCRIPTION: Constructor
* 	PARAMETER:
* 	RETURNVALUE:

*************************************************************************************************/
	scd_ssc_tclSmartcardHandler();

/*************************************************************************************************
* 	FUNCTION: scd_ssc_tclSmartcardHandler
* 	DESCRIPTION: Copy constructor
* 	PARAMETER:
* 	RETURNVALUE:

*************************************************************************************************/
	scd_ssc_tclSmartcardHandler(const scd_ssc_tclSmartcardHandler & osmartcard);

/*************************************************************************************************
	FUNCTION: operator=
	DESCRIPTION: Assignment operator
	PARAMETERS:
	RETURN VALUE:

*************************************************************************************************/
	scd_ssc_tclSmartcardHandler & operator=(const scd_ssc_tclSmartcardHandler & oproperty);

/*************************************************************************************************
* 	FUNCTION: ~scd_ssc_tclSmartcardHandler
* 	DESCRIPTION: Destructor
* 	PARAMETER:
* 	RETURNVALUE:

*************************************************************************************************/
	virtual ~scd_ssc_tclSmartcardHandler();

/*************************************************************************************************
* 	FUNCTION: getAttributes
* 	DESCRIPTION: gets the smartcard's attributes
* 	PARAMETER:
* 	RETURNVALUE:  bool, true - success, false - failed

*************************************************************************************************/
	bool getAttributes(void);

/*************************************************************************************************
* 	FUNCTION: initialize
* 	DESCRIPTION: initialize CCodeMeter object
* 	PARAMETER:
* 	RETURNVALUE: (bool) true - succeeded, false - failed

*************************************************************************************************/
	bool initialize(scd_ssc_tclProperty *m_poProperty, scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
* FUNCTION: getManufacturer
* DESCRIPTION: gets a string - manufacturer
* PARAMETER:
* RETURNVALUE: char*

*************************************************************************************************/
	char* getManufacturer() ;

/*************************************************************************************************
* 	FUNCTION: setManufacturer
* 	DESCRIPTION: sets the string - manufacturer
* 	PARAMETER: const char*
* 	RETURNVALUE:

*************************************************************************************************/
	void setManufacturer(const char* manufacturer);

/*************************************************************************************************
* 	FUNCTION: getProduct
* 	DESCRIPTION: gets a string - product
* 	PARAMETER:
* 	RETURNVALUE: char*

*************************************************************************************************/
	char* getProduct();

/*************************************************************************************************
* 	FUNCTION: setProduct
* 	DESCRIPTION: sets the string - product
* 	PARAMETER: const char*
* 	RETURNVALUE:

*************************************************************************************************/
	void setProduct(const char* product);

/*************************************************************************************************
* 	FUNCTION: getProductId
* 	DESCRIPTION: gets a string - product_id
* 	PARAMETER:
* 	RETURNVALUE: char*

*************************************************************************************************/
	char* getProductId();

/*************************************************************************************************
* 	FUNCTION: setProductId
* 	DESCRIPTION: sets the string - productId
* 	PARAMETER: const char*
* 	RETURNVALUE:

*************************************************************************************************/
	void setProductId(const char* productId);

/*************************************************************************************************
* 	FUNCTION: getSerial
* 	DESCRIPTION: gets a string - serial
* 	PARAMETER:
* 	RETURNVALUE: char*

*************************************************************************************************/
	char* getSerial();

/*************************************************************************************************
* 	FUNCTION: setSerial
* 	DESCRIPTION: sets the string - serial
* 	PARAMETER: const char*
* 	RETURNVALUE:

*************************************************************************************************/
	void setSerial(const char* serial);

/*************************************************************************************************
* 	FUNCTION: getVendorId
* 	DESCRIPTION: gets a string - vendor_id
* 	PARAMETER:
* 	RETURNVALUE: char*

*************************************************************************************************/
	char* getVendorId();

/*************************************************************************************************
* 	FUNCTION: setVendorId
* 	DESCRIPTION: sets the string - vendor_id
* 	PARAMETER: const char*
* 	RETURNVALUE:

*************************************************************************************************/
	void setVendorId(const char* vendorId);

private:

	 static const unsigned int VENDOR_ID_SIZE 		    = 4;
	 static const unsigned int PRODUCT_ID_SIZE 		    = 4;
	 static const unsigned int MANUFACTURER_SIZE 		= 15;
	 static const unsigned int PRODUCT_SIZE 		    = 15;
	 static const unsigned int SERIAL_SIZE 		        = 12;

	 char *vendor_id;
     char *product_id;
     char *manufacturer;
     char *product;
     char *serial;

     CCodeMeter *m_poCCodeMeter;

};

#endif /* SCD_SSC_SMARTCARDHANDLER_H_ */
