/*************************************************************************************************
 FILE:           scd_ssc_property.h
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    Declaration of the property class

 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#ifndef SCD_SSC_PROPERTY_H_
#define SCD_SSC_PROPERTY_H_

#include <cstddef>
#include <ctype.h>
#include <cstring>
#include <vector>

class scd_ssc_tclProperty
{
public:

/*************************************************************************************************
	FUNCTION: scd_ssc_tclProperty
	DESCRIPTION:
	PARAMETERS:
	RETURN VALUE: constructor

*************************************************************************************************/
	scd_ssc_tclProperty();

/*************************************************************************************************
	FUNCTION: operator=
	DESCRIPTION: Assignment operator
	PARAMETERS:
	RETURN VALUE:

*************************************************************************************************/
	scd_ssc_tclProperty & operator=(const scd_ssc_tclProperty & oproperty);

/*************************************************************************************************
	FUNCTION: scd_ssc_tclProperty
	DESCRIPTION: Copy constructor
	PARAMETERS: scd_ssc_tclProperty &
	RETURN VALUE:

*************************************************************************************************/
	scd_ssc_tclProperty(const scd_ssc_tclProperty & oproperty);

/*************************************************************************************************
	FUNCTION: scd_ssc_tclProperty
	DESCRIPTION: destructor
	PARAMETERS:
	RETURN VALUE:

*************************************************************************************************/
	virtual ~scd_ssc_tclProperty();

/*************************************************************************************************
	FUNCTION: getAldChallengeOut
	DESCRIPTION: get a pointer that points to (96 bytes of) data
	PARAMETERS:
	RETURN VALUE: char* - a pointer to the array of bytes

*************************************************************************************************/
	char* getAldChallengeOut()const;

/*************************************************************************************************
	FUNCTION: getAldChallengeSize
	DESCRIPTION: gets challenge size
	PARAMETERS:
	RETURN VALUE: const unsigned int  - size

*************************************************************************************************/
	const unsigned int getAldChallengeSize()const;

/*************************************************************************************************
	FUNCTION: getResultResponseSize
	DESCRIPTION: gets result from response in size
	PARAMETERS:
	RETURN VALUE: const unsigned int  - size

*************************************************************************************************/
	const unsigned int getResultResponseSize()const;

/*************************************************************************************************
	FUNCTION: getAldEcuIdIn
	DESCRIPTION: gets a pointer that points to ecu_id data
	PARAMETERS:
	RETURN VALUE: char* - a pointer to the array of bytes

*************************************************************************************************/
	char* getAldEcuIdIn() const;

/*************************************************************************************************
	FUNCTION: getAldEcuIdSize
	DESCRIPTION: gets ecu_id size
	PARAMETERS:l
	RETURN VALUE: const unsigned int  - size

*************************************************************************************************/
	const unsigned int getAldEcuIdSize() const;

/*************************************************************************************************
	FUNCTION: getAldInterfaceChangeLevel
	DESCRIPTION: gets a pointer that points to a string - ALD_INTERFACE_CHANGE_LEVEL
	PARAMETERS:
	RETURN VALUE: const char* - string

*************************************************************************************************/
	const char* getAldInterfaceChangeLevel() const;

/*************************************************************************************************
	FUNCTION: getAldInterfaceLevelStatus
	DESCRIPTION: gets a pointer that points to a string - ALD_INTERFACE_LEVEL_STATUS
	PARAMETERS:
	RETURN VALUE: const char* - string

*************************************************************************************************/
	const char* getAldInterfaceLevelStatus() const;

/*************************************************************************************************
	FUNCTION: getAldLockResultOut
	DESCRIPTION: gets data form ald
	PARAMETERS:
	RETURN VALUE: unsigned int - result

*************************************************************************************************/
	unsigned int getAldLockResultOut() const;

/*************************************************************************************************
	FUNCTION: getAldMethodChallenge
	DESCRIPTION: gets a pointer that points to a string - ALD_METHOD_CHALLENGE
	PARAMETERS:
	RETURN VALUE: const char* - string

*************************************************************************************************/
	const char* getAldMethodChallenge() const;

/*************************************************************************************************
	FUNCTION: getAldMethodLockDevice
	DESCRIPTION: gets a pointer that points to a string - ALD_METHOD_LOCK_DEVICE
	PARAMETERS:
	RETURN VALUE: const char* - string

*************************************************************************************************/
	const char* getAldMethodLockDevice() const;

/*************************************************************************************************
	FUNCTION: getAldMethodResponse
	DESCRIPTION: gets a pointer that points to a string - ALD_METHOD_RESPONSE
	PARAMETERS:
	RETURN VALUE: const char* - string

*************************************************************************************************/
	const char* getAldMethodResponse() const;

/*************************************************************************************************
	FUNCTION: getAldName
	DESCRIPTION: gets a pointer that points to a string - destination - ALD_NAME
	PARAMETERS:
	RETURN VALUE: const char*

*************************************************************************************************/
	const char* getAldName() const;

/*************************************************************************************************
	FUNCTION: getAldPath
	DESCRIPTION: gets a pointer that points to a string - path
	PARAMETERS:
	RETURN VALUE: const char*

*************************************************************************************************/
	const char* getAldPath() const;

/*************************************************************************************************
	FUNCTION: getAldResponseIn
	DESCRIPTION: gets a pointer that points to response data
	PARAMETERS:
	RETURN VALUE: const char*

*************************************************************************************************/
	char* getResponseIn() const;

/*************************************************************************************************
	FUNCTION: getAldResponseSize
	DESCRIPTION: gets the size of the response
	PARAMETERS:
	RETURN VALUE: const unsigned int

*************************************************************************************************/
	const unsigned int getResponseSize() const ;

/*************************************************************************************************
	FUNCTION: getAldResultOut
	DESCRIPTION: gets data from ALD
	PARAMETERS:
	RETURN VALUE: unsigned int

*************************************************************************************************/
	unsigned int getAldResultOut() const;

/*************************************************************************************************
	FUNCTION: getAldSignalLevelChangeDone
	DESCRIPTION: signal name - ALD_SIGNAL_LEVEL_CHANGE_DONE
	PARAMETERS:
	RETURN VALUE: const char*

*************************************************************************************************/
	const char* getAldSignalLevelChangeDone() const;

/*************************************************************************************************
	FUNCTION: getAldSignalNewLevel
	DESCRIPTION: signal name - ALD_SIGNAL_NEW_LEVEL
	PARAMETERS:
	RETURN VALUE: const char*

*************************************************************************************************/
	const char* getAldSignalNewLevel() const;

/*************************************************************************************************
	FUNCTION: getPtrAldEcuId
	DESCRIPTION: gets a pointer to ecu_id
	PARAMETERS:
	RETURN VALUE: const char*

*************************************************************************************************/
	const char* getPtrAldEcuId() const;

/*************************************************************************************************
	FUNCTION:
	DESCRIPTION: gets a pointer that points to an address (response)
	PARAMETERS:
	RETURN VALUE: char*

*************************************************************************************************/
	int getPtrAldResponseInAddress() const;

/*************************************************************************************************
	FUNCTION: getPtrAldResponseIn
	DESCRIPTION: gets a pointer that points to the lock result data
	PARAMETERS:
	RETURN VALUE: unsigned int*

*************************************************************************************************/
	unsigned int* getPtrAldLockResultOut() const;

/*************************************************************************************************
	FUNCTION: getPtrAldResultOut
	DESCRIPTION: gets a pointer that points to the result data
	PARAMETERS:
	RETURN VALUE: unsigned int*

*************************************************************************************************/
	unsigned int* getPtrAldResultOut() const;
	
/*************************************************************************************************
	FUNCTION: getSerialSize
	DESCRIPTION: gets the serial size
	PARAMETERS:
	RETURN VALUE: const unsigned int*

*************************************************************************************************/
	const unsigned int getSerialSize() const;

/*************************************************************************************************
	FUNCTION: getRequestUnlockLevelSize
	DESCRIPTION: gets REQUEST_UNLOCK_LEVEL_SIZE
	PARAMETERS:
	RETURN VALUE: const unsigned int*

*************************************************************************************************/
	const unsigned int getRequestUnlockLevelSize() const;

/*************************************************************************************************
	FUNCTION: getPublicKeyUserSize
	DESCRIPTION: gets PUBLIC_KEY_USER_SIZE
	PARAMETERS:
	RETURN VALUE: const unsigned int*

*************************************************************************************************/
	const unsigned int getPublicKeyUserSize() const;

/*************************************************************************************************
	FUNCTION: getReservedSize
	DESCRIPTION: gets RESERVED_SIZE
	PARAMETERS:
	RETURN VALUE: const unsigned int*

*************************************************************************************************/
	const unsigned int getReservedSize() const;

/*************************************************************************************************
	FUNCTION: getSignatureSize
	DESCRIPTION: gets SIGNATURE_SIZE
	PARAMETERS: const unsigned int
	RETURN VALUE: unsigned int*

*************************************************************************************************/
	const unsigned int getSignatureSize() const;

/*************************************************************************************************
 	FUNCTION: getSerial
	DESCRIPTION: gets serial (string)
	PARAMETER:
	RETURNVALUE: unsigned char*

*************************************************************************************************/
	unsigned char* getSerial() const;

/*************************************************************************************************
	FUNCTION: setSerial
	DESCRIPTION: sets the serial
	PARAMETER: const char* serial
	RETURNVALUE:

*************************************************************************************************/
	void setSerial(const char* serial)const;

/*************************************************************************************************
	FUNCTION: getLockLevel
	DESCRIPTION: gets the lock level
	PARAMETER:
	RETURNVALUE: unsigned char*

*************************************************************************************************/
	unsigned char* getLockLevel() const;

/*************************************************************************************************
	FUNCTION: setLockLevel
	DESCRIPTION: sets the lock level
	PARAMETER: const char* lock_level
	RETURNVALUE:

*************************************************************************************************/
	void setLockLevel(const char* lock_level)const;

/*************************************************************************************************
	FUNCTION: getCurrentLockLevel
	DESCRIPTION: gets the current lock level
	PARAMETER:
	RETURNVALUE: unsigned char*

*************************************************************************************************/
	unsigned char * getCurrentLockLevel();

/*************************************************************************************************
	FUNCTION: setLockLevel
	DESCRIPTION: sets the current lock level
	PARAMETER: const char* lock_level
	RETURNVALUE:

*************************************************************************************************/
	void setCurrentLockLevel(const char * level);

/*************************************************************************************************
	FUNCTION: getPublicKey
	DESCRIPTION: gets the public key
	PARAMETER:
	RETURNVALUE: unsigned char*

*************************************************************************************************/
	unsigned char* getPublicKey() const;

/*************************************************************************************************
	FUNCTION: setPublicKey
	DESCRIPTION: sets the public key
	PARAMETER: const char* public_key
	RETURNVALUE:

*************************************************************************************************/
	void setPublicKey(const char* public_key)const;

/*************************************************************************************************
	FUNCTION: getSignature
	DESCRIPTION: get the signature
	PARAMETER:
	RETURNVALUE: unsigned char*`

*************************************************************************************************/
	unsigned char* getSignature() const;

/*************************************************************************************************
	FUNCTION: setSignature
	DESCRIPTION: sets the signature
	PARAMETER: const char* Signature
	RETURNVALUE:

*************************************************************************************************/
	void setSignature(const char* Signature)const;

/*************************************************************************************************
	FUNCTION: getSignDataSize
	DESCRIPTION: gets the size of the signature
	PARAMETER:
	RETURNVALUE: unsigned int

*************************************************************************************************/
	unsigned int getSignDataSize(void)const;

/*************************************************************************************************
	FUNCTION: getEcuPosition
	DESCRIPTION: gets the index of ecu id in the challenge
	PARAMETER:
	RETURNVALUE:

*************************************************************************************************/
	unsigned int getEcuPosition(void)const;

/*************************************************************************************************
	FUNCTION: getPathToWibuConfig
	DESCRIPTION: gets the path to the wibu configuration file
	PARAMETER:
	RETURNVALUE: const char*

*************************************************************************************************/
	const char* getPathToWibuConfig(void)const;

/*************************************************************************************************
	FUNCTION: getCustomer
	DESCRIPTION: gets the customer - string constant
	PARAMETER:
	RETURNVALUE:

*************************************************************************************************/
	const char* getCustomer(void)const;

/*************************************************************************************************
	FUNCTION: getProductCode
	DESCRIPTION: gets the product code
	PARAMETER: void
	RETURNVALUE: const char*

*************************************************************************************************/
	unsigned int getProductCode(void);

/*************************************************************************************************
	FUNCTION: getFirmCode
	DESCRIPTION: get the firm code
	PARAMETER:
	RETURNVALUE: unsigned int

*************************************************************************************************/
	unsigned int getFirmCode(void);

/*************************************************************************************************
	FUNCTION: addProductCode
	DESCRIPTION: adds the product code into a container - vector
	PARAMETER: unsigned int
	RETURNVALUE: void

*************************************************************************************************/
	void addProductCode(unsigned int val);

/*************************************************************************************************
	FUNCTION: addFirmCode
	DESCRIPTION: adds the firm code into a container - vector
	PARAMETER: unsigned int
	RETURNVALUE: void

*************************************************************************************************/
	void addFirmCode(unsigned int val);

/*************************************************************************************************
	FUNCTION: getPythonModule
	DESCRIPTION: gets the name of the python module
	PARAMETER:
	RETURNVALUE: const char*

*************************************************************************************************/
	const char* getPythonModule(void)const;

/*************************************************************************************************
	FUNCTION: getPythonCmd1
	DESCRIPTION: gets the python execution command
	PARAMETER:
	RETURNVALUE: const char*

*************************************************************************************************/
	const char* getPythonCmd1(void)const;

/*************************************************************************************************
	FUNCTION: getPythonModuleCmdPath
	DESCRIPTION: gets the command plus path to the python module
	PARAMETER:
	RETURNVALUE: const char*

*************************************************************************************************/
	const char* getPythonModuleCmdPath(void)const;

/*************************************************************************************************
	FUNCTION: getPythonFunc
	DESCRIPTION: gets the python's module function name
	PARAMETER:
	RETURNVALUE: const char*

*************************************************************************************************/
	const char* getPythonFunc(void)const;


/*************************************************************************************************
	FUNCTION: getModeOfOperation
	DESCRIPTION: gets the env key
	PARAMETER:
	RETURNVALUE: const char*

*************************************************************************************************/
	const char* getModeOfOperation(void)const;

/*************************************************************************************************
	FUNCTION: getLockedLevel
	DESCRIPTION: gets the locked level - 0
	PARAMETERS:
	RETURN VALUE: const unsigned int

*************************************************************************************************/
	const int getLockedLevel() const;

/*************************************************************************************************
	FUNCTION: getMaxUnlockedLevel
	DESCRIPTION: gets the maximum unlocked level - 50
	PARAMETERS:
	RETURN VALUE: const unsigned int

*************************************************************************************************/
	const int getMaxUnlockedLevel() const;

/*************************************************************************************************
	FUNCTION: setNewLockLevel
	DESCRIPTION: set the new unlock level
	PARAMETERS: unsigned char *
	RETURN VALUE:

*************************************************************************************************/
	void setNewLockLevel(unsigned char *level);

/*************************************************************************************************
	FUNCTION: getNewLockLevel
	DESCRIPTION: get the new unlock level
	PARAMETERS:
	RETURN VALUE: unsigned char *

*************************************************************************************************/
	unsigned char * getNewLockLevel();

private:

	static const unsigned int ALD_ECU_ID_SIZE 		    = 16;    /* ecu id size                 */
	static const unsigned int ALD_CHALLENGE_SIZE 	    = 96;    /* challenge size              */
	static const unsigned int RESPONSE_SIZE	 	    	= 1400;  /* response size               */
	static const unsigned int RESULT_RESPONSE_SIZE	 	= 1;     /* result from response - size */
	static const unsigned int SERIAL_SIZE               = 25;    /* serial size                 */
	static const unsigned int REQUEST_UNLOCK_LEVEL_SIZE = 4;     /* lock level size             */
	static const unsigned int PUBLIC_KEY_USER_SIZE      = 512;   /* public key size             */
	static const unsigned int RESERVED_SIZE             = 251;   /* reserved size               */
	static const unsigned int SSIGNATURE_SIZE           = 512;   /* signature size              */
	static const unsigned int SIGN_DATA_SIZE            = 888;   /* data size to be signed      */
	static const unsigned int START_ECU_ID_CHALLENGE    = 36;    /* ecu_id in challenge         */
	static const int LOCKED_LEVEL                       = 0;     /* locked level                */
	static const int MAX_UNLOCKED_LEVEL                 = 50;    /* max unlocked level          */

	const char *ALD_NAME;                                        /* destination name            */
	const char *ALD_PATH;                                        /* path                        */
	const char *ALD_INTERFACE_LEVEL_STATUS;                      /* interfaces                  */
	const char *ALD_INTERFACE_CHANGE_LEVEL;
	const char *ALD_SIGNAL_NEW_LEVEL;                            /* signals name                */
	const char *ALD_SIGNAL_LEVEL_CHANGE_DONE;
	const char *ALD_METHOD_CHALLENGE;                            /* methods                     */
	const char *ALD_METHOD_RESPONSE;
	const char *ALD_METHOD_LOCK_DEVICE;
	const char *PATH_TO_WIBU_CONFIG_FILE;                        /* path to config file         */
	const char *CUSTOMER;                                        /* defined in cpp file         */

	const char *PYTHON_MODULE;                                   /* python properties           */
	const char *PYTHON_CMD_1;
	const char *PYTHON_MODULE_CMD_PATH;
	const char *PYTHON_FUNC;
    const char *MODE_OF_OPERATION;

	char *ald_ecu_id_in;                                         /* ecu id                      */
	char *ptr_ecu_id_in;                                         /* pointer to ecu id           */
	char *ald_challenge_out;                                     /* challenge                   */
	char *ptr_challenge_out;                                     /* pointer to challenge        */
	char *response_in;                                  		 /* response                    */
	char *ptr_response_in;                                       /* pointer to response         */

	unsigned int ald_result_out;                                 /* result                      */
	unsigned int *ptr_ald_result_out;                            /* pointer to result           */
	unsigned int ald_lock_result_out;                            /* lock result                 */
	unsigned int *ptr_ald_lock_result_out;                       /* pointer to lock result      */

	unsigned char *serial;                                       /* serial number               */
	unsigned char *lock_level;                                   /* lock level from a smartcard */
	unsigned char *public_key;                                   /* public key                  */
	unsigned char *signature;                                    /* signature                   */

	unsigned char *current_lock_level;                           /* current lock level          */
	unsigned char *new_lock_level;                               /* new lock level              */

	std::vector<unsigned int> firmcodes;                         /* containers for product      */
	std::vector<unsigned int> productcodes;                      /* and firmcode                */
};

#endif /* SCD_SSC_PROPERTY_H_ */
