/*************************************************************************************************
 FILE:           scd_ssc_main.h
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    header file
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#ifndef SCD_SSC_MAIN_H_
#define SCD_SSC_MAIN_H_

/*                                       include sources                                        */
#include "scd_ssc_clienthandler_ALD.h"
#include "scd_ssc_utility.h"
#include "scd_ssc_property.h"
#include "scd_ssc_smartcardhandler.h"
#include "scd_ssc_test.h"
#include "scd_ssc_logger.h"

#include <cstdio>
#include <iostream>
#include <fstream>
#include <unistd.h>
#include <cstring>

/*    data for the debugging purpose at run time                                                */
	static const char *logging 		    = "logging";
	static const char *term 	        = "term";

	bool logging_enabled                = false;
	bool term_enabled                   = false;

/*************************************************************************************************
	FUNCTION: lockIt
	PARAMETERS: scd_ssc_tclClientHandler_ALD, scd_ssc_tclProperty
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: this function locks the system - unlock level 0

*************************************************************************************************/
bool lockIt(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD, scd_ssc_tclProperty *m_poProperty,
		scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: unlockIt
	PARAMETERS: scd_ssc_tclClientHandler_ALD, scd_ssc_tclProperty, scd_ssc_tclSmartcardHandler
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: this function unlocks the system

*************************************************************************************************/
bool unlockIt(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD, scd_ssc_tclProperty *m_poProperty,
		scd_ssc_tclSmartcardHandler *m_poSmartcardHandler, scd_ssc_tclLogger  *m_poLogger);


#endif /* SCD_SSC_TCLMAINAPPLICATION_H_ */

