/**
 * CCodeMeter Class
 * ----------------------------------------------------------------------------
 * Author:	Dietmar Wegner
 *			Mourad Goumrhar
 *			Mirko Lochau
 *			Michael Reinhold
 *
 * This header files defines the CCodeMeter class which encapsulates all
 * CodeMeter related functionality.
 * Internal data is kept private, getter and setter functions are used instead.
 *
 * Features to be implemented:
 * - UnitCounter
 * - Expiration Data
 *
 * Version History
 * ----------------------------------------------------------------------------
 * 06.11.2014	Initial Version
 * 11.11.2014	Refactoring done, commamnd line binary product introduced
 * 
 */


#include <string>
#include <cstddef>
#include <cstring>
//#include <stdlib.h>
//#include <clocale>
//#include <unistd.h>
//#include <cstdio>
#include "../lib/CodeMeterCompact.h"
#include "definitions.h"
#include "scd_ssc_logger.h"
#include "scd_ssc_utility.h"

/**
 * Definition of class CCodeMeter
 * 
 */
class CCodeMeter
{
public:
	// Constructor to set Pointer to Logging Class, FirmCode and ProductCode to be used

	CCodeMeter(CMULONG firmCode, CMULONG prodCode);

	// Destructor
	virtual ~CCodeMeter();

	void setProductFirmCode(unsigned int prodcode, unsigned int firmcode);

	// Initialize: Establish connection to the CmContainer and get necessary information
	int initialize(scd_ssc_tclLogger  *m_poLogger);

	// Get the current handle for the CmContainer
	HCMSysEntry getHcmse() { return m_hcmse; }
	
	// Get the SerialNumber of the CmContainer with handle m_hcmse
	CMULONG getSerialNumber() { return m_SerialNumber; }

	// Get the PublicKey that is stored in the CmContainer with handle m_hcmse
	unsigned char* getPublicKey() { return m_publicKey; }

	// Sign the data that is provided ....
	int sign(unsigned char *data, unsigned int length, unsigned char* signature, scd_ssc_tclLogger  *m_poLogger);

	void setMode(int nMode) { m_nMode = nMode; }

	int getMode() { return m_nMode; }

private:
	void addPadding(int hashlen, unsigned char *hash, unsigned char *sig);
	void reverseArray(unsigned char *data, unsigned int length, scd_ssc_tclLogger  *m_poLogger);
	
	CMACCESS2		m_cmaccess;
	HCMSysEntry		m_hcmse;
	CMBOXINFO		m_cmboxinfo;
	CMULONG			m_firmCode;
	CMULONG			m_prodCode;
	CMULONG			m_SerialNumber;
	CMULONG			m_MajorVersion;
	CMULONG			m_MinorVersion;
	CMTIME			m_expirationTime;

	int				m_UnitCounter;	// number of 
	int				m_nBoxes;
	int				m_nMode;
	char			sFirmItemText[CM_MAX_STRING_LEN];	// the CmContainer "Text" Field
	unsigned char	m_sha256Hash[CM_DIGEST_LEN];
	unsigned char	m_publicKey[LEN_PUBLIC_KEY];
	std::string m_name;
};
