#ifndef ISOINIT_H_
#define ISOINIT_H_

/**
 * Scan service directory
 * The directory that will be scanned is taken from the environment varibale
 * ISOINIT_SRV_DIR. If this isn't set, it defaults to "/etc/isoinit.d/"
 * All *.service files in this directory will be sorted and evaluated. Numeric
 * prefixed files will be evaluated in increasing order. Services will be
 * started and environment injected.
 *
 * @return -1 on error, 0 on success
 */
int ISOINIT_ScanSrvDir(void);

/**
 * Detach from the controlling terminal and run in the background as a system
 * daemon. The process will change current working directory to the root
 * directory ("/") and redirect standard input, standard output and standard
 * error to /dev/null
 */
int ISOINIT_Daemonize(void);

/**
 * TODO
 */
int ISOINIT_SetupSocket(void);

/**
 * Sets socket path from ISOINIT_SOCK_DIR environment variable. If variable
 * is missing, the socket path defaults to "/tmp"
 * Isoinit uses this socket to communicate with the services
 */
void ISOINIT_SetSocketPath(void);

/**
 * Gets socket path
 * Isoinit uses this socket to communicate with the services
 * @return Path to socket
 */
char *ISOINIT_GetSocketPath(void);

/**
 * Change uid (and gid / supplementary groups) to what was set by
 * ISOINIT_CheckArgs()
 */
int ISOINIT_ChangeUser(void);

/**
 * Print credentials (uid, euid, gid, egid and supplementary groups)
 */
void ISOINIT_PrintCredentials(void);

/**
 * Build the socket path for isorun, based on the hostname
 */
void ISOINIT_BuildSocketPaths(void);

/**
 * Install signal handler for SIGINT, SIGCHLD, SIGUSR1 and SIGALRM
 */
void ISOINIT_InstallSignalHandler(void);

/**
 * TODO
 */
void ISOINIT_SetupDebug(void);

/**
 * TODO
 *
 * @param argc TODO
 * @param argv TODO
 * @return TODO
 */
int ISOINIT_CheckArgs(int argc, char *argv[]);

/**
 * The isoinit mainloop
 *
 * @return TODO
 */
int ISOINIT_MainLoop(void);



#endif /* ISOINIT_H_ */
