#ifndef LCM_DEFINES_H
#define LCM_DEFINES_H

#ifdef __cplusplus
    extern "C"{
#endif

#define DESIGN_COMPLETED "Sep 20 2017"

#if defined(LCM_ENABLE_DLT) || defined(LCM_ENABLE_LOG)
#include <stdio.h>
#include <string.h>
#include <errno.h>

#if defined(LCM_ENABLE_DLT)
#define DBG_NONE  DLT_LOG_OFF
#define DBG_FATAL DLT_LOG_FATAL
#define DBG_ERR   DLT_LOG_ERROR
#define DBG_WARN  DLT_LOG_WARN
#define DBG_INFO  DLT_LOG_INFO
#define DBG_DBG   DLT_LOG_DEBUG
#define DBG_ALL   DLT_LOG_VERBOSE
#else
#define DBG_NONE  0
#define DBG_FATAL 1
#define DBG_ERR   2
#define DBG_WARN  3
#define DBG_INFO  4
#define DBG_DBG   5
#define DBG_ALL   6
#endif
#else
#define DBG_NONE
#define DBG_FATAL
#define DBG_ERR
#define DBG_WARN
#define DBG_INFO
#define DBG_DBG
#define DBG_ALL
#endif
// Log levels map to:
#if 0
    DLT_LOG_OFF     =           0x00,   /**< Log level off */
    DLT_LOG_FATAL   =           0x01,   /**< fatal system error */
    DLT_LOG_ERROR   =           0x02,   /**< error with impact to correct functionality */
    DLT_LOG_WARN    =           0x03,   /**< warning, correct behaviour could not be ensured */
    DLT_LOG_INFO    =           0x04,   /**< informational */
    DLT_LOG_DEBUG   =           0x05,   /**< debug  */
    DLT_LOG_VERBOSE =           0x06,   /**< highest grade of information */
#endif

#ifdef LCM_ENABLE_DLT
#include <dlt/dlt.h>

#define DEBUG_TRACE_LEV(format)   _DEBUG_TRACE_LEV format;  _DBG format
#define DEBUG_TRACE_FUNC(format)    _DEBUG_TRACE_FUNC format
#define DEBUG_TRACE_PERROR(format)    _DEBUG_TRACE_PERR format;  _DBG_PERROR format

#define _DEBUG_TRACE_LEV(ctx,level,format,args...) do { \
    char log_buff[1024]; \
    char final_string[1024]; \
    int printed = snprintf(final_string, sizeof(final_string),"File:%s, Line:%d, ",__FILE__, __LINE__); \
    if (printed < 0) printed = 0;\
    snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string) - (size_t)printed - 1); \
    DLT_LOG(ctx, level, DLT_STRING(final_string)); \
} while(0)

#define _DEBUG_TRACE_FUNC(ctx,format,args...) do { \
    char log_buff[1024]; \
    char final_string[1024]; \
    int printed = snprintf(final_string, sizeof(final_string),"Function:%s, Line:%d, ",__FUNCTION__, __LINE__); \
    if (printed < 0) printed = 0;\
    snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string) - (size_t)printed - 1); \
    DLT_LOG(ctx, DLT_LOG_INFO, DLT_STRING(final_string)); \
} while(0)

#define _DEBUG_TRACE_PERR(ctx,format,args...) do { \
    int loc_errno = errno; \
    char log_buff[1024]; \
    char final_string[1024]; \
    char err_string[128]; \
    int printed = snprintf(final_string, sizeof(final_string),"Function:%s, Line:%d, ",__FUNCTION__, __LINE__); \
    if (printed < 0) printed = 0;\
    int added = snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string) - (size_t)printed - 1); \
    printed += added; \
    if (printed > 1023) printed = 1023; \
    snprintf(err_string, sizeof(err_string), ": %s", strerror(loc_errno)); \
    strncat(final_string, err_string, sizeof(final_string) - (size_t)printed - 1); \
    DLT_LOG(ctx, DLT_LOG_ERROR, DLT_STRING(final_string)); \
} while(0)

#define LCM_DECLARE_CONTEXT(context) DLT_DECLARE_CONTEXT(context)
#define LCM_IMPORT_CONTEXT(context) DLT_IMPORT_CONTEXT(context)
#define LCM_REGISTER_APP(component, description) DLT_REGISTER_APP(component, description)
#define LCM_REGISTER_CONTEXT(context, subComponent, description)  DLT_REGISTER_CONTEXT(context, subComponent, description)
#define LCM_UNREGISTER_CONTEXT(context) DLT_UNREGISTER_CONTEXT(context)
#define LCM_UNREGISTER_APP() DLT_UNREGISTER_APP()

#else  //No LCM_ENABLE_DLT

#define DEBUG_TRACE_LEV(format)  _DBG format
#define DEBUG_TRACE_FUNC(format)
//#define _DEBUG_TRACE_FUNC(ctx,format,args...)
#define DEBUG_TRACE_PERROR(format)  _DBG_PERROR format
//#define _DEBUG_TRACE_PERR(ctx,format,args...)

#define LCM_DECLARE_CONTEXT(context)
#define LCM_IMPORT_CONTEXT(context)
#define LCM_REGISTER_APP(component, description)
#define LCM_REGISTER_CONTEXT(context, subComponent, description)
#define LCM_UNREGISTER_CONTEXT(context)
#define LCM_UNREGISTER_APP()

#endif //ifdef LCM_ENABLE_DLT

/**
*
* LCM_ENABLE_LOG Macros
*
*/

#ifdef LCM_ENABLE_LOG        // general LCM_ENABLE_LOG guard

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>        // for getpid

extern int DBG_LEVEL;
extern FILE *stream;
extern char* __dbgstr;

#define DBG_SET_LEVEL( level ) DBG_LEVEL=level;
#define DBG_SETOUTPUT( fp ) stream = fp;

//#define noDBG_WITH_FUNCTION
#define DBG_WITH_FUNCTION
#define DBG_WITH_PID

#ifdef DBG_WITH_FUNCTION
    #define _DBGF  fprintf(stream, "%s:%d(): ", __FUNCTION__, __LINE__);
#else
    #define _DBGF
#endif

#ifdef DBG_WITH_PID
    #define _DBGPID fprintf(stream, "%d: ", getpid());
#else
    #define _DBGPID
#endif

#define DBG(level, ...)  \
    do { \
        if (level <= DBG_LEVEL) \
        { \
            _DBGPID _DBGF fprintf(stream, __VA_ARGS__); \
            fflush(stream); \
        } \
    } while (0)

#define _DBG(ctx,level, ...)  \
    do { \
        if (level <= DBG_LEVEL) \
        { \
            _DBGPID _DBGF fprintf(stream, __VA_ARGS__); \
            fflush(stream); \
        } \
    } while (0)

#define DBG_ENTER  DBG(6,"enter %s:%d()\n", __FUNCTION__, __LINE__);
#define DBG_LEAVE  DBG(6,"leave %s:%d()\n", __FUNCTION__, __LINE__);
#define DBG_PERROR(...) \
        do { \
            int loc_errno = errno; \
            DBGF(DBG_ERR, "%s: %s\n", __VA_ARGS__, strerror(loc_errno)); \
        } while (0)
#define _DBG_PERROR(ctx,...) \
        do { \
            int loc_errno = errno; \
            DBGF(DBG_ERR, "%s: %s\n", __VA_ARGS__, strerror(loc_errno)); \
        } while (0)
#define DBGF(level, ...) \
    do { \
        if (level <= DBG_LEVEL) \
        { \
            _DBGPID  fprintf(stream, "%s:%d(): ", __FUNCTION__, __LINE__); \
            fprintf(stream, __VA_ARGS__); \
            fflush(stream); \
        } \
    } while (0)


/*
 * Macro to create temporary debug buffer, add output e.g. within a loop and finally print it
 *
 */
#define DBG_TMP_BUF_SIZE    256        // num chars for tmp debug
#define DBG_START(level, ...)                                                \
    if(level<=DBG_LEVEL){                                                    \
         _DBGF                                                               \
        __dbgstr=(char*)malloc( DBG_TMP_BUF_SIZE+1 );*__dbgstr = 0;          \
        snprintf(__dbgstr+strlen(__dbgstr)                                   \
                , DBG_TMP_BUF_SIZE-strlen(__dbgstr) , __VA_ARGS__ );         \
    }
// add stuff to temp debug buffer
#define DBG_ADD(level, ...)                                                  \
    if(level<=DBG_LEVEL){                                                    \
        snprintf(__dbgstr+strlen(__dbgstr)                                   \
                , DBG_TMP_BUF_SIZE-strlen(__dbgstr), __VA_ARGS__ );          \
    }
// print temp debug buffer and free mem
#define DBG_END(level, ...)                                                  \
    if(level<=DBG_LEVEL){                                                    \
        snprintf(__dbgstr+strlen(__dbgstr)                                   \
                , DBG_TMP_BUF_SIZE-strlen(__dbgstr), __VA_ARGS__ );          \
        fprintf(stream, "%s", __dbgstr);                                     \
        free(__dbgstr);                                                      \
    }


#else  // no LCM_ENABLE_LOG
// undefine all DBG functions
#define DBG_SET_LEVEL( level )
#define DBG_SETOUTPUT( fp )
#define DBG_OUTPUTFILE( f )

#define DBG(level, ...)
//#define _DBG(ctx,level, ...)
#define _DBG(...)
#define DBG_ENTER
#define DBG_LEAVE
#define DBG_PERROR(...)
#define _DBG_PERROR(ctx,...)
#define DBGF(level, ...)

#define DBG_START(level, ...)
#define DBG_ADD(level, ...)
#define DBG_END(level, ...)
#endif   // #ifdef LCM_ENABLE_LOG

#ifdef __cplusplus
}  //extern "C"
#endif
#endif //#ifndef LCM_DEFINES_H
